------------------------------------------------------------------------------
--  This file is a part of the GRLIB VHDL IP LIBRARY
--  Copyright (C) 2015, Cobham Gaisler AB - all rights reserved.
--
-- ANY USE OR REDISTRIBUTION IN PART OR IN WHOLE MUST BE HANDLED IN 
-- ACCORDANCE WITH THE GAISLER LICENSE AGREEMENT AND MUST BE APPROVED 
-- IN ADVANCE IN WRITING.
------------------------------------------------------------------------------


library ieee, stratixii;
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use stratixii.stratixii_components.all;

entity grlfpw_net is
port(
  rst :  in std_logic;
  clk :  in std_logic;
  holdn :  in std_logic;
  cpi_flush :  in std_logic;
  cpi_exack :  in std_logic;
  cpi_a_rs1 : in std_logic_vector(4 downto 0);
  cpi_d_pc : in std_logic_vector(31 downto 0);
  cpi_d_inst : in std_logic_vector(31 downto 0);
  cpi_d_cnt : in std_logic_vector(1 downto 0);
  cpi_d_trap :  in std_logic;
  cpi_d_annul :  in std_logic;
  cpi_d_pv :  in std_logic;
  cpi_a_pc : in std_logic_vector(31 downto 0);
  cpi_a_inst : in std_logic_vector(31 downto 0);
  cpi_a_cnt : in std_logic_vector(1 downto 0);
  cpi_a_trap :  in std_logic;
  cpi_a_annul :  in std_logic;
  cpi_a_pv :  in std_logic;
  cpi_e_pc : in std_logic_vector(31 downto 0);
  cpi_e_inst : in std_logic_vector(31 downto 0);
  cpi_e_cnt : in std_logic_vector(1 downto 0);
  cpi_e_trap :  in std_logic;
  cpi_e_annul :  in std_logic;
  cpi_e_pv :  in std_logic;
  cpi_m_pc : in std_logic_vector(31 downto 0);
  cpi_m_inst : in std_logic_vector(31 downto 0);
  cpi_m_cnt : in std_logic_vector(1 downto 0);
  cpi_m_trap :  in std_logic;
  cpi_m_annul :  in std_logic;
  cpi_m_pv :  in std_logic;
  cpi_x_pc : in std_logic_vector(31 downto 0);
  cpi_x_inst : in std_logic_vector(31 downto 0);
  cpi_x_cnt : in std_logic_vector(1 downto 0);
  cpi_x_trap :  in std_logic;
  cpi_x_annul :  in std_logic;
  cpi_x_pv :  in std_logic;
  cpi_lddata : in std_logic_vector(31 downto 0);
  cpi_dbg_enable :  in std_logic;
  cpi_dbg_write :  in std_logic;
  cpi_dbg_fsr :  in std_logic;
  cpi_dbg_addr : in std_logic_vector(4 downto 0);
  cpi_dbg_data : in std_logic_vector(31 downto 0);
  cpo_data : out std_logic_vector(31 downto 0);
  cpo_exc :  out std_logic;
  cpo_cc : out std_logic_vector(1 downto 0);
  cpo_ccv :  out std_logic;
  cpo_ldlock :  out std_logic;
  cpo_holdn :  out std_logic;
  cpo_dbg_data : out std_logic_vector(31 downto 0);
  rfi1_rd1addr : out std_logic_vector(3 downto 0);
  rfi1_rd2addr : out std_logic_vector(3 downto 0);
  rfi1_wraddr : out std_logic_vector(3 downto 0);
  rfi1_wrdata : out std_logic_vector(31 downto 0);
  rfi1_ren1 :  out std_logic;
  rfi1_ren2 :  out std_logic;
  rfi1_wren :  out std_logic;
  rfi2_rd1addr : out std_logic_vector(3 downto 0);
  rfi2_rd2addr : out std_logic_vector(3 downto 0);
  rfi2_wraddr : out std_logic_vector(3 downto 0);
  rfi2_wrdata : out std_logic_vector(31 downto 0);
  rfi2_ren1 :  out std_logic;
  rfi2_ren2 :  out std_logic;
  rfi2_wren :  out std_logic;
  rfo1_data1 : in std_logic_vector(31 downto 0);
  rfo1_data2 : in std_logic_vector(31 downto 0);
  rfo2_data1 : in std_logic_vector(31 downto 0);
  rfo2_data2 : in std_logic_vector(31 downto 0));
end grlfpw_net;

architecture beh of grlfpw_net is
  signal devclrn : std_logic := '1';
  signal devpor : std_logic := '1';
  signal devoe : std_logic := '0';
  signal \GRLFPC20.FPI.OP2\ : std_logic_vector(63 downto 32);
  signal \GRLFPC20.R.FSR.RD\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.FPO.FRAC\ : std_logic_vector(54 downto 3);
  signal \GRLFPC20.FPO.EXP\ : std_logic_vector(10 downto 0);
  signal \GRLFPC20.R.STATE\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.I.INST\ : std_logic_vector(31 downto 0);
  signal \GRLFPC20.R.FSR.TEM\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.I.EXC\ : std_logic_vector(5 downto 0);
  signal \GRLFPC20.R.FSR.AEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS2\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.I.PC\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.R.FSR.CEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.FSR.FTT\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.R.I.CC\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.I.RES\ : std_logic_vector(63 downto 0);
  signal \GRLFPC20.COMB.V.I.RES_1\ : std_logic_vector(63 to 63);
  signal \GRLFPC20.R.A.RF1REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.A.RF2REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.I.EXC_MB\ : std_logic_vector(4 downto 1);
  signal \GRLFPC20.COMB.RS2_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.E.STDATA_1\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.COMB.RS1_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.FSR.FCC_1\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\ : std_logic_vector(16 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SCTRL_NEW\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\ : std_logic_vector(12 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_DIVMULTV\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\ : std_logic_vector(85 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\ : std_logic_vector(377 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\ : std_logic_vector(112 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_4\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_5\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_6\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\ : std_logic_vector(12 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\ : std_logic_vector(52 to 52);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\ : std_logic_vector(77 downto 65);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_18\ : std_logic_vector(74 to 74);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\ : std_logic_vector(55 downto 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\ : std_logic_vector(113 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\ : std_logic_vector(9 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\ : std_logic_vector(375 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\ : std_logic_vector(9 downto 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\ : std_logic_vector(56 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\ : std_logic_vector(7 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\ : std_logic_vector(112 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\ : std_logic_vector(257 downto 248);
  signal \GRLFPC20.FPI.OP1\ : std_logic_vector(62 downto 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.55.SI_60\ : std_logic_vector(53 to 53);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\ : std_logic_vector(57 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\ : std_logic_vector(112 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\ : std_logic_vector(115 downto 114);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\ : std_logic_vector(115 downto 114);
  signal \GRLFPC20.COMB.V.A.RF2REN_1_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.FPCI_I_M\ : std_logic_vector(340 to 340);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\ : std_logic_vector(53 downto 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\ : std_logic_vector(56 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.U_RDN_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\ : std_logic_vector(51 downto 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\ : std_logic_vector(31 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TOPBITSIN\ : std_logic_vector(6 downto 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\ : std_logic_vector(44 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\ : std_logic_vector(9 downto 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\ : std_logic_vector(3 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\ : std_logic_vector(44 downto 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_8_1\ : std_logic_vector(52 to 52);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_7_0\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_6_0\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_17_0\ : std_logic_vector(57 downto 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV_1_TZ\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_11_1\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_10_1\ : std_logic_vector(53 to 53);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_15_0\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_10_1\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A2_0\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0\ : std_logic_vector(58 to 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_1\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_2_0\ : std_logic_vector(62 to 62);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_0_A15_0\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_I_I_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\ : std_logic_vector(56 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\ : std_logic_vector(57 downto 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\ : std_logic_vector(55 downto 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\ : std_logic_vector(45 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_I\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M_0\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\ : std_logic_vector(6 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_6\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_5\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_27_1\ : std_logic_vector(55 to 55);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_6_0\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_7_0\ : std_logic_vector(57 to 57);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_19_0\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_12_0\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_20_0\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_7_0\ : std_logic_vector(48 downto 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_7_1\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_3_1\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_8_1\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_0\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_1\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_21_1\ : std_logic_vector(54 to 54);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0_0\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_5_1\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_11_0\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_23_1\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_15_1\ : std_logic_vector(54 to 54);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_5_1\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_10_1\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_11_1\ : std_logic_vector(52 to 52);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_19_1\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_15_0\ : std_logic_vector(58 to 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_16\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_17\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_19\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_21\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_25\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_26\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_27\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_A2_0_28\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_4_3\ : std_logic_vector(62 to 62);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_4_1\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A17_2_0\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_0\ : std_logic_vector(52 to 52);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_45_0\ : std_logic_vector(55 to 55);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_6_3\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A14_15_1\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_8_0\ : std_logic_vector(56 to 56);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_15_0\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_33_0\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A21_13_0\ : std_logic_vector(59 to 59);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0_0\ : std_logic_vector(58 to 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_0_0\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_2_0\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_1\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0\ : std_logic_vector(33 downto 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_1_0\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A9_5_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_6_0\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_6_0\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_8_0\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_6_0\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\ : std_logic_vector(38 downto 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_10_0\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A2_4_0\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_O12_3_0\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_S_0\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_1_0\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_13_0_A2_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_0\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_0_A2_0_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\ : std_logic_vector(57 to 57);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\ : std_logic_vector(8 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_M\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M\ : std_logic_vector(7 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\ : std_logic_vector(0 to 0);
  signal CPO_DATAZ : std_logic_vector(31 downto 0);
  signal CPO_CCZ : std_logic_vector(1 downto 0);
  signal CPO_DBG_DATAZ : std_logic_vector(31 downto 0);
  signal RFI1_WRDATAZ : std_logic_vector(31 downto 0);
  signal RFI2_RD1ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_RD2ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRDATAZ : std_logic_vector(31 downto 0);
  signal CLK_INTERNAL : std_logic ;
  signal HOLDN_INTERNAL : std_logic ;
  signal CPI_FLUSH_INTERNAL : std_logic ;
  signal CPI_EXACK_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL_0 : std_logic ;
  signal CPI_A_RS1_INTERNAL_1 : std_logic ;
  signal CPI_A_RS1_INTERNAL_2 : std_logic ;
  signal CPI_A_RS1_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL : std_logic ;
  signal CPI_D_PC_INTERNAL_0 : std_logic ;
  signal CPI_D_PC_INTERNAL_1 : std_logic ;
  signal CPI_D_PC_INTERNAL_2 : std_logic ;
  signal CPI_D_PC_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL_4 : std_logic ;
  signal CPI_D_PC_INTERNAL_5 : std_logic ;
  signal CPI_D_PC_INTERNAL_6 : std_logic ;
  signal CPI_D_PC_INTERNAL_7 : std_logic ;
  signal CPI_D_PC_INTERNAL_8 : std_logic ;
  signal CPI_D_PC_INTERNAL_9 : std_logic ;
  signal CPI_D_PC_INTERNAL_10 : std_logic ;
  signal CPI_D_PC_INTERNAL_11 : std_logic ;
  signal CPI_D_PC_INTERNAL_12 : std_logic ;
  signal CPI_D_PC_INTERNAL_13 : std_logic ;
  signal CPI_D_PC_INTERNAL_14 : std_logic ;
  signal CPI_D_PC_INTERNAL_15 : std_logic ;
  signal CPI_D_PC_INTERNAL_16 : std_logic ;
  signal CPI_D_PC_INTERNAL_17 : std_logic ;
  signal CPI_D_PC_INTERNAL_18 : std_logic ;
  signal CPI_D_PC_INTERNAL_19 : std_logic ;
  signal CPI_D_PC_INTERNAL_20 : std_logic ;
  signal CPI_D_PC_INTERNAL_21 : std_logic ;
  signal CPI_D_PC_INTERNAL_22 : std_logic ;
  signal CPI_D_PC_INTERNAL_23 : std_logic ;
  signal CPI_D_PC_INTERNAL_24 : std_logic ;
  signal CPI_D_PC_INTERNAL_25 : std_logic ;
  signal CPI_D_PC_INTERNAL_26 : std_logic ;
  signal CPI_D_PC_INTERNAL_27 : std_logic ;
  signal CPI_D_PC_INTERNAL_28 : std_logic ;
  signal CPI_D_PC_INTERNAL_29 : std_logic ;
  signal CPI_D_PC_INTERNAL_30 : std_logic ;
  signal CPI_D_INST_INTERNAL : std_logic ;
  signal CPI_D_INST_INTERNAL_0 : std_logic ;
  signal CPI_D_INST_INTERNAL_1 : std_logic ;
  signal CPI_D_INST_INTERNAL_2 : std_logic ;
  signal CPI_D_INST_INTERNAL_3 : std_logic ;
  signal CPI_D_INST_INTERNAL_4 : std_logic ;
  signal CPI_D_INST_INTERNAL_5 : std_logic ;
  signal CPI_D_INST_INTERNAL_7 : std_logic ;
  signal CPI_D_INST_INTERNAL_8 : std_logic ;
  signal CPI_D_INST_INTERNAL_9 : std_logic ;
  signal CPI_D_INST_INTERNAL_10 : std_logic ;
  signal CPI_D_INST_INTERNAL_11 : std_logic ;
  signal CPI_D_INST_INTERNAL_12 : std_logic ;
  signal CPI_D_INST_INTERNAL_13 : std_logic ;
  signal CPI_D_INST_INTERNAL_14 : std_logic ;
  signal CPI_D_INST_INTERNAL_15 : std_logic ;
  signal CPI_D_INST_INTERNAL_16 : std_logic ;
  signal CPI_D_INST_INTERNAL_17 : std_logic ;
  signal CPI_D_INST_INTERNAL_18 : std_logic ;
  signal CPI_D_INST_INTERNAL_19 : std_logic ;
  signal CPI_D_INST_INTERNAL_20 : std_logic ;
  signal CPI_D_INST_INTERNAL_21 : std_logic ;
  signal CPI_D_INST_INTERNAL_22 : std_logic ;
  signal CPI_D_INST_INTERNAL_23 : std_logic ;
  signal CPI_D_INST_INTERNAL_24 : std_logic ;
  signal CPI_D_INST_INTERNAL_25 : std_logic ;
  signal CPI_D_INST_INTERNAL_26 : std_logic ;
  signal CPI_D_INST_INTERNAL_27 : std_logic ;
  signal CPI_D_INST_INTERNAL_28 : std_logic ;
  signal CPI_D_INST_INTERNAL_29 : std_logic ;
  signal CPI_D_INST_INTERNAL_30 : std_logic ;
  signal CPI_D_CNT_INTERNAL : std_logic ;
  signal CPI_D_CNT_INTERNAL_0 : std_logic ;
  signal CPI_D_TRAP_INTERNAL : std_logic ;
  signal CPI_D_ANNUL_INTERNAL : std_logic ;
  signal CPI_D_PV_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL_0 : std_logic ;
  signal CPI_A_PC_INTERNAL_1 : std_logic ;
  signal CPI_A_PC_INTERNAL_2 : std_logic ;
  signal CPI_A_PC_INTERNAL_3 : std_logic ;
  signal CPI_A_PC_INTERNAL_4 : std_logic ;
  signal CPI_A_PC_INTERNAL_5 : std_logic ;
  signal CPI_A_PC_INTERNAL_6 : std_logic ;
  signal CPI_A_PC_INTERNAL_7 : std_logic ;
  signal CPI_A_PC_INTERNAL_8 : std_logic ;
  signal CPI_A_PC_INTERNAL_9 : std_logic ;
  signal CPI_A_PC_INTERNAL_10 : std_logic ;
  signal CPI_A_PC_INTERNAL_11 : std_logic ;
  signal CPI_A_PC_INTERNAL_12 : std_logic ;
  signal CPI_A_PC_INTERNAL_13 : std_logic ;
  signal CPI_A_PC_INTERNAL_14 : std_logic ;
  signal CPI_A_PC_INTERNAL_15 : std_logic ;
  signal CPI_A_PC_INTERNAL_16 : std_logic ;
  signal CPI_A_PC_INTERNAL_17 : std_logic ;
  signal CPI_A_PC_INTERNAL_18 : std_logic ;
  signal CPI_A_PC_INTERNAL_19 : std_logic ;
  signal CPI_A_PC_INTERNAL_20 : std_logic ;
  signal CPI_A_PC_INTERNAL_21 : std_logic ;
  signal CPI_A_PC_INTERNAL_22 : std_logic ;
  signal CPI_A_PC_INTERNAL_23 : std_logic ;
  signal CPI_A_PC_INTERNAL_24 : std_logic ;
  signal CPI_A_PC_INTERNAL_25 : std_logic ;
  signal CPI_A_PC_INTERNAL_26 : std_logic ;
  signal CPI_A_PC_INTERNAL_27 : std_logic ;
  signal CPI_A_PC_INTERNAL_28 : std_logic ;
  signal CPI_A_PC_INTERNAL_29 : std_logic ;
  signal CPI_A_PC_INTERNAL_30 : std_logic ;
  signal CPI_A_INST_INTERNAL : std_logic ;
  signal CPI_A_INST_INTERNAL_0 : std_logic ;
  signal CPI_A_INST_INTERNAL_1 : std_logic ;
  signal CPI_A_INST_INTERNAL_2 : std_logic ;
  signal CPI_A_INST_INTERNAL_3 : std_logic ;
  signal CPI_A_INST_INTERNAL_4 : std_logic ;
  signal CPI_A_INST_INTERNAL_5 : std_logic ;
  signal CPI_A_INST_INTERNAL_6 : std_logic ;
  signal CPI_A_INST_INTERNAL_7 : std_logic ;
  signal CPI_A_INST_INTERNAL_8 : std_logic ;
  signal CPI_A_INST_INTERNAL_9 : std_logic ;
  signal CPI_A_INST_INTERNAL_10 : std_logic ;
  signal CPI_A_INST_INTERNAL_11 : std_logic ;
  signal CPI_A_INST_INTERNAL_12 : std_logic ;
  signal CPI_A_INST_INTERNAL_13 : std_logic ;
  signal CPI_A_INST_INTERNAL_14 : std_logic ;
  signal CPI_A_INST_INTERNAL_15 : std_logic ;
  signal CPI_A_INST_INTERNAL_16 : std_logic ;
  signal CPI_A_INST_INTERNAL_17 : std_logic ;
  signal CPI_A_INST_INTERNAL_18 : std_logic ;
  signal CPI_A_INST_INTERNAL_19 : std_logic ;
  signal CPI_A_INST_INTERNAL_20 : std_logic ;
  signal CPI_A_INST_INTERNAL_21 : std_logic ;
  signal CPI_A_INST_INTERNAL_22 : std_logic ;
  signal CPI_A_INST_INTERNAL_23 : std_logic ;
  signal CPI_A_INST_INTERNAL_24 : std_logic ;
  signal CPI_A_INST_INTERNAL_25 : std_logic ;
  signal CPI_A_INST_INTERNAL_26 : std_logic ;
  signal CPI_A_INST_INTERNAL_27 : std_logic ;
  signal CPI_A_INST_INTERNAL_28 : std_logic ;
  signal CPI_A_INST_INTERNAL_29 : std_logic ;
  signal CPI_A_INST_INTERNAL_30 : std_logic ;
  signal CPI_A_CNT_INTERNAL : std_logic ;
  signal CPI_A_CNT_INTERNAL_0 : std_logic ;
  signal CPI_A_TRAP_INTERNAL : std_logic ;
  signal CPI_A_ANNUL_INTERNAL : std_logic ;
  signal CPI_A_PV_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL_0 : std_logic ;
  signal CPI_E_PC_INTERNAL_1 : std_logic ;
  signal CPI_E_PC_INTERNAL_2 : std_logic ;
  signal CPI_E_PC_INTERNAL_3 : std_logic ;
  signal CPI_E_PC_INTERNAL_4 : std_logic ;
  signal CPI_E_PC_INTERNAL_5 : std_logic ;
  signal CPI_E_PC_INTERNAL_6 : std_logic ;
  signal CPI_E_PC_INTERNAL_7 : std_logic ;
  signal CPI_E_PC_INTERNAL_8 : std_logic ;
  signal CPI_E_PC_INTERNAL_9 : std_logic ;
  signal CPI_E_PC_INTERNAL_10 : std_logic ;
  signal CPI_E_PC_INTERNAL_11 : std_logic ;
  signal CPI_E_PC_INTERNAL_12 : std_logic ;
  signal CPI_E_PC_INTERNAL_13 : std_logic ;
  signal CPI_E_PC_INTERNAL_14 : std_logic ;
  signal CPI_E_PC_INTERNAL_15 : std_logic ;
  signal CPI_E_PC_INTERNAL_16 : std_logic ;
  signal CPI_E_PC_INTERNAL_17 : std_logic ;
  signal CPI_E_PC_INTERNAL_18 : std_logic ;
  signal CPI_E_PC_INTERNAL_19 : std_logic ;
  signal CPI_E_PC_INTERNAL_20 : std_logic ;
  signal CPI_E_PC_INTERNAL_21 : std_logic ;
  signal CPI_E_PC_INTERNAL_22 : std_logic ;
  signal CPI_E_PC_INTERNAL_23 : std_logic ;
  signal CPI_E_PC_INTERNAL_24 : std_logic ;
  signal CPI_E_PC_INTERNAL_25 : std_logic ;
  signal CPI_E_PC_INTERNAL_26 : std_logic ;
  signal CPI_E_PC_INTERNAL_27 : std_logic ;
  signal CPI_E_PC_INTERNAL_28 : std_logic ;
  signal CPI_E_PC_INTERNAL_29 : std_logic ;
  signal CPI_E_PC_INTERNAL_30 : std_logic ;
  signal CPI_E_INST_INTERNAL : std_logic ;
  signal CPI_E_INST_INTERNAL_0 : std_logic ;
  signal CPI_E_INST_INTERNAL_1 : std_logic ;
  signal CPI_E_INST_INTERNAL_2 : std_logic ;
  signal CPI_E_INST_INTERNAL_3 : std_logic ;
  signal CPI_E_INST_INTERNAL_4 : std_logic ;
  signal CPI_E_INST_INTERNAL_5 : std_logic ;
  signal CPI_E_INST_INTERNAL_6 : std_logic ;
  signal CPI_E_INST_INTERNAL_7 : std_logic ;
  signal CPI_E_INST_INTERNAL_8 : std_logic ;
  signal CPI_E_INST_INTERNAL_9 : std_logic ;
  signal CPI_E_INST_INTERNAL_10 : std_logic ;
  signal CPI_E_INST_INTERNAL_11 : std_logic ;
  signal CPI_E_INST_INTERNAL_12 : std_logic ;
  signal CPI_E_INST_INTERNAL_13 : std_logic ;
  signal CPI_E_INST_INTERNAL_14 : std_logic ;
  signal CPI_E_INST_INTERNAL_15 : std_logic ;
  signal CPI_E_INST_INTERNAL_16 : std_logic ;
  signal CPI_E_INST_INTERNAL_17 : std_logic ;
  signal CPI_E_INST_INTERNAL_18 : std_logic ;
  signal CPI_E_INST_INTERNAL_19 : std_logic ;
  signal CPI_E_INST_INTERNAL_20 : std_logic ;
  signal CPI_E_INST_INTERNAL_21 : std_logic ;
  signal CPI_E_INST_INTERNAL_22 : std_logic ;
  signal CPI_E_INST_INTERNAL_23 : std_logic ;
  signal CPI_E_INST_INTERNAL_24 : std_logic ;
  signal CPI_E_INST_INTERNAL_25 : std_logic ;
  signal CPI_E_INST_INTERNAL_26 : std_logic ;
  signal CPI_E_INST_INTERNAL_27 : std_logic ;
  signal CPI_E_INST_INTERNAL_28 : std_logic ;
  signal CPI_E_INST_INTERNAL_29 : std_logic ;
  signal CPI_E_INST_INTERNAL_30 : std_logic ;
  signal CPI_E_CNT_INTERNAL : std_logic ;
  signal CPI_E_CNT_INTERNAL_0 : std_logic ;
  signal CPI_E_TRAP_INTERNAL : std_logic ;
  signal CPI_E_ANNUL_INTERNAL : std_logic ;
  signal CPI_E_PV_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL_0 : std_logic ;
  signal CPI_M_PC_INTERNAL_1 : std_logic ;
  signal CPI_M_PC_INTERNAL_2 : std_logic ;
  signal CPI_M_PC_INTERNAL_3 : std_logic ;
  signal CPI_M_PC_INTERNAL_4 : std_logic ;
  signal CPI_M_PC_INTERNAL_5 : std_logic ;
  signal CPI_M_PC_INTERNAL_6 : std_logic ;
  signal CPI_M_PC_INTERNAL_7 : std_logic ;
  signal CPI_M_PC_INTERNAL_8 : std_logic ;
  signal CPI_M_PC_INTERNAL_9 : std_logic ;
  signal CPI_M_PC_INTERNAL_10 : std_logic ;
  signal CPI_M_PC_INTERNAL_11 : std_logic ;
  signal CPI_M_PC_INTERNAL_12 : std_logic ;
  signal CPI_M_PC_INTERNAL_13 : std_logic ;
  signal CPI_M_PC_INTERNAL_14 : std_logic ;
  signal CPI_M_PC_INTERNAL_15 : std_logic ;
  signal CPI_M_PC_INTERNAL_16 : std_logic ;
  signal CPI_M_PC_INTERNAL_17 : std_logic ;
  signal CPI_M_PC_INTERNAL_18 : std_logic ;
  signal CPI_M_PC_INTERNAL_19 : std_logic ;
  signal CPI_M_PC_INTERNAL_20 : std_logic ;
  signal CPI_M_PC_INTERNAL_21 : std_logic ;
  signal CPI_M_PC_INTERNAL_22 : std_logic ;
  signal CPI_M_PC_INTERNAL_23 : std_logic ;
  signal CPI_M_PC_INTERNAL_24 : std_logic ;
  signal CPI_M_PC_INTERNAL_25 : std_logic ;
  signal CPI_M_PC_INTERNAL_26 : std_logic ;
  signal CPI_M_PC_INTERNAL_27 : std_logic ;
  signal CPI_M_PC_INTERNAL_28 : std_logic ;
  signal CPI_M_PC_INTERNAL_29 : std_logic ;
  signal CPI_M_PC_INTERNAL_30 : std_logic ;
  signal CPI_M_INST_INTERNAL : std_logic ;
  signal CPI_M_INST_INTERNAL_0 : std_logic ;
  signal CPI_M_INST_INTERNAL_1 : std_logic ;
  signal CPI_M_INST_INTERNAL_2 : std_logic ;
  signal CPI_M_INST_INTERNAL_3 : std_logic ;
  signal CPI_M_INST_INTERNAL_4 : std_logic ;
  signal CPI_M_INST_INTERNAL_5 : std_logic ;
  signal CPI_M_INST_INTERNAL_6 : std_logic ;
  signal CPI_M_INST_INTERNAL_7 : std_logic ;
  signal CPI_M_INST_INTERNAL_8 : std_logic ;
  signal CPI_M_INST_INTERNAL_9 : std_logic ;
  signal CPI_M_INST_INTERNAL_10 : std_logic ;
  signal CPI_M_INST_INTERNAL_11 : std_logic ;
  signal CPI_M_INST_INTERNAL_12 : std_logic ;
  signal CPI_M_INST_INTERNAL_13 : std_logic ;
  signal CPI_M_INST_INTERNAL_14 : std_logic ;
  signal CPI_M_INST_INTERNAL_15 : std_logic ;
  signal CPI_M_INST_INTERNAL_16 : std_logic ;
  signal CPI_M_INST_INTERNAL_17 : std_logic ;
  signal CPI_M_INST_INTERNAL_18 : std_logic ;
  signal CPI_M_INST_INTERNAL_19 : std_logic ;
  signal CPI_M_INST_INTERNAL_20 : std_logic ;
  signal CPI_M_INST_INTERNAL_21 : std_logic ;
  signal CPI_M_INST_INTERNAL_22 : std_logic ;
  signal CPI_M_INST_INTERNAL_23 : std_logic ;
  signal CPI_M_INST_INTERNAL_24 : std_logic ;
  signal CPI_M_INST_INTERNAL_25 : std_logic ;
  signal CPI_M_INST_INTERNAL_26 : std_logic ;
  signal CPI_M_INST_INTERNAL_27 : std_logic ;
  signal CPI_M_INST_INTERNAL_28 : std_logic ;
  signal CPI_M_INST_INTERNAL_29 : std_logic ;
  signal CPI_M_INST_INTERNAL_30 : std_logic ;
  signal CPI_M_CNT_INTERNAL : std_logic ;
  signal CPI_M_CNT_INTERNAL_0 : std_logic ;
  signal CPI_M_TRAP_INTERNAL : std_logic ;
  signal CPI_M_ANNUL_INTERNAL : std_logic ;
  signal CPI_M_PV_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL_0 : std_logic ;
  signal CPI_X_PC_INTERNAL_1 : std_logic ;
  signal CPI_X_PC_INTERNAL_2 : std_logic ;
  signal CPI_X_PC_INTERNAL_3 : std_logic ;
  signal CPI_X_PC_INTERNAL_4 : std_logic ;
  signal CPI_X_PC_INTERNAL_5 : std_logic ;
  signal CPI_X_PC_INTERNAL_6 : std_logic ;
  signal CPI_X_PC_INTERNAL_7 : std_logic ;
  signal CPI_X_PC_INTERNAL_8 : std_logic ;
  signal CPI_X_PC_INTERNAL_9 : std_logic ;
  signal CPI_X_PC_INTERNAL_10 : std_logic ;
  signal CPI_X_PC_INTERNAL_11 : std_logic ;
  signal CPI_X_PC_INTERNAL_12 : std_logic ;
  signal CPI_X_PC_INTERNAL_13 : std_logic ;
  signal CPI_X_PC_INTERNAL_14 : std_logic ;
  signal CPI_X_PC_INTERNAL_15 : std_logic ;
  signal CPI_X_PC_INTERNAL_16 : std_logic ;
  signal CPI_X_PC_INTERNAL_17 : std_logic ;
  signal CPI_X_PC_INTERNAL_18 : std_logic ;
  signal CPI_X_PC_INTERNAL_19 : std_logic ;
  signal CPI_X_PC_INTERNAL_20 : std_logic ;
  signal CPI_X_PC_INTERNAL_21 : std_logic ;
  signal CPI_X_PC_INTERNAL_22 : std_logic ;
  signal CPI_X_PC_INTERNAL_23 : std_logic ;
  signal CPI_X_PC_INTERNAL_24 : std_logic ;
  signal CPI_X_PC_INTERNAL_25 : std_logic ;
  signal CPI_X_PC_INTERNAL_26 : std_logic ;
  signal CPI_X_PC_INTERNAL_27 : std_logic ;
  signal CPI_X_PC_INTERNAL_28 : std_logic ;
  signal CPI_X_PC_INTERNAL_29 : std_logic ;
  signal CPI_X_PC_INTERNAL_30 : std_logic ;
  signal CPI_X_INST_INTERNAL : std_logic ;
  signal CPI_X_INST_INTERNAL_0 : std_logic ;
  signal CPI_X_INST_INTERNAL_1 : std_logic ;
  signal CPI_X_INST_INTERNAL_2 : std_logic ;
  signal CPI_X_INST_INTERNAL_3 : std_logic ;
  signal CPI_X_INST_INTERNAL_4 : std_logic ;
  signal CPI_X_INST_INTERNAL_5 : std_logic ;
  signal CPI_X_INST_INTERNAL_6 : std_logic ;
  signal CPI_X_INST_INTERNAL_7 : std_logic ;
  signal CPI_X_INST_INTERNAL_8 : std_logic ;
  signal CPI_X_INST_INTERNAL_9 : std_logic ;
  signal CPI_X_INST_INTERNAL_10 : std_logic ;
  signal CPI_X_INST_INTERNAL_11 : std_logic ;
  signal CPI_X_INST_INTERNAL_12 : std_logic ;
  signal CPI_X_INST_INTERNAL_13 : std_logic ;
  signal CPI_X_INST_INTERNAL_14 : std_logic ;
  signal CPI_X_INST_INTERNAL_15 : std_logic ;
  signal CPI_X_INST_INTERNAL_16 : std_logic ;
  signal CPI_X_INST_INTERNAL_17 : std_logic ;
  signal CPI_X_INST_INTERNAL_18 : std_logic ;
  signal CPI_X_INST_INTERNAL_19 : std_logic ;
  signal CPI_X_INST_INTERNAL_20 : std_logic ;
  signal CPI_X_INST_INTERNAL_21 : std_logic ;
  signal CPI_X_INST_INTERNAL_22 : std_logic ;
  signal CPI_X_INST_INTERNAL_23 : std_logic ;
  signal CPI_X_INST_INTERNAL_24 : std_logic ;
  signal CPI_X_INST_INTERNAL_25 : std_logic ;
  signal CPI_X_INST_INTERNAL_26 : std_logic ;
  signal CPI_X_INST_INTERNAL_27 : std_logic ;
  signal CPI_X_INST_INTERNAL_28 : std_logic ;
  signal CPI_X_INST_INTERNAL_29 : std_logic ;
  signal CPI_X_INST_INTERNAL_30 : std_logic ;
  signal CPI_X_CNT_INTERNAL : std_logic ;
  signal CPI_X_CNT_INTERNAL_0 : std_logic ;
  signal CPI_X_TRAP_INTERNAL : std_logic ;
  signal CPI_X_ANNUL_INTERNAL : std_logic ;
  signal CPI_X_PV_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL_0 : std_logic ;
  signal CPI_LDDATA_INTERNAL_1 : std_logic ;
  signal CPI_LDDATA_INTERNAL_2 : std_logic ;
  signal CPI_LDDATA_INTERNAL_3 : std_logic ;
  signal CPI_LDDATA_INTERNAL_4 : std_logic ;
  signal CPI_LDDATA_INTERNAL_5 : std_logic ;
  signal CPI_LDDATA_INTERNAL_6 : std_logic ;
  signal CPI_LDDATA_INTERNAL_7 : std_logic ;
  signal CPI_LDDATA_INTERNAL_8 : std_logic ;
  signal CPI_LDDATA_INTERNAL_9 : std_logic ;
  signal CPI_LDDATA_INTERNAL_10 : std_logic ;
  signal CPI_LDDATA_INTERNAL_11 : std_logic ;
  signal CPI_LDDATA_INTERNAL_12 : std_logic ;
  signal CPI_LDDATA_INTERNAL_13 : std_logic ;
  signal CPI_LDDATA_INTERNAL_14 : std_logic ;
  signal CPI_LDDATA_INTERNAL_15 : std_logic ;
  signal CPI_LDDATA_INTERNAL_16 : std_logic ;
  signal CPI_LDDATA_INTERNAL_17 : std_logic ;
  signal CPI_LDDATA_INTERNAL_18 : std_logic ;
  signal CPI_LDDATA_INTERNAL_19 : std_logic ;
  signal CPI_LDDATA_INTERNAL_20 : std_logic ;
  signal CPI_LDDATA_INTERNAL_21 : std_logic ;
  signal CPI_LDDATA_INTERNAL_22 : std_logic ;
  signal CPI_LDDATA_INTERNAL_23 : std_logic ;
  signal CPI_LDDATA_INTERNAL_24 : std_logic ;
  signal CPI_LDDATA_INTERNAL_25 : std_logic ;
  signal CPI_LDDATA_INTERNAL_26 : std_logic ;
  signal CPI_LDDATA_INTERNAL_27 : std_logic ;
  signal CPI_LDDATA_INTERNAL_28 : std_logic ;
  signal CPI_LDDATA_INTERNAL_29 : std_logic ;
  signal CPI_LDDATA_INTERNAL_30 : std_logic ;
  signal CPI_DBG_ENABLE_INTERNAL : std_logic ;
  signal CPI_DBG_WRITE_INTERNAL : std_logic ;
  signal CPI_DBG_FSR_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_0 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_1 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_2 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_0 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_1 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_2 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_4 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_5 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_6 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_7 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_8 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_9 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_10 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_11 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_12 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_13 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_14 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_15 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_16 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_17 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_18 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_19 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_20 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_21 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_22 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_23 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_24 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_25 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_26 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_27 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_28 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_29 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_30 : std_logic ;
  signal RFO1_DATA1_INTERNAL : std_logic ;
  signal RFO1_DATA1_INTERNAL_0 : std_logic ;
  signal RFO1_DATA1_INTERNAL_1 : std_logic ;
  signal RFO1_DATA1_INTERNAL_2 : std_logic ;
  signal RFO1_DATA1_INTERNAL_3 : std_logic ;
  signal RFO1_DATA1_INTERNAL_4 : std_logic ;
  signal RFO1_DATA1_INTERNAL_5 : std_logic ;
  signal RFO1_DATA1_INTERNAL_6 : std_logic ;
  signal RFO1_DATA1_INTERNAL_7 : std_logic ;
  signal RFO1_DATA1_INTERNAL_8 : std_logic ;
  signal RFO1_DATA1_INTERNAL_9 : std_logic ;
  signal RFO1_DATA1_INTERNAL_10 : std_logic ;
  signal RFO1_DATA1_INTERNAL_11 : std_logic ;
  signal RFO1_DATA1_INTERNAL_12 : std_logic ;
  signal RFO1_DATA1_INTERNAL_13 : std_logic ;
  signal RFO1_DATA1_INTERNAL_14 : std_logic ;
  signal RFO1_DATA1_INTERNAL_15 : std_logic ;
  signal RFO1_DATA1_INTERNAL_16 : std_logic ;
  signal RFO1_DATA1_INTERNAL_17 : std_logic ;
  signal RFO1_DATA1_INTERNAL_18 : std_logic ;
  signal RFO1_DATA1_INTERNAL_19 : std_logic ;
  signal RFO1_DATA1_INTERNAL_20 : std_logic ;
  signal RFO1_DATA1_INTERNAL_21 : std_logic ;
  signal RFO1_DATA1_INTERNAL_22 : std_logic ;
  signal RFO1_DATA1_INTERNAL_23 : std_logic ;
  signal RFO1_DATA1_INTERNAL_24 : std_logic ;
  signal RFO1_DATA1_INTERNAL_25 : std_logic ;
  signal RFO1_DATA1_INTERNAL_26 : std_logic ;
  signal RFO1_DATA1_INTERNAL_27 : std_logic ;
  signal RFO1_DATA1_INTERNAL_28 : std_logic ;
  signal RFO1_DATA1_INTERNAL_29 : std_logic ;
  signal RFO1_DATA1_INTERNAL_30 : std_logic ;
  signal RFO1_DATA2_INTERNAL : std_logic ;
  signal RFO1_DATA2_INTERNAL_0 : std_logic ;
  signal RFO1_DATA2_INTERNAL_1 : std_logic ;
  signal RFO1_DATA2_INTERNAL_2 : std_logic ;
  signal RFO1_DATA2_INTERNAL_3 : std_logic ;
  signal RFO1_DATA2_INTERNAL_4 : std_logic ;
  signal RFO1_DATA2_INTERNAL_5 : std_logic ;
  signal RFO1_DATA2_INTERNAL_6 : std_logic ;
  signal RFO1_DATA2_INTERNAL_7 : std_logic ;
  signal RFO1_DATA2_INTERNAL_8 : std_logic ;
  signal RFO1_DATA2_INTERNAL_9 : std_logic ;
  signal RFO1_DATA2_INTERNAL_10 : std_logic ;
  signal RFO1_DATA2_INTERNAL_11 : std_logic ;
  signal RFO1_DATA2_INTERNAL_12 : std_logic ;
  signal RFO1_DATA2_INTERNAL_13 : std_logic ;
  signal RFO1_DATA2_INTERNAL_14 : std_logic ;
  signal RFO1_DATA2_INTERNAL_15 : std_logic ;
  signal RFO1_DATA2_INTERNAL_16 : std_logic ;
  signal RFO1_DATA2_INTERNAL_17 : std_logic ;
  signal RFO1_DATA2_INTERNAL_18 : std_logic ;
  signal RFO1_DATA2_INTERNAL_19 : std_logic ;
  signal RFO1_DATA2_INTERNAL_20 : std_logic ;
  signal RFO1_DATA2_INTERNAL_21 : std_logic ;
  signal RFO1_DATA2_INTERNAL_22 : std_logic ;
  signal RFO1_DATA2_INTERNAL_23 : std_logic ;
  signal RFO1_DATA2_INTERNAL_24 : std_logic ;
  signal RFO1_DATA2_INTERNAL_25 : std_logic ;
  signal RFO1_DATA2_INTERNAL_26 : std_logic ;
  signal RFO1_DATA2_INTERNAL_27 : std_logic ;
  signal RFO1_DATA2_INTERNAL_28 : std_logic ;
  signal RFO1_DATA2_INTERNAL_29 : std_logic ;
  signal RFO1_DATA2_INTERNAL_30 : std_logic ;
  signal RFO2_DATA1_INTERNAL : std_logic ;
  signal RFO2_DATA1_INTERNAL_0 : std_logic ;
  signal RFO2_DATA1_INTERNAL_1 : std_logic ;
  signal RFO2_DATA1_INTERNAL_2 : std_logic ;
  signal RFO2_DATA1_INTERNAL_3 : std_logic ;
  signal RFO2_DATA1_INTERNAL_4 : std_logic ;
  signal RFO2_DATA1_INTERNAL_5 : std_logic ;
  signal RFO2_DATA1_INTERNAL_6 : std_logic ;
  signal RFO2_DATA1_INTERNAL_7 : std_logic ;
  signal RFO2_DATA1_INTERNAL_8 : std_logic ;
  signal RFO2_DATA1_INTERNAL_9 : std_logic ;
  signal RFO2_DATA1_INTERNAL_10 : std_logic ;
  signal RFO2_DATA1_INTERNAL_11 : std_logic ;
  signal RFO2_DATA1_INTERNAL_12 : std_logic ;
  signal RFO2_DATA1_INTERNAL_13 : std_logic ;
  signal RFO2_DATA1_INTERNAL_14 : std_logic ;
  signal RFO2_DATA1_INTERNAL_15 : std_logic ;
  signal RFO2_DATA1_INTERNAL_16 : std_logic ;
  signal RFO2_DATA1_INTERNAL_17 : std_logic ;
  signal RFO2_DATA1_INTERNAL_18 : std_logic ;
  signal RFO2_DATA1_INTERNAL_19 : std_logic ;
  signal RFO2_DATA1_INTERNAL_20 : std_logic ;
  signal RFO2_DATA1_INTERNAL_21 : std_logic ;
  signal RFO2_DATA1_INTERNAL_22 : std_logic ;
  signal RFO2_DATA1_INTERNAL_23 : std_logic ;
  signal RFO2_DATA1_INTERNAL_24 : std_logic ;
  signal RFO2_DATA1_INTERNAL_25 : std_logic ;
  signal RFO2_DATA1_INTERNAL_26 : std_logic ;
  signal RFO2_DATA1_INTERNAL_27 : std_logic ;
  signal RFO2_DATA1_INTERNAL_28 : std_logic ;
  signal RFO2_DATA1_INTERNAL_29 : std_logic ;
  signal RFO2_DATA1_INTERNAL_30 : std_logic ;
  signal RFO2_DATA2_INTERNAL : std_logic ;
  signal RFO2_DATA2_INTERNAL_0 : std_logic ;
  signal RFO2_DATA2_INTERNAL_1 : std_logic ;
  signal RFO2_DATA2_INTERNAL_2 : std_logic ;
  signal RFO2_DATA2_INTERNAL_3 : std_logic ;
  signal RFO2_DATA2_INTERNAL_4 : std_logic ;
  signal RFO2_DATA2_INTERNAL_5 : std_logic ;
  signal RFO2_DATA2_INTERNAL_6 : std_logic ;
  signal RFO2_DATA2_INTERNAL_7 : std_logic ;
  signal RFO2_DATA2_INTERNAL_8 : std_logic ;
  signal RFO2_DATA2_INTERNAL_9 : std_logic ;
  signal RFO2_DATA2_INTERNAL_10 : std_logic ;
  signal RFO2_DATA2_INTERNAL_11 : std_logic ;
  signal RFO2_DATA2_INTERNAL_12 : std_logic ;
  signal RFO2_DATA2_INTERNAL_13 : std_logic ;
  signal RFO2_DATA2_INTERNAL_14 : std_logic ;
  signal RFO2_DATA2_INTERNAL_15 : std_logic ;
  signal RFO2_DATA2_INTERNAL_16 : std_logic ;
  signal RFO2_DATA2_INTERNAL_17 : std_logic ;
  signal RFO2_DATA2_INTERNAL_18 : std_logic ;
  signal RFO2_DATA2_INTERNAL_19 : std_logic ;
  signal RFO2_DATA2_INTERNAL_20 : std_logic ;
  signal RFO2_DATA2_INTERNAL_21 : std_logic ;
  signal RFO2_DATA2_INTERNAL_22 : std_logic ;
  signal RFO2_DATA2_INTERNAL_23 : std_logic ;
  signal RFO2_DATA2_INTERNAL_24 : std_logic ;
  signal RFO2_DATA2_INTERNAL_25 : std_logic ;
  signal RFO2_DATA2_INTERNAL_26 : std_logic ;
  signal RFO2_DATA2_INTERNAL_27 : std_logic ;
  signal RFO2_DATA2_INTERNAL_28 : std_logic ;
  signal RFO2_DATA2_INTERNAL_29 : std_logic ;
  signal RFO2_DATA2_INTERNAL_30 : std_logic ;
  signal GND : std_logic ;
  signal VCC : std_logic ;
  signal \GRLFPC20.FPI.START\ : std_logic ;
  signal \GRLFPC20.FPI.RST\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY\ : std_logic ;
  signal \GRLFPC20.R.X.LD\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.SEQERR\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D\ : std_logic ;
  signal \GRLFPC20.R.A.RS2D\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ\ : std_logic ;
  signal \GRLFPC20.R.MK.RST\ : std_logic ;
  signal \GRLFPC20.R.MK.RST2\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN1\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.ST\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN2\ : std_logic ;
  signal \GRLFPC20.R.I.V\ : std_logic ;
  signal \GRLFPC20.R.M.LD\ : std_logic ;
  signal \GRLFPC20.R.E.LD\ : std_logic ;
  signal \GRLFPC20.R.A.LD\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP\ : std_logic ;
  signal \GRLFPC20.R.MK.LDOP\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ\ : std_logic ;
  signal \GRLFPC20.R.A.MOV\ : std_logic ;
  signal \GRLFPC20.R.I.RDD\ : std_logic ;
  signal \GRLFPC20.R.X.RDD\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD\ : std_logic ;
  signal \GRLFPC20.COMB.RS2D_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.MK.RST_1\ : std_logic ;
  signal \GRLFPC20.N_2001\ : std_logic ;
  signal \GRLFPC20.N_314\ : std_logic ;
  signal \GRLFPC20.N_315\ : std_logic ;
  signal \GRLFPC20.N_316\ : std_logic ;
  signal \GRLFPC20.N_319\ : std_logic ;
  signal \GRLFPC20.N_320\ : std_logic ;
  signal \GRLFPC20.N_321\ : std_logic ;
  signal \GRLFPC20.N_2562\ : std_logic ;
  signal \GRLFPC20.N_2564\ : std_logic ;
  signal \GRLFPC20.N_2566\ : std_logic ;
  signal \GRLFPC20.N_2683\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_319__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_317__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4734\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4696\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4697\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4736\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7954\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10688\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10689\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10690\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10691\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10692\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10693\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10694\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10695\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10696\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10697\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10698\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10699\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10700\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10701\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10702\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10703\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10704\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10705\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10706\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10707\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10708\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10709\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10710\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10711\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10713\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10714\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10715\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10716\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10717\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10718\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10719\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10720\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10721\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10722\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10723\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10724\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10725\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10726\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10727\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10728\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10729\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10730\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10731\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10732\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10733\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10734\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10735\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10736\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10737\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10738\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10739\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10740\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10741\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10742\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10743\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10744\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10745\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10748\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10749\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10750\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10751\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10752\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10753\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10754\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10755\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10756\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10757\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10758\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10759\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10760\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10761\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10762\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10763\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10764\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10765\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10766\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10767\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10768\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10769\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10770\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10771\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10772\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10773\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10774\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10775\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10776\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10777\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10778\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10779\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10780\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10781\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10782\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10783\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10784\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10785\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10786\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10787\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10788\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10789\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10790\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10791\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10792\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10793\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10794\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10795\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10796\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10797\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10798\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10799\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10800\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10801\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10802\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10803\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10804\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10805\ : std_logic ;
  signal N_26822_1 : std_logic ;
  signal N_27396_1 : std_logic ;
  signal N_26722_I : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7440\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN38_PCTRL_NEW_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I\ : std_logic ;
  signal N_27104_I : std_logic ;
  signal N_27209_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\ : std_logic ;
  signal N_28098_I : std_logic ;
  signal N_27978_2 : std_logic ;
  signal N_27131_1 : std_logic ;
  signal N_26971_1 : std_logic ;
  signal N_28273 : std_logic ;
  signal N_28292 : std_logic ;
  signal N_23715_1 : std_logic ;
  signal N_27050_1 : std_logic ;
  signal N_28292_1 : std_logic ;
  signal N_26764_1 : std_logic ;
  signal N_22426_1 : std_logic ;
  signal N_27482_1 : std_logic ;
  signal N_26981_1 : std_logic ;
  signal N_27208_1 : std_logic ;
  signal N_27286_1 : std_logic ;
  signal N_22759_1 : std_logic ;
  signal N_22427_1 : std_logic ;
  signal N_23024_1 : std_logic ;
  signal N_22745_1 : std_logic ;
  signal N_22424_2 : std_logic ;
  signal N_28123_4 : std_logic ;
  signal N_22756_1 : std_logic ;
  signal N_22530_1 : std_logic ;
  signal N_23079_1 : std_logic ;
  signal N_23850_1 : std_logic ;
  signal N_26808_1 : std_logic ;
  signal N_28048_1 : std_logic ;
  signal N_26815_1 : std_logic ;
  signal N_22425_1 : std_logic ;
  signal N_23785_1 : std_logic ;
  signal N_27989_2 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4274\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_47__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_40__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_24__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_22__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_8__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_2__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_316__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_262__N_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_260__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\ : std_logic ;
  signal \GRLFPC20.R.A.RDD_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.A.ST_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.COMB.RS1D_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD_0_0_G2\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_0__G4\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__G4\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_17__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_19__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_20__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_21__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_0__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_1__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_0__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_1__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_2__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_3__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_4__G2\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__N_5\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_2__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_3__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G1\ : std_logic ;
  signal N_30674 : std_logic ;
  signal N_30675 : std_logic ;
  signal N_30873 : std_logic ;
  signal N_30897 : std_logic ;
  signal N_30921 : std_logic ;
  signal N_30959 : std_logic ;
  signal N_30976 : std_logic ;
  signal N_30991 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4702_I\ : std_logic ;
  signal N_32136 : std_logic ;
  signal N_32137 : std_logic ;
  signal N_32138 : std_logic ;
  signal N_32139 : std_logic ;
  signal N_32140 : std_logic ;
  signal N_32141 : std_logic ;
  signal N_32142 : std_logic ;
  signal N_32143 : std_logic ;
  signal N_32144 : std_logic ;
  signal N_32145 : std_logic ;
  signal N_32146 : std_logic ;
  signal N_32147 : std_logic ;
  signal N_32148 : std_logic ;
  signal N_32149 : std_logic ;
  signal N_32150 : std_logic ;
  signal RST_INTERNAL : std_logic ;
  signal \GRLFPC20.N_1802\ : std_logic ;
  signal \GRLFPC20.N_1804\ : std_logic ;
  signal \GRLFPC20.N_1173\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__I1_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\ : std_logic ;
  signal N_32997 : std_logic ;
  signal N_32998 : std_logic ;
  signal N_32999 : std_logic ;
  signal N_33000 : std_logic ;
  signal N_33001 : std_logic ;
  signal N_33002 : std_logic ;
  signal N_23342 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5457\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5465\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11405\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11411\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11403\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11408\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11409\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11410\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11412\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_84\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_78\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5019_1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4660\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11399\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11407\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11414\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7160\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1490_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7249\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7192\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7194\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7311\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5415\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7244\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1493_I\ : std_logic ;
  signal N_29124 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7133\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7768\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.54.TRFWWBASICCELL.TEMP2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7217\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_138\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11179\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11178\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11339\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11192\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11191\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11340\ : std_logic ;
  signal N_30760 : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_2_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5312\ : std_logic ;
  signal \GRLFPC20.N_1269\ : std_logic ;
  signal \GRLFPC20.N_1146\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_2_SQMUXA\ : std_logic ;
  signal \GRLFPC20.N_3423\ : std_logic ;
  signal \GRLFPC20.N_3419\ : std_logic ;
  signal \GRLFPC20.N_1170\ : std_logic ;
  signal N_28095 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3953\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4345\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\ : std_logic ;
  signal N_30696 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__I1_I_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4583\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3968\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7073\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7480\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5522\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10453\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7506\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7092\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13694\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7072\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5454\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13693\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN22_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_GEN\ : std_logic ;
  signal \GRLFPC20.N_3741\ : std_logic ;
  signal \GRLFPC20.UN1_FPOP7_1\ : std_logic ;
  signal \GRLFPC20.N_952\ : std_logic ;
  signal \GRLFPC20.RS1V_0_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.N_3761\ : std_logic ;
  signal \GRLFPC20.N_3733\ : std_logic ;
  signal \GRLFPC20.N_3737\ : std_logic ;
  signal \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\ : std_logic ;
  signal \GRLFPC20.N_3736\ : std_logic ;
  signal \GRLFPC20.N_3730\ : std_logic ;
  signal \GRLFPC20.N_3773\ : std_logic ;
  signal \GRLFPC20.N_3748\ : std_logic ;
  signal \GRLFPC20.N_3747\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D_0_0_G4\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G3\ : std_logic ;
  signal \GRLFPC20.N_2391\ : std_logic ;
  signal \GRLFPC20.N_3727\ : std_logic ;
  signal N_31104 : std_logic ;
  signal \GRLFPC20.N_3458\ : std_logic ;
  signal \GRLFPC20.N_3728\ : std_logic ;
  signal \GRLFPC20.WREN2_2_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.N_1693\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11406\ : std_logic ;
  signal \GRLFPC20.N_3662\ : std_logic ;
  signal \GRLFPC20.N_3661\ : std_logic ;
  signal \GRLFPC20.N_3655\ : std_logic ;
  signal \GRLFPC20.N_3654\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.I.V\ : std_logic ;
  signal \GRLFPC20.R.I.V_M\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.I.EXEC_5\ : std_logic ;
  signal \GRLFPC20.N_2370\ : std_logic ;
  signal \GRLFPC20.N_2125\ : std_logic ;
  signal \GRLFPC20.N_1211\ : std_logic ;
  signal \GRLFPC20.N_1660\ : std_logic ;
  signal N_31028_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5427\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5424\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SCTRL_NEW_0_0__N_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11014\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10666\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11327\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11316\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10677\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11319\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10669\ : std_logic ;
  signal N_30990 : std_logic ;
  signal N_29164 : std_logic ;
  signal \GRLFPC20.UN1_FPCI_5\ : std_logic ;
  signal \GRLFPC20.N_1256\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_ANNULFPU\ : std_logic ;
  signal \GRLFPC20.N_3408\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G2\ : std_logic ;
  signal \GRLFPC20.N_1739_M\ : std_logic ;
  signal \GRLFPC20.N_1507\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7767\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7302\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7209\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7117\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_1\ : std_logic ;
  signal \GRLFPC20.N_3399\ : std_logic ;
  signal \GRLFPC20.N_3398\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_3_SQMUXA\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11322\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10672\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4433\ : std_logic ;
  signal \GRLFPC20.FPO.SIGN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11312\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10662\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11285\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11225\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11226\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10635\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11220\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10454\ : std_logic ;
  signal \GRLFPC20.N_3766\ : std_logic ;
  signal \GRLFPC20.N_3184\ : std_logic ;
  signal \GRLFPC20.N_2305\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7562\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11017\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10892\ : std_logic ;
  signal N_24030 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4724\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4644\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4012\ : std_logic ;
  signal N_28124 : std_logic ;
  signal N_28117 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLCREGXZ.UN2_INFORCREGSN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11533\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11427\ : std_logic ;
  signal \GRLFPC20.N_3397\ : std_logic ;
  signal \GRLFPC20.N_3403\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_17__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G2\ : std_logic ;
  signal \GRLFPC20.N_3415\ : std_logic ;
  signal N_30848 : std_logic ;
  signal N_30826 : std_logic ;
  signal N_30804 : std_logic ;
  signal N_30782 : std_logic ;
  signal N_30738 : std_logic ;
  signal N_30716 : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.I7_MUX\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13773\ : std_logic ;
  signal N_28287 : std_logic ;
  signal N_27686 : std_logic ;
  signal N_26740 : std_logic ;
  signal N_26739 : std_logic ;
  signal N_26741 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10452\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_71\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11200\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11183\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11197\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11196\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11202\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11198\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10670\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10667\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11284\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11224\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10634\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11332\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10682\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10479\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11304\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11302\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10654\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10652\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11195\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11199\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11203\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11182\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11281\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11282\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11283\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11286\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11287\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11288\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11289\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11290\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10465\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11292\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11293\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10468\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11295\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11296\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11297\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11298\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11299\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11300\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11301\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11303\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10480\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10481\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11308\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11310\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11311\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11313\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11314\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11317\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11318\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11320\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11321\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11323\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11324\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11325\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11326\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11328\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11329\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11331\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10508\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10509\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10631\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10632\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10633\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10636\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10637\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10638\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10639\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10640\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10642\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10643\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10645\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10646\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10647\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10648\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10649\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10650\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10651\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10653\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10658\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10660\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10661\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10663\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10664\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10668\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10671\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10673\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10674\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10675\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10676\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10678\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10679\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10681\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11021\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11227\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11228\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11229\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11230\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11503\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11532\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11309\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11315\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10504\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10507\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10659\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10665\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11363\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11379\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8427\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11013\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11015\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11016\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11018\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11019\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11020\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11022\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11025\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11026\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11027\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11193\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11194\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11201\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11180\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11181\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11218\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11341\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11342\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10894\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10947\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_172__N_6\ : std_logic ;
  signal N_30866 : std_logic ;
  signal N_24032 : std_logic ;
  signal N_28294 : std_logic ;
  signal N_28284 : std_logic ;
  signal N_28131 : std_logic ;
  signal N_28123 : std_logic ;
  signal N_28122 : std_logic ;
  signal N_28121 : std_logic ;
  signal N_28120 : std_logic ;
  signal N_28118 : std_logic ;
  signal N_27682 : std_logic ;
  signal N_26742 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13708\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5471\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5474\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5391\ : std_logic ;
  signal \GRLFPC20.N_3753\ : std_logic ;
  signal \GRLFPC20.N_3756\ : std_logic ;
  signal \GRLFPC20.N_920\ : std_logic ;
  signal \GRLFPC20.N_3750\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD2\ : std_logic ;
  signal \GRLFPC20.N_3744\ : std_logic ;
  signal \GRLFPC20.N_891\ : std_logic ;
  signal \GRLFPC20.N_2305_1\ : std_logic ;
  signal \GRLFPC20.N_3772\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7448\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4008\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5398\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5399\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5402\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN14_EXMIPTRLSBS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_25\ : std_logic ;
  signal \GRLFPC20.N_951\ : std_logic ;
  signal N_24036 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\ : std_logic ;
  signal N_24031 : std_logic ;
  signal N_24029 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7222\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7191\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLCREGXZ.UN11_INFORCREGSN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11366\ : std_logic ;
  signal N_26972_1 : std_logic ;
  signal N_23344 : std_logic ;
  signal N_28154_1 : std_logic ;
  signal N_23346 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\ : std_logic ;
  signal N_23026_1 : std_logic ;
  signal N_27020 : std_logic ;
  signal N_27257_I : std_logic ;
  signal N_27523 : std_logic ;
  signal N_28219 : std_logic ;
  signal N_28055 : std_logic ;
  signal N_28057 : std_logic ;
  signal N_28072 : std_logic ;
  signal N_27826 : std_logic ;
  signal N_27827 : std_logic ;
  signal N_27061 : std_logic ;
  signal N_27054 : std_logic ;
  signal N_27050 : std_logic ;
  signal N_27983 : std_logic ;
  signal N_27989 : std_logic ;
  signal N_27988 : std_logic ;
  signal N_27990 : std_logic ;
  signal N_27987 : std_logic ;
  signal N_23361 : std_logic ;
  signal N_28033_I : std_logic ;
  signal N_23362_1 : std_logic ;
  signal N_22600_1 : std_logic ;
  signal N_26908 : std_logic ;
  signal N_27762_1 : std_logic ;
  signal N_26909 : std_logic ;
  signal N_26910_3 : std_logic ;
  signal N_26920_1 : std_logic ;
  signal N_27811 : std_logic ;
  signal N_26975_1 : std_logic ;
  signal N_26914 : std_logic ;
  signal N_27046_1 : std_logic ;
  signal N_27793_I : std_logic ;
  signal N_27053_2 : std_logic ;
  signal N_22804_1 : std_logic ;
  signal N_23003_1 : std_logic ;
  signal N_26986_1 : std_logic ;
  signal N_26747_1 : std_logic ;
  signal N_22681_1 : std_logic ;
  signal N_27065_2 : std_logic ;
  signal N_27067_1 : std_logic ;
  signal N_27081_1 : std_logic ;
  signal N_27177 : std_logic ;
  signal N_27397_1 : std_logic ;
  signal N_22599_1 : std_logic ;
  signal N_26813_1 : std_logic ;
  signal N_27993_2 : std_logic ;
  signal N_28046 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10325\ : std_logic ;
  signal N_27792 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10216\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10379\ : std_logic ;
  signal N_27731_I : std_logic ;
  signal N_23668 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10283\ : std_logic ;
  signal N_23622_1 : std_logic ;
  signal N_27794 : std_logic ;
  signal N_27871 : std_logic ;
  signal N_28006 : std_logic ;
  signal N_27830 : std_logic ;
  signal N_27840 : std_logic ;
  signal N_27268 : std_logic ;
  signal N_27271 : std_logic ;
  signal N_28189 : std_logic ;
  signal N_28190 : std_logic ;
  signal N_28192 : std_logic ;
  signal N_28195 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10222\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10271\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9827\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10246\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9385\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\ : std_logic ;
  signal N_26890 : std_logic ;
  signal N_22589_1 : std_logic ;
  signal N_23791_1 : std_logic ;
  signal N_27272_1 : std_logic ;
  signal N_27247 : std_logic ;
  signal N_28178 : std_logic ;
  signal N_26726_I : std_logic ;
  signal N_27068_1 : std_logic ;
  signal N_28194_1 : std_logic ;
  signal N_22496_2 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\ : std_logic ;
  signal N_27149_1 : std_logic ;
  signal N_27882 : std_logic ;
  signal N_27925 : std_logic ;
  signal N_27913 : std_logic ;
  signal N_27928 : std_logic ;
  signal N_27047 : std_logic ;
  signal N_27053 : std_logic ;
  signal N_27749 : std_logic ;
  signal N_27751 : std_logic ;
  signal N_27755 : std_logic ;
  signal N_22651_I : std_logic ;
  signal N_22612_1 : std_logic ;
  signal N_27062 : std_logic ;
  signal N_27066 : std_logic ;
  signal N_22744_1 : std_logic ;
  signal N_27763_1 : std_logic ;
  signal N_27910_2 : std_logic ;
  signal N_27291_1 : std_logic ;
  signal N_26773_I : std_logic ;
  signal N_23982 : std_logic ;
  signal N_26948_I : std_logic ;
  signal N_26993_1 : std_logic ;
  signal N_23976 : std_logic ;
  signal N_23954 : std_logic ;
  signal N_23956 : std_logic ;
  signal N_23984 : std_logic ;
  signal N_27325 : std_logic ;
  signal N_27524 : std_logic ;
  signal N_27561 : std_logic ;
  signal N_27342 : std_logic ;
  signal N_27347 : std_logic ;
  signal N_27341 : std_logic ;
  signal N_27339 : std_logic ;
  signal N_23966 : std_logic ;
  signal N_23968 : std_logic ;
  signal N_23963 : std_logic ;
  signal N_22429_1 : std_logic ;
  signal N_22958_1 : std_logic ;
  signal N_23953 : std_logic ;
  signal N_26820_1 : std_logic ;
  signal N_27342_2 : std_logic ;
  signal N_28336_1 : std_logic ;
  signal N_26932_1 : std_logic ;
  signal N_22730_I : std_logic ;
  signal N_27469_1 : std_logic ;
  signal N_23165_1 : std_logic ;
  signal N_27338_2 : std_logic ;
  signal N_26978_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G4\ : std_logic ;
  signal N_22588_1 : std_logic ;
  signal N_22947_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10139\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10048\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G4\ : std_logic ;
  signal N_27628 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10088\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10044\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10230\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_22__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9390\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10316\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9337\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9998\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9434\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G4\ : std_logic ;
  signal N_23324 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9208\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9186\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10244\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9822\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G4\ : std_logic ;
  signal N_27997 : std_logic ;
  signal N_27266 : std_logic ;
  signal N_27267 : std_logic ;
  signal N_27202 : std_logic ;
  signal N_27201 : std_logic ;
  signal N_27049 : std_logic ;
  signal N_27041 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9317\ : std_logic ;
  signal N_27096 : std_logic ;
  signal N_27186 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\ : std_logic ;
  signal N_27383 : std_logic ;
  signal N_27533 : std_logic ;
  signal N_27970 : std_logic ;
  signal N_28217 : std_logic ;
  signal N_23274 : std_logic ;
  signal N_22818_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10303\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10203\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10161\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10298\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\ : std_logic ;
  signal N_23276 : std_logic ;
  signal N_26994_2 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10220\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10184\ : std_logic ;
  signal N_27696_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10218\ : std_logic ;
  signal N_23353 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10180\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10042\ : std_logic ;
  signal N_22889_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9698\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9889\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\ : std_logic ;
  signal N_23366 : std_logic ;
  signal N_23364 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10066\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10068\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9768\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9742\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9251\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9869\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10133\ : std_logic ;
  signal N_26800 : std_logic ;
  signal N_26869 : std_logic ;
  signal N_26976 : std_logic ;
  signal N_28065_1 : std_logic ;
  signal N_27043 : std_logic ;
  signal N_27126 : std_logic ;
  signal N_27135 : std_logic ;
  signal N_27144_1 : std_logic ;
  signal N_27397 : std_logic ;
  signal N_27472 : std_logic ;
  signal N_27549 : std_logic ;
  signal N_27618 : std_logic ;
  signal N_27619 : std_logic ;
  signal N_27620 : std_logic ;
  signal N_27688 : std_logic ;
  signal N_27750 : std_logic ;
  signal N_27979 : std_logic ;
  signal N_28049 : std_logic ;
  signal N_28414_3 : std_logic ;
  signal N_28413 : std_logic ;
  signal N_28411 : std_logic ;
  signal N_22486_1 : std_logic ;
  signal N_28438 : std_logic ;
  signal N_28408 : std_logic ;
  signal N_28407 : std_logic ;
  signal N_28401 : std_logic ;
  signal N_22608_2 : std_logic ;
  signal N_28400 : std_logic ;
  signal N_28399 : std_logic ;
  signal N_28398 : std_logic ;
  signal N_27377 : std_logic ;
  signal N_28397 : std_logic ;
  signal N_28395 : std_logic ;
  signal N_28349 : std_logic ;
  signal N_28312 : std_logic ;
  signal N_28345 : std_logic ;
  signal N_28342_1 : std_logic ;
  signal N_28340 : std_logic ;
  signal N_28337 : std_logic ;
  signal N_28335 : std_logic ;
  signal N_28333 : std_logic ;
  signal N_28332 : std_logic ;
  signal N_28322 : std_logic ;
  signal N_28297 : std_logic ;
  signal N_28290 : std_logic ;
  signal N_26801_1 : std_logic ;
  signal N_28289 : std_logic ;
  signal N_28252 : std_logic ;
  signal N_28251 : std_logic ;
  signal N_28247 : std_logic ;
  signal N_28246 : std_logic ;
  signal N_28245 : std_logic ;
  signal N_28242 : std_logic ;
  signal N_28242_1 : std_logic ;
  signal N_28241 : std_logic ;
  signal N_28240 : std_logic ;
  signal N_23117_1 : std_logic ;
  signal N_28208 : std_logic ;
  signal N_28186 : std_logic ;
  signal N_28185 : std_logic ;
  signal N_28184 : std_logic ;
  signal N_28065 : std_logic ;
  signal N_28062 : std_logic ;
  signal N_28062_1 : std_logic ;
  signal N_28056 : std_logic ;
  signal N_28054 : std_logic ;
  signal N_28052 : std_logic ;
  signal N_28050 : std_logic ;
  signal N_28050_1 : std_logic ;
  signal N_28048 : std_logic ;
  signal N_28047 : std_logic ;
  signal N_27994 : std_logic ;
  signal N_27986 : std_logic ;
  signal N_27981_3 : std_logic ;
  signal N_27980 : std_logic ;
  signal N_27924 : std_logic ;
  signal N_27923 : std_logic ;
  signal N_27922 : std_logic ;
  signal N_27920 : std_logic ;
  signal N_27919 : std_logic ;
  signal N_27917 : std_logic ;
  signal N_27916_2 : std_logic ;
  signal N_27915 : std_logic ;
  signal N_27914 : std_logic ;
  signal N_27912 : std_logic ;
  signal N_27910 : std_logic ;
  signal N_27908 : std_logic ;
  signal N_27902 : std_logic ;
  signal N_27849_2 : std_logic ;
  signal N_27846 : std_logic ;
  signal N_26969_1 : std_logic ;
  signal N_27799_I : std_logic ;
  signal N_27838 : std_logic ;
  signal N_27837 : std_logic ;
  signal N_27836 : std_logic ;
  signal N_27835 : std_logic ;
  signal N_27831 : std_logic ;
  signal N_27829 : std_logic ;
  signal N_27785 : std_logic ;
  signal N_27756_2 : std_logic ;
  signal N_27753 : std_logic ;
  signal N_27752 : std_logic ;
  signal N_27748 : std_logic ;
  signal N_27747 : std_logic ;
  signal N_27747_1 : std_logic ;
  signal N_27746 : std_logic ;
  signal N_27698_2 : std_logic ;
  signal N_27694 : std_logic ;
  signal N_27693 : std_logic ;
  signal N_27691 : std_logic ;
  signal N_27448_I : std_logic ;
  signal N_27690 : std_logic ;
  signal N_27689 : std_logic ;
  signal N_27634 : std_logic ;
  signal N_27626_2 : std_logic ;
  signal N_27617 : std_logic ;
  signal N_27616 : std_logic ;
  signal N_27615 : std_logic ;
  signal N_27560 : std_logic ;
  signal N_27552 : std_logic ;
  signal N_27585 : std_logic ;
  signal N_27551 : std_logic ;
  signal N_27548 : std_logic ;
  signal N_27547 : std_logic ;
  signal N_27547_1 : std_logic ;
  signal N_27546 : std_logic ;
  signal N_27545 : std_logic ;
  signal N_27491_2 : std_logic ;
  signal N_27516 : std_logic ;
  signal N_27489 : std_logic ;
  signal N_27488 : std_logic ;
  signal N_27486 : std_logic ;
  signal N_27485 : std_logic ;
  signal N_27480_1 : std_logic ;
  signal N_27478_1 : std_logic ;
  signal N_27477 : std_logic ;
  signal N_27476 : std_logic ;
  signal N_27475 : std_logic ;
  signal N_27470 : std_logic ;
  signal N_27469 : std_logic ;
  signal N_27416 : std_logic ;
  signal N_27415_2 : std_logic ;
  signal N_27412 : std_logic ;
  signal N_27411 : std_logic ;
  signal N_27409_1 : std_logic ;
  signal N_27408 : std_logic ;
  signal N_27406 : std_logic ;
  signal N_27404 : std_logic ;
  signal N_27402 : std_logic ;
  signal N_27400 : std_logic ;
  signal N_27398 : std_logic ;
  signal N_27394 : std_logic ;
  signal N_27393 : std_logic ;
  signal N_27392 : std_logic ;
  signal N_27317 : std_logic ;
  signal N_27343 : std_logic ;
  signal N_27338 : std_logic ;
  signal N_27337 : std_logic ;
  signal N_27336_2 : std_logic ;
  signal N_27334 : std_logic ;
  signal N_27289_1 : std_logic ;
  signal N_27288 : std_logic ;
  signal N_27288_2 : std_logic ;
  signal N_27287 : std_logic ;
  signal N_27281 : std_logic ;
  signal N_27280 : std_logic ;
  signal N_27279 : std_logic ;
  signal N_27244 : std_logic ;
  signal N_27274 : std_logic ;
  signal N_27258 : std_logic ;
  signal N_27187 : std_logic ;
  signal N_27218 : std_logic ;
  signal N_27214 : std_logic ;
  signal N_27212 : std_logic ;
  signal N_27208 : std_logic ;
  signal N_27207 : std_logic ;
  signal N_27206 : std_logic ;
  signal N_27205 : std_logic ;
  signal N_27203 : std_logic ;
  signal N_27146 : std_logic ;
  signal N_27095_I : std_logic ;
  signal N_27136 : std_logic ;
  signal N_27107 : std_logic ;
  signal N_27132 : std_logic ;
  signal N_27131 : std_logic ;
  signal N_27125 : std_logic ;
  signal N_27052 : std_logic ;
  signal N_27048 : std_logic ;
  signal N_26981 : std_logic ;
  signal N_22795_I : std_logic ;
  signal N_26979 : std_logic ;
  signal N_26975 : std_logic ;
  signal N_26971 : std_logic ;
  signal N_26970 : std_logic ;
  signal N_26969 : std_logic ;
  signal N_26912 : std_logic ;
  signal N_26913 : std_logic ;
  signal N_26909_1 : std_logic ;
  signal N_26886 : std_logic ;
  signal N_26868 : std_logic ;
  signal N_26868_3 : std_logic ;
  signal N_26867 : std_logic ;
  signal N_26861 : std_logic ;
  signal N_26829 : std_logic ;
  signal N_26823 : std_logic ;
  signal N_26818 : std_logic ;
  signal N_26817 : std_logic ;
  signal N_26815 : std_logic ;
  signal N_26814 : std_logic ;
  signal N_26810 : std_logic ;
  signal N_26808 : std_logic ;
  signal N_26806 : std_logic ;
  signal N_26805 : std_logic ;
  signal N_26804 : std_logic ;
  signal N_26803 : std_logic ;
  signal N_26802 : std_logic ;
  signal N_26788 : std_logic ;
  signal N_26745 : std_logic ;
  signal N_26744 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9826\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10040\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9195\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11910_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9854\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9855\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10091\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10135\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9987\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10278\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9940\ : std_logic ;
  signal N_22820_2 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9844\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10321\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9181\ : std_logic ;
  signal N_23286 : std_logic ;
  signal N_23287 : std_logic ;
  signal N_23289 : std_logic ;
  signal N_23320 : std_logic ;
  signal N_23322 : std_logic ;
  signal N_23323 : std_logic ;
  signal N_23311 : std_logic ;
  signal N_23360 : std_logic ;
  signal N_23362 : std_logic ;
  signal N_23369 : std_logic ;
  signal N_23284 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10210\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9941\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9938\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10061\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10041\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12200_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12640_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9847\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10217\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10094\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9851\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10353\ : std_logic ;
  signal N_27231 : std_logic ;
  signal N_22686_1 : std_logic ;
  signal N_23298 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10197\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10173\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10241\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10193\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10385\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10236\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10212\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10206\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10207\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10182\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10381\ : std_logic ;
  signal N_36514 : std_logic ;
  signal N_36515 : std_logic ;
  signal N_36594 : std_logic ;
  signal N_36595 : std_logic ;
  signal N_36665 : std_logic ;
  signal \GRLFPC20.N_1215_M_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_4_7950_I_0_TZ\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_ANNULFPU_TZ_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_1_C\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_7636_1_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_16_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_9_TZ\ : std_logic ;
  signal \GRLFPC20.N_3765\ : std_logic ;
  signal N_28293_2 : std_logic ;
  signal N_28413_1 : std_logic ;
  signal N_28408_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_0\ : std_logic ;
  signal N_27347_1 : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1_0\ : std_logic ;
  signal N_41586 : std_logic ;
  signal N_41588 : std_logic ;
  signal N_41590 : std_logic ;
  signal N_41592 : std_logic ;
  signal N_41594 : std_logic ;
  signal N_41596 : std_logic ;
  signal N_41598 : std_logic ;
  signal N_41600 : std_logic ;
  signal N_41602 : std_logic ;
  signal N_41604 : std_logic ;
  signal N_41606 : std_logic ;
  signal N_41608 : std_logic ;
  signal N_41610 : std_logic ;
  signal N_41612 : std_logic ;
  signal N_41614 : std_logic ;
  signal N_41616 : std_logic ;
  signal N_41618 : std_logic ;
  signal N_41620 : std_logic ;
  signal N_41622 : std_logic ;
  signal N_41624 : std_logic ;
  signal N_41626 : std_logic ;
  signal N_41628 : std_logic ;
  signal N_41630 : std_logic ;
  signal N_41632 : std_logic ;
  signal N_41634 : std_logic ;
  signal N_41636 : std_logic ;
  signal N_41638 : std_logic ;
  signal N_41640 : std_logic ;
  signal N_41642 : std_logic ;
  signal N_41644 : std_logic ;
  signal N_41646 : std_logic ;
  signal N_41648 : std_logic ;
  signal N_41650 : std_logic ;
  signal N_41652 : std_logic ;
  signal N_41654 : std_logic ;
  signal N_41656 : std_logic ;
  signal N_41658 : std_logic ;
  signal N_41660 : std_logic ;
  signal N_41662 : std_logic ;
  signal N_41664 : std_logic ;
  signal N_41666 : std_logic ;
  signal N_41668 : std_logic ;
  signal N_41670 : std_logic ;
  signal N_41672 : std_logic ;
  signal N_41674 : std_logic ;
  signal N_41676 : std_logic ;
  signal N_41678 : std_logic ;
  signal N_41680 : std_logic ;
  signal N_41682 : std_logic ;
  signal N_41684 : std_logic ;
  signal N_41686 : std_logic ;
  signal N_41688 : std_logic ;
  signal N_41690 : std_logic ;
  signal N_41692 : std_logic ;
  signal N_41694 : std_logic ;
  signal N_41696 : std_logic ;
  signal N_41698 : std_logic ;
  signal N_41700 : std_logic ;
  signal N_41702 : std_logic ;
  signal N_41704 : std_logic ;
  signal N_41706 : std_logic ;
  signal N_41708 : std_logic ;
  signal N_41710 : std_logic ;
  signal N_41712 : std_logic ;
  signal N_41714 : std_logic ;
  signal N_41716 : std_logic ;
  signal N_41718 : std_logic ;
  signal N_41720 : std_logic ;
  signal N_41722 : std_logic ;
  signal N_41724 : std_logic ;
  signal N_41726 : std_logic ;
  signal N_41728 : std_logic ;
  signal N_41730 : std_logic ;
  signal N_41732 : std_logic ;
  signal N_41734 : std_logic ;
  signal N_41736 : std_logic ;
  signal N_41738 : std_logic ;
  signal N_41740 : std_logic ;
  signal N_41742 : std_logic ;
  signal N_41744 : std_logic ;
  signal N_41746 : std_logic ;
  signal N_41748 : std_logic ;
  signal N_41750 : std_logic ;
  signal N_41752 : std_logic ;
  signal N_41754 : std_logic ;
  signal N_41756 : std_logic ;
  signal N_41758 : std_logic ;
  signal N_41760 : std_logic ;
  signal N_41762 : std_logic ;
  signal N_41764 : std_logic ;
  signal N_41766 : std_logic ;
  signal N_41768 : std_logic ;
  signal N_41770 : std_logic ;
  signal N_41772 : std_logic ;
  signal N_41774 : std_logic ;
  signal N_41776 : std_logic ;
  signal N_41778 : std_logic ;
  signal N_41780 : std_logic ;
  signal N_41782 : std_logic ;
  signal N_41784 : std_logic ;
  signal N_41786 : std_logic ;
  signal N_41788 : std_logic ;
  signal N_41790 : std_logic ;
  signal N_41792 : std_logic ;
  signal N_41794 : std_logic ;
  signal N_41796 : std_logic ;
  signal N_41798 : std_logic ;
  signal N_41800 : std_logic ;
  signal N_41805 : std_logic ;
  signal N_41806 : std_logic ;
  signal N_41812 : std_logic ;
  signal N_41813 : std_logic ;
  signal N_41821 : std_logic ;
  signal N_41828 : std_logic ;
  signal N_41829 : std_logic ;
  signal N_41835 : std_logic ;
  signal N_41836 : std_logic ;
  signal N_41844 : std_logic ;
  signal N_41851 : std_logic ;
  signal N_41852 : std_logic ;
  signal N_41858 : std_logic ;
  signal N_41859 : std_logic ;
  signal N_41867 : std_logic ;
  signal N_41874 : std_logic ;
  signal N_41875 : std_logic ;
  signal N_41881 : std_logic ;
  signal N_41882 : std_logic ;
  signal N_41890 : std_logic ;
  signal N_41897 : std_logic ;
  signal N_41898 : std_logic ;
  signal N_41904 : std_logic ;
  signal N_41905 : std_logic ;
  signal N_41913 : std_logic ;
  signal N_41920 : std_logic ;
  signal N_41921 : std_logic ;
  signal N_41927 : std_logic ;
  signal N_41928 : std_logic ;
  signal N_41936 : std_logic ;
  signal N_41943 : std_logic ;
  signal N_41944 : std_logic ;
  signal N_41950 : std_logic ;
  signal N_41951 : std_logic ;
  signal N_41959 : std_logic ;
  signal N_41966 : std_logic ;
  signal N_41967 : std_logic ;
  signal N_41973 : std_logic ;
  signal N_41974 : std_logic ;
  signal N_41982 : std_logic ;
  signal N_41989 : std_logic ;
  signal N_41990 : std_logic ;
  signal N_41996 : std_logic ;
  signal N_41997 : std_logic ;
  signal N_42005 : std_logic ;
  signal N_42012 : std_logic ;
  signal N_42013 : std_logic ;
  signal N_42019 : std_logic ;
  signal N_42020 : std_logic ;
  signal N_42028 : std_logic ;
  signal N_42035 : std_logic ;
  signal N_42036 : std_logic ;
  signal N_42042 : std_logic ;
  signal N_42043 : std_logic ;
  signal N_42051 : std_logic ;
  signal N_42058 : std_logic ;
  signal N_42059 : std_logic ;
  signal N_42065 : std_logic ;
  signal N_42066 : std_logic ;
  signal N_42074 : std_logic ;
  signal N_42081 : std_logic ;
  signal N_42082 : std_logic ;
  signal N_42088 : std_logic ;
  signal N_42089 : std_logic ;
  signal N_42097 : std_logic ;
  signal N_42104 : std_logic ;
  signal N_42105 : std_logic ;
  signal N_42111 : std_logic ;
  signal N_42112 : std_logic ;
  signal N_42120 : std_logic ;
  signal N_42127 : std_logic ;
  signal N_42128 : std_logic ;
  signal N_42134 : std_logic ;
  signal N_42135 : std_logic ;
  signal N_42143 : std_logic ;
  signal N_42150 : std_logic ;
  signal N_42151 : std_logic ;
  signal N_42157 : std_logic ;
  signal N_42158 : std_logic ;
  signal N_42166 : std_logic ;
  signal N_42173 : std_logic ;
  signal N_42174 : std_logic ;
  signal N_42180 : std_logic ;
  signal N_42181 : std_logic ;
  signal N_42189 : std_logic ;
  signal N_42196 : std_logic ;
  signal N_42197 : std_logic ;
  signal N_42203 : std_logic ;
  signal N_42204 : std_logic ;
  signal N_42212 : std_logic ;
  signal N_42219 : std_logic ;
  signal N_42220 : std_logic ;
  signal N_42226 : std_logic ;
  signal N_42227 : std_logic ;
  signal N_42235 : std_logic ;
  signal N_42242 : std_logic ;
  signal N_42243 : std_logic ;
  signal N_42249 : std_logic ;
  signal N_42250 : std_logic ;
  signal N_42258 : std_logic ;
  signal N_42265 : std_logic ;
  signal N_42266 : std_logic ;
  signal N_42272 : std_logic ;
  signal N_42273 : std_logic ;
  signal N_42281 : std_logic ;
  signal N_42288 : std_logic ;
  signal N_42289 : std_logic ;
  signal N_42295 : std_logic ;
  signal N_42296 : std_logic ;
  signal N_42304 : std_logic ;
  signal N_42311 : std_logic ;
  signal N_42312 : std_logic ;
  signal N_42318 : std_logic ;
  signal N_42319 : std_logic ;
  signal N_42327 : std_logic ;
  signal N_42334 : std_logic ;
  signal N_42335 : std_logic ;
  signal N_42341 : std_logic ;
  signal N_42342 : std_logic ;
  signal N_42350 : std_logic ;
  signal N_42357 : std_logic ;
  signal N_42358 : std_logic ;
  signal N_42364 : std_logic ;
  signal N_42365 : std_logic ;
  signal N_42373 : std_logic ;
  signal N_42380 : std_logic ;
  signal N_42381 : std_logic ;
  signal N_42387 : std_logic ;
  signal N_42388 : std_logic ;
  signal N_42396 : std_logic ;
  signal N_42403 : std_logic ;
  signal N_42404 : std_logic ;
  signal N_42410 : std_logic ;
  signal N_42411 : std_logic ;
  signal N_42419 : std_logic ;
  signal N_42426 : std_logic ;
  signal N_42427 : std_logic ;
  signal N_42433 : std_logic ;
  signal N_42434 : std_logic ;
  signal N_42442 : std_logic ;
  signal N_42449 : std_logic ;
  signal N_42450 : std_logic ;
  signal N_42456 : std_logic ;
  signal N_42457 : std_logic ;
  signal N_42465 : std_logic ;
  signal N_42472 : std_logic ;
  signal N_42473 : std_logic ;
  signal N_42479 : std_logic ;
  signal N_42480 : std_logic ;
  signal N_42488 : std_logic ;
  signal N_42495 : std_logic ;
  signal N_42496 : std_logic ;
  signal N_42502 : std_logic ;
  signal N_42503 : std_logic ;
  signal N_42511 : std_logic ;
  signal N_42518 : std_logic ;
  signal N_42519 : std_logic ;
  signal N_42525 : std_logic ;
  signal N_42526 : std_logic ;
  signal N_42534 : std_logic ;
  signal N_42541 : std_logic ;
  signal N_42542 : std_logic ;
  signal N_42548 : std_logic ;
  signal N_42549 : std_logic ;
  signal N_42557 : std_logic ;
  signal N_42564 : std_logic ;
  signal N_42565 : std_logic ;
  signal N_42571 : std_logic ;
  signal N_42572 : std_logic ;
  signal N_42580 : std_logic ;
  signal N_42587 : std_logic ;
  signal N_42588 : std_logic ;
  signal N_42594 : std_logic ;
  signal N_42595 : std_logic ;
  signal N_42603 : std_logic ;
  signal N_42610 : std_logic ;
  signal N_42611 : std_logic ;
  signal N_42617 : std_logic ;
  signal N_42618 : std_logic ;
  signal N_42626 : std_logic ;
  signal N_42633 : std_logic ;
  signal N_42634 : std_logic ;
  signal N_42640 : std_logic ;
  signal N_42641 : std_logic ;
  signal N_42649 : std_logic ;
  signal N_42656 : std_logic ;
  signal N_42657 : std_logic ;
  signal N_42663 : std_logic ;
  signal N_42664 : std_logic ;
  signal N_42672 : std_logic ;
  signal N_42679 : std_logic ;
  signal N_42680 : std_logic ;
  signal N_42686 : std_logic ;
  signal N_42687 : std_logic ;
  signal N_42695 : std_logic ;
  signal N_42702 : std_logic ;
  signal N_42703 : std_logic ;
  signal N_42709 : std_logic ;
  signal N_42710 : std_logic ;
  signal N_42718 : std_logic ;
  signal N_42725 : std_logic ;
  signal N_42726 : std_logic ;
  signal N_42732 : std_logic ;
  signal N_42733 : std_logic ;
  signal N_42741 : std_logic ;
  signal N_42748 : std_logic ;
  signal N_42749 : std_logic ;
  signal N_42755 : std_logic ;
  signal N_42756 : std_logic ;
  signal N_42764 : std_logic ;
  signal N_42771 : std_logic ;
  signal N_42772 : std_logic ;
  signal N_42778 : std_logic ;
  signal N_42779 : std_logic ;
  signal N_42787 : std_logic ;
  signal N_42794 : std_logic ;
  signal N_42795 : std_logic ;
  signal N_42801 : std_logic ;
  signal N_42802 : std_logic ;
  signal N_42810 : std_logic ;
  signal N_42817 : std_logic ;
  signal N_42818 : std_logic ;
  signal N_42824 : std_logic ;
  signal N_42825 : std_logic ;
  signal N_42833 : std_logic ;
  signal N_42840 : std_logic ;
  signal N_42841 : std_logic ;
  signal N_42847 : std_logic ;
  signal N_42848 : std_logic ;
  signal N_42856 : std_logic ;
  signal N_42863 : std_logic ;
  signal N_42864 : std_logic ;
  signal N_42870 : std_logic ;
  signal N_42871 : std_logic ;
  signal N_42879 : std_logic ;
  signal N_42886 : std_logic ;
  signal N_42887 : std_logic ;
  signal N_42893 : std_logic ;
  signal N_42894 : std_logic ;
  signal N_42902 : std_logic ;
  signal N_42912 : std_logic ;
  signal N_42921 : std_logic ;
  signal N_42922 : std_logic ;
  signal N_42923 : std_logic ;
  signal N_42926 : std_logic ;
  signal N_42927 : std_logic ;
  signal N_42931 : std_logic ;
  signal N_42932 : std_logic ;
  signal N_42938 : std_logic ;
  signal N_42939 : std_logic ;
  signal N_42947 : std_logic ;
  signal N_42954 : std_logic ;
  signal N_42955 : std_logic ;
  signal N_42961 : std_logic ;
  signal N_42962 : std_logic ;
  signal N_42970 : std_logic ;
  signal N_42977 : std_logic ;
  signal N_42978 : std_logic ;
  signal N_42984 : std_logic ;
  signal N_42985 : std_logic ;
  signal N_42993 : std_logic ;
  signal N_43000 : std_logic ;
  signal N_43001 : std_logic ;
  signal N_43007 : std_logic ;
  signal N_43008 : std_logic ;
  signal N_43066 : std_logic ;
  signal N_43067 : std_logic ;
  signal N_43068 : std_logic ;
  signal N_43074 : std_logic ;
  signal N_43075 : std_logic ;
  signal N_43080 : std_logic ;
  signal N_43081 : std_logic ;
  signal N_43086 : std_logic ;
  signal N_43087 : std_logic ;
  signal N_43092 : std_logic ;
  signal N_43093 : std_logic ;
  signal N_43098 : std_logic ;
  signal N_43099 : std_logic ;
  signal N_43104 : std_logic ;
  signal N_43105 : std_logic ;
  signal N_43110 : std_logic ;
  signal N_43111 : std_logic ;
  signal N_43116 : std_logic ;
  signal N_43117 : std_logic ;
  signal N_43122 : std_logic ;
  signal N_43123 : std_logic ;
  signal N_43128 : std_logic ;
  signal N_43129 : std_logic ;
  signal N_43134 : std_logic ;
  signal N_43135 : std_logic ;
  signal N_43140 : std_logic ;
  signal N_43141 : std_logic ;
  signal N_43146 : std_logic ;
  signal N_43147 : std_logic ;
  signal N_43152 : std_logic ;
  signal N_43153 : std_logic ;
  signal N_43158 : std_logic ;
  signal N_43159 : std_logic ;
  signal N_43163 : std_logic ;
  signal N_43257 : std_logic ;
  signal CPI_D_INST_INTERNAL_6 : std_logic ;
  signal \GRLFPC20.N_3768\ : std_logic ;
  signal N_31081 : std_logic ;
  signal N_43535 : std_logic ;
  signal N_43536 : std_logic ;
  signal N_43537 : std_logic ;
  signal N_43538 : std_logic ;
  signal N_43539 : std_logic ;
  signal N_43540 : std_logic ;
  signal N_43541 : std_logic ;
  signal N_43543 : std_logic ;
  signal N_43544 : std_logic ;
  signal N_43545 : std_logic ;
  signal N_43546 : std_logic ;
  signal N_43547 : std_logic ;
  signal N_43550 : std_logic ;
  signal N_43551 : std_logic ;
  signal N_43553 : std_logic ;
  signal N_43555 : std_logic ;
  signal N_43556 : std_logic ;
  signal N_43559 : std_logic ;
  signal N_43560 : std_logic ;
  signal N_43561 : std_logic ;
  signal N_43562 : std_logic ;
  signal N_43563 : std_logic ;
  signal N_43564 : std_logic ;
  signal N_43567 : std_logic ;
  signal N_43568 : std_logic ;
  signal N_43569 : std_logic ;
  signal N_43570 : std_logic ;
  signal N_43571 : std_logic ;
  signal N_43572 : std_logic ;
  signal N_43574 : std_logic ;
  signal N_43575 : std_logic ;
  signal N_43577 : std_logic ;
  signal N_43578 : std_logic ;
  signal N_43579 : std_logic ;
  signal N_43580 : std_logic ;
  signal N_43581 : std_logic ;
  signal N_43582 : std_logic ;
  signal N_43583 : std_logic ;
  signal N_43584 : std_logic ;
  signal N_43586 : std_logic ;
  signal N_43588 : std_logic ;
  signal N_43589 : std_logic ;
  signal N_43590 : std_logic ;
  signal N_43591 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_77_I\ : std_logic ;
  signal N_43595 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_74_I\ : std_logic ;
  signal N_43597 : std_logic ;
  signal N_43598 : std_logic ;
  signal N_43599 : std_logic ;
  signal N_43602 : std_logic ;
  signal N_43603 : std_logic ;
  signal N_43605 : std_logic ;
  signal N_43606 : std_logic ;
  signal N_43608 : std_logic ;
  signal N_43610 : std_logic ;
  signal N_43613 : std_logic ;
  signal N_43615 : std_logic ;
  signal N_43616 : std_logic ;
  signal N_43617 : std_logic ;
  signal N_43618 : std_logic ;
  signal N_43619 : std_logic ;
  signal N_43620 : std_logic ;
  signal N_43621 : std_logic ;
  signal N_43622 : std_logic ;
  signal N_43624 : std_logic ;
  signal N_43626 : std_logic ;
  signal N_43627 : std_logic ;
  signal N_43628 : std_logic ;
  signal N_43629 : std_logic ;
  signal N_43630 : std_logic ;
  signal N_43631 : std_logic ;
  signal N_43632 : std_logic ;
  signal N_43633 : std_logic ;
  signal N_43634 : std_logic ;
  signal N_43635 : std_logic ;
  signal N_43636 : std_logic ;
  signal N_43637 : std_logic ;
  signal N_43639 : std_logic ;
  signal N_43640 : std_logic ;
  signal N_43643 : std_logic ;
  signal N_43644 : std_logic ;
  signal N_43646 : std_logic ;
  signal N_43651 : std_logic ;
  signal N_43653 : std_logic ;
  signal N_43655 : std_logic ;
  signal N_43656 : std_logic ;
  signal N_43661 : std_logic ;
  signal N_43662 : std_logic ;
  signal N_43666 : std_logic ;
  signal N_43668 : std_logic ;
  signal N_43674 : std_logic ;
  signal N_43675 : std_logic ;
  signal N_43676 : std_logic ;
  signal N_43677 : std_logic ;
  signal N_43678 : std_logic ;
  signal N_43679 : std_logic ;
  signal N_43680 : std_logic ;
  signal N_43682 : std_logic ;
  signal N_43683 : std_logic ;
  signal N_43684 : std_logic ;
  signal N_43685 : std_logic ;
  signal N_43686 : std_logic ;
  signal N_43687 : std_logic ;
  signal N_43688 : std_logic ;
  signal N_43689 : std_logic ;
  signal N_43690 : std_logic ;
  signal N_43691 : std_logic ;
  signal N_43692 : std_logic ;
  signal N_43693 : std_logic ;
  signal N_43694 : std_logic ;
  signal N_43696 : std_logic ;
  signal N_43701 : std_logic ;
  signal N_43702 : std_logic ;
  signal N_43704 : std_logic ;
  signal N_43705 : std_logic ;
  signal N_43707 : std_logic ;
  signal N_43708 : std_logic ;
  signal N_43709 : std_logic ;
  signal N_43710 : std_logic ;
  signal N_43711 : std_logic ;
  signal N_43712 : std_logic ;
  signal N_43713 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_7_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_6_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_10_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C_3\ : std_logic ;
  signal N_48611 : std_logic ;
  signal N_48624 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_1_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_1_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\ : std_logic ;
  signal \GRLFPC20.MOV_2_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.WREN1_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV_1\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD2_4\ : std_logic ;
  signal \GRLFPC20.UN1_MOV_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_2\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_3\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV_1\ : std_logic ;
  signal \GRLFPC20.WREN2_1_SQMUXA_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_A8_0\ : std_logic ;
  signal \GRLFPC20.RS2_0_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_A5_0\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M10_0\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M7_E_52_I_A2_0\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1_0_3\ : std_logic ;
  signal \GRLFPC20.COMB.UN9_CCV_2\ : std_logic ;
  signal \GRLFPC20.MOV_1_SQMUXA_4\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_A6_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1_2\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_8180_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_6\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_4\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_0_A2_2\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN12_SRTOSTICKY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_ENTRYPOINT_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_18_0\ : std_logic ;
  signal \GRLFPC20.N_2248_I_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_22__G2_2_1\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_7636_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2_1\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2_0_0_G3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_40__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_2\ : std_logic ;
  signal \GRLFPC20.COMB.V.STATE_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_4_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_9_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_20\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_8_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_9_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_6_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_M2_0\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_0_0_G1_0_8109_A2_0\ : std_logic ;
  signal \GRLFPC20.R.I.V_1_0_G0_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.STKGEN_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_11_7726_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_10_7758_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_7790_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_8_7822_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_7_7854_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_6_7886_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_7918_I_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_0__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_2__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.STKGEN_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN36_STKGEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\ : std_logic ;
  signal \GRLFPC20.COMB.V.MK.RST_1_0_G0_1\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY_0_0_G0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\ : std_logic ;
  signal N_30976_3 : std_logic ;
  signal \GRLFPC20.N_1452\ : std_logic ;
  signal N_23282_1 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\ : std_logic ;
  signal N_27721 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_FPCI_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\ : std_logic ;
  signal \GRLFPC20.WRADDR_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.N_2173\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_2\ : std_logic ;
  signal \GRLFPC20.N_1929\ : std_logic ;
  signal \GRLFPC20.WRADDR_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.N_1341\ : std_logic ;
  signal \GRLFPC20.N_1378\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SS0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_94\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7965\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7270\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13695\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7765\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.A.RS1_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.E.STDATA2\ : std_logic ;
  signal \GRLFPC20.N_2405_3\ : std_logic ;
  signal N_55780 : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__N_7\ : std_logic ;
  signal \GRLFPC20.R.I.PC_1_0_9__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4\ : std_logic ;
  signal N_22673_1 : std_logic ;
  signal N_55786_I : std_logic ;
  signal N_55787_I : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.V.I.EXEC_0_SQMUXA\ : std_logic ;
  signal N_56186 : std_logic ;
  signal N_56187 : std_logic ;
  signal N_56188 : std_logic ;
  signal N_56189 : std_logic ;
  signal N_56190 : std_logic ;
  signal N_56191 : std_logic ;
  signal N_56192 : std_logic ;
  signal N_56193 : std_logic ;
  signal N_56194 : std_logic ;
  signal N_56195 : std_logic ;
  signal N_56196 : std_logic ;
  signal N_56197 : std_logic ;
  signal N_56198 : std_logic ;
  signal N_56199 : std_logic ;
  signal N_56200 : std_logic ;
  signal N_56201 : std_logic ;
  signal N_56202 : std_logic ;
  signal N_56203 : std_logic ;
  signal N_56204 : std_logic ;
  signal N_56205 : std_logic ;
  signal N_56206 : std_logic ;
  signal N_56207 : std_logic ;
  signal N_56208 : std_logic ;
  signal N_56209 : std_logic ;
  signal N_56210 : std_logic ;
  signal N_56211 : std_logic ;
  signal N_56212 : std_logic ;
  signal N_56213 : std_logic ;
  signal N_56214 : std_logic ;
  signal N_56215 : std_logic ;
  signal N_56216 : std_logic ;
  signal N_56217 : std_logic ;
  signal N_56218 : std_logic ;
  signal N_56219 : std_logic ;
  signal N_56220 : std_logic ;
  signal N_56221 : std_logic ;
  signal N_56222 : std_logic ;
  signal N_56223 : std_logic ;
  signal N_56224 : std_logic ;
  signal N_56225 : std_logic ;
  signal N_56226 : std_logic ;
  signal N_56227 : std_logic ;
  signal N_56228 : std_logic ;
  signal N_56229 : std_logic ;
  signal N_56230 : std_logic ;
  signal N_56231 : std_logic ;
  signal N_56232 : std_logic ;
  signal N_56233 : std_logic ;
  signal N_56234 : std_logic ;
  signal N_56235 : std_logic ;
  signal N_56236 : std_logic ;
  signal N_56237 : std_logic ;
  signal N_56238 : std_logic ;
  signal N_56239 : std_logic ;
  signal N_56264 : std_logic ;
  signal N_56274 : std_logic ;
  signal N_56284 : std_logic ;
  signal N_56286 : std_logic ;
  signal N_56308 : std_logic ;
  signal N_56310 : std_logic ;
  signal N_56312 : std_logic ;
  signal N_56314 : std_logic ;
  signal N_56316 : std_logic ;
  signal N_56318 : std_logic ;
  signal N_56320 : std_logic ;
  signal N_56322 : std_logic ;
  signal N_56326 : std_logic ;
  signal N_56330 : std_logic ;
  signal N_56334 : std_logic ;
  signal N_56336 : std_logic ;
  signal N_56340 : std_logic ;
  signal N_56342 : std_logic ;
  signal N_56350 : std_logic ;
  signal N_56352 : std_logic ;
  signal N_56353 : std_logic ;
  signal N_56354 : std_logic ;
  signal N_56355 : std_logic ;
  signal N_56356 : std_logic ;
  signal N_56357 : std_logic ;
  signal N_56358 : std_logic ;
  signal N_56359 : std_logic ;
  signal N_56360 : std_logic ;
  signal N_56361 : std_logic ;
  signal N_56362 : std_logic ;
  signal N_56363 : std_logic ;
  signal N_56364 : std_logic ;
  signal N_56365 : std_logic ;
  signal N_56366 : std_logic ;
  signal N_56367 : std_logic ;
  signal N_56368 : std_logic ;
  signal N_56369 : std_logic ;
  signal N_56370 : std_logic ;
  signal N_56371 : std_logic ;
  signal N_56372 : std_logic ;
  signal N_56373 : std_logic ;
  signal N_56374 : std_logic ;
  signal N_56375 : std_logic ;
  signal N_56376 : std_logic ;
  signal N_56378 : std_logic ;
  signal N_56379 : std_logic ;
  signal N_56380 : std_logic ;
  signal N_56381 : std_logic ;
  signal N_56382 : std_logic ;
  signal N_56383 : std_logic ;
  signal N_56384 : std_logic ;
  signal N_56385 : std_logic ;
  signal N_56386 : std_logic ;
  signal N_56387 : std_logic ;
  signal N_56388 : std_logic ;
  signal N_56389 : std_logic ;
  signal N_56390 : std_logic ;
  signal N_56391 : std_logic ;
  signal N_56393 : std_logic ;
  signal N_56394 : std_logic ;
  signal N_56395 : std_logic ;
  signal N_56396 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_3\ : std_logic ;
  signal N_56531 : std_logic ;
  signal N_56533 : std_logic ;
  signal N_56535 : std_logic ;
  signal N_56537 : std_logic ;
  signal N_56539 : std_logic ;
  signal N_56541 : std_logic ;
  signal N_56543 : std_logic ;
  signal N_56545 : std_logic ;
  signal N_56563 : std_logic ;
  signal N_56583 : std_logic ;
  signal N_56585 : std_logic ;
  signal N_56587 : std_logic ;
  signal N_56589 : std_logic ;
  signal N_56593 : std_logic ;
  signal N_56594 : std_logic ;
  signal N_56595 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13712\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13714\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13713\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13711\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13705\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13690\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4537\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11361\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11385\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__N_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_8\ : std_logic ;
  signal N_56551 : std_logic ;
  signal N_57319 : std_logic ;
  signal N_57320 : std_logic ;
  signal N_57321 : std_logic ;
  signal N_57322 : std_logic ;
  signal N_57323 : std_logic ;
  signal N_57324 : std_logic ;
  signal N_57325 : std_logic ;
  signal N_57326 : std_logic ;
  signal N_57327 : std_logic ;
  signal N_57328 : std_logic ;
  signal N_57329 : std_logic ;
  signal N_57330 : std_logic ;
  signal N_57331 : std_logic ;
  signal N_57332 : std_logic ;
  signal N_57333 : std_logic ;
  signal N_57334 : std_logic ;
  signal N_57335 : std_logic ;
  signal N_57336 : std_logic ;
  signal N_57337 : std_logic ;
  signal N_57338 : std_logic ;
  signal N_57339 : std_logic ;
  signal N_57340 : std_logic ;
  signal N_57341 : std_logic ;
  signal N_57342 : std_logic ;
  signal N_57343 : std_logic ;
  signal N_57344 : std_logic ;
  signal N_57345 : std_logic ;
  signal N_57346 : std_logic ;
  signal N_57347 : std_logic ;
  signal N_57348 : std_logic ;
  signal N_57349 : std_logic ;
  signal N_57350 : std_logic ;
  signal N_57351 : std_logic ;
  signal N_57352 : std_logic ;
  signal N_57353 : std_logic ;
  signal N_57354 : std_logic ;
  signal N_57355 : std_logic ;
  signal N_57356 : std_logic ;
  signal N_57357 : std_logic ;
  signal N_57358 : std_logic ;
  signal N_57359 : std_logic ;
  signal N_57360 : std_logic ;
  signal N_57361 : std_logic ;
  signal N_57362 : std_logic ;
  signal N_57363 : std_logic ;
  signal N_57364 : std_logic ;
  signal N_57365 : std_logic ;
  signal N_57366 : std_logic ;
  signal N_57367 : std_logic ;
  signal N_57368 : std_logic ;
  signal N_57369 : std_logic ;
  signal N_57370 : std_logic ;
  signal N_57371 : std_logic ;
  signal N_57372 : std_logic ;
  signal N_57373 : std_logic ;
  signal N_57374 : std_logic ;
  signal N_57375 : std_logic ;
  signal N_57376 : std_logic ;
  signal N_57377 : std_logic ;
  signal N_57378 : std_logic ;
  signal N_57467 : std_logic ;
  signal N_57468 : std_logic ;
  signal N_57679 : std_logic ;
  signal N_57735 : std_logic ;
  signal N_57736 : std_logic ;
  signal N_30976_3_I : std_logic ;
  signal RST_I : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\ : std_logic ;
  signal N_55787_I_0 : std_logic ;
  signal N_55786_I_0 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SS0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_2_SQMUXA0\ : std_logic ;
  signal \GRLFPC20.COMB.V.FSR.FCC100\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_V.STATE0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M20_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_50130\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M30_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M30_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M30\ : std_logic ;
  signal N_1 : std_logic ;
  signal N_2 : std_logic ;
  signal N_3 : std_logic ;
  signal N_4 : std_logic ;
  signal N_5 : std_logic ;
  signal N_6 : std_logic ;
  signal N_7 : std_logic ;
  signal N_8 : std_logic ;
  signal N_9 : std_logic ;
  signal N_10 : std_logic ;
  signal N_11 : std_logic ;
  signal N_12 : std_logic ;
  signal N_13 : std_logic ;
  signal N_14 : std_logic ;
  signal N_15 : std_logic ;
  signal N_16 : std_logic ;
  signal N_17 : std_logic ;
  signal N_18 : std_logic ;
  signal N_19 : std_logic ;
  signal N_20 : std_logic ;
  signal N_21 : std_logic ;
  signal N_22 : std_logic ;
  signal N_23 : std_logic ;
  signal N_24 : std_logic ;
  signal N_25 : std_logic ;
  signal N_26 : std_logic ;
  signal N_27 : std_logic ;
  signal N_28 : std_logic ;
  signal N_29 : std_logic ;
  signal N_30 : std_logic ;
  signal N_31 : std_logic ;
  signal N_32 : std_logic ;
  signal N_33 : std_logic ;
  signal N_34 : std_logic ;
  signal N_35 : std_logic ;
  signal N_36 : std_logic ;
  signal N_37 : std_logic ;
  signal N_38 : std_logic ;
  signal N_39 : std_logic ;
  signal N_40 : std_logic ;
  signal N_41 : std_logic ;
  signal N_42 : std_logic ;
  signal N_43 : std_logic ;
  signal N_44 : std_logic ;
  signal N_45 : std_logic ;
  signal N_46 : std_logic ;
  signal N_47 : std_logic ;
  signal N_48 : std_logic ;
  signal N_49 : std_logic ;
  signal N_50 : std_logic ;
  signal N_51 : std_logic ;
  signal N_52 : std_logic ;
  signal N_53 : std_logic ;
  signal N_54 : std_logic ;
  signal N_55 : std_logic ;
  signal N_56 : std_logic ;
  signal N_57 : std_logic ;
  signal N_58 : std_logic ;
  signal N_59 : std_logic ;
  signal N_60 : std_logic ;
  signal N_61 : std_logic ;
  signal N_62 : std_logic ;
  signal N_63 : std_logic ;
  signal N_64 : std_logic ;
  signal N_65 : std_logic ;
  signal N_66 : std_logic ;
  signal N_67 : std_logic ;
  signal N_68 : std_logic ;
  signal N_69 : std_logic ;
  signal N_70 : std_logic ;
  signal N_71 : std_logic ;
  signal N_72 : std_logic ;
  signal N_73 : std_logic ;
  signal N_74 : std_logic ;
  signal N_75 : std_logic ;
  signal N_76 : std_logic ;
  signal N_77 : std_logic ;
  signal N_78 : std_logic ;
  signal N_79 : std_logic ;
  signal N_80 : std_logic ;
  signal N_81 : std_logic ;
  signal N_82 : std_logic ;
  signal N_83 : std_logic ;
  signal N_84 : std_logic ;
  signal N_85 : std_logic ;
  signal N_86 : std_logic ;
  signal N_87 : std_logic ;
  signal N_88 : std_logic ;
  signal N_89 : std_logic ;
  signal N_90 : std_logic ;
  signal N_91 : std_logic ;
  signal N_92 : std_logic ;
  signal N_93 : std_logic ;
  signal N_94 : std_logic ;
  signal N_95 : std_logic ;
  signal N_96 : std_logic ;
  signal N_97 : std_logic ;
  signal N_98 : std_logic ;
  signal N_99 : std_logic ;
  signal N_100 : std_logic ;
  signal N_101 : std_logic ;
  signal N_102 : std_logic ;
  signal N_103 : std_logic ;
  signal N_104 : std_logic ;
  signal N_105 : std_logic ;
  signal N_106 : std_logic ;
  signal N_107 : std_logic ;
  signal N_108 : std_logic ;
  signal N_109 : std_logic ;
  signal N_110 : std_logic ;
  signal N_111 : std_logic ;
  signal N_112 : std_logic ;
  signal N_113 : std_logic ;
  signal N_114 : std_logic ;
  signal N_115 : std_logic ;
  signal N_116 : std_logic ;
  signal N_117 : std_logic ;
  signal N_118 : std_logic ;
  signal N_119 : std_logic ;
  signal N_120 : std_logic ;
  signal N_121 : std_logic ;
  signal N_122 : std_logic ;
  signal N_123 : std_logic ;
  signal N_124 : std_logic ;
  signal N_125 : std_logic ;
  signal N_126 : std_logic ;
  signal N_127 : std_logic ;
  signal N_128 : std_logic ;
  signal N_129 : std_logic ;
  signal N_130 : std_logic ;
  signal N_131 : std_logic ;
  signal N_132 : std_logic ;
  signal N_133 : std_logic ;
  signal N_134 : std_logic ;
  signal N_135 : std_logic ;
  signal N_136 : std_logic ;
  signal N_137 : std_logic ;
  signal N_138 : std_logic ;
  signal N_139 : std_logic ;
  signal N_140 : std_logic ;
  signal N_141 : std_logic ;
  signal N_142 : std_logic ;
  signal N_143 : std_logic ;
  signal N_144 : std_logic ;
  signal N_145 : std_logic ;
  signal N_146 : std_logic ;
  signal N_147 : std_logic ;
  signal N_148 : std_logic ;
  signal N_149 : std_logic ;
  signal N_150 : std_logic ;
  signal N_151 : std_logic ;
  signal N_152 : std_logic ;
  signal N_153 : std_logic ;
  signal N_154 : std_logic ;
  signal N_155 : std_logic ;
  signal N_156 : std_logic ;
  signal N_157 : std_logic ;
  signal N_158 : std_logic ;
  signal N_159 : std_logic ;
  signal N_160 : std_logic ;
  signal N_161 : std_logic ;
  signal N_162 : std_logic ;
  signal N_163 : std_logic ;
  signal N_164 : std_logic ;
  signal N_165 : std_logic ;
  signal N_166 : std_logic ;
  signal N_167 : std_logic ;
  signal N_168 : std_logic ;
  signal N_169 : std_logic ;
  signal N_170 : std_logic ;
  signal N_171 : std_logic ;
  signal N_172 : std_logic ;
  signal N_173 : std_logic ;
  signal N_174 : std_logic ;
  signal N_175 : std_logic ;
  signal N_176 : std_logic ;
  signal N_177 : std_logic ;
  signal N_178 : std_logic ;
  signal N_179 : std_logic ;
  signal N_180 : std_logic ;
  signal N_181 : std_logic ;
  signal N_182 : std_logic ;
  signal N_183 : std_logic ;
  signal N_184 : std_logic ;
  signal N_185 : std_logic ;
  signal N_186 : std_logic ;
  signal N_187 : std_logic ;
  signal N_188 : std_logic ;
  signal N_189 : std_logic ;
  signal N_190 : std_logic ;
  signal N_191 : std_logic ;
  signal N_192 : std_logic ;
  signal N_193 : std_logic ;
  signal N_194 : std_logic ;
  signal N_195 : std_logic ;
  signal N_196 : std_logic ;
  signal N_197 : std_logic ;
  signal N_198 : std_logic ;
  signal N_199 : std_logic ;
  signal N_200 : std_logic ;
  signal N_201 : std_logic ;
  signal N_202 : std_logic ;
  signal N_203 : std_logic ;
  signal N_204 : std_logic ;
  signal N_205 : std_logic ;
  signal N_206 : std_logic ;
  signal N_207 : std_logic ;
  signal N_208 : std_logic ;
  signal N_209 : std_logic ;
  signal N_210 : std_logic ;
  signal N_211 : std_logic ;
  signal N_212 : std_logic ;
  signal N_213 : std_logic ;
  signal N_214 : std_logic ;
  signal N_215 : std_logic ;
  signal N_216 : std_logic ;
  signal N_217 : std_logic ;
  signal N_218 : std_logic ;
  signal N_219 : std_logic ;
  signal N_220 : std_logic ;
  signal N_221 : std_logic ;
  signal N_222 : std_logic ;
  signal N_223 : std_logic ;
  signal N_224 : std_logic ;
  signal N_225 : std_logic ;
  signal N_226 : std_logic ;
  signal N_227 : std_logic ;
  signal N_228 : std_logic ;
  signal N_229 : std_logic ;
  signal N_230 : std_logic ;
  signal N_231 : std_logic ;
  signal N_232 : std_logic ;
  signal N_233 : std_logic ;
  signal N_234 : std_logic ;
  signal N_235 : std_logic ;
  signal N_236 : std_logic ;
  signal N_237 : std_logic ;
  signal N_238 : std_logic ;
  signal N_239 : std_logic ;
  signal N_240 : std_logic ;
  signal N_241 : std_logic ;
  signal N_242 : std_logic ;
  signal N_243 : std_logic ;
  signal N_244 : std_logic ;
  signal N_245 : std_logic ;
  signal N_246 : std_logic ;
  signal N_247 : std_logic ;
  signal N_248 : std_logic ;
  signal N_249 : std_logic ;
  signal N_250 : std_logic ;
  signal N_251 : std_logic ;
  signal N_252 : std_logic ;
  signal N_253 : std_logic ;
  signal N_254 : std_logic ;
  signal N_255 : std_logic ;
  signal N_256 : std_logic ;
  signal N_257 : std_logic ;
  signal N_258 : std_logic ;
  signal N_259 : std_logic ;
  signal N_260 : std_logic ;
  signal N_261 : std_logic ;
  signal N_262 : std_logic ;
  signal N_263 : std_logic ;
  signal N_264 : std_logic ;
  signal N_265 : std_logic ;
  signal N_266 : std_logic ;
  signal N_267 : std_logic ;
  signal N_268 : std_logic ;
  signal N_269 : std_logic ;
  signal N_270 : std_logic ;
  signal N_271 : std_logic ;
  signal N_272 : std_logic ;
  signal N_273 : std_logic ;
  signal N_274 : std_logic ;
  signal N_275 : std_logic ;
  signal N_276 : std_logic ;
  signal N_277 : std_logic ;
  signal N_278 : std_logic ;
  signal N_279 : std_logic ;
  signal N_280 : std_logic ;
  signal N_281 : std_logic ;
  signal N_282 : std_logic ;
  signal N_283 : std_logic ;
  signal N_284 : std_logic ;
  signal N_285 : std_logic ;
  signal N_286 : std_logic ;
  signal N_287 : std_logic ;
  signal N_288 : std_logic ;
  signal N_289 : std_logic ;
  signal N_290 : std_logic ;
  signal N_291 : std_logic ;
  signal N_292 : std_logic ;
  signal N_293 : std_logic ;
  signal N_294 : std_logic ;
  signal N_295 : std_logic ;
  signal N_296 : std_logic ;
  signal N_297 : std_logic ;
  signal N_298 : std_logic ;
  signal N_299 : std_logic ;
  signal N_300 : std_logic ;
  signal N_301 : std_logic ;
  signal N_302 : std_logic ;
  signal N_303 : std_logic ;
  signal N_304 : std_logic ;
  signal N_305 : std_logic ;
  signal N_306 : std_logic ;
  signal N_307 : std_logic ;
  signal N_308 : std_logic ;
  signal N_309 : std_logic ;
  signal N_310 : std_logic ;
  signal N_311 : std_logic ;
  signal N_312 : std_logic ;
  signal N_313 : std_logic ;
  signal N_314 : std_logic ;
  signal N_315 : std_logic ;
  signal N_316 : std_logic ;
  signal N_317 : std_logic ;
  signal N_318 : std_logic ;
  signal N_319 : std_logic ;
  signal N_320 : std_logic ;
  signal N_321 : std_logic ;
  signal N_322 : std_logic ;
  signal N_323 : std_logic ;
  signal N_324 : std_logic ;
  signal N_325 : std_logic ;
  signal N_326 : std_logic ;
  signal N_327 : std_logic ;
  signal N_328 : std_logic ;
  signal N_329 : std_logic ;
  signal N_330 : std_logic ;
  signal N_331 : std_logic ;
  signal N_332 : std_logic ;
  signal N_333 : std_logic ;
  signal N_334 : std_logic ;
  signal N_335 : std_logic ;
  signal N_336 : std_logic ;
  signal N_337 : std_logic ;
  signal N_338 : std_logic ;
  signal N_339 : std_logic ;
  signal N_340 : std_logic ;
  signal N_341 : std_logic ;
  signal N_342 : std_logic ;
  signal N_343 : std_logic ;
  signal N_344 : std_logic ;
  signal N_345 : std_logic ;
  signal N_346 : std_logic ;
  signal N_347 : std_logic ;
  signal N_348 : std_logic ;
  signal N_349 : std_logic ;
  signal N_350 : std_logic ;
  signal N_351 : std_logic ;
  signal N_352 : std_logic ;
  signal N_353 : std_logic ;
  signal N_354 : std_logic ;
  signal N_355 : std_logic ;
  signal N_356 : std_logic ;
  signal N_357 : std_logic ;
  signal N_358 : std_logic ;
  signal N_359 : std_logic ;
  signal N_360 : std_logic ;
  signal N_361 : std_logic ;
  signal N_362 : std_logic ;
  signal N_363 : std_logic ;
  signal N_364 : std_logic ;
  signal N_365 : std_logic ;
  signal N_366 : std_logic ;
  signal N_367 : std_logic ;
  signal N_368 : std_logic ;
  signal N_369 : std_logic ;
  signal N_370 : std_logic ;
  signal N_371 : std_logic ;
  signal N_372 : std_logic ;
  signal N_373 : std_logic ;
  signal N_374 : std_logic ;
  signal N_375 : std_logic ;
  signal N_376 : std_logic ;
  signal N_377 : std_logic ;
  signal N_378 : std_logic ;
  signal N_379 : std_logic ;
  signal N_380 : std_logic ;
  signal N_381 : std_logic ;
  signal N_382 : std_logic ;
  signal N_383 : std_logic ;
  signal N_384 : std_logic ;
  signal N_385 : std_logic ;
  signal N_386 : std_logic ;
  signal N_387 : std_logic ;
  signal N_388 : std_logic ;
  signal N_389 : std_logic ;
  signal N_390 : std_logic ;
  signal N_391 : std_logic ;
  signal N_392 : std_logic ;
  signal N_393 : std_logic ;
  signal N_394 : std_logic ;
  signal N_395 : std_logic ;
  signal N_396 : std_logic ;
  signal N_397 : std_logic ;
  signal N_398 : std_logic ;
  signal N_399 : std_logic ;
  signal N_400 : std_logic ;
  signal N_401 : std_logic ;
  signal N_402 : std_logic ;
  signal N_403 : std_logic ;
  signal N_404 : std_logic ;
  signal N_405 : std_logic ;
  signal N_406 : std_logic ;
  signal N_407 : std_logic ;
  signal N_408 : std_logic ;
  signal N_409 : std_logic ;
  signal N_410 : std_logic ;
  signal N_411 : std_logic ;
  signal N_412 : std_logic ;
  signal N_413 : std_logic ;
  signal N_414 : std_logic ;
  signal N_415 : std_logic ;
  signal N_416 : std_logic ;
  signal N_417 : std_logic ;
  signal N_418 : std_logic ;
  signal N_419 : std_logic ;
  signal N_420 : std_logic ;
  signal N_421 : std_logic ;
  signal N_422 : std_logic ;
  signal N_423 : std_logic ;
  signal N_424 : std_logic ;
  signal N_425 : std_logic ;
  signal N_426 : std_logic ;
  signal N_427 : std_logic ;
  signal N_428 : std_logic ;
  signal N_429 : std_logic ;
  signal N_430 : std_logic ;
  signal N_431 : std_logic ;
  signal N_0 : std_logic ;
  signal N_1_0 : std_logic ;
  signal N_2_0 : std_logic ;
  signal N_3_0 : std_logic ;
  signal N_4_0 : std_logic ;
  signal N_5_0 : std_logic ;
  signal N_6_0 : std_logic ;
  signal N_7_0 : std_logic ;
  signal N_8_0 : std_logic ;
  signal N_9_0 : std_logic ;
  signal N_10_0 : std_logic ;
  signal N_11_0 : std_logic ;
  signal N_12_0 : std_logic ;
  signal N_13_0 : std_logic ;
  signal N_14_0 : std_logic ;
  signal N_15_0 : std_logic ;
  signal N_16_0 : std_logic ;
  signal N_17_0 : std_logic ;
  signal N_18_0 : std_logic ;
  signal N_19_0 : std_logic ;
  signal N_20_0 : std_logic ;
  signal N_21_0 : std_logic ;
  signal N_22_0 : std_logic ;
  signal N_23_0 : std_logic ;
  signal N_24_0 : std_logic ;
  signal N_25_0 : std_logic ;
  signal N_26_0 : std_logic ;
  signal N_27_0 : std_logic ;
  signal N_28_0 : std_logic ;
  signal N_29_0 : std_logic ;
  signal N_30_0 : std_logic ;
  signal N_31_0 : std_logic ;
  signal N_32_0 : std_logic ;
  signal N_33_0 : std_logic ;
  signal N_34_0 : std_logic ;
  signal N_35_0 : std_logic ;
  signal N_36_0 : std_logic ;
  signal N_37_0 : std_logic ;
  signal N_38_0 : std_logic ;
  signal N_39_0 : std_logic ;
  signal N_40_0 : std_logic ;
  signal N_41_0 : std_logic ;
  signal N_42_0 : std_logic ;
  signal N_43_0 : std_logic ;
  signal N_44_0 : std_logic ;
  signal N_45_0 : std_logic ;
  signal N_46_0 : std_logic ;
  signal N_47_0 : std_logic ;
  signal N_48_0 : std_logic ;
  signal N_49_0 : std_logic ;
  signal N_50_0 : std_logic ;
  signal N_51_0 : std_logic ;
  signal N_52_0 : std_logic ;
  signal N_53_0 : std_logic ;
  signal N_54_0 : std_logic ;
  signal N_55_0 : std_logic ;
  signal N_56_0 : std_logic ;
  signal N_57_0 : std_logic ;
  signal N_58_0 : std_logic ;
  signal N_59_0 : std_logic ;
  signal N_60_0 : std_logic ;
  signal N_61_0 : std_logic ;
  signal N_62_0 : std_logic ;
  signal N_63_0 : std_logic ;
  signal N_64_0 : std_logic ;
  signal N_65_0 : std_logic ;
  signal N_66_0 : std_logic ;
  signal N_67_0 : std_logic ;
  signal N_68_0 : std_logic ;
  signal N_69_0 : std_logic ;
  signal N_70_0 : std_logic ;
  signal N_71_0 : std_logic ;
  signal N_72_0 : std_logic ;
  signal N_73_0 : std_logic ;
  signal N_74_0 : std_logic ;
  signal N_75_0 : std_logic ;
  signal N_76_0 : std_logic ;
  signal N_77_0 : std_logic ;
  signal N_78_0 : std_logic ;
  signal N_79_0 : std_logic ;
  signal N_80_0 : std_logic ;
  signal N_81_0 : std_logic ;
  signal N_82_0 : std_logic ;
  signal N_83_0 : std_logic ;
  signal N_84_0 : std_logic ;
  signal N_85_0 : std_logic ;
  signal N_86_0 : std_logic ;
  signal N_87_0 : std_logic ;
  signal N_88_0 : std_logic ;
  signal N_89_0 : std_logic ;
  signal N_90_0 : std_logic ;
  signal N_91_0 : std_logic ;
  signal N_92_0 : std_logic ;
  signal N_93_0 : std_logic ;
  signal N_94_0 : std_logic ;
  signal N_95_0 : std_logic ;
  signal N_96_0 : std_logic ;
  signal N_97_0 : std_logic ;
  signal N_98_0 : std_logic ;
  signal N_99_0 : std_logic ;
  signal N_100_0 : std_logic ;
  signal N_101_0 : std_logic ;
  signal N_102_0 : std_logic ;
  signal N_103_0 : std_logic ;
  signal N_104_0 : std_logic ;
  signal N_105_0 : std_logic ;
  signal N_106_0 : std_logic ;
  signal N_107_0 : std_logic ;
  signal N_108_0 : std_logic ;
  signal N_109_0 : std_logic ;
  signal N_110_0 : std_logic ;
  signal N_111_0 : std_logic ;
  signal N_112_0 : std_logic ;
  signal N_113_0 : std_logic ;
  signal N_114_0 : std_logic ;
  signal N_115_0 : std_logic ;
  signal N_116_0 : std_logic ;
  signal N_117_0 : std_logic ;
  signal N_118_0 : std_logic ;
  signal N_119_0 : std_logic ;
  signal N_120_0 : std_logic ;
  signal N_121_0 : std_logic ;
  signal N_122_0 : std_logic ;
  signal N_123_0 : std_logic ;
  signal N_124_0 : std_logic ;
  signal N_125_0 : std_logic ;
  signal N_126_0 : std_logic ;
  signal N_127_0 : std_logic ;
  signal N_128_0 : std_logic ;
  signal N_129_0 : std_logic ;
  signal N_130_0 : std_logic ;
  signal N_131_0 : std_logic ;
  signal N_132_0 : std_logic ;
  signal N_133_0 : std_logic ;
  signal N_134_0 : std_logic ;
  signal N_135_0 : std_logic ;
  signal N_136_0 : std_logic ;
  signal N_137_0 : std_logic ;
  signal N_138_0 : std_logic ;
  signal N_139_0 : std_logic ;
  signal N_140_0 : std_logic ;
  signal N_141_0 : std_logic ;
  signal N_142_0 : std_logic ;
  signal N_143_0 : std_logic ;
  signal N_144_0 : std_logic ;
  signal N_145_0 : std_logic ;
  signal N_146_0 : std_logic ;
  signal N_147_0 : std_logic ;
  signal N_148_0 : std_logic ;
  signal N_149_0 : std_logic ;
  signal N_150_0 : std_logic ;
  signal N_151_0 : std_logic ;
  signal N_152_0 : std_logic ;
  signal N_153_0 : std_logic ;
  signal N_154_0 : std_logic ;
  signal N_155_0 : std_logic ;
  signal N_156_0 : std_logic ;
  signal N_157_0 : std_logic ;
  signal N_158_0 : std_logic ;
  signal N_159_0 : std_logic ;
  signal N_160_0 : std_logic ;
  signal N_161_0 : std_logic ;
  signal N_162_0 : std_logic ;
  signal N_163_0 : std_logic ;
  signal N_596 : std_logic ;
  signal N_597 : std_logic ;
  signal N_598 : std_logic ;
  signal N_599 : std_logic ;
  signal N_600 : std_logic ;
  signal N_601 : std_logic ;
  signal N_602 : std_logic ;
  signal N_603 : std_logic ;
  signal N_604 : std_logic ;
  signal N_605 : std_logic ;
  signal N_606 : std_logic ;
  signal N_607 : std_logic ;
  signal N_608 : std_logic ;
  signal N_609 : std_logic ;
  signal N_610 : std_logic ;
  signal N_611 : std_logic ;
  signal N_612 : std_logic ;
  signal N_613 : std_logic ;
  signal N_614 : std_logic ;
  signal N_615 : std_logic ;
  signal N_616 : std_logic ;
  signal N_617 : std_logic ;
  signal N_618 : std_logic ;
  signal N_619 : std_logic ;
  signal N_620 : std_logic ;
  signal N_621 : std_logic ;
  signal N_622 : std_logic ;
  signal N_623 : std_logic ;
  signal N_624 : std_logic ;
  signal N_625 : std_logic ;
  signal N_626 : std_logic ;
  signal N_627 : std_logic ;
  signal N_628 : std_logic ;
  signal N_629 : std_logic ;
  signal N_630 : std_logic ;
  signal N_631 : std_logic ;
  signal N_632 : std_logic ;
  signal N_633 : std_logic ;
  signal N_634 : std_logic ;
  signal N_635 : std_logic ;
  signal N_636 : std_logic ;
  signal N_637 : std_logic ;
  signal N_638 : std_logic ;
  signal N_639 : std_logic ;
  signal N_640 : std_logic ;
  signal N_641 : std_logic ;
  signal N_642 : std_logic ;
  signal N_643 : std_logic ;
  signal N_644 : std_logic ;
  signal N_645 : std_logic ;
  signal N_646 : std_logic ;
  signal N_647 : std_logic ;
  signal N_648 : std_logic ;
  signal N_649 : std_logic ;
  signal N_650 : std_logic ;
  signal N_651 : std_logic ;
  signal N_652 : std_logic ;
  signal N_653 : std_logic ;
  signal N_654 : std_logic ;
  signal N_655 : std_logic ;
  signal N_656 : std_logic ;
  signal N_657 : std_logic ;
  signal N_658 : std_logic ;
  signal N_659 : std_logic ;
  signal N_660 : std_logic ;
  signal N_661 : std_logic ;
  signal N_662 : std_logic ;
  signal N_663 : std_logic ;
  signal N_664 : std_logic ;
  signal N_665 : std_logic ;
  signal N_666 : std_logic ;
  signal N_667 : std_logic ;
  signal N_668 : std_logic ;
  signal N_669 : std_logic ;
  signal N_670 : std_logic ;
  signal N_671 : std_logic ;
  signal N_672 : std_logic ;
  signal N_673 : std_logic ;
  signal N_674 : std_logic ;
  signal N_675 : std_logic ;
  signal N_676 : std_logic ;
  signal N_677 : std_logic ;
  signal N_678 : std_logic ;
  signal N_679 : std_logic ;
  signal N_680 : std_logic ;
  signal N_681 : std_logic ;
  signal N_682 : std_logic ;
  signal N_683 : std_logic ;
  signal N_684 : std_logic ;
  signal N_685 : std_logic ;
  signal N_686 : std_logic ;
  signal N_687 : std_logic ;
  signal N_688 : std_logic ;
  signal N_689 : std_logic ;
  signal N_690 : std_logic ;
  signal N_691 : std_logic ;
  signal N_692 : std_logic ;
  signal N_693 : std_logic ;
  signal N_694 : std_logic ;
  signal N_695 : std_logic ;
  signal N_696 : std_logic ;
  signal N_697 : std_logic ;
  signal N_698 : std_logic ;
  signal N_699 : std_logic ;
  signal N_700 : std_logic ;
  signal N_701 : std_logic ;
  signal N_702 : std_logic ;
  signal N_703 : std_logic ;
  signal N_704 : std_logic ;
  signal N_705 : std_logic ;
  signal N_706 : std_logic ;
  signal N_707 : std_logic ;
  signal N_708 : std_logic ;
  signal N_709 : std_logic ;
  signal N_710 : std_logic ;
  signal N_711 : std_logic ;
  signal N_712 : std_logic ;
  signal N_713 : std_logic ;
  signal N_714 : std_logic ;
  signal N_715 : std_logic ;
  signal N_716 : std_logic ;
  signal N_717 : std_logic ;
  signal N_718 : std_logic ;
  signal N_719 : std_logic ;
  signal N_720 : std_logic ;
  signal N_721 : std_logic ;
  signal N_722 : std_logic ;
  signal N_723 : std_logic ;
  signal CPO_EXCZ : std_logic ;
  signal CPO_CCVZ : std_logic ;
  signal CPO_LDLOCKZ : std_logic ;
  signal CPO_HOLDNZ : std_logic ;
  signal RFI1_REN1Z : std_logic ;
  signal RFI1_REN2Z : std_logic ;
  signal RFI1_WRENZ : std_logic ;
  signal RFI2_REN1Z : std_logic ;
  signal RFI2_REN2Z : std_logic ;
  signal RFI2_WRENZ : std_logic ;
begin
GND <= '0';
VCC <= '1';
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\,
dataf => N_41806,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(320),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41800);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\,
dataf => N_41812,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\,
dataf => N_41813,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(8),
cout => N_41798,
dataf => N_41821,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\,
dataf => N_41829,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(321),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41796);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\,
dataf => N_41835,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\,
dataf => N_41836,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(9),
cout => N_41794,
dataf => N_41844,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\,
dataf => N_41852,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(322),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41792);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\,
dataf => N_41858,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\,
dataf => N_41859,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(10),
cout => N_41790,
dataf => N_41867,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\,
dataf => N_41875,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(323),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41788);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\,
dataf => N_41881,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\,
dataf => N_41882,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(11),
cout => N_41786,
dataf => N_41890,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\,
dataf => N_41898,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(324),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41784);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\,
dataf => N_41904,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\,
dataf => N_41905,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(12),
cout => N_41782,
dataf => N_41913,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\,
dataf => N_41921,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(325),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41780);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\,
dataf => N_41927,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\,
dataf => N_41928,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(13),
cout => N_41778,
dataf => N_41936,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\,
dataf => N_41944,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(326),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41776);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\,
dataf => N_41950,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\,
dataf => N_41951,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(14),
cout => N_41774,
dataf => N_41959,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\,
dataf => N_41967,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(327),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41772);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\,
dataf => N_41973,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\,
dataf => N_41974,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(15),
cout => N_41770,
dataf => N_41982,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\,
dataf => N_41990,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(328),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41768);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\,
dataf => N_41996,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\,
dataf => N_41997,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(16),
cout => N_41766,
dataf => N_42005,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\,
dataf => N_42013,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(329),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41764);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\,
dataf => N_42019,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\,
dataf => N_42020,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(17),
cout => N_41762,
dataf => N_42028,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\,
dataf => N_42036,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(330),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41760);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\,
dataf => N_42042,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\,
dataf => N_42043,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(18),
cout => N_41758,
dataf => N_42051,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\,
dataf => N_42059,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(331),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41756);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\,
dataf => N_42065,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\,
dataf => N_42066,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(19),
cout => N_41754,
dataf => N_42074,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\,
dataf => N_42082,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(332),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41752);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\,
dataf => N_42088,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\,
dataf => N_42089,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(20),
cout => N_41750,
dataf => N_42097,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\,
dataf => N_42105,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(333),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41748);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\,
dataf => N_42111,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\,
dataf => N_42112,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(21),
cout => N_41746,
dataf => N_42120,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\,
dataf => N_42128,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(334),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41744);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\,
dataf => N_42134,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\,
dataf => N_42135,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(22),
cout => N_41742,
dataf => N_42143,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\,
dataf => N_42151,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(335),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41740);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\,
dataf => N_42157,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\,
dataf => N_42158,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(23),
cout => N_41738,
dataf => N_42166,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\,
dataf => N_42174,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(336),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41736);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\,
dataf => N_42180,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\,
dataf => N_42181,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(24),
cout => N_41734,
dataf => N_42189,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\,
dataf => N_42197,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(337),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41732);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\,
dataf => N_42203,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\,
dataf => N_42204,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(25),
cout => N_41730,
dataf => N_42212,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\,
dataf => N_42220,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(338),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41728);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\,
dataf => N_42226,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\,
dataf => N_42227,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(26),
cout => N_41726,
dataf => N_42235,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\,
dataf => N_42243,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(339),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41724);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\,
dataf => N_42249,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\,
dataf => N_42250,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(27),
cout => N_41722,
dataf => N_42258,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\,
dataf => N_42266,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(340),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41720);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\,
dataf => N_42272,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\,
dataf => N_42273,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(28),
cout => N_41718,
dataf => N_42281,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\,
dataf => N_42289,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(341),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41716);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\,
dataf => N_42295,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\,
dataf => N_42296,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(29),
cout => N_41714,
dataf => N_42304,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\,
dataf => N_42312,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(342),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41712);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\,
dataf => N_42318,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\,
dataf => N_42319,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(30),
cout => N_41710,
dataf => N_42327,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\,
dataf => N_42335,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(343),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41708);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\,
dataf => N_42341,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\,
dataf => N_42342,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(31),
cout => N_41706,
dataf => N_42350,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\,
dataf => N_42358,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(344),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41704);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\,
dataf => N_42364,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\,
dataf => N_42365,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(32),
cout => N_41702,
dataf => N_42373,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\,
dataf => N_42381,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(345),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41700);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\,
dataf => N_42387,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\,
dataf => N_42388,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(33),
cout => N_41698,
dataf => N_42396,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\,
dataf => N_42404,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(346),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41696);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\,
dataf => N_42410,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\,
dataf => N_42411,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(34),
cout => N_41694,
dataf => N_42419,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\,
dataf => N_42427,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(347),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41692);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\,
dataf => N_42433,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\,
dataf => N_42434,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(35),
cout => N_41690,
dataf => N_42442,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\,
dataf => N_42450,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(348),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41688);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\,
dataf => N_42456,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\,
dataf => N_42457,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(36),
cout => N_41686,
dataf => N_42465,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\,
dataf => N_42473,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(349),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41684);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\,
dataf => N_42479,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\,
dataf => N_42480,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(37),
cout => N_41682,
dataf => N_42488,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\,
dataf => N_42496,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(350),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41680);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\,
dataf => N_42502,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\,
dataf => N_42503,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(38),
cout => N_41678,
dataf => N_42511,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\,
dataf => N_42519,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(351),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41676);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\,
dataf => N_42525,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\,
dataf => N_42526,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(39),
cout => N_41674,
dataf => N_42534,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\,
dataf => N_42542,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(352),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41672);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\,
dataf => N_42548,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\,
dataf => N_42549,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(40),
cout => N_41670,
dataf => N_42557,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\,
dataf => N_42565,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(353),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41668);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\,
dataf => N_42571,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\,
dataf => N_42572,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(41),
cout => N_41666,
dataf => N_42580,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\,
dataf => N_42588,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(354),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41664);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\,
dataf => N_42594,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\,
dataf => N_42595,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(42),
cout => N_41662,
dataf => N_42603,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\,
dataf => N_42611,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(355),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41660);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\,
dataf => N_42617,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\,
dataf => N_42618,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(43),
cout => N_41658,
dataf => N_42626,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\,
dataf => N_42634,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(356),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41656);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\,
dataf => N_42640,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\,
dataf => N_42641,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(44),
cout => N_41654,
dataf => N_42649,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\,
dataf => N_42657,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(357),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41652);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\,
dataf => N_42663,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\,
dataf => N_42664,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(45),
cout => N_41650,
dataf => N_42672,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\,
dataf => N_42680,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(358),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41648);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\,
dataf => N_42686,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\,
dataf => N_42687,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(46),
cout => N_41646,
dataf => N_42695,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\,
dataf => N_42703,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(359),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41644);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\,
dataf => N_42709,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\,
dataf => N_42710,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(47),
cout => N_41642,
dataf => N_42718,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\,
dataf => N_42726,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(360),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41640);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\,
dataf => N_42732,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\,
dataf => N_42733,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(48),
cout => N_41638,
dataf => N_42741,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\,
dataf => N_42749,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(361),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41636);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\,
dataf => N_42755,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\,
dataf => N_42756,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(49),
cout => N_41634,
dataf => N_42764,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\,
dataf => N_42772,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(362),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41632);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\,
dataf => N_42778,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\,
dataf => N_42779,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(50),
cout => N_41630,
dataf => N_42787,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\,
dataf => N_42795,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(363),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41628);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\,
dataf => N_42801,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\,
dataf => N_42802,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(51),
cout => N_41626,
dataf => N_42810,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\,
dataf => N_42818,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(364),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41624);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\,
dataf => N_42824,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\,
dataf => N_42825,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(52),
cout => N_41622,
dataf => N_42833,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\,
dataf => N_42841,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(365),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41620);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\,
dataf => N_42847,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\,
dataf => N_42848,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(53),
cout => N_41618,
dataf => N_42856,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\,
dataf => N_42864,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(366),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41616);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\,
dataf => N_42870,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\,
dataf => N_42871,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(54),
cout => N_41614,
dataf => N_42879,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\,
dataf => N_42887,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(367),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41612);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\,
dataf => N_42893,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\,
dataf => N_42894,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00003000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(55),
cout => N_41610,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\(0),
datad => N_42902,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\(52),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\,
dataf => N_42912,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(316),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41608);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\,
dataf => N_42922,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7767\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7768\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\,
dataf => N_42923,
datad => N_42921,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7311\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7160\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(4),
cout => N_41606,
dataf => N_42927,
datad => N_42926,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.55.SI_60\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7244\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\,
dataf => N_42932,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(317),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41604);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\,
dataf => N_42938,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\,
dataf => N_42939,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(5),
cout => N_41602,
dataf => N_42947,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\,
dataf => N_42955,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(318),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41600);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\,
dataf => N_42961,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\,
dataf => N_42962,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(6),
cout => N_41598,
dataf => N_42970,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\,
dataf => N_42978,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(319),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
cin => N_41596);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\,
dataf => N_42984,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\,
dataf => N_42985,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(7),
cout => N_41594,
dataf => N_42993,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI5HDS1_368_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ccff0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(368),
datad => N_43001,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7083\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
cin => N_41592);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_0_RNIA4LK4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000c00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\(1),
datad => N_43007,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNICUPS9: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\,
dataf => N_43008,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNICUPS9_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\,
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\,
dataf => VCC,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNI17UEJ: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\,
cout => N_41590,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f0cc")
port map (
sumout => \GRLFPC20.FPO.EXP\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11191\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11178\,
cin => N_41588);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11179\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11192\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11180\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11193\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11181\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11194\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11182\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11195\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_5: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11196\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11183\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11197\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11183\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_7: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11198\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_8: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11199\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_9: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11200\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_10: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.FPO.EXP\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5391\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11201\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_11: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5474\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11202\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_12: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
cout => N_1,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5471\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11203\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f0cc")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\,
dataf => N_43068,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
cin => N_41586);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\,
dataf => N_43074,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\,
dataf => N_43075,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\,
dataf => N_43080,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\,
dataf => N_43081,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_5: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\,
dataf => N_43086,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\,
dataf => N_43087,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_7: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\,
dataf => N_43092,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_8: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\,
dataf => N_43093,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_9: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\,
dataf => N_43098,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_10: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\,
dataf => N_43099,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_11: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\,
dataf => N_43104,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_12: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\,
dataf => N_43105,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_13: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\,
dataf => N_43110,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_14: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\,
dataf => N_43111,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_15: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\,
dataf => N_43116,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_16: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\,
dataf => N_43117,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_17: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\,
dataf => N_43122,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_18: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\,
dataf => N_43123,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_19: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\,
dataf => N_43128,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_20: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\,
dataf => N_43129,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\,
dataf => N_43134,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\,
dataf => N_43135,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\,
dataf => N_43140,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\,
dataf => N_43141,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\,
dataf => N_43146,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\,
dataf => N_43147,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\,
dataf => N_43152,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_28: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\,
dataf => N_43153,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_29: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\,
dataf => N_43158,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_30: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\,
dataf => N_43159,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_31: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.FPO.FRAC\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\,
dataf => N_43163,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_32: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_33: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_34: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_35: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_36: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_37: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_38: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_39: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_40: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_41: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_42: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_43: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_44: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_45: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_46: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_47: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_48: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_49: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_50: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_51: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_52: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(52),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_53: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(53),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_54: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(54),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_55: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\,
dataf => N_43257,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_56: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_57: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
cout => N_2,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(257),
cin => N_57679);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(256),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(242),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(255),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(241),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(254),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(240),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(253),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_5: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(239),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(252),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(238),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(251),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_7: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(237),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(250),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_8: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(236),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(249),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_9: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(248),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_10: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(234),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(247),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_11: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_12: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(12),
cout => N_3,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(232),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f033")
port map (
cout => N_41586,
datad => N_43067,
datac => N_43066,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f0cc")
port map (
cout => N_41588,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNI17UEJ_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_4\,
cout => N_4,
cin => N_41590);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_RNIE5UV_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41592,
datad => N_43000,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(64),
cin => N_41594);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41596,
datad => N_42977,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(63),
cin => N_41598);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41600,
datad => N_42954,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(62),
cin => N_41602);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41604,
datad => N_42931,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(61),
cin => N_41606);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41608,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10947\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(112),
cin => N_41610);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41612,
datad => N_42886,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(111),
cin => N_41614);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41616,
datad => N_42863,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(110),
cin => N_41618);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41620,
datad => N_42840,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(109),
cin => N_41622);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41624,
datad => N_42817,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(108),
cin => N_41626);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41628,
datad => N_42794,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(107),
cin => N_41630);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41632,
datad => N_42771,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(106),
cin => N_41634);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41636,
datad => N_42748,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(105),
cin => N_41638);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41640,
datad => N_42725,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(104),
cin => N_41642);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41644,
datad => N_42702,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(103),
cin => N_41646);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41648,
datad => N_42679,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(102),
cin => N_41650);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41652,
datad => N_42656,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(101),
cin => N_41654);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41656,
datad => N_42633,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(100),
cin => N_41658);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41660,
datad => N_42610,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(99),
cin => N_41662);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41664,
datad => N_42587,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(98),
cin => N_41666);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41668,
datad => N_42564,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(97),
cin => N_41670);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41672,
datad => N_42541,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(96),
cin => N_41674);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41676,
datad => N_42518,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(95),
cin => N_41678);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41680,
datad => N_42495,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(94),
cin => N_41682);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41684,
datad => N_42472,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(93),
cin => N_41686);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41688,
datad => N_42449,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(92),
cin => N_41690);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41692,
datad => N_42426,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(91),
cin => N_41694);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41696,
datad => N_42403,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(90),
cin => N_41698);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41700,
datad => N_42380,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(89),
cin => N_41702);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41704,
datad => N_42357,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(88),
cin => N_41706);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41708,
datad => N_42334,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(87),
cin => N_41710);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41712,
datad => N_42311,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(86),
cin => N_41714);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41716,
datad => N_42288,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(85),
cin => N_41718);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41720,
datad => N_42265,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(84),
cin => N_41722);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41724,
datad => N_42242,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(83),
cin => N_41726);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41728,
datad => N_42219,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(82),
cin => N_41730);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41732,
datad => N_42196,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(81),
cin => N_41734);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41736,
datad => N_42173,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(80),
cin => N_41738);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41740,
datad => N_42150,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(79),
cin => N_41742);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41744,
datad => N_42127,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(78),
cin => N_41746);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41748,
datad => N_42104,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(77),
cin => N_41750);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41752,
datad => N_42081,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(76),
cin => N_41754);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41756,
datad => N_42058,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(75),
cin => N_41758);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41760,
datad => N_42035,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(74),
cin => N_41762);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41764,
datad => N_42012,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(73),
cin => N_41766);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41768,
datad => N_41989,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(72),
cin => N_41770);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41772,
datad => N_41966,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(71),
cin => N_41774);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41776,
datad => N_41943,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(70),
cin => N_41778);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41780,
datad => N_41920,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(69),
cin => N_41782);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41784,
datad => N_41897,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(68),
cin => N_41786);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41788,
datad => N_41874,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(67),
cin => N_41790);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41792,
datad => N_41851,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(66),
cin => N_41794);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41796,
datad => N_41828,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_3_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(65),
cin => N_41798);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_41800,
datad => N_41805,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"33ff33fffafafafa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
datad => N_27050_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"fa50d8d8fa502727")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_245_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"fcf0505030f05050")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(245),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(232),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12));
\GRLFPC20_R_FSR_CEXC_RNO_0_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"d0d0dd0dd0d00d0d")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_4__G1_1\,
dataf => \GRLFPC20.R.I.EXC\(4),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.R.FSR.TEM\(4),
datac => \GRLFPC20.N_1146\,
datab => N_364,
dataa => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datag => N_404);
\GRLFPC20_R_FSR_CEXC_RNO_0_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"d0d0dd0dd0d00d0d")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\,
dataf => \GRLFPC20.R.I.EXC\(3),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.R.FSR.TEM\(3),
datac => \GRLFPC20.N_1146\,
datab => N_363,
dataa => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datag => N_403);
\GRLFPC20_R_FSR_CEXC_RNO_0_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"d0d0dd0dd0d00d0d")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_1__G1_1\,
dataf => \GRLFPC20.R.I.EXC\(1),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.R.FSR.TEM\(1),
datac => \GRLFPC20.N_1146\,
datab => N_361,
dataa => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datag => N_401);
\GRLFPC20_R_FSR_CEXC_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"d0d0dd0dd0d00d0d")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_0__G1_1\,
dataf => \GRLFPC20.R.I.EXC\(0),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.R.FSR.TEM\(0),
datac => \GRLFPC20.N_1146\,
datab => N_360,
dataa => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datag => N_400);
\GRLFPC20_R_FSR_CEXC_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"d0d0dd0dd0d00d0d")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_2__G1_1\,
dataf => \GRLFPC20.R.I.EXC\(2),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.R.FSR.TEM\(2),
datac => \GRLFPC20.N_1146\,
datab => N_362,
dataa => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datag => N_402);
\GRLFPC20_COMB_V_FSR_FCC_1_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0ccf5f0f0cca0")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(1),
dataf => CPO_CCZ(1),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.N_1269\,
datac => N_371,
datab => \GRLFPC20.R.I.CC\(1),
dataa => \GRLFPC20.N_1341\,
datag => N_411);
\GRLFPC20_COMB_V_FSR_FCC_1_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0ccf5f0f0cca0")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(0),
dataf => CPO_CCZ(0),
datae => \GRLFPC20.N_1378\,
datad => \GRLFPC20.N_1269\,
datac => N_370,
datab => \GRLFPC20.R.I.CC\(0),
dataa => \GRLFPC20.N_1341\,
datag => N_410);
\GRLFPC20_R_A_RF2REN_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"3020333230003310")
port map (
combout => N_32150,
dataf => \GRLFPC20.N_3458\,
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.COMB.RS1D_1\,
datac => N_72,
datab => N_31081,
dataa => \GRLFPC20.N_2173\,
datag => \GRLFPC20.UN1_FPOP7_1\);
\GRLFPC20_R_A_RF1REN_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"3030333310300123")
port map (
combout => N_32148,
dataf => \GRLFPC20.COMB.RS1D_1\,
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.N_3458\,
datac => N_72,
datab => N_31081,
dataa => \GRLFPC20.N_2173\,
datag => \GRLFPC20.UN1_FPOP7_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"ae04f5f5ae04a0a0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44));
\GRLFPC20_WRDATA_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(9),
dataf => \GRLFPC20.R.I.RES\(38),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_369,
datac => \GRLFPC20.R.I.RES\(41),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_409);
\GRLFPC20_WRDATA_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(27),
dataf => \GRLFPC20.R.I.RES\(56),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_387,
datac => \GRLFPC20.R.I.RES\(27),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_427);
\GRLFPC20_WRDATA_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(21),
dataf => \GRLFPC20.R.I.RES\(50),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_381,
datac => \GRLFPC20.R.I.RES\(21),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_421);
\GRLFPC20_WRDATA_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(4),
dataf => \GRLFPC20.R.I.RES\(33),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_364,
datac => \GRLFPC20.R.I.RES\(36),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_404);
\GRLFPC20_WRDATA_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(23),
dataf => \GRLFPC20.R.I.RES\(52),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_383,
datac => \GRLFPC20.R.I.RES\(23),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_423);
\GRLFPC20_WRDATA_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(19),
dataf => \GRLFPC20.R.I.RES\(48),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_379,
datac => \GRLFPC20.R.I.RES\(19),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_419);
\GRLFPC20_WRDATA_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(12),
dataf => \GRLFPC20.R.I.RES\(41),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_372,
datac => \GRLFPC20.R.I.RES\(12),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_412);
\GRLFPC20_WRDATA_22_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(22),
dataf => \GRLFPC20.R.I.RES\(51),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_382,
datac => \GRLFPC20.R.I.RES\(22),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_422);
\GRLFPC20_WRDATA_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(30),
dataf => \GRLFPC20.R.I.RES\(59),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_390,
datac => \GRLFPC20.R.I.RES\(62),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_430);
\GRLFPC20_WRDATA_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(23),
dataf => \GRLFPC20.R.I.RES\(52),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_383,
datac => \GRLFPC20.R.I.RES\(55),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_423);
\GRLFPC20_WRDATA_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(6),
dataf => \GRLFPC20.R.I.RES\(35),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_366,
datac => \GRLFPC20.R.I.RES\(38),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_406);
\GRLFPC20_WRDATA_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(16),
dataf => \GRLFPC20.R.I.RES\(45),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_376,
datac => \GRLFPC20.R.I.RES\(16),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_416);
\GRLFPC20_WRDATA_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(14),
dataf => \GRLFPC20.R.I.RES\(43),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_374,
datac => \GRLFPC20.R.I.RES\(14),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_414);
\GRLFPC20_WRDATA_10_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(10),
dataf => \GRLFPC20.R.I.RES\(39),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_370,
datac => \GRLFPC20.R.I.RES\(10),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_410);
\GRLFPC20_WRDATA_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(30),
dataf => \GRLFPC20.R.I.RES\(59),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_390,
datac => \GRLFPC20.R.I.RES\(30),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_430);
\GRLFPC20_WRDATA_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(20),
dataf => \GRLFPC20.R.I.RES\(49),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_380,
datac => \GRLFPC20.R.I.RES\(52),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_420);
\GRLFPC20_WRDATA_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(25),
dataf => \GRLFPC20.R.I.RES\(54),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_385,
datac => \GRLFPC20.R.I.RES\(25),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_425);
\GRLFPC20_WRDATA_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(7),
dataf => \GRLFPC20.R.I.RES\(36),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_367,
datac => \GRLFPC20.R.I.RES\(39),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_407);
\GRLFPC20_WRDATA_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(12),
dataf => \GRLFPC20.R.I.RES\(41),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_372,
datac => \GRLFPC20.R.I.RES\(44),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_412);
\GRLFPC20_WRDATA_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(15),
dataf => \GRLFPC20.R.I.RES\(44),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_375,
datac => \GRLFPC20.R.I.RES\(15),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_415);
\GRLFPC20_WRDATA_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(26),
dataf => \GRLFPC20.R.I.RES\(55),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_386,
datac => \GRLFPC20.R.I.RES\(26),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_426);
\GRLFPC20_WRDATA_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(11),
dataf => \GRLFPC20.R.I.RES\(40),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_371,
datac => \GRLFPC20.R.I.RES\(11),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_411);
\GRLFPC20_WRDATA_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(18),
dataf => \GRLFPC20.R.I.RES\(47),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_378,
datac => \GRLFPC20.R.I.RES\(18),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_418);
\GRLFPC20_WRDATA_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(16),
dataf => \GRLFPC20.R.I.RES\(45),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_376,
datac => \GRLFPC20.R.I.RES\(48),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_416);
\GRLFPC20_WRDATA_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(19),
dataf => \GRLFPC20.R.I.RES\(48),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_379,
datac => \GRLFPC20.R.I.RES\(51),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_419);
\GRLFPC20_WRDATA_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(10),
dataf => \GRLFPC20.R.I.RES\(39),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_370,
datac => \GRLFPC20.R.I.RES\(42),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_410);
\GRLFPC20_WRDATA_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(22),
dataf => \GRLFPC20.R.I.RES\(51),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_382,
datac => \GRLFPC20.R.I.RES\(54),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_422);
\GRLFPC20_WRDATA_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(3),
dataf => \GRLFPC20.R.I.RES\(32),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_363,
datac => \GRLFPC20.R.I.RES\(35),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_403);
\GRLFPC20_WRDATA_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(24),
dataf => \GRLFPC20.R.I.RES\(53),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_384,
datac => \GRLFPC20.R.I.RES\(24),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_424);
\GRLFPC20_WRDATA_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(0),
dataf => \GRLFPC20.R.I.RES\(29),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_360,
datac => \GRLFPC20.R.I.RES\(0),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_400);
\GRLFPC20_WRDATA_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(8),
dataf => \GRLFPC20.R.I.RES\(37),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_368,
datac => \GRLFPC20.R.I.RES\(8),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_408);
\GRLFPC20_WRDATA_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(5),
dataf => \GRLFPC20.R.I.RES\(34),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_365,
datac => \GRLFPC20.R.I.RES\(5),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_405);
\GRLFPC20_WRDATA_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(7),
dataf => \GRLFPC20.R.I.RES\(36),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_367,
datac => \GRLFPC20.R.I.RES\(7),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_407);
\GRLFPC20_WRDATA_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(4),
dataf => \GRLFPC20.R.I.RES\(33),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_364,
datac => \GRLFPC20.R.I.RES\(4),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_404);
\GRLFPC20_WRDATA_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(31),
dataf => \GRLFPC20.R.I.RES\(63),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_391,
datac => \GRLFPC20.R.I.RES\(31),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_431);
\GRLFPC20_WRDATA_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(0),
dataf => \GRLFPC20.R.I.RES\(29),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_360,
datac => \GRLFPC20.R.I.RES\(32),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_400);
\GRLFPC20_WRDATA_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(24),
dataf => \GRLFPC20.R.I.RES\(53),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_384,
datac => \GRLFPC20.R.I.RES\(56),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_424);
\GRLFPC20_WRDATA_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(21),
dataf => \GRLFPC20.R.I.RES\(50),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_381,
datac => \GRLFPC20.R.I.RES\(53),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_421);
\GRLFPC20_WRDATA_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(17),
dataf => \GRLFPC20.R.I.RES\(46),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_377,
datac => \GRLFPC20.R.I.RES\(49),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_417);
\GRLFPC20_WRDATA_46_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(14),
dataf => \GRLFPC20.R.I.RES\(43),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_374,
datac => \GRLFPC20.R.I.RES\(46),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_414);
\GRLFPC20_WRDATA_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(15),
dataf => \GRLFPC20.R.I.RES\(44),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_375,
datac => \GRLFPC20.R.I.RES\(47),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_415);
\GRLFPC20_WRDATA_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(28),
dataf => \GRLFPC20.R.I.RES\(57),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_388,
datac => \GRLFPC20.R.I.RES\(28),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_428);
\GRLFPC20_WRDATA_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(29),
dataf => \GRLFPC20.R.I.RES\(58),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_389,
datac => \GRLFPC20.R.I.RES\(29),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_429);
\GRLFPC20_WRDATA_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(2),
dataf => \GRLFPC20.R.I.RES\(31),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_362,
datac => \GRLFPC20.R.I.RES\(2),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_402);
\GRLFPC20_WRDATA_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(17),
dataf => \GRLFPC20.R.I.RES\(46),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_377,
datac => \GRLFPC20.R.I.RES\(17),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_417);
\GRLFPC20_WRDATA_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(9),
dataf => \GRLFPC20.R.I.RES\(38),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_369,
datac => \GRLFPC20.R.I.RES\(9),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_409);
\GRLFPC20_WRDATA_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(20),
dataf => \GRLFPC20.R.I.RES\(49),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_380,
datac => \GRLFPC20.R.I.RES\(20),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_420);
\GRLFPC20_WRDATA_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(11),
dataf => \GRLFPC20.R.I.RES\(40),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_371,
datac => \GRLFPC20.R.I.RES\(43),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_411);
\GRLFPC20_WRDATA_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(13),
dataf => \GRLFPC20.R.I.RES\(42),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_373,
datac => \GRLFPC20.R.I.RES\(45),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_413);
\GRLFPC20_WRDATA_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(13),
dataf => \GRLFPC20.R.I.RES\(42),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_373,
datac => \GRLFPC20.R.I.RES\(13),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_413);
\GRLFPC20_WRDATA_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(25),
dataf => \GRLFPC20.R.I.RES\(54),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_385,
datac => \GRLFPC20.R.I.RES\(57),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_425);
\GRLFPC20_WRDATA_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(3),
dataf => \GRLFPC20.R.I.RES\(32),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_363,
datac => \GRLFPC20.R.I.RES\(3),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_403);
\GRLFPC20_WRDATA_40_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(8),
dataf => \GRLFPC20.R.I.RES\(37),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_368,
datac => \GRLFPC20.R.I.RES\(40),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_408);
\GRLFPC20_WRDATA_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(26),
dataf => \GRLFPC20.R.I.RES\(55),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_386,
datac => \GRLFPC20.R.I.RES\(58),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_426);
\GRLFPC20_WRDATA_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(1),
dataf => \GRLFPC20.R.I.RES\(30),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_361,
datac => \GRLFPC20.R.I.RES\(33),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_401);
\GRLFPC20_WRDATA_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(28),
dataf => \GRLFPC20.R.I.RES\(57),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_388,
datac => \GRLFPC20.R.I.RES\(60),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_428);
\GRLFPC20_WRDATA_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(18),
dataf => \GRLFPC20.R.I.RES\(47),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_378,
datac => \GRLFPC20.R.I.RES\(50),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_418);
\GRLFPC20_WRDATA_37_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(5),
dataf => \GRLFPC20.R.I.RES\(34),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_365,
datac => \GRLFPC20.R.I.RES\(37),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_405);
\GRLFPC20_WRDATA_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(27),
dataf => \GRLFPC20.R.I.RES\(56),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_387,
datac => \GRLFPC20.R.I.RES\(59),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_427);
\GRLFPC20_WRDATA_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(29),
dataf => \GRLFPC20.R.I.RES\(58),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_389,
datac => \GRLFPC20.R.I.RES\(61),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_429);
\GRLFPC20_WRDATA_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(2),
dataf => \GRLFPC20.R.I.RES\(31),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_362,
datac => \GRLFPC20.R.I.RES\(34),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_402);
\GRLFPC20_WRDATA_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(1),
dataf => \GRLFPC20.R.I.RES\(30),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_361,
datac => \GRLFPC20.R.I.RES\(1),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_401);
\GRLFPC20_WRDATA_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(6),
dataf => \GRLFPC20.R.I.RES\(35),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_366,
datac => \GRLFPC20.R.I.RES\(6),
datab => \GRLFPC20.N_1929\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_406);
\GRLFPC20_R_E_STDATA_RNO_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(9),
dataf => \GRLFPC20.FPI.OP1\(41),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(9),
datac => \GRLFPC20.R.FSR.AEXC\(4),
datab => \GRLFPC20.R.I.PC\(9),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(4),
dataf => \GRLFPC20.FPI.OP1\(36),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(4),
datac => \GRLFPC20.R.FSR.CEXC\(4),
datab => \GRLFPC20.R.I.PC\(4),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(15),
dataf => \GRLFPC20.FPI.OP1\(47),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(15),
datac => \GRLFPC20.R.FSR.FTT\(1),
datab => \GRLFPC20.R.I.PC\(15),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0c0008080c000a0a")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_3\,
dataf => N_27721,
datae => N_26815_1,
datad => N_26813_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => N_26886,
dataa => N_28336_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_R_E_STDATA_RNO_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(8),
dataf => \GRLFPC20.FPI.OP1\(40),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(8),
datac => \GRLFPC20.R.FSR.AEXC\(3),
datab => \GRLFPC20.R.I.PC\(8),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(3),
dataf => \GRLFPC20.FPI.OP1\(35),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(3),
datac => \GRLFPC20.R.FSR.CEXC\(3),
datab => \GRLFPC20.R.I.PC\(3),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_10_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(10),
dataf => \GRLFPC20.FPI.OP1\(42),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(10),
datac => CPO_CCZ(0),
datab => \GRLFPC20.R.I.PC\(10),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(14),
dataf => \GRLFPC20.FPI.OP1\(46),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(14),
datac => \GRLFPC20.R.FSR.FTT\(0),
datab => \GRLFPC20.R.I.PC\(14),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(25),
dataf => \GRLFPC20.FPI.OP1\(57),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(25),
datac => \GRLFPC20.R.FSR.TEM\(2),
datab => \GRLFPC20.R.I.PC\(25),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(2),
dataf => \GRLFPC20.FPI.OP1\(34),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(2),
datac => \GRLFPC20.R.FSR.CEXC\(2),
datab => \GRLFPC20.R.I.PC\(2),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(13),
dataf => \GRLFPC20.FPI.OP1\(45),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(13),
datac => \GRLFPC20.N_2391\,
datab => \GRLFPC20.R.I.PC\(13),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(24),
dataf => \GRLFPC20.FPI.OP1\(56),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(24),
datac => \GRLFPC20.R.FSR.TEM\(1),
datab => \GRLFPC20.R.I.PC\(24),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0f00ff8000008080")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_7\,
dataf => N_22759_1,
datae => N_27721,
datad => N_26972_1,
datac => N_23791_1,
datab => N_23715_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datag => N_23346);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_0_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0c00cc000c000800")
port map (
combout => N_27202,
dataf => N_27747_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => N_23785_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => N_28065_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\);
\GRLFPC20_R_E_STDATA_RNO_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(30),
dataf => \GRLFPC20.FPI.OP1\(62),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(30),
datac => \GRLFPC20.R.FSR.RD\(0),
datab => \GRLFPC20.R.I.PC\(30),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_22_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(22),
dataf => \GRLFPC20.FPI.OP1\(54),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(22),
datac => \GRLFPC20.R.FSR.NONSTD\,
datab => \GRLFPC20.R.I.PC\(22),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(26),
dataf => \GRLFPC20.FPI.OP1\(58),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(26),
datac => \GRLFPC20.R.FSR.TEM\(3),
datab => \GRLFPC20.R.I.PC\(26),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0000000084218181")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5398\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5424\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_15: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(216),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11022\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(225),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11013\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"c0005050c0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_0\,
dataf => N_23165_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => N_27698_2,
datac => N_26813_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => N_27149_1,
datag => N_27547_1);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_14: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(217),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11021\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_234_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"00f0c4c400f08080")
port map (
combout => N_30921,
dataf => \GRLFPC20.FPO.EXP\(10),
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(247),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datag => \GRLFPC20.FPI.OP2\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_7: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(224),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11014\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A7_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0100100000001000")
port map (
combout => N_23320,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => N_26722_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => N_27811,
datag => N_22673_1);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_18: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(213),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11025\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_9: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(222),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11016\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_235_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"00f0c4c400f08080")
port map (
combout => N_30897,
dataf => \GRLFPC20.FPO.EXP\(9),
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(248),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datag => \GRLFPC20.FPI.OP2\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_236_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"00f0c4c400f08080")
port map (
combout => N_30873,
dataf => \GRLFPC20.FPO.EXP\(8),
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(249),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datag => \GRLFPC20.FPI.OP2\(60));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_11: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(220),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11018\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f66ff99ff99ff99f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11201\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11182\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5391\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11195\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"7350330000005050")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_9\,
dataf => N_26801_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => N_27065_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => N_27096,
dataa => N_27187,
datag => N_27050_1);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_20: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_20\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(211),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11027\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_10: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(221),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11017\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_8: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(223),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11015\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_GEN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0f00ec800000ec80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.GEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10892\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(372),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(371),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(314),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_19: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(212),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11026\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_13: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_13\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(218),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11020\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_12: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(219),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11019\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"a8a00a8a88000088")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0\,
dataf => N_22612_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => N_28336_1,
dataa => N_22958_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"880088008c0cc8c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_1_0\,
dataf => N_23344,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => N_26986_1,
dataa => N_27547_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M13_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"33300f0f33300a0a")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_32_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0000000020000200")
port map (
combout => N_27477,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => N_23362_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M13_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"fffc0000fffc0505")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M12_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0fcfffff0fc0505")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7965\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_1_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0ffffcfc0a0a0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13),
datae => N_30976_3,
datad => N_627,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datab => N_691,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datag => \GRLFPC20.COMB.UN1_R.A.RS1_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0222020202000202")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => N_23342,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => N_22804_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"c0ff5f5ff3ff5f5f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datae => N_27144_1,
datad => N_27396_1,
datac => N_23165_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => N_23850_1,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M13_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"ccfcf5f5ccfcf0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_0_BUF: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
cout => N_57679,
datad => VCC,
cin => GND);
GRLFPC20_R_X_LD_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.LD_0_0_G1\,
dataf => \GRLFPC20.R.M.LD\,
datae => \GRLFPC20.N_1802\);
GRLFPC20_R_X_FPOP_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.M.FPOP\,
datae => \GRLFPC20.N_1802\);
GRLFPC20_R_X_AFSR_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.M.AFSR\,
datae => \GRLFPC20.N_1802\);
GRLFPC20_R_X_AFQ_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.M.AFQ\,
datae => \GRLFPC20.N_1802\);
GRLFPC20_R_M_LD_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.LD_0_0_G1\,
dataf => \GRLFPC20.R.E.LD\,
datae => \GRLFPC20.N_1804\);
GRLFPC20_R_M_FPOP_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.E.FPOP\,
datae => \GRLFPC20.N_1804\);
GRLFPC20_R_M_AFSR_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.E.AFSR\,
datae => \GRLFPC20.N_1804\);
GRLFPC20_R_M_AFQ_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.E.AFQ\,
datae => \GRLFPC20.N_1804\);
GRLFPC20_R_E_LD_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.LD_0_0_G1\,
dataf => \GRLFPC20.R.A.LD\,
datae => \GRLFPC20.N_1173\);
GRLFPC20_R_E_FPOP_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.N_1173\);
GRLFPC20_R_E_AFSR_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.A.AFSR\,
datae => \GRLFPC20.N_1173\);
GRLFPC20_R_E_AFQ_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.A.AFQ\,
datae => \GRLFPC20.N_1173\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ba303030aa000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0_0\(38),
datae => N_22759_1,
datad => N_28194_1,
datac => N_22804_1,
datab => N_27794,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10197\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000f000000ff")
port map (
combout => N_57468,
dataf => N_27981_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_1\,
datad => N_28395,
datac => N_27289_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffcffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_18\,
dataf => N_57468,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_8\,
datad => N_28413,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_0\,
datab => N_28398);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0103050f113355ff")
port map (
combout => N_57467,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10236\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10197\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_3\,
dataf => N_57467,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10321\,
datad => N_26948_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_225_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57378,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.FPO.FRAC\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(225));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_226_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57377,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.FPO.FRAC\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(226));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_227_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57376,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.FPO.FRAC\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(227));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_228_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57375,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.FPO.FRAC\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(228));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_229_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57374,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(229));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_230_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57373,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(230));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_231_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57372,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(231));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57371,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57370,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57369,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_2__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57368,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57367,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57366,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57365,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57364,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57363,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_8__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57362,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57361,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57360,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57359,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57358,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57357,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57356,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57355,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57354,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57353,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57352,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57351,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57350,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57349,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57348,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57347,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57346,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57345,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57344,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57343,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57342,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2\,
datad => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57341,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57340,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57339,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57338,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57337,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57335,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_47__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57334,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57333,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57332,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57331,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57330,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57329,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57328,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57327,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57326,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57325,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57324,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57323,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_63_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57322,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57321,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_57320,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_79_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0fc0000f0f4")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11385\,
datae => N_56587,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4345\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"b0b1f5f500000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_5\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_85_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"b0b0f0f000bb00ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D\,
datad => N_56589,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_1_TZ\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C_3\,
dataa => N_24029);
GRLFPC20_R_MK_RST_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f000ff00ff00ff")
port map (
combout => \GRLFPC20.COMB.V.MK.RST_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
datad => N_56585,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_84_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00050207080d0a0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_M\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\,
datac => N_56583,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_REEXCOVUV_UN14_LOCOV_RNI10CEK: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00070000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5465\,
datae => N_56334,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datac => N_56551,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_11_RNI83RQH: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0000ffff")
port map (
combout => N_56551,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\);
GRLFPC20_R_MK_BUSY_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000ff00ff00ff00")
port map (
combout => \GRLFPC20.N_2564\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
datad => \GRLFPC20.R.MK.BUSY_0_0_G0_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_82_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3000000f1000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__N_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11385\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C\,
datad => N_24032,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4345\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_80_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"6fcfffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_1_C\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_80_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00cfeeee00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_8\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_RNIGRHQ01_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffafdf8f7f2f5f0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\,
datac => N_56350,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI7D4GS_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000003ffffffff")
port map (
combout => N_56340,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_8_RNIVFEN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0f0f0f0f0fff")
port map (
combout => N_56334,
dataf => \GRLFPC20.FPO.EXP\(10),
datae => \GRLFPC20.FPO.EXP\(9),
datad => \GRLFPC20.FPO.EXP\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_0_RNIR6KA01_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffafdf8f7f2f5f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_56_RNI5V83O: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"2220aaa8aaa8aaa8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
datab => \GRLFPC20.FPO.FRAC\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_79_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datac => N_55);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_78_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datac => N_59);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_78_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0ffffffccffcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_78_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfdf00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13690\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C\,
datab => N_24036,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTBZERODENORM_RNINBGH5: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300ff00ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4644\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_6\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4008\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_83_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ef00efffffcccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M_0\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
dataa => N_54);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_83_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ff0000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_2__G0_0_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C_3\,
datac => N_24031);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_82_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff31313300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__N_6\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G3_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_79_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000fe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_84_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00cf000000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_M\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C_3\,
datab => N_24030);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_79_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_84_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"d0f0ddffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_1_0\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4644\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_WAITMULXFF_NOTSAMPLEDWAIT_RNIGRHQ01: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_D_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_RNINAGA01_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffccf3c03f0c3300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11385\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11376\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_25_RNIDH3DR_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7c4fbc877447b48")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11383\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11379\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_12_RNIDQRM3_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"af6f9f5fa0609050")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11369\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11361\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11363\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11366\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_SXC_SFTLFT_AREGXORBREG_RNIQVQ22: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c9c5f9f509053935")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11361\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_83_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0c0c0c0c0c0cfc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
datad => \GRLFPC20.FPO.FRAC\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(58));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_47_RNI0FEQ1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_5\,
dataf => \GRLFPC20.FPO.FRAC\(53),
datae => \GRLFPC20.FPO.FRAC\(52),
datad => \GRLFPC20.FPO.FRAC\(51),
datac => \GRLFPC20.FPO.FRAC\(48),
datab => \GRLFPC20.FPO.FRAC\(47));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_49_RNIQ5CN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\,
dataf => \GRLFPC20.FPO.FRAC\(50),
datae => \GRLFPC20.FPO.FRAC\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\,
datad => \GRLFPC20.FPO.FRAC\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIOA89_238_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(239),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(241),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(240),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(238));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIFLHI_237_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(237),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(242));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIMENC_234_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000fffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4537\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(234),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(236),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTAZERODENORM_RNI80I91: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0333000003330333")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4724\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_6\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4537\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4012\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_AEBEEXC_UN3_NOTAZERODENORM_RNII98U1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4724\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_5\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI25386_77_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff00ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5312\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3953\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(77));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIA4N67_77_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5312\,
datae => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_0_O2_RNITE96Q_68_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datac => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_1_RNIPC3U_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc3cc33333c33ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13711\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11181\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11194\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIE7MB1_235_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f3ff0c0ff3f00c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RET_RNIMVJ7: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIT7SI_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_2_RNI6U5B2_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0ff0f0ffff000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13705\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11200\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_6_RNIMOFV2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff9fffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13705\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13708\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_1_RNIJ63U_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc3cc33333c33ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13713\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11179\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11192\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_1_RNIL5VA6_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc3cc33333c33ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13712\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11180\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11193\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_1_RNIBRUA6_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc3cc33333c33ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13714\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11178\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11191\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_6_RNI3D9KH: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"efffffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13712\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13714\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13713\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13711\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_5\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_0_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffffff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_78\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_5_RNIB2JG: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\,
dataf => \GRLFPC20.FPO.EXP\(7),
datae => \GRLFPC20.FPO.EXP\(6),
datad => \GRLFPC20.FPO.EXP\(5));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_1_RNIM24M: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_3\,
dataf => \GRLFPC20.FPO.EXP\(4),
datae => \GRLFPC20.FPO.EXP\(2),
datad => \GRLFPC20.FPO.EXP\(3),
datac => \GRLFPC20.FPO.EXP\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_REEXCOVUV_UN14_LOCOV: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5465\,
dataf => \GRLFPC20.FPO.EXP\(10),
datae => \GRLFPC20.FPO.EXP\(9),
datad => \GRLFPC20.FPO.EXP\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000153f")
port map (
combout => N_56594,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9742\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10173\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10212\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff4000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2\,
dataf => N_56393,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2_1\,
datad => N_28284,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff40ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_19\,
datae => N_56369,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(44),
datac => N_27291_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12640_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000135f")
port map (
combout => N_56366,
dataf => N_36594,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_3_0\,
datad => N_27981_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10184\,
datab => N_27289_1,
dataa => N_28242_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffecffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2\,
dataf => N_56357,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_19\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_20\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\,
datab => N_27041,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff5400")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_6_0\,
dataf => N_36515,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12200_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12640_1\,
datab => N_22588_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f1f0f0f011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datae => N_22745_1,
datad => N_27068_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10241\,
datab => N_22730_I,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000023330000afff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_17\,
dataf => N_28123_4,
datae => N_27392,
datad => N_22673_1,
datac => N_27208_1,
datab => N_26978_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f700000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_20\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_15\,
datae => N_27416,
datad => N_27404,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datab => N_26981_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000007f00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_1\,
datae => N_27408,
datad => N_27394,
datac => N_22958_1,
datab => N_23117_1,
dataa => N_22818_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_14\,
datae => N_26970,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_0\,
datac => N_26932_1,
datab => N_28336_1,
dataa => N_26808_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff88880008")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_5\,
datae => N_27785,
datad => N_28219,
datac => N_27721,
datab => N_22427_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffefffffefe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_19\,
dataf => N_27415_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_0\,
datad => N_27849_2,
datac => N_27836,
datab => N_28411,
dataa => N_27827);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff000f0004")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_13\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_6\,
datae => N_27871,
datad => N_28219,
datac => N_27792,
datab => N_27794,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff40")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_14\,
datae => N_27928,
datad => N_27919,
datac => N_27068_1,
datab => N_22759_1,
dataa => N_27794);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff1000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_13\,
dataf => N_26800,
datae => N_26815,
datad => N_22673_1,
datac => N_26932_1,
datab => N_23344,
dataa => N_27448_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff08ff0808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_12\,
dataf => N_26810,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_15_1\(54),
datad => N_27721,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658_2\,
dataa => N_26909_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff8f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_11\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_18_0\,
datad => N_22588_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff40440000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_3\,
dataf => N_27214,
datae => N_26993_1,
datad => N_22795_I,
datac => N_27231,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0040")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_7\,
dataf => N_27208,
datae => N_27206,
datad => N_22424_2,
datac => N_28242_1,
datab => N_22612_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffdccc5000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_8\,
dataf => N_27274,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_11_1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_10_TZ\,
datac => N_27050_1,
datab => N_28154_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0800")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_12\,
dataf => N_27288,
datae => N_27268,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_0\(52),
datac => N_22673_1,
datab => N_26815_1,
dataa => N_28194_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0200")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_16\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_0\,
datae => N_27287,
datad => N_27050_1,
datac => N_27177,
datab => N_27794,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000088f88888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_8\,
dataf => N_27970,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_7_0\(48),
datad => N_27792,
datac => N_22426_1,
datab => N_26972_1,
dataa => N_27286_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff8f8f8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_13\,
dataf => N_27988,
datae => N_27415_2,
datad => N_27849_2,
datac => N_27986,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_15_0\(48),
dataa => N_27993_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff4000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_4\,
dataf => N_27979,
datae => N_27983,
datad => N_27209_1,
datac => N_28006,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff40")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_9\,
datae => N_27989,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G4\,
datac => N_27065_2,
datab => N_27482_1,
dataa => N_27533);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff888f888f888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10161\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10173\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10184\,
dataa => N_27849_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffff4f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_13\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_5\,
datae => N_28333,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_1_0\(36),
datac => N_28335,
datab => N_22425_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff8f8f8fff0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2_1\,
dataf => N_27289_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10379\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10321\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9869\,
datab => N_22673_1,
dataa => N_28292_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff1000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9208\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12200_1\,
datac => N_22429_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_16\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_11\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10353\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0\(33),
datab => N_22424_2,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffe0a0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_16\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_10\,
datad => N_22958_1,
datac => N_28194_1,
datab => N_22429_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10241\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff8fff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_6_0\(28),
datad => N_27988,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\,
datab => N_22425_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0200")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_0\,
datad => N_23282_1,
datac => N_22745_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_24__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9390\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9337\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9998\,
datac => N_27065_2,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12200_1\,
dataa => N_27482_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffeac0eac0eac0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datae => N_23282_1,
datad => N_27561,
datac => N_27409_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_2_0\(23),
dataa => N_27068_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffeca0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_6\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10206\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10180\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10161\,
dataa => N_26868_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffeac0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_9\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_10\,
datad => N_27626_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_10_0\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffff2f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_0\,
datae => N_28240,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_0_0\(5),
datac => N_28246,
datab => N_28219,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0002")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_2\,
datae => N_28407,
datad => N_27792,
datac => N_23346,
datab => N_23344,
dataa => N_22486_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00001000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G4\,
datae => N_22673_1,
datad => N_22426_1,
datac => N_26822_1,
datab => N_28048_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_O12_2_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff8f08800")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9385\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10246\,
datae => N_23282_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10325\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A2_4_0\(17),
datab => N_22681_1,
dataa => N_26764_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff08000a00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_3\,
dataf => N_26909,
datae => N_27721,
datad => N_27131_1,
datac => N_27811,
datab => N_26975_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffec")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_6\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datab => N_26908,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10173\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff0effee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_8\,
dataf => N_28124,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_11_0\(11),
datad => N_27721,
datac => N_27209_1,
datab => N_28095,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000003f007f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_17\,
dataf => N_28120,
datae => N_27081_1,
datad => N_28117,
datac => N_28292_1,
datab => N_23362_1,
dataa => N_27144_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0010")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_5\,
dataf => N_27988,
datae => N_26745,
datad => N_23346,
datac => N_22427_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff40")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_8_0\,
dataf => N_27693,
datae => N_27686,
datad => N_27694,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_9_TZ\,
datab => N_22425_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_9_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_8_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_8\,
datac => N_22673_1,
datab => N_27682,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_WAITMULXFF_NOTSAMPLEDWAIT: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ba000a00b0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4345\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffc000aaaaaaaa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7954\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__N_4_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10088\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10298\,
datac => N_22958_1,
datab => N_22429_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_U: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000d0500000f05")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(56),
datae => N_43651,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_ENTRYPOINT_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc8cffafccccffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN1_ENTRYPOINT_0\,
datad => N_28219,
datac => N_26722_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4583\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datae => N_53);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_81_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_REST_N_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"d0dd0000f0ff0000")
port map (
combout => N_56595,
dataf => N_27065_2,
datae => N_56355,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_15_0\(58),
datac => N_28219,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
dataa => N_27762_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => N_56357,
dataf => N_56356,
datae => N_56595,
datad => N_27053,
datac => N_27054);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2\,
dataf => N_56366,
datae => N_56594,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_9\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9768\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"5555fcfffffffcff")
port map (
combout => N_56593,
dataf => N_27409_1,
datae => N_26932_1,
datad => N_23791_1,
datac => N_22804_1,
datab => N_27524,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_85_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0f0000000f")
port map (
combout => N_56589,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5457\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_79_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"6a6aff6aaaaaffaa")
port map (
combout => N_56587,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_R_MK_RST_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff0ffff")
port map (
combout => N_56585,
dataf => \GRLFPC20.COMB.UN1_ANNULFPU\,
datae => \GRLFPC20.COMB.V.MK.RST_1_0_G0_1\,
datad => \GRLFPC20.R.MK.RST2\,
datac => \GRLFPC20.R.MK.RST\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_84_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3fff3fff1fff3")
port map (
combout => N_56583,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_0\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fff00000ff0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_I_I_0\(0),
datae => N_56563,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4702_I\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_0_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0f0f0fff3f3f")
port map (
combout => N_56563,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4702_I\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.U_RDN_1\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4697\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(8));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_43152,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_56545,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(204));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56545,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_43147,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_56543,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(205));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56543,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_29_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43158,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56541,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(202));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_29_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56541,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43140,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56539,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(208));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56539,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43141,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56537,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(207));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56537,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43135,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56535,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(209));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56535,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43146,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56533,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(206));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56533,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_28_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43153,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56531,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(203));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_28_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56531,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_113_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffffe000")
port map (
combout => N_48611,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5019_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M0_114_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00f0f0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(114),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M0_115_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00f0f0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(115),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M12_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000c0000000f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_138\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_80_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datae => N_52);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_80_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_5__G0_REST_N_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIR97F2_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffeffee")
port map (
combout => N_56396,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIM91H3_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fff0f0fffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_1\(0),
dataf => N_56396,
datae => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_8_S_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000dd00d0d0d0d0")
port map (
combout => N_56395,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13694\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.STKGEN_1_0\,
datac => N_43661,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(315));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_8_S_RNI1UPBO_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fffffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\,
dataf => N_43713,
datae => N_43712,
datad => N_56395,
datac => N_43662);
GRLFPC20_COMB_V_A_LD_1_I_O2_S: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000005400000055")
port map (
combout => N_56394,
dataf => \GRLFPC20.N_3773\,
datae => \GRLFPC20.N_3736\,
datad => \GRLFPC20.N_3730\,
datac => N_80,
datab => N_79,
dataa => N_82);
GRLFPC20_COMB_V_A_LD_1_I_O2_S_RNIC7BO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.N_3747\,
dataf => N_56394,
datae => CPO_EXCZ,
datad => N_8,
datac => N_81);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000013")
port map (
combout => N_56393,
dataf => N_28290,
datae => N_28287,
datad => N_28294,
datac => N_28293_2,
datab => N_28292,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A9_5_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff40404000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_0__G2_1\,
dataf => N_28289,
datae => N_28297,
datad => N_26932_1,
datac => N_28048_1,
datab => N_26820_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"efffffffffffffff")
port map (
combout => N_56391,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_17\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_9\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_2\,
datab => N_28122,
dataa => N_28131);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000c0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2\,
dataf => N_56391,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_7\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_8\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_5\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"a8fcfcfcaaffffff")
port map (
combout => N_56390,
dataf => N_23117_1,
datae => N_27209_1,
datad => N_26981_1,
datac => N_23346,
datab => N_28273,
dataa => N_28095);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_18\,
dataf => N_28123,
datae => N_56390,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_3\,
datac => N_28118);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff3fffffffffff")
port map (
combout => N_56389,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_18\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10094\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_14\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_17\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_15\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000cfff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2\,
dataf => N_56389,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_20\,
datad => N_22889_1,
datac => N_28336_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_14_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0c000000000000")
port map (
combout => N_56388,
dataf => N_23791_1,
datae => N_27482_1,
datad => N_22608_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffffffffffffff")
port map (
combout => N_56387,
dataf => N_22958_1,
datae => N_22756_1,
datad => N_26975_1,
datac => N_22530_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_9\,
dataf => N_56387,
datae => N_22599_1,
datad => N_22745_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0fff0dffffffdd")
port map (
combout => N_56386,
dataf => N_22958_1,
datae => N_27020,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datac => N_27131_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_12\,
datae => N_56386,
datad => N_28057,
datac => N_28072);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000007000000ff")
port map (
combout => N_56385,
dataf => N_26910_3,
datae => N_26913,
datad => N_26914,
datac => N_27480_1,
datab => N_26932_1,
dataa => N_28312);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_8\,
dataf => N_56385,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_1\,
datad => N_27409_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_8_0\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_3_S_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"153f3f3f55ffffff")
port map (
combout => N_56384,
dataf => N_23282_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10216\,
datad => N_27068_1,
datac => N_27547_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A2_0_RNIV6RF1_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(7),
dataf => N_56384,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10283\,
datad => N_26920_1,
datac => N_28408_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000007fff")
port map (
combout => N_56383,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_2\,
datae => N_27545,
datad => N_27523,
datac => N_26764_1,
datab => N_22612_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffcffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_20\,
dataf => N_56383,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_0_0\,
datab => N_27547);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0d0fffffddffffff")
port map (
combout => N_56382,
dataf => N_22425_1,
datae => N_22745_1,
datad => N_23785_1,
datac => N_22427_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_4_1\,
datae => N_27546,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_3\,
datac => N_56382);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cbffffffffffffff")
port map (
combout => N_56381,
dataf => N_27993_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_4\,
datae => N_56381,
datad => N_28397,
datac => N_28408);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000070f070f070f")
port map (
combout => N_56380,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datae => N_23282_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10298\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10133\,
datab => N_22429_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_2\,
dataf => N_56380,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10135\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4c5fccff5f5fffff")
port map (
combout => N_56379,
dataf => N_23282_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_4_1\(5),
datad => N_26764_1,
datac => N_27469_1,
datab => N_27793_I,
dataa => N_26726_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffcff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_11\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_9\,
datad => N_56379,
datac => N_28252,
datab => N_28247);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000003f000000ff")
port map (
combout => N_56378,
dataf => N_27342_2,
datae => N_28245,
datad => N_28242,
datac => N_27448_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_11\,
dataf => N_56378,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G4\,
datad => N_28251,
datac => N_28241);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"e6b3f7f7eebbffff")
port map (
combout => N_56376,
dataf => N_27291_1,
datae => N_23282_1,
datad => N_23165_1,
datac => N_27177,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0ff00ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10094\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\,
datad => N_56376,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000003f")
port map (
combout => N_56375,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10068\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9385\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10216\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2\,
dataf => N_56375,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"010533ff0505ffff")
port map (
combout => N_56374,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10193\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10321\,
datad => N_27050_1,
datac => N_28062_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff00ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9208\,
datae => N_56374,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000001")
port map (
combout => N_56373,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10068\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_O12_3_0\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_1\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9698\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2\,
dataf => N_56373,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_9\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_6\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10042\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_O12_S_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ef00ffefefffff")
port map (
combout => N_56372,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datae => N_23668,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10182\,
datac => N_22673_1,
datab => N_27104_I,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A2_0_RNIB8RI1_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff000ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9434\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10210\,
datae => N_56372,
datad => N_23282_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10222\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000135f135f135f")
port map (
combout => N_56371,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10271\,
datae => N_22889_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10220\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10184\,
datab => N_27849_2,
dataa => N_28242_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2\,
dataf => N_56371,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9434\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000100030005000f")
port map (
combout => N_56370,
dataf => N_27478_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_1_TZ\,
datad => N_27486,
datac => N_27469,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_33_0\(27),
dataa => N_26975_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffcffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_20\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_17\,
datae => N_56370,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_7\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G4\,
datab => N_27470);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000bf")
port map (
combout => N_56369,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_14\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_8\,
datac => N_22889_1,
datab => N_22759_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffbfffbfffbf")
port map (
combout => N_56368,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10236\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12640_1\,
datad => N_27177,
datac => N_28242_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_10\,
dataf => N_56368,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0_0\,
datad => N_22820_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10182\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000030f")
port map (
combout => N_56367,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9851\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000010000")
port map (
combout => N_56365,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_16\,
datae => N_56364,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_6\,
datab => N_36595,
dataa => N_27266);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffcffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2\,
dataf => N_56365,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_12\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_14\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_9\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_8\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bbbfbfbfbbffffff")
port map (
combout => N_56364,
dataf => N_27291_1,
datae => N_27050_1,
datad => N_23785_1,
datac => N_28292_1,
datab => N_23622_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000002")
port map (
combout => N_56363,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_3\,
datac => N_27207,
datab => N_27201,
dataa => N_56362);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffcffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2\,
dataf => N_56363,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_10\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_7\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_9\,
datab => N_27202);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff6fffffffffff")
port map (
combout => N_56362,
dataf => N_22424_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000abbbafff")
port map (
combout => N_56361,
dataf => N_26814,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_21_1\(54),
datad => N_26932_1,
datac => N_22681_1,
datab => N_26909_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_15\,
dataf => N_56361,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_3\,
datad => N_28414_3,
datac => N_26805);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000b")
port map (
combout => N_56360,
dataf => N_27910,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_4\,
datac => N_27922,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_27_1\(55),
dataa => N_27882);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffcffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_20\,
dataf => N_56360,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_11\,
datad => N_27924,
datac => N_27915,
datab => N_27923);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"a8aafcffffffffff")
port map (
combout => N_56359,
dataf => N_28154_1,
datae => N_26815_1,
datad => N_27209_1,
datac => N_26971_1,
datab => N_26747_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f00000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_14\,
dataf => N_56359,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_19_1\(56),
datad => N_27524,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000dfff")
port map (
combout => N_56358,
dataf => N_27132,
datae => N_27125,
datad => N_22958_1,
datac => N_23362_1,
datab => N_27095_I,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_20\,
dataf => N_56358,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_7\,
datac => N_27146);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000bf")
port map (
combout => N_56356,
dataf => N_27043,
datae => N_27047,
datad => N_27066,
datac => N_27067_1,
datab => N_23117_1,
dataa => N_23342);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffbff")
port map (
combout => N_56355,
dataf => N_22496_2,
datae => N_27762_1,
datad => N_23026_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffeffee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_13\,
dataf => N_27747,
datae => N_27756_2,
datad => N_27751,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_1\(19),
datab => N_27748,
dataa => N_27749);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eeffffffe0fff0ff")
port map (
combout => N_56354,
dataf => N_22958_1,
datae => N_22745_1,
datad => N_22759_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_13\,
datae => N_56354,
datad => N_26971,
datac => N_26969);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000bbbffff")
port map (
combout => N_56353,
dataf => N_26981,
datae => N_26972_1,
datad => N_22759_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datab => N_26986_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f00000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_13\,
dataf => N_56353,
datae => N_26822_1,
datad => N_27096,
datac => N_27149_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ececffffccecccff")
port map (
combout => N_56352,
dataf => N_27325,
datae => N_22673_1,
datad => N_23791_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datab => N_27811,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_22\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_18\,
datae => N_56352,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_4\,
datac => N_27402,
datab => N_27412);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_0_RNIPG1G_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffff")
port map (
combout => N_56350,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_RNO_115_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff000808ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(115),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(118));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_114_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff000808ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(114),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(117));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_7_SQMUXA: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff0000ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => N_56342,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_7_SQMUXA_SUB: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff3fffffffffff")
port map (
combout => N_56342,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_XZAREGLOADEN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff0000fff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => N_56340,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datac => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffff0003")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => N_56336,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_39_IV_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000133333333")
port map (
combout => N_56336,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4433\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_85_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff15ff55ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5457\,
dataf => N_56334,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5465\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_3\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_RNIBMRI5_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"dc10dc10dc10cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
dataf => N_56330,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11341\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M12_RNISCE51_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0f0f000000")
port map (
combout => N_56330,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_94\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_RNI5GRI5_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"dc10dc10dc10cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
dataf => N_56326,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11339\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M12_RNIO8E51_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0f0f000000")
port map (
combout => N_56326,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_94\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_4_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56322,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43134,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56320,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(210));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56320,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_5_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56318,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_2_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56316,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_3_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_56314,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_16_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43117,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56312,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(215));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_16_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56312,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(41));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_17_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f3c3cf00ff0f0")
port map (
combout => N_43122,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => N_56310,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(214));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_17_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_56310,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00fc00ff00fc00cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_94\,
datad => N_56308,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_SUB_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00fc00fffffcffff")
port map (
combout => N_56308,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11340\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_1_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0ff0000ff00ff")
port map (
combout => N_43074,
dataf => N_56286,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_1_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000f000000ff")
port map (
combout => N_56286,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5415\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5402\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5399\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"15ea00ff1fe000ff")
port map (
combout => N_43068,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => N_56284,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5415\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffff")
port map (
combout => N_56284,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5427\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(15));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_COUNTSUCCESSIVEZERO18_0_A2_2_RNI33UR2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
datae => N_56274,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_0_A2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_138\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIQBQK1_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000f")
port map (
combout => N_56274,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIFDCR1_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff00ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5415\,
datad => N_56264);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN3_NOTXZYFROMD_RNIFDCR1_4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5415\,
datad => N_56264);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI82A81_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f0f0f00ffffff")
port map (
combout => N_56264,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(374),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10743\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10803\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10742\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10802\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10741\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10801\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10740\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10800\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10739\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10799\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10738\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10798\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(8),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10737\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10797\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(9),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10736\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10796\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_10_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10735\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10795\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10734\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10794\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10733\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10793\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10732\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10792\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10731\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10791\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(15),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10730\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10790\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(16),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10729\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10789\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10728\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10788\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(18),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10727\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10787\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(19),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10726\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10786\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(20),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10725\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10785\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(21),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10724\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10784\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_22_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10723\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10783\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10722\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10782\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10721\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10781\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10720\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10780\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10719\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10779\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10718\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10778\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10717\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10777\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(29),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10716\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10776\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10715\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10775\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10714\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10774\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10713\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10773\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_25\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10772\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10711\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10771\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10710\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10770\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10709\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10769\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_37_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(37),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10708\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10768\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10707\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10767\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10706\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10766\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_40_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(40),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10705\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10765\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(41),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10704\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10764\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10703\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10763\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10702\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10762\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(44),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10701\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10761\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(45),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10700\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10760\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_46_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(46),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10699\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10759\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10698\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10758\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10697\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10757\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10696\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10756\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10695\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10755\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(51),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10694\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10754\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(52),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10693\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10753\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10692\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10752\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(54),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10691\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10751\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10689\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10749\,
datad => N_55787_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56239,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56238,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56237,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56236,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56235,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56234,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56233,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56232,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_10_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56231,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56230,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56229,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56228,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56227,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56226,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56225,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56224,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56223,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56222,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56221,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56220,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_22_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56219,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56218,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56217,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56216,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56215,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56214,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56213,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56212,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56211,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56210,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56209,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56208,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56207,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56206,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56205,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_37_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56204,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56203,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56202,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_40_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56201,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56200,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56199,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56198,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56197,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56196,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_46_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56195,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56194,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56193,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56192,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56191,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56190,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56189,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56188,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56187,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_56186,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_10_RNIEHNI1_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffeeefeeefeee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_3\,
dataf => N_26994_2,
datae => N_23668,
datad => N_26910_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12200_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10061\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9941\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffcf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9827\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_3\,
datad => N_27989_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_4\,
datab => N_22530_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff8fffff8f8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10066\,
datad => N_22889_1,
datac => N_28413,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffd5c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10044\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9251\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datac => N_27626_2,
datab => N_27910_2,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9317\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(7),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10091\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10381\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff8000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_10\,
dataf => N_27212,
datae => N_27205,
datad => N_28154_1,
datac => N_27209_1,
datab => N_27186,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00200000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_2\,
dataf => N_27477,
datae => N_26822_1,
datad => N_27149_1,
datac => N_22947_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc000e000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_0\,
datae => N_28336_1,
datad => N_23165_1,
datac => N_22486_1,
datab => N_23976,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff080808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0\,
datae => N_27989_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10325\,
datac => N_27811,
datab => N_26993_1,
dataa => N_27469_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_3_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000700000000000")
port map (
combout => N_27688,
dataf => N_22426_1,
datae => N_22756_1,
datad => N_22424_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_2_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000030c50000")
port map (
combout => N_27748,
dataf => N_27721,
datae => N_27272_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_0_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ccc00c000000000")
port map (
combout => N_27393,
dataf => N_23791_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
GRLFPC20_COMB_UN9_CCV_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff888f888f888")
port map (
combout => \GRLFPC20.COMB.UN9_CCV_2\,
dataf => \GRLFPC20.R.I.EXEC\,
datae => \GRLFPC20.R.I.INST\(19),
datad => \GRLFPC20.R.X.FPOP\,
datac => N_342,
datab => \GRLFPC20.R.M.FPOP\,
dataa => N_273);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000ffc0000")
port map (
combout => N_27125,
dataf => N_27721,
datae => N_27208_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A7_1_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"082c000000000000")
port map (
combout => N_23322,
dataf => N_22426_1,
datae => N_22612_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"2700ffff27002700")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_1_TZ\,
dataf => N_27272_1,
datae => N_26773_I,
datad => N_22947_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_9_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"5101000000000000")
port map (
combout => N_27755,
dataf => N_22744_1,
datae => N_27272_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_4_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f3c00000")
port map (
combout => N_27206,
dataf => N_27721,
datae => N_26932_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_2_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000a0020000")
port map (
combout => N_26742,
dataf => N_27882,
datae => N_22427_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_COMB_UN1_MEXC_1_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000077707770777")
port map (
combout => \GRLFPC20.COMB.UN1_MEXC_1_2\,
dataf => \GRLFPC20.R.I.EXC\(0),
datae => \GRLFPC20.R.FSR.TEM\(0),
datad => \GRLFPC20.R.I.EXC\(3),
datac => \GRLFPC20.R.FSR.TEM\(3),
datab => \GRLFPC20.R.FSR.TEM\(1),
dataa => \GRLFPC20.R.I.EXC\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_3_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000041500000000")
port map (
combout => N_26912,
dataf => N_22426_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_5_1_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4040004040000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_5_1\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_7_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c00000000000000")
port map (
combout => N_28246,
dataf => N_26815_1,
datae => N_28217,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A27_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0150000000000000")
port map (
combout => N_27545,
dataf => N_22958_1,
datae => N_22425_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_1_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000350a00000000")
port map (
combout => N_26741,
dataf => N_27050_1,
datae => N_27794,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_0_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000030002")
port map (
combout => N_27827,
dataf => N_23344,
datae => N_22600_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_5_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ca00000000000000")
port map (
combout => N_27751,
dataf => N_22673_1,
datae => N_26972_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000c0030000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G4\,
dataf => N_27792,
datae => N_23622_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN38_SHDVAR_4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aeaa0c000c000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_2\,
dataf => N_22673_1,
datae => N_27068_1,
datad => N_26815_1,
datac => N_27096,
datab => N_23362_1,
dataa => N_26801_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(176));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_3_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"5000000030000000")
port map (
combout => N_27619,
dataf => N_22745_1,
datae => N_27338_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f444f00044440000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_11\,
dataf => N_27491_2,
datae => N_27480_1,
datad => N_22673_1,
datac => N_28194_1,
datab => N_22589_1,
dataa => N_22947_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A7_3_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3300000003000000")
port map (
combout => N_23324,
dataf => N_28154_1,
datae => N_22804_1,
datad => N_26820_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_COMB_FPDECODE_RS1D5_6_0_A2_0_RNIGIGI1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000008000")
port map (
combout => \GRLFPC20.R.A.RS1D_0_0_G4\,
dataf => N_57,
datae => N_55,
datad => \GRLFPC20.N_3765\,
datac => N_56,
datab => \GRLFPC20.N_3761\,
dataa => N_58);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"6eeaf7bffb7f9dd5")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5471\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5474\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11203\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11202\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_2_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0fff0000000000")
port map (
combout => N_26868,
dataf => N_26868_3,
datae => N_22818_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42870,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_13_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000c0000000000")
port map (
combout => N_27406,
dataf => N_22958_1,
datae => N_27144_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_0_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000033300000")
port map (
combout => N_27334,
dataf => N_27721,
datae => N_22426_1,
datad => N_27286_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000e0002000")
port map (
combout => N_28118,
dataf => N_27721,
datae => N_26808_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN11_WQSTSETS: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000007f7f7f70")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SCTRL_NEW_0_0__N_5\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cff0cc000ff00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_10_1\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0\(58),
datad => N_26972_1,
datac => N_23715_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_1_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000aa0000008000")
port map (
combout => N_27686,
dataf => N_28242_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datad => N_23079_1,
datac => N_27144_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(206));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_8_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f0000000000")
port map (
combout => N_27050,
dataf => N_27050_1,
datae => N_23117_1,
datad => N_22496_2,
datac => N_23342);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_13_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_28252,
dataf => N_22426_1,
datae => N_23791_1,
datad => N_23165_1,
datac => N_23622_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"11f100f011110000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_14\,
dataf => N_27342_2,
datae => N_28293_2,
datad => N_22756_1,
datac => N_22804_1,
datab => N_22612_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff30000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_4\,
dataf => N_27925,
datae => N_22426_1,
datad => N_22745_1,
datac => N_22756_1,
datab => N_22804_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000f0022002f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_2\,
dataf => N_23982,
datae => N_27096,
datad => N_27317,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_1_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000003000000")
port map (
combout => N_27268,
dataf => N_23791_1,
datae => N_23079_1,
datad => N_23622_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_42955,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_4_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000004440000")
port map (
combout => N_27397,
dataf => N_22426_1,
datae => N_27397_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(214));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_3_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c3000000000000")
port map (
combout => N_27337,
dataf => N_27547_1,
datae => N_27209_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_40_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_27485,
dataf => N_27792,
datae => N_22745_1,
datad => N_22681_1,
datac => N_26773_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10048\,
datae => N_22599_1,
datad => N_27547_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => N_22608_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0c00000000aa00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_7\,
dataf => N_27721,
datae => N_27131_1,
datad => N_28194_1,
datac => N_22589_1,
datab => N_27762_1,
dataa => N_27482_1);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42970,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
GRLFPC20_COMB_UN1_FPCI_2_RNI1EVL1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000004ffffffff")
port map (
combout => \GRLFPC20.COMB.ANNULRES_1_IV_7636_0\,
dataf => \GRLFPC20.UN1_FPCI_5\,
datae => \GRLFPC20.R.X.FPOP\,
datad => \GRLFPC20.R.I.EXEC\,
datac => \GRLFPC20.R.M.FPOP\,
datab => \GRLFPC20.R.E.FPOP\,
dataa => \GRLFPC20.N_1804\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_24_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(207));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42887,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_28_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_27912,
dataf => N_28154_1,
datae => N_22681_1,
datad => N_27731_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"5050dc500000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_11\,
dataf => N_23791_1,
datae => N_28312,
datad => N_22588_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658_2\,
datab => N_28050_1,
dataa => N_26909_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f00000e0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_4\,
dataf => N_22673_1,
datae => N_27209_1,
datad => N_26981_1,
datac => N_26971_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42825,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(202));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_0_A29_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aa00080000000000")
port map (
combout => N_28046,
dataf => N_26972_1,
datae => N_26822_1,
datad => N_26981_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(208));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_9_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_26810,
dataf => N_23791_1,
datae => N_23715_1,
datad => N_22588_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00df00ffdfdfffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_11_1\(5),
datae => N_22745_1,
datad => N_26815_1,
datac => N_27209_1,
datab => N_28095,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"b000b00000008000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G4\,
dataf => N_22673_1,
datae => N_27721,
datad => N_28336_1,
datac => N_26747_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eaaac000c000c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_2\,
dataf => N_22681_1,
datae => N_22744_1,
datad => N_23003_1,
datac => N_26808_1,
datab => N_22608_2,
dataa => N_22651_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(201));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0110040800000000")
port map (
combout => N_26739,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.UN3_S_SQRT_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42961,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"a0000000a0202020")
port map (
combout => N_28287,
dataf => N_28219,
datae => N_28336_1,
datad => N_26971_1,
datac => N_26764_1,
datab => N_28273,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_0_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0300000f0000000")
port map (
combout => N_26909,
dataf => N_22496_2,
datae => N_27131_1,
datad => N_22589_1,
datac => N_26909_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_RESULT_IV_0_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0555555535555555")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT_IV_0\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(59));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(203));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_0_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f444000000000000")
port map (
combout => N_26740,
dataf => N_22425_1,
datae => N_23715_1,
datad => N_26971_1,
datac => N_26764_1,
datab => N_22588_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A27_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0002222200000000")
port map (
combout => N_27266,
dataf => N_28154_1,
datae => N_27793_I,
datad => N_27257_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_5_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00000000000")
port map (
combout => N_27339,
dataf => N_22496_2,
datae => N_22744_1,
datad => N_27286_1,
datac => N_22947_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0505000001000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G4\,
dataf => N_22759_1,
datae => N_26722_I,
datad => N_23715_1,
datac => N_27811,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_15_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00000000000")
port map (
combout => N_28411,
dataf => N_22426_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datad => N_27286_1,
datac => N_23622_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_0_A15_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"030303b000000000")
port map (
combout => N_26908,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_0_A15_0\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A29_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4040444000004400")
port map (
combout => N_27041,
dataf => N_27081_1,
datae => N_27096,
datad => N_23003_1,
datac => N_27762_1,
datab => N_22429_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_22_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(209));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42962,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff8000008080")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A2_0\(3),
datae => N_28219,
datad => N_28154_1,
datac => N_27547_1,
datab => N_27131_1,
dataa => N_22589_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00008888f000f888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_0\,
dataf => N_27096,
datae => N_27524,
datad => N_26747_1,
datac => N_23026_1,
datab => N_28065_1,
dataa => N_27095_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_25_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00c00000000000")
port map (
combout => N_27470,
dataf => N_27050_1,
datae => N_22600_1,
datad => N_23024_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f03ff0ffff3fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_1\,
dataf => N_23117_1,
datae => N_22530_1,
datad => N_28273,
datac => N_28095,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eca0cc00a0a00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_4_1\,
dataf => N_27523,
datae => N_22599_1,
datad => N_22745_1,
datac => N_26932_1,
datab => N_27469_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_4_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00000000000")
port map (
combout => N_27338,
dataf => N_22745_1,
datae => N_22496_2,
datad => N_27144_1,
datac => N_27338_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_1_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f300f000")
port map (
combout => N_28289,
dataf => N_28219,
datae => N_26722_I,
datad => N_26747_1,
datac => N_28048_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_1_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fff000000000")
port map (
combout => N_27747,
dataf => N_27747_1,
datae => N_27792,
datad => N_26972_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_30_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff000ff00000000")
port map (
combout => N_27475,
dataf => N_26910_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff70ff0070700000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datae => N_27626_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10217\,
datac => N_22756_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_11_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fff000000000000")
port map (
combout => N_27404,
dataf => N_23791_1,
datae => N_23117_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_9_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f300000000000000")
port map (
combout => N_27135,
dataf => N_27721,
datae => N_28292_1,
datad => N_23976,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"7f7fffff087f88ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_4\,
dataf => N_27721,
datae => N_22958_1,
datad => N_27208_1,
datac => N_27286_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_7_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4400440044004000")
port map (
combout => N_27049,
dataf => N_22599_1,
datae => N_23791_1,
datad => N_23117_1,
datac => N_26813_1,
datab => N_27762_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_6_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_27691,
dataf => N_22589_1,
datae => N_28292_1,
datad => N_27448_I,
datac => N_22947_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_4\,
dataf => N_27997,
datae => N_23791_1,
datad => N_23117_1,
datac => N_27794,
datab => N_27096);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eac0c0c0aa000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_10_1\(19),
datae => N_27763_1,
datad => N_22673_1,
datac => N_27721,
datab => N_26972_1,
dataa => N_26808_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0c000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_3\,
dataf => N_26817,
datae => N_22756_1,
datad => N_26747_1,
datac => N_27397_1,
datab => N_22486_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_3_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0000300")
port map (
combout => N_27205,
dataf => N_27721,
datae => N_22426_1,
datad => N_27131_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(200));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(184));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_41_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(190));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000f0000000")
port map (
combout => N_36514,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datad => N_27547_1,
datac => N_27731_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(178));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(205));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_242_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_7790_I_0\,
dataf => \GRLFPC20.FPI.OP2\(54),
datae => \GRLFPC20.FPI.OP2\(57),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_1_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000005040500")
port map (
combout => N_23284,
dataf => N_27020,
datae => N_22681_1,
datad => N_27209_1,
datac => N_28312,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(195));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(186));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000202000000020")
port map (
combout => N_28395,
dataf => N_28438,
datae => N_27792,
datad => N_27794,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(188));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A2_4_RNIC4IM1_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff080008000800")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2_1_0\,
dataf => N_27626_2,
datae => N_27910_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10298\,
datac => N_23003_1,
datab => N_22429_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(181));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f1f0f0f011000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_7\,
dataf => N_27288_2,
datae => N_27247,
datad => N_22673_1,
datac => N_22759_1,
datab => N_27177,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_R_E_STDATA_RNO_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"e400e4ffe400e400")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_21__G1\,
dataf => \GRLFPC20.FPI.OP1\(53),
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.A.AFQ\,
datac => \GRLFPC20.R.I.PC\(21),
datab => \GRLFPC20.R.I.INST\(21),
dataa => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(196));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN50_ZERO_RNI2LVM1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33cc0ff000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7222\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7244\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(180));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_77_I\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\(57),
datad => N_43547,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(187));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(177));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_37_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(194));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(182));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffefffafefefafa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_2__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10303\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10203\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10088\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10298\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10048\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0008")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_5\,
dataf => N_23968,
datae => N_27997,
datad => N_27792,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datab => N_27762_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_R_E_STDATA_RNO_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"e400e4ffe400e400")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_20__G1\,
dataf => \GRLFPC20.FPI.OP1\(52),
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.A.AFQ\,
datac => \GRLFPC20.R.I.PC\(20),
datab => \GRLFPC20.R.I.INST\(20),
dataa => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_238_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_7918_I_0\,
dataf => \GRLFPC20.FPI.OP2\(58),
datae => \GRLFPC20.FPI.OP2\(61),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(193));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff54ff4450500000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_2\,
dataf => N_27626_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10381\,
datac => N_22599_1,
datab => N_26993_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_240_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_7_7854_I_0\,
dataf => \GRLFPC20.FPI.OP2\(56),
datae => \GRLFPC20.FPI.OP2\(59),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(198));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f888f00088880000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11910_2\,
datae => N_27491_2,
datad => N_28342_1,
datac => N_22759_1,
datab => N_27469_1,
dataa => N_22795_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_46_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(185));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff3f033003300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datae => N_26868_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10353\,
datac => N_22686_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_R_E_STDATA_RNO_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"d800d8ffd800d800")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_19__G1\,
dataf => \GRLFPC20.FPI.OP1\(51),
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.A.AFQ\,
datac => \GRLFPC20.R.I.INST\(19),
datab => \GRLFPC20.R.I.PC\(19),
dataa => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_I_EXC_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000030aaaaaaaa")
port map (
combout => \GRLFPC20.N_2683\,
dataf => \GRLFPC20.N_2405_3\,
datae => \GRLFPC20.N_1452\,
datad => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
dataa => \GRLFPC20.R.I.EXC\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_244_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_11_7726_I_0\,
dataf => \GRLFPC20.FPI.OP2\(52),
datae => \GRLFPC20.FPI.OP2\(55),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(199));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_239_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_6_7886_I_0\,
dataf => \GRLFPC20.FPI.OP2\(57),
datae => \GRLFPC20.FPI.OP2\(60),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffeaffc0eaeac0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10203\,
datac => N_27696_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10218\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10241\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_O12_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff8f8f8ff888888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10203\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10173\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10197\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(175));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_40_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(191));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_O12_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff20ff0020200000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datad => N_26994_2,
datac => N_28312,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(197));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(179));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(189));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(192));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_243_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_10_7758_I_0\,
dataf => \GRLFPC20.FPI.OP2\(53),
datae => \GRLFPC20.FPI.OP2\(56),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0aaaaccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(204));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccaaaaf0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(183));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_241_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffee0feef0ee00ee")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_8_7822_I_0\,
dataf => \GRLFPC20.FPI.OP2\(55),
datae => \GRLFPC20.FPI.OP2\(58),
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7));
\GRLFPC20_R_A_RS1_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bb33bbf3880088c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(4),
dataf => \GRLFPC20.R.A.RS1\(4),
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.N_2173\,
datac => N_76,
datab => N_7,
dataa => N_65);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff8fff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(44),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10271\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10207\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10206\,
datab => N_22958_1,
dataa => N_27731_I);
\GRLFPC20_R_A_RS1_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bb33bbf3880088c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(3),
dataf => \GRLFPC20.R.A.RS1\(3),
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.N_2173\,
datac => N_75,
datab => N_7,
dataa => N_64);
\GRLFPC20_COMB_RS1_1_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bb33bbf3880088c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(1),
dataf => \GRLFPC20.R.A.RS1\(1),
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.N_2173\,
datac => N_73,
datab => N_7,
dataa => N_62);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_8: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"808020204f40101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"808020204f40101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_10: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"808020204f40101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75));
\GRLFPC20_COMB_RS1_1_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bb33bbf3880088c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(2),
dataf => \GRLFPC20.R.A.RS1\(2),
datae => \GRLFPC20.N_3741\,
datad => \GRLFPC20.N_2173\,
datac => N_74,
datab => N_7,
dataa => N_63);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_6: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fdf7df2aa8f7df7f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11185\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11199\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11198\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_18: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8f8040402020101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_24: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8f8020204040101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_24\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000030aa30aa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_43646,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_12: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c00030000caa0355")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f1f4f5fafbfeff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f1f4f5fafbfeff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(40),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f4f6f9fbfdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(29),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f9fbf4f6fdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f9fbf4f6fdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f9f2fbf4fdf6ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
GRLFPC20_COMB_RS2D_1_IV: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f000e000e000e0")
port map (
combout => \GRLFPC20.COMB.RS2D_1\,
dataf => \GRLFPC20.R.A.RS1D_0_0_G4\,
datae => \GRLFPC20.N_952\,
datad => N_77,
datac => N_78,
datab => \GRLFPC20.UN1_MOV_1_SQMUXA_0\,
dataa => \GRLFPC20.N_951\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaaaf0f0ccccff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10044\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2_1_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10139\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fff0ff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(48),
dataf => N_43598,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3932\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
GRLFPC20_COMB_WREN129: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0503000000000000")
port map (
combout => \GRLFPC20.N_1693\,
dataf => \GRLFPC20.N_1660\,
datae => \GRLFPC20.N_2370\,
datad => \GRLFPC20.COMB.UN1_R.I.V\,
datac => \GRLFPC20.R.X.LD\,
datab => \GRLFPC20.R.I.INST\(19),
dataa => N_342);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_83_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffc0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M_0\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4044\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4644\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_6\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4008\);
\GRLFPC20_COMB_RF1REN_1_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"2f200f002f202f20")
port map (
combout => \GRLFPC20.N_3661\,
dataf => \GRLFPC20.COMB.RS2_1\(0),
datae => \GRLFPC20.COMB.RS2D_1\,
datad => \GRLFPC20.R.A.RF1REN\(2),
datac => N_7,
datab => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
dataa => \GRLFPC20.N_2173\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI86J79_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff001212ff003030")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4697\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629_0\,
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(20));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN50_ZERO_RNIM0PU51_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c33c3cc33cc3c33c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_32\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7133\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7222\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_247_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00000f000f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(247),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11427\,
datad => \GRLFPC20.FPI.OP1\(62),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_248_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(248),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11412\,
datad => \GRLFPC20.FPO.EXP\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(248),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_249_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(249),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11411\,
datad => \GRLFPC20.FPO.EXP\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(249),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_250_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(250),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11410\,
datad => \GRLFPC20.FPO.EXP\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(250),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_251_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(251),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11409\,
datad => \GRLFPC20.FPO.EXP\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(251),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_252_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(252),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11408\,
datad => \GRLFPC20.FPO.EXP\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(252),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_253_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(253),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11407\,
datad => \GRLFPC20.FPO.EXP\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(253),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_254_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(254),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11406\,
datad => \GRLFPC20.FPO.EXP\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(254),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_255_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(255),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11405\,
datad => \GRLFPC20.FPO.EXP\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(255),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_256_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(256),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_84\,
datad => \GRLFPC20.FPO.EXP\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(256),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_257_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(257),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11403\,
datad => \GRLFPC20.FPO.EXP\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(257),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_246_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffccf0f03300f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(246),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11414\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11399\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_R_E_STDATA_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00ffff0f000000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_0__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_0__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(0),
datac => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00ffff0f000000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_1__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_1__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(1),
datac => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(5),
dataf => \GRLFPC20.N_3397\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(5),
datac => \GRLFPC20.R.I.INST\(5),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(6),
dataf => \GRLFPC20.N_3398\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(6),
datac => \GRLFPC20.R.I.INST\(6),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(7),
dataf => \GRLFPC20.N_3399\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(7),
datac => \GRLFPC20.R.I.INST\(7),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(11),
dataf => \GRLFPC20.N_3403\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(11),
datac => \GRLFPC20.R.I.INST\(11),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_12__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_12__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(12),
datac => \GRLFPC20.R.I.INST\(12),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(16),
dataf => \GRLFPC20.N_3408\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(16),
datac => \GRLFPC20.R.I.INST\(16),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_17__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_17__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(17),
datac => \GRLFPC20.R.I.INST\(17),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_18__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_18__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(18),
datac => \GRLFPC20.R.I.INST\(18),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(23),
dataf => \GRLFPC20.N_3415\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(23),
datac => \GRLFPC20.R.I.INST\(23),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(27),
dataf => \GRLFPC20.N_3419\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(27),
datac => \GRLFPC20.R.I.INST\(27),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_28__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_28__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(28),
datac => \GRLFPC20.R.I.INST\(28),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_29__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_29__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(29),
datac => \GRLFPC20.R.I.INST\(29),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc30fffffc300000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(31),
dataf => \GRLFPC20.N_3423\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.PC\(31),
datac => \GRLFPC20.R.I.INST\(31),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSAMPLEDWAIT_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000ff0000000000")
port map (
combout => N_27392,
dataf => N_23117_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000fcff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_8\,
dataf => N_27411,
datae => N_27393,
datad => N_23117_1,
datac => N_27383,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_7_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff0c")
port map (
combout => N_27400,
dataf => N_27020,
datae => N_28312,
datad => N_28048_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000fcffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_7\,
dataf => N_27400,
datae => N_22958_1,
datad => N_27050_1,
datac => N_27020,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_5_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000c000")
port map (
combout => N_27398,
dataf => N_27377,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff3f00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_7\,
datae => N_27398,
datad => N_27020,
datac => N_22496_2,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_23_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => N_27416,
dataf => N_27792,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datad => N_23850_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_9_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0ff00000000")
port map (
combout => N_27402,
dataf => N_23165_1,
datae => N_27096,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_15_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27408,
dataf => N_22958_1,
datae => N_28242_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_I_0_A27_1_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff0f0000")
port map (
combout => N_27394,
dataf => N_28312,
datae => N_23715_1,
datad => N_22608_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"1000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_20\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_22\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_8\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_31__G2_17\,
datab => N_27406,
dataa => N_27397);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_5_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => N_23364,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_23079_1,
datad => N_23342,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_1_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000c3000000")
port map (
combout => N_23360,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_23785_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_10_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_23369,
dataf => N_26813_1,
datae => N_23003_1,
datad => N_23079_1,
datac => N_22608_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_4\,
dataf => N_23369,
datae => N_23360,
datad => N_23364,
datac => N_23361);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_7_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"300c000000000000")
port map (
combout => N_23366,
dataf => N_27068_1,
datae => N_28408_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_3_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c0000000000000")
port map (
combout => N_23362,
dataf => N_23344,
datae => N_23362_1,
datad => N_23342,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00c00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_0\,
dataf => N_23362,
datae => N_22589_1,
datad => N_23003_1,
datac => N_23079_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_0\,
datae => N_28242_1,
datad => N_26822_1,
datac => N_26975_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffcc00c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_3\,
datae => N_27478_1,
datad => N_28154_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_6_TZ\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff40")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_7\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_4\,
datad => N_23366,
datac => N_23715_1,
datab => N_23353,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0000000fc00cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_1\,
dataf => N_27020,
datae => N_27096,
datad => N_27149_1,
datac => N_26978_1,
datab => N_22795_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_6_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000300000000000")
port map (
combout => N_26976,
dataf => N_27020,
datae => N_22759_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datac => N_28065_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_9\,
dataf => N_26976,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_2_0\(62),
datad => N_22958_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0300030c000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_0\,
dataf => N_22600_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_1_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0303000003000000")
port map (
combout => N_26971,
dataf => N_22599_1,
datae => N_26971_1,
datad => N_27396_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fc0000000000000")
port map (
combout => N_26969,
dataf => N_26815_1,
datae => N_26969_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_11_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_26981,
dataf => N_26822_1,
datae => N_26981_1,
datad => N_22795_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_9_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => N_26979,
dataf => N_22958_1,
datae => N_22599_1,
datad => N_26932_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0030")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_2\,
datae => N_26979,
datad => N_28219,
datac => N_22589_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_5_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff3000000000000")
port map (
combout => N_26975,
dataf => N_22425_1,
datae => N_26975_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00c00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_11\,
dataf => N_26975,
datae => N_22426_1,
datad => N_28048_1,
datac => N_28006,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_21\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_18\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_11\,
datad => N_26994_2,
datac => N_22759_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_19\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_21\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_15\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_9\,
datab => N_27561,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_7_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => N_27753,
dataf => N_28219,
datae => N_27272_1,
datad => N_27731_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_0_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f300000")
port map (
combout => N_27746,
dataf => N_27177,
datae => N_26986_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff30ffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_7_TZ\,
datae => N_27753,
datad => N_27746,
datac => N_27792,
datab => N_26822_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_4_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000300000000")
port map (
combout => N_27750,
dataf => N_26972_1,
datae => N_22744_1,
datad => N_26975_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_6_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300030003000000")
port map (
combout => N_27752,
dataf => N_23785_1,
datae => N_26808_1,
datad => N_27397_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_0\,
dataf => N_27752,
datae => N_23715_1,
datad => N_27272_1,
datac => N_26978_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A21_13_0_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A21_13_0\(59),
dataf => N_23362_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00030000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_5\,
dataf => N_27755,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A21_13_0\(59),
datad => N_27792,
datac => N_26972_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_11\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_0\,
datad => N_27750,
datac => N_27287,
datab => N_26817);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_15\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_13\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_10\,
datab => N_27053_2,
dataa => N_27762_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_10_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_27052,
dataf => N_28154_1,
datae => N_26813_1,
datad => N_22651_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0f0f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_5\,
dataf => N_27020,
datae => N_26972_1,
datad => N_22612_1,
datac => N_23026_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_9\,
dataf => N_27924,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_5\,
datad => N_28154_1,
datac => N_22681_1,
datab => N_22651_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_6_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00cf000000000000")
port map (
combout => N_27048,
dataf => N_23003_1,
datae => N_28292_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_2_0_0_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0_0\(58),
dataf => N_28219,
datae => N_22804_1,
datad => N_23079_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffff0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_8\,
dataf => N_27062,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0_0\(58),
datad => N_27048,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_2_0\(58));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_20\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_8\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_9\,
datad => N_27049,
datac => N_27050,
datab => N_36665,
dataa => N_27052);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_19_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_27061,
dataf => N_22496_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff000c0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_0\,
dataf => N_27061,
datae => N_22681_1,
datad => N_23346,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff30ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_0\,
datae => N_27046_1,
datad => N_27218,
datac => N_22673_1,
datab => N_27793_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0c0c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_59__G2_14\,
datae => N_27978_2,
datad => N_22681_1,
datac => N_26822_1,
datab => N_26722_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_3\,
dataf => N_27840,
datae => N_27020,
datad => N_22425_1,
datac => N_27794);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_17_0_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_17_0\(57),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_8_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => N_27835,
dataf => N_28242_1,
datae => N_26971_1,
datad => N_27731_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_4_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_27831,
dataf => N_27811,
datae => N_26978_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_1\,
dataf => N_27831,
datae => N_26971_1,
datad => N_26969_1,
datac => N_27799_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_1\,
datae => N_27835,
datad => N_28242_1,
datac => N_23165_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_17_0\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_8\,
dataf => N_27838,
datae => N_28242_1,
datad => N_26822_1,
datac => N_26975_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_9_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0000f0000000000")
port map (
combout => N_27836,
dataf => N_22673_1,
datae => N_26822_1,
datad => N_28062_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_7_0_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff000f0f00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_7_0\(57),
dataf => N_27396_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0cff000c0c0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_7_0\(57),
datae => N_22425_1,
datad => N_26972_1,
datac => N_27793_I,
datab => N_26978_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_6\,
dataf => N_27914,
datae => N_26813_1,
datad => N_28242_1,
datac => N_27794,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_19_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000c30000")
port map (
combout => N_27846,
dataf => N_27811,
datae => N_26993_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_10_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f30000000c000000")
port map (
combout => N_27837,
dataf => N_23165_1,
datae => N_28242_1,
datad => N_26808_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0000c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_4\,
dataf => N_27837,
datae => N_22424_2,
datad => N_28194_1,
datac => N_23003_1,
datab => N_27482_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_4\,
datae => N_27846,
datad => N_27826,
datac => N_27830);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_21\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_17\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_13\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_16_TZ\,
datac => N_27050_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_21\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_11\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_19\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_10\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_58__G2_8\,
dataa => N_27829);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_19_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_19_1\(56),
dataf => N_28154_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_10_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_27136,
dataf => N_23117_1,
datae => N_28065_1,
datad => N_27104_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_2_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_1\(56),
dataf => N_23117_1,
datae => N_23344);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_2_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_0\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffec")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_22\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_20\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_1\(56),
datab => N_27136,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_2_0\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_23_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_23_1\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_23117_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_5_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc000c0c00000000")
port map (
combout => N_27131,
dataf => N_27131_1,
datae => N_27397_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_7_1_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f3300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_7_1\(56),
dataf => N_26971_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => N_27126,
dataf => N_22673_1,
datae => N_27186,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_1\,
dataf => N_27126,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_7_1\(56),
datad => N_27096);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff30ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_23_1\(56),
datad => N_27131,
datac => N_27149_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_I_A27_8_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_8_0\(56),
dataf => N_28312,
datae => N_27397_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff0cff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_18\,
datae => N_27763_1,
datad => N_27135,
datac => N_27208_1,
datab => N_28065_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_22\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_17\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_12\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_57__G2_0\,
datab => N_27107,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_0_I_A27_8_0\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_33_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f0000000000")
port map (
combout => N_27917,
dataf => N_28154_1,
datae => N_27068_1,
datad => N_22804_1,
datac => N_27882);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_3\,
dataf => N_27917,
datae => N_27792,
datad => N_27547_1,
datac => N_26813_1,
datab => N_22486_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_45_0_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_45_0\(55),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_24_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000f33")
port map (
combout => N_27908,
dataf => N_27792,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_11\,
dataf => N_27908,
datae => N_27912,
datad => N_22588_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_45_0\(55),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_39_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => N_27923,
dataf => N_27792,
datae => N_27762_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_31_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c3000000000000")
port map (
combout => N_27915,
dataf => N_26813_1,
datae => N_22424_2,
datad => N_23342,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_38_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27922,
dataf => N_28194_1,
datae => N_26981_1,
datad => N_27396_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_27_1_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fcc000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_27_1\(55),
dataf => N_27396_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_26_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0000000000000")
port map (
combout => N_27910,
dataf => N_27910_2,
datae => N_23165_1,
datad => N_27882,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_35_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000f00")
port map (
combout => N_27919,
dataf => N_28219,
datae => N_27547_1,
datad => N_26981_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_36_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000c0000")
port map (
combout => N_27920,
dataf => N_27792,
datae => N_27068_1,
datad => N_27547_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00f30000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_7\,
dataf => N_27920,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_0_A15_0\(4),
datad => N_27792,
datac => N_27397_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_7\,
datae => N_27925,
datad => N_27916_2,
datac => N_23715_1,
datab => N_22588_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_30_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c3000000000000")
port map (
combout => N_27914,
dataf => N_28194_1,
datae => N_22588_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_5\,
dataf => N_27914,
datae => N_28219,
datad => N_27397_1,
datac => N_27882,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_18\,
dataf => N_27913,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_5\,
datad => N_27902,
datac => N_22745_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_20\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_19\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_56__G2_18\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_21_1_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_21_1\(54),
dataf => N_22681_1,
datae => N_26822_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_13_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fc0000000000")
port map (
combout => N_26814,
dataf => N_22496_2,
datae => N_28312,
datad => N_22486_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_16_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_26817,
dataf => N_22588_1,
datae => N_26726_I,
datad => N_26909_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_4_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"003c000000000000")
port map (
combout => N_26805,
dataf => N_26981_1,
datae => N_22427_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_17_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => N_26818,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datae => N_27882,
datad => N_26726_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_7_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f0000000000")
port map (
combout => N_26808,
dataf => N_26981_1,
datae => N_23715_1,
datad => N_26808_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_22_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_26823,
dataf => N_26981_1,
datae => N_26747_1,
datad => N_27397_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_3_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c300000000000000")
port map (
combout => N_26804,
dataf => N_28154_1,
datae => N_26773_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_2_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccc0000000000000")
port map (
combout => N_26803,
dataf => N_28154_1,
datae => N_26932_1,
datad => N_22496_2,
datac => N_22612_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_14\,
dataf => N_26803,
datae => N_26808,
datad => N_26823,
datac => N_26804,
datab => N_26818);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_14_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_26815,
dataf => N_26815_1,
datae => N_22756_1,
datad => N_22486_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A26_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_26800,
dataf => N_27721,
datae => N_26932_1,
datad => N_23785_1,
datac => N_27397_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_15_1_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_15_1\(54),
dataf => N_26932_1,
datae => N_26726_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff00ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_18_0\,
dataf => N_28154_1,
datae => N_26829,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_5_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0000000000000")
port map (
combout => N_26806,
dataf => N_22496_2,
datae => N_28050_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_1_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0000000f000f000")
port map (
combout => N_26802,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_22496_2,
datad => N_22486_1,
datac => N_26829);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff0cff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_16\,
dataf => N_26802,
datae => N_26788,
datad => N_26806,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datab => N_26801_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_15\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_13\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_16\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_17\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_55__G2_12\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_10_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27212,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_10_1\(53),
datae => N_28065_1,
datad => N_26801_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_12_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => N_27214,
dataf => N_22426_1,
datae => N_27177,
datad => N_26969_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A20_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c0f00000000000")
port map (
combout => N_27201,
dataf => N_22958_1,
datae => N_28242_1,
datad => N_22612_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_6_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27208,
dataf => N_27916_2,
datae => N_27187,
datad => N_27208_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_5_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00003f0000000000")
port map (
combout => N_27207,
dataf => N_26981_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datad => N_23079_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_1_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f000f000f00000")
port map (
combout => N_27203,
dataf => N_28242_1,
datae => N_23165_1,
datad => N_27524,
datac => N_22818_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00c00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_54__G2_0\,
dataf => N_27203,
datae => N_23785_1,
datad => N_27177,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_14_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27281,
dataf => N_28154_1,
datae => N_26972_1,
datad => N_23715_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_9\,
dataf => N_27281,
datae => N_27271,
datad => N_22673_1,
datac => N_26972_1,
datab => N_27177);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_11_1_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000ff000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_11_1\(52),
dataf => N_27068_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_7_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f000")
port map (
combout => N_27274,
dataf => N_27068_1,
datae => N_27177,
datad => N_26969_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_7\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10197\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_0_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => N_27267,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_27258,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_6\,
dataf => N_27267,
datae => N_22673_1,
datad => N_27209_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datab => N_27272_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_13_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000f00")
port map (
combout => N_27280,
dataf => N_27050_1,
datae => N_27794,
datad => N_23715_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00c00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_3\,
dataf => N_27280,
datae => N_28154_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\,
datac => N_23622_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_12_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000003c00000000")
port map (
combout => N_27279,
dataf => N_26815_1,
datae => N_23342,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_0\,
dataf => N_27279,
datae => N_26972_1,
datad => N_22756_1,
datac => N_27177,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_20_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300000000000000")
port map (
combout => N_27287,
dataf => N_27050_1,
datae => N_26815_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff000c0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_3_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9251\,
datae => N_27547_1,
datad => N_27177,
datac => N_28312,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_50__G2_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datab => N_26948_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_12_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f0000000000")
port map (
combout => N_27990,
dataf => N_22426_1,
datae => N_26722_I,
datad => N_28006,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_7\,
dataf => N_28413_1,
datae => N_27987,
datad => N_27990,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_6_0\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_15_0_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_15_0\(48),
dataf => N_26972_1,
datae => N_23346);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_8_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => N_27986,
dataf => N_27721,
datae => N_27792,
datad => N_22426_1,
datac => N_26813_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_19_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_27997,
dataf => N_27762_1,
datae => N_22818_1,
datad => N_28006,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_2_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c300000033000000")
port map (
combout => N_27980,
dataf => N_27721,
datae => N_26972_1,
datad => N_26993_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffcfcfc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_16\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datac => N_27980,
datab => N_27994);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000fc000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G4\,
dataf => N_27347_1,
datae => N_27792,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_1_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000300000")
port map (
combout => N_27979,
dataf => N_22599_1,
datae => N_26972_1,
datad => N_23026_1,
datac => N_26986_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0300000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_4\,
datae => N_27978_2,
datad => N_22804_1,
datac => N_22744_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_49_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_18\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_16\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_13\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_7\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_49__G2_8\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffc0c0c0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2_0\,
dataf => N_27626_2,
datae => N_23282_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10161\,
datac => N_22756_1,
datab => N_28098_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffc0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2_0\,
datad => N_27288,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_43_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2_0\,
datac => N_27288);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_42_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffcf0cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10244\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10196\,
datab => N_27144_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_40_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_40__G2_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9208\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9847\,
datad => N_27291_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10230\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00030000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9847\,
datae => N_22599_1,
datad => N_27020,
datac => N_27317,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_0_0_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff0000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0_0\(38),
dataf => N_28312,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_39_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9844\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10184\,
datae => N_26948_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffc0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9186\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9855\,
datac => N_26948_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_38__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_39__G2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9854\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9847\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10230\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c00000000000000")
port map (
combout => N_28332,
dataf => N_28322,
datae => N_27286_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_16_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_28349,
dataf => N_28292_1,
datae => N_26986_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_12_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c00000000000000")
port map (
combout => N_28345,
dataf => N_26722_I,
datae => N_27208_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_6\,
dataf => N_28345,
datae => N_28349,
datad => N_27811,
datac => N_26993_1,
datab => N_27469_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_7_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f300000000000000")
port map (
combout => N_28340,
dataf => N_23003_1,
datae => N_27469_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_0\,
dataf => N_28340,
datae => N_28336_1,
datad => N_22530_1,
datac => N_26986_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_0\,
datae => N_23785_1,
datad => N_26722_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_0_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fc000000f000")
port map (
combout => N_28333,
dataf => N_23785_1,
datae => N_23346,
datad => N_22530_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_2_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc0f000000000000")
port map (
combout => N_28335,
dataf => N_22681_1,
datae => N_23026_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_1_0_0_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_1_0\(36),
dataf => N_27547_1,
datae => N_23715_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0c00000c0c0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_4\,
dataf => N_28342_1,
datae => N_22673_1,
datad => N_22681_1,
datac => N_28312,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_15_0\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_5_1_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_5_1\(36),
dataf => N_27208_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_4_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3f0000000c000000")
port map (
combout => N_28337,
dataf => N_27050_1,
datae => N_28154_1,
datad => N_22496_2,
datac => N_27469_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff30000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_3\,
dataf => N_28337,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_5_1\(36),
datad => N_23003_1,
datac => N_27882,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_36_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_13\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_15\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\,
datac => N_28332,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_36__G2_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_35_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0030000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9869\,
dataf => N_27050_1,
datae => N_23165_1,
datad => N_28033_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_0_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0\(33),
dataf => N_26972_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_1\,
dataf => N_28056,
datae => N_28219,
datad => N_27547_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\,
datae => N_28194_1,
datad => N_28408_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_1\,
datad => N_28336_1,
datac => N_22424_2,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_0_0\,
dataf => N_28065,
datae => N_27794,
datad => N_26993_1,
datac => N_27469_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_3_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00f00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9889\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffcf0cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_33__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9889\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datad => N_27989_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10217\,
datab => N_22530_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_2_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datae => N_28312,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_2_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c3000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9940\,
dataf => N_22820_2,
datae => N_28336_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\,
dataf => N_22820_2,
datae => N_27050_1,
datad => N_23026_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_1_0_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\(30),
dataf => N_27046_1,
datae => N_23715_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_RNIGU961_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9940\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\,
datac => N_27989_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_0_RNIH5HP3_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffc0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9938\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2_3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10220\,
datab => N_27046_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A7_2_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_23323,
dataf => N_26820_1,
datae => N_23311,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A7_RNIES0V1_29_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffcfff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9938\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10220\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2_1\,
datac => N_23320,
datab => N_27046_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_6_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0003000000000000")
port map (
combout => N_23289,
dataf => N_23791_1,
datae => N_27209_1,
datad => N_27524,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00003000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_1\,
dataf => N_23289,
datae => N_27721,
datad => N_27272_1,
datac => N_23274,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_4_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0003000000000000")
port map (
combout => N_23287,
dataf => N_22486_1,
datae => N_27272_1,
datad => N_27257_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0000c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_0\,
dataf => N_23287,
datae => N_23791_1,
datad => N_26722_I,
datac => N_27762_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_3_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300300000000000")
port map (
combout => N_23286,
dataf => N_22496_2,
datae => N_28312,
datad => N_22486_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_2\,
dataf => N_23284,
datae => N_23286);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9822\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_28__G2_0\,
datab => N_23282_1,
dataa => N_23276);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_33_0_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A26_33_0\(27),
dataf => N_27448_I,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_41_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000000000")
port map (
combout => N_27486,
dataf => N_23362_1,
datae => N_23024_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_24_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f000000000000")
port map (
combout => N_27469,
dataf => N_27469_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_43_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27488,
dataf => N_27516,
datae => N_28065_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_44_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => N_27489,
dataf => N_27547_1,
datae => N_26975_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_27_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fcc000000000000")
port map (
combout => N_27472,
dataf => N_26972_1,
datae => N_27131_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_11\,
datae => N_27488,
datad => N_27485,
datac => N_27472,
datab => N_27489);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_31_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0cc00000000")
port map (
combout => N_27476,
dataf => N_22589_1,
datae => N_27811,
datad => N_23346,
datac => N_23024_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0c000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_9_0\,
dataf => N_27476,
datae => N_22425_1,
datad => N_22681_1,
datac => N_26986_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_27_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_20\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_8\,
datad => N_27475,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_9_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_27__G2_9\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_6_0_28_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_6_0\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_12640_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_26_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff303030ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_26__G2_1\,
dataf => N_26910_3,
datae => N_27696_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10385\,
datac => N_26773_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00003000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10135\,
datae => N_22958_1,
datad => N_28336_1,
datac => N_22424_2,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_2_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\,
dataf => N_27020,
datae => N_23791_1,
datad => N_27317,
datac => N_28098_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0c000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\,
datae => N_27050_1,
datad => N_28336_1,
datac => N_26722_I,
datab => N_23079_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_25_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9434\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_25__G2_6_0\,
datac => N_36514,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9987\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_2_0_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_2_0\(23),
dataf => N_23117_1,
datae => N_27209_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_23_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffff000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_22__G2_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_23__G2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_21_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffcf0cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10220\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10157\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10379\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0f0fff0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10180\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G4\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_1_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0c0000000000000")
port map (
combout => N_26867,
dataf => N_26932_1,
datae => N_22818_1,
datad => N_27149_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_6\,
dataf => N_27561,
datae => N_26867,
datad => N_27792,
datac => N_26861,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_3_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_26869,
dataf => N_22425_1,
datae => N_22745_1,
datad => N_26815_1,
datac => N_27257_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_1_1\,
dataf => N_26869,
datae => N_27721,
datad => N_26815_1,
datac => N_22818_1,
datab => N_28062_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\,
datac => N_26868,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_18__G2_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_1_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10041\,
dataf => N_22599_1,
datae => N_27317,
datad => N_27731_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10040\,
dataf => N_27491_2,
datae => N_22608_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff03ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10040\,
datae => N_27291_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10041\,
datac => N_27020,
datab => N_27317);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_0_1_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0\(17),
dataf => N_23003_1,
datae => N_22588_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffc000c000c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10203\,
datae => N_27989_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_0\(17),
datac => N_27068_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_2_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10042\,
dataf => N_22889_1,
datae => N_22599_1,
datad => N_28194_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_17__G2_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9385\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10185\,
datad => N_23165_1,
datac => N_27524);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_16_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_16__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10230\,
datae => N_22958_1,
datad => N_22599_1,
datac => N_22744_1,
datab => N_22651_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_2\,
dataf => N_22889_1,
datae => N_27626_2,
datad => N_27910_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10385\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10044\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcfcfcfff0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2\,
dataf => N_27981_3,
datae => N_22889_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10180\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_14__G2_0\,
datab => N_28208);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_O12_3_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_O12_3_0\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10174\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10183\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10212\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_12__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_O12_3_0\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9698\,
datac => N_27696_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_8__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10044\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2_1_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10269\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10161\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10088\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10244\,
datae => N_22889_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10236\,
datac => N_27144_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_9\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_7__G2_7\,
datab => N_27288);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_2_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => N_27618,
dataf => N_22756_1,
datae => N_27096,
datad => N_26971_1,
datac => N_26764_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_1_A23_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3300000030000000")
port map (
combout => N_27615,
dataf => N_22426_1,
datae => N_22745_1,
datad => N_22756_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffff000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_7\,
dataf => N_27615,
datae => N_27618,
datad => N_22673_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_5_1\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_12_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000c0c0c")
port map (
combout => N_27628,
dataf => N_27524,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_7_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff00f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_7_0\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0000c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_0\,
dataf => N_27628,
datae => N_27792,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_7_0\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_9_33_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datae => N_27020,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffc0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_4\,
datac => N_27409_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_8_0\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_4_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_27620,
dataf => N_22673_1,
datae => N_22599_1,
datad => N_26815_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9197\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_1_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000c000000000")
port map (
combout => N_27617,
dataf => N_27792,
datae => N_26822_1,
datad => N_27524,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_18_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => N_27634,
dataf => N_27792,
datae => N_27209_1,
datad => N_27524,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000333000000000")
port map (
combout => N_27616,
dataf => N_26932_1,
datae => N_27882,
datad => N_23026_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_10\,
dataf => N_27620,
datae => N_27617,
datad => N_27634,
datac => N_27616);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_10_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_10_0\(6),
dataf => N_28098_I,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_17\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_15\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10207\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_7\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_6__G2_2\,
dataa => N_27619);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_8_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f0000000000")
port map (
combout => N_28247,
dataf => N_22426_1,
datae => N_27177,
datad => N_28217,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_5__G2_0\,
dataf => N_27691,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_11_1\(5),
datad => N_28292_1,
datac => N_27448_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_1_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0cc000000000000")
port map (
combout => N_28240,
dataf => N_22673_1,
datae => N_22599_1,
datad => N_27811,
datac => N_26971_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_0_0_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff000000ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_0_0\(5),
dataf => N_27177,
datae => N_28048_1,
datad => N_22600_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_2_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3030000030000000")
port map (
combout => N_28241,
dataf => N_26815_1,
datae => N_28242_1,
datad => N_26808_1,
datac => N_28048_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_6_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => N_28245,
dataf => N_22426_1,
datae => N_22599_1,
datad => N_23165_1,
datac => N_23362_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A16_3_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_28242,
dataf => N_22673_1,
datae => N_28242_1,
datad => N_23079_1,
datac => N_27257_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff30ff0030300000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_4\,
dataf => N_27981_3,
datae => N_22889_1,
datad => N_28208,
datac => N_28336_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffc0c0c0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10193\,
datae => N_27626_2,
datad => N_27910_2,
datac => N_28336_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0c000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10133\,
dataf => N_22599_1,
datae => N_27547_1,
datad => N_28194_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_3__G2_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_11_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => N_28407,
dataf => N_27792,
datae => N_22744_1,
datad => N_23344,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_4_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => N_28400,
dataf => N_27792,
datae => N_22589_1,
datad => N_27317,
datac => N_26773_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff30000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_2\,
dataf => N_28400,
datae => N_22426_1,
datad => N_27131_1,
datac => N_27257_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_3_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_28399,
dataf => N_26815_1,
datae => N_28098_I,
datad => N_26978_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_10_1\(51),
datae => N_28399,
datad => N_27286_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_5_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00000000000")
port map (
combout => N_28401,
dataf => N_27131_1,
datae => N_23346,
datad => N_23344,
datac => N_22608_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff000c0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_0\,
dataf => N_28401,
datae => N_27131_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_2_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_28398,
dataf => N_27377,
datae => N_22425_1,
datad => N_28048_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_17_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_28413,
dataf => N_28413_1,
datae => N_22589_1,
datad => N_26978_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_5\,
dataf => N_28411,
datae => N_28414_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_6_0_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff00ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_6_0\(51),
dataf => N_23346,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_12_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => N_28408,
dataf => N_22426_1,
datae => N_23346,
datad => N_28408_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_1_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000300000000000")
port map (
combout => N_28397,
dataf => N_22425_1,
datae => N_22496_2,
datad => N_22744_1,
datac => N_27317,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_8_1_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_4_1\(5),
dataf => N_27721,
datae => N_22426_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3003300f0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A16_4_1\(5),
datae => N_28438,
datad => N_27131_1,
datac => N_22589_1,
datab => N_27257_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_18\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10207\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_52__G2_5\,
datab => N_28413_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_6_0\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A22_10_1_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A22_10_1\(51),
dataf => N_27068_1,
datae => N_22589_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_14_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0000000")
port map (
combout => N_27560,
dataf => N_22673_1,
datae => N_22425_1,
datad => N_26808_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_6_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000000000")
port map (
combout => N_27552,
dataf => N_27585,
datae => N_22673_1,
datad => N_22818_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_6\,
dataf => N_27561,
datae => N_22745_1,
datad => N_23785_1,
datac => N_27338_2);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_5_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"003c000000000000")
port map (
combout => N_27551,
dataf => N_26932_1,
datae => N_22759_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_3_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_27549,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_1\(19),
datae => N_22673_1,
datad => N_27096,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff03000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_10\,
dataf => N_27549,
datae => N_22426_1,
datad => N_28154_1,
datac => N_22730_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_2_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0cc000000000000")
port map (
combout => N_27548,
dataf => N_22745_1,
datae => N_23715_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff03000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_1\,
dataf => N_27548,
datae => N_23785_1,
datad => N_22818_1,
datac => N_22651_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_19_0_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_19_0\(19),
dataf => N_26808_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0ff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_19_0\(19),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_20_0\(19),
datad => N_23785_1,
datac => N_22804_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_20\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_18\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_6\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_19__G2_14\,
datab => N_27552,
dataa => N_27560);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_6_3_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_6_3\(32),
dataf => N_23785_1,
datae => N_26822_1,
datad => N_27144_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c3030000c0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_0\,
dataf => N_22426_1,
datae => N_28336_1,
datad => N_22744_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00003000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_0\,
datae => N_27721,
datad => N_26932_1,
datac => N_23785_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_6_3\(32),
datac => N_22673_1,
datab => N_22426_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_11\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_7\,
datad => N_27338,
datac => N_27337,
datab => N_27339,
dataa => N_27341);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_9_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c300000000000000")
port map (
combout => N_27343,
dataf => N_22673_1,
datae => N_22496_2,
datad => N_27144_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffc0000000c00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_3\,
dataf => N_27336_2,
datae => N_22744_1,
datad => N_27317,
datac => N_27286_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_13\,
dataf => N_27342,
datae => N_27347,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_3\,
datac => N_27334,
datab => N_27343);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffc0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9768\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_32__G2_13\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10163\,
datab => N_27696_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_63_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_2\,
dataf => N_23966,
datae => N_23968,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_4_3\(62),
datac => N_22958_1,
datab => N_22425_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_63_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccccfccc0000f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_2_0\(62),
datae => N_27792,
datad => N_22958_1,
datac => N_23954,
datab => N_23953);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_63_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff80")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_2\,
datae => N_23963,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_63__G2_1\,
datac => N_23956,
datab => N_26820_1,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_20_0_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_20_0\(19),
dataf => N_23362_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_8_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000ff000000000")
port map (
combout => N_27342,
dataf => N_27342_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A20_7_32_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00c3000000000000")
port map (
combout => N_27341,
dataf => N_23785_1,
datae => N_26764_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A8_0_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000f000f0000000")
port map (
combout => N_23963,
dataf => N_27978_2,
datae => N_23982,
datad => N_22673_1,
datac => N_22427_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A8_3_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00f00000000000")
port map (
combout => N_23966,
dataf => N_27065_2,
datae => N_26993_1,
datad => N_27762_1,
datac => N_23976);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A8_5_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_23968,
dataf => N_27721,
datae => N_22425_1,
datad => N_26971_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A8_4_3_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f00000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A8_4_3\(62),
dataf => N_23346,
datae => N_26971_1,
datad => N_22429_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_44_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => N_27928,
dataf => N_27046_1,
datae => N_27020,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_29_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0000000000000")
port map (
combout => N_27913,
dataf => N_27291_1,
datae => N_22429_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_24_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0000000")
port map (
combout => N_27066,
dataf => N_28219,
datae => N_22681_1,
datad => N_23003_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_20_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27062,
dataf => N_23117_1,
datae => N_22681_1,
datad => N_22756_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_11_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27053,
dataf => N_27053_2,
datae => N_28219,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_5_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => N_27047,
dataf => N_28219,
datae => N_27020,
datad => N_23342,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3333ffff0000f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A14_15_1\(34),
datae => N_28219,
datad => N_22681_1,
datac => N_28178,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_12_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3030000000300000")
port map (
combout => N_28184,
dataf => N_28208,
datae => N_22673_1,
datad => N_28219,
datac => N_22496_2,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_0\,
datae => N_28192,
datad => N_28194_1,
datac => N_23003_1,
datab => N_27482_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_13_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffc0000000000000")
port map (
combout => N_28185,
dataf => N_27989_2,
datae => N_22756_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_14_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fcf0000000000000")
port map (
combout => N_28186,
dataf => N_27050_1,
datae => N_22745_1,
datad => N_27104_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_4\,
datae => N_28185,
datad => N_28195,
datac => N_28186,
datab => N_28190,
dataa => N_28189);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffffc0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_9\,
datae => N_28184,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_34__G2_5\,
datac => N_27989_2,
datab => N_22530_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff000f000f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10213\,
datad => N_23298,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_45_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9826\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_45__G2_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_3_0_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_3_0\(52),
dataf => N_22600_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_17_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000c0000000000")
port map (
combout => N_28189,
dataf => N_27068_1,
datae => N_22804_1,
datad => N_26764_1,
datac => N_28006,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_23_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_28195,
dataf => N_22673_1,
datae => N_27050_1,
datad => N_22681_1,
datac => N_28006);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_20_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_28192,
dataf => N_27068_1,
datae => N_26722_I,
datad => N_27482_1,
datac => N_28006);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_18_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00000000000000")
port map (
combout => N_28190,
dataf => N_22673_1,
datae => N_27068_1,
datad => N_26747_1,
datac => N_26726_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A14_15_1_34_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A14_15_1\(34),
dataf => N_27721,
datae => N_22496_2,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_13_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000f00")
port map (
combout => N_27840,
dataf => N_28194_1,
datae => N_23344,
datad => N_22429_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_3_57_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000f00")
port map (
combout => N_27830,
dataf => N_27020,
datae => N_23344,
datad => N_26773_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A27_4_52_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => N_27271,
dataf => N_23791_1,
datae => N_26815_1,
datad => N_23622_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_1_0_44_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1\(44),
dataf => N_22759_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A2_5_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10246\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10216\,
datae => N_22599_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A2_4_0_17_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A2_4_0\(17),
dataf => N_22958_1,
datae => N_27731_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_5_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cf0c000000000000")
port map (
combout => N_26914,
dataf => N_28154_1,
datae => N_26975_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_4_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00c00000000000")
port map (
combout => N_26913,
dataf => N_22426_1,
datae => N_23791_1,
datad => N_26975_1,
datac => N_23026_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A15_8_1_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_8_1\(4),
dataf => N_23344,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0c0f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_1\,
dataf => N_26912,
datae => N_26920_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_8_1\(4),
datac => N_23791_1,
datab => N_26975_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_8_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff00f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_8_0\(6),
dataf => N_27177,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0f0f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_4__G2_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10139\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_6_0\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A15_7_0\(4),
datac => N_26890);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_27_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0f0f000")
port map (
combout => N_28048,
dataf => N_27020,
datae => N_27068_1,
datad => N_27208_1,
datac => N_28048_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_29_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000ff0000")
port map (
combout => N_28050,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9266\,
datae => N_28050_1,
datad => N_28033_I);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffcf")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_15\,
dataf => N_28048,
datae => N_28050,
datad => N_27020,
datac => N_23791_1,
datab => N_27811);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_28_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_28049,
dataf => N_22599_1,
datae => N_22745_1,
datad => N_22530_1,
datac => N_22612_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_44_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_28065,
dataf => N_26981_1,
datae => N_27208_1,
datad => N_28065_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000fcfff3ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_5\,
dataf => N_28065,
datae => N_22759_1,
datad => N_22530_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_5\,
datae => N_28049,
datad => N_26932_1,
datac => N_22589_1,
datab => N_27317);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_41_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_28062,
dataf => N_22745_1,
datae => N_27208_1,
datad => N_28062_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000003fff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_12\,
dataf => N_28046,
datae => N_28062,
datad => N_22958_1,
datac => N_22425_1,
datab => N_26813_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_33_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_28054,
dataf => N_22612_1,
datae => N_27731_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_9_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000cc000c00")
port map (
combout => N_28047,
dataf => N_28312,
datae => N_22530_1,
datad => N_27482_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_31_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => N_28052,
dataf => N_22599_1,
datae => N_22608_2,
datad => N_23024_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000fcffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_0\,
dataf => N_28052,
datae => N_26981_1,
datad => N_27482_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_35_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => N_28056,
dataf => N_23791_1,
datae => N_26975_1,
datad => N_26747_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_0\,
datae => N_28056,
datad => N_28047,
datac => N_28054,
datab => N_28055);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_A12_1_0_38_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\(38),
dataf => N_22958_1,
datae => N_22429_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_20\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_9\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_48__G2_8\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10202\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_A12_1_0\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_51_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_28072,
dataf => N_26813_1,
datae => N_26981_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A20_15_0\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_36_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000c0000000000")
port map (
combout => N_28057,
dataf => N_23785_1,
datae => N_26813_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_0_A29_34_47_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0000000000000")
port map (
combout => N_28055,
dataf => N_26764_1,
datae => N_26801_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_11_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_27989,
dataf => N_27989_2,
datae => N_26813_1,
datad => N_27131_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_9_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => N_27987,
dataf => N_22426_1,
datae => N_22599_1,
datad => N_22424_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_7_0_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_7_0\(48),
dataf => N_27397_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_6_0_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A23_6_0\(48),
dataf => N_22745_1,
datae => N_22818_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A23_5_48_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c300000000000000")
port map (
combout => N_27983,
dataf => N_28336_1,
datae => N_23362_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A29_15_0_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A29_15_0\(58),
dataf => N_28154_1,
datae => N_26747_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A13_2_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => N_23361,
dataf => N_23346,
datae => N_23079_1,
datad => N_22600_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN54_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7167\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN48_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7251\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI0L7D1_46_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\(77),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3953\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(65),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(46));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_EXPAREGLOADEN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcff00ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4629_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M11S4_I_A2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_11_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_11_0\(11),
dataf => N_27793_I,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_13_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_28131,
dataf => N_23117_1,
datae => N_27104_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_4_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000fff0000")
port map (
combout => N_28122,
dataf => N_27096,
datae => N_27286_1,
datad => N_28095,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff3f3fffffff0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_5\,
dataf => N_23117_1,
datae => N_27096,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_5_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00f000000000")
port map (
combout => N_28123,
dataf => N_28123_4,
datae => N_23165_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_12_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_12_0\(11),
dataf => N_27104_I,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00cf00ffffcfcf")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_I_I_I_A25_12_0\(11),
datae => N_27096,
datad => N_23346,
datac => N_28292_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_2_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3330000000000000")
port map (
combout => N_28120,
dataf => N_22673_1,
datae => N_27209_1,
datad => N_26808_1,
datac => N_27793_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f3000000000")
port map (
combout => N_28117,
dataf => N_23079_1,
datae => N_28273,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_9_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3f0fffffff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_2\,
dataf => N_26722_I,
datae => N_27482_1,
datad => N_23342,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000fffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_11__G2_9\,
dataf => N_28121,
datae => N_22673_1,
datad => N_27104_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A27_17_0\(19));
\GRLFPC20_R_FSR_AEXC_RNO_0_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1341\,
datad => \GRLFPC20.N_1378\,
datac => N_366,
datab => N_406);
\GRLFPC20_R_FSR_AEXC_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
datac => \GRLFPC20.R.I.EXC\(1),
datab => \GRLFPC20.R.FSR.AEXC\(1));
\GRLFPC20_R_FSR_AEXC_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1341\,
datad => \GRLFPC20.N_1378\,
datac => N_367,
datab => N_407);
\GRLFPC20_R_FSR_AEXC_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
datac => \GRLFPC20.R.I.EXC\(2),
datab => \GRLFPC20.R.FSR.AEXC\(2));
\GRLFPC20_R_FSR_AEXC_RNO_0_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1341\,
datad => \GRLFPC20.N_1378\,
datac => N_369,
datab => N_409);
\GRLFPC20_R_FSR_AEXC_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_4__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\,
datac => \GRLFPC20.R.I.EXC\(4),
datab => \GRLFPC20.R.FSR.AEXC\(4));
\GRLFPC20_R_FSR_CEXC_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0f0ccff00000000")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_1__G1\,
dataf => \GRLFPC20.R.FSR.CEXC_1_0_1__G1_1\,
datae => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datac => \GRLFPC20.R.I.EXC\(1),
datab => \GRLFPC20.R.FSR.CEXC\(1));
\GRLFPC20_R_FSR_CEXC_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0f0ccff00000000")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_2__G1\,
dataf => \GRLFPC20.R.FSR.CEXC_1_0_2__G1_1\,
datae => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datac => \GRLFPC20.R.I.EXC\(2),
datab => \GRLFPC20.R.FSR.CEXC\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_4\(2),
dataf => N_56,
datae => N_59,
datad => N_54,
datac => N_58);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_5_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c300000000000000")
port map (
combout => N_26745,
dataf => N_22673_1,
datae => N_22427_1,
datad => N_28062_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_6_0_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0000ff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_6_0\(50),
dataf => N_22427_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_3_1_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f3300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_3_1\(50),
dataf => N_26971_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A11_4_50_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000030c0000")
port map (
combout => N_26744,
dataf => N_28219,
datae => N_23079_1,
datad => N_28273,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffcf0fcc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_2\,
dataf => N_26744,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_3_1\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A11_6_0\(50),
datac => N_27020,
datab => N_22425_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_51_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_51__G2_2\,
datad => N_26739,
datac => N_26740,
datab => N_26741,
dataa => N_26742);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A26_41_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_27925,
dataf => N_27020,
datae => N_26813_1,
datad => N_27272_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_4_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0000c0000000000")
port map (
combout => N_27689,
dataf => N_28292_1,
datae => N_28062_1,
datad => N_27396_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_2_0_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A17_2_0\(13),
dataf => N_28062_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffc3000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_3\,
dataf => N_27689,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A17_2_0\(13),
datad => N_26815_1,
datac => N_22744_1,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_5_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c00000000000000")
port map (
combout => N_27690,
dataf => N_22756_1,
datae => N_27793_I,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffff0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_1\,
dataf => N_27690,
datae => N_27698_2,
datad => N_23003_1,
datac => N_28292_1);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_9_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_13__G2_3\,
datac => N_27688,
datab => N_27691);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_9_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => N_27694,
dataf => N_22424_2,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\,
datad => N_28033_I,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A17_8_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c00000000000")
port map (
combout => N_27693,
dataf => N_23785_1,
datae => N_22424_2,
datad => N_27209_1,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_6_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => N_28294,
dataf => N_22673_1,
datae => N_22426_1,
datad => N_28273,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_4_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff0f0000")
port map (
combout => N_28292,
dataf => N_27721,
datae => N_28292_1,
datad => N_28273,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_0_A9_5_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0_0_A9_5_0\(0),
dataf => N_28273,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_374_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff30000003ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(374),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\(0));
\GRLFPC20_R_A_RDD_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => \GRLFPC20.R.A.RDD_0_0_0__G1\,
dataf => \GRLFPC20.COMB.RDD_1.I7_MUX\,
datae => N_71,
datad => N_69,
datac => N_78);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_244_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30716,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(257));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_244_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32136,
dataf => \GRLFPC20.FPO.EXP\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_11_7726_I_0\,
datad => N_30716,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_243_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30738,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(256));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_243_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32137,
dataf => \GRLFPC20.FPO.EXP\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_10_7758_I_0\,
datad => N_30738,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_241_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30782,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(254));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_241_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32139,
dataf => \GRLFPC20.FPO.EXP\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_8_7822_I_0\,
datad => N_30782,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_240_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30804,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(253));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_240_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32140,
dataf => \GRLFPC20.FPO.EXP\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_7_7854_I_0\,
datad => N_30804,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_239_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30826,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(252));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_239_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32141,
dataf => \GRLFPC20.FPO.EXP\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_6_7886_I_0\,
datad => N_30826,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_238_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30848,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(251));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_238_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32142,
dataf => \GRLFPC20.FPO.EXP\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_7918_I_0\,
datad => N_30848,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_237_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff000f0ffc000c0")
port map (
combout => N_32143,
dataf => \GRLFPC20.FPO.EXP\(7),
datae => N_30866,
datad => N_30976_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_4_7950_I_0_TZ\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_115_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0303000003000300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(115),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SS0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(115),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(115),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datab => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_64_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00ff")
port map (
combout => \GRLFPC20.FPI.RST\,
dataf => \GRLFPC20.R.MK.RST\,
datae => \GRLFPC20.R.MK.RST2\,
datad => N_5);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_0_I_I_I_A25_6_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0330000")
port map (
combout => N_28124,
dataf => N_28273,
datae => N_23024_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_COMB_UN1_FPCI_0_RNIVP8E: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.R.I.PC_1_0_9__G2\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.N_1211\,
datad => N_7);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0fffffff00")
port map (
combout => N_30675,
dataf => \GRLFPC20.R.FSR.RD\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(2));
\GRLFPC20_R_FSR_CEXC_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0f0ccff00000000")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_4__G1\,
dataf => \GRLFPC20.R.FSR.CEXC_1_0_4__G1_1\,
datae => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datac => \GRLFPC20.R.I.EXC\(4),
datab => \GRLFPC20.R.FSR.CEXC\(4));
\GRLFPC20_R_FSR_CEXC_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0f0ccff00000000")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_3__G1\,
dataf => \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\,
datae => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datac => \GRLFPC20.R.I.EXC\(3),
datab => \GRLFPC20.R.FSR.CEXC\(3));
\GRLFPC20_R_FSR_CEXC_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c0f0ccff00000000")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_0__G1\,
dataf => \GRLFPC20.R.FSR.CEXC_1_0_0__G1_1\,
datae => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datad => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datac => \GRLFPC20.R.I.EXC\(0),
datab => \GRLFPC20.R.FSR.CEXC\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN18_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7788\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN24_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7761\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN33_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7599\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN39_ZERO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7604\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
\GRLFPC20_R_I_EXC_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000c")
port map (
combout => \GRLFPC20.R.I.EXC_MB\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_29\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.EXCEP_I_1\(0),
datad => \GRLFPC20.N_1452\,
datac => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40));
\GRLFPC20_R_FSR_FTT_RNO_0_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_8180_I_1\,
dataf => \GRLFPC20.R.I.V\,
datae => \GRLFPC20.R.I.EXC\(5),
datad => N_5);
\GRLFPC20_R_FSR_FTT_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0fc000000000000")
port map (
combout => N_32146,
dataf => N_31028_1,
datae => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_8180_I_1\,
datad => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_A6_1_0\,
datac => \GRLFPC20.R.X.FPOP\,
datab => \GRLFPC20.R.I.EXEC\);
GRLFPC20_COMB_LOCK_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000300000000")
port map (
combout => CPO_LDLOCKZ,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => N_82,
datad => N_81,
datac => \GRLFPC20.R.STATE\(1),
datab => \GRLFPC20.R.STATE\(0));
\GRLFPC20_R_STATE_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"03000f003300ff00")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G1_0\,
dataf => CPO_EXCZ,
datae => \GRLFPC20.N_1378\,
datad => N_5,
datac => N_9,
datab => N_428);
\GRLFPC20_R_STATE_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ff00cf00")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G1\,
dataf => \GRLFPC20.N_2125\,
datae => \GRLFPC20.N_1146\,
datad => \GRLFPC20.R.STATE_0_0_0__G1_0\,
datac => \GRLFPC20.UN1_FPCI_5\,
datab => \GRLFPC20.R.STATE\(0));
GRLFPC20_COMB_UN2_HOLDN: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.N_1452\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.R.A.MOV\,
datad => \GRLFPC20.N_1173\,
datac => N_7);
GRLFPC20_R_MK_BUSY2_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.N_2566\,
dataf => \GRLFPC20.COMB.UN1_ANNULFPU\,
datae => \GRLFPC20.R.MK.BUSY\,
datad => N_5);
GRLFPC20_R_MK_BUSY2_RNIH1961: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000003000000000")
port map (
combout => \GRLFPC20.R.I.CC_0_0_1__N_7\,
dataf => \GRLFPC20.N_1170\,
datae => \GRLFPC20.R.MK.RST\,
datad => \GRLFPC20.R.MK.RST2\,
datac => \GRLFPC20.R.MK.BUSY2\,
datab => \GRLFPC20.R.MK.BUSY\);
\GRLFPC20_R_FSR_FTT_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_2__G2\,
dataf => \GRLFPC20.N_2125\,
datae => \GRLFPC20.N_1146\,
datad => \GRLFPC20.UN1_FPCI_5\,
datac => N_5);
GRLFPC20_R_I_EXEC_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.R.I.EXEC_0_0_G1_0_8109_A2_0\,
dataf => \GRLFPC20.COMB.V.I.EXEC_5\,
datae => N_30990,
datad => N_5);
GRLFPC20_R_I_EXEC_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000c")
port map (
combout => N_30991,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1693\,
datad => N_29164,
datac => \GRLFPC20.N_1146\,
datab => \GRLFPC20.R.I.EXEC_0_0_G1_0_8109_A2_0\);
GRLFPC20_COMB_UN9_CCV: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000003f3f3f")
port map (
combout => CPO_CCVZ,
dataf => \GRLFPC20.COMB.UN9_CCV_2\,
datae => \GRLFPC20.R.E.FPOP\,
datad => N_204,
datac => \GRLFPC20.R.X.LD\,
datab => \GRLFPC20.R.X.AFSR\);
\GRLFPC20_R_X_SEQERR_RNIFNVB_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_A6_1_0\,
dataf => \GRLFPC20.R.X.SEQERR\,
datae => \GRLFPC20.N_1211\);
\GRLFPC20_R_FSR_FTT_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0000000f000f000")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_1\,
dataf => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_A6_1_0\,
datae => \GRLFPC20.R.X.FPOP\,
datad => \GRLFPC20.R.I.V\,
datac => N_5);
\GRLFPC20_R_FSR_FTT_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccc00000fff00000")
port map (
combout => N_32145,
dataf => N_31028_1,
datae => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_8156_I_1\,
datad => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.R.I.EXC\(5));
GRLFPC20_RS2_0_SQMUXA_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => \GRLFPC20.RS2_0_SQMUXA_1\,
dataf => N_67,
datae => N_69,
datad => N_68);
GRLFPC20_RS2_0_SQMUXA: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c00000000000000")
port map (
combout => \GRLFPC20.N_2173\,
dataf => \GRLFPC20.RS2_0_SQMUXA_1\,
datae => N_71,
datad => N_70,
datac => N_77,
datab => N_78);
\GRLFPC20_R_A_RF2REN_RNO_1_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000fff0fff0fff")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_A5_0\,
dataf => \GRLFPC20.N_2173\,
datae => N_47,
datad => \GRLFPC20.R.A.RS1D_0_0_G4\,
datac => \GRLFPC20.N_952\);
\GRLFPC20_R_A_RF2REN_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fc000000ff00")
port map (
combout => \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_0\,
dataf => \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_A5_0\,
datae => N_77,
datad => N_78,
datac => \GRLFPC20.UN1_MOV_1_SQMUXA_0\,
datab => \GRLFPC20.N_951\);
\GRLFPC20_R_A_RF2REN_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fcff0000ffff0000")
port map (
combout => N_32149,
dataf => N_31104,
datae => \GRLFPC20.COMB.V.A.RF2REN_1_0_8263_I_0\,
datad => \GRLFPC20.N_3727\,
datac => N_80,
datab => N_79);
\GRLFPC20_R_A_RF1REN_RNO_2_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_1\,
dataf => N_71,
datae => N_67,
datad => N_70);
\GRLFPC20_R_A_RF1REN_RNO_1_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_3\,
dataf => N_77,
datae => N_78,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_1\,
datac => N_69,
datab => N_68);
\GRLFPC20_R_A_RF1REN_RNO_0_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3ffffff00000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_A8_0\,
dataf => N_47,
datae => \GRLFPC20.R.A.RS1D_0_0_G4\,
datad => N_66,
datac => \GRLFPC20.N_3733\,
datab => N_70);
\GRLFPC20_R_A_RF1REN_RNO_2_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000cccccc0c")
port map (
combout => N_32147,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.UN1_MOV_1_SQMUXA_0\,
datad => \GRLFPC20.N_951\,
datac => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_A8_0\,
datab => \GRLFPC20.COMB.V.A.RF1REN_1_0_8207_I_3\);
GRLFPC20_R_A_MOV_RNO_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000f000f000f00")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_2\,
dataf => N_55,
datae => N_54,
datad => \GRLFPC20.N_3761\,
datac => N_56);
GRLFPC20_R_A_MOV_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_3\,
dataf => N_53,
datae => N_52,
datad => \GRLFPC20.N_920\,
datac => N_77,
datab => N_78);
GRLFPC20_R_A_MOV_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000000000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1\,
dataf => \GRLFPC20.R.A.MOV_0_0_G1_3\,
datae => \GRLFPC20.R.A.MOV_0_0_G1_2\,
datad => N_58,
datac => N_57);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_65_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0fff0fffffff0ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\(65),
dataf => N_30696,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(64));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_76_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff00ffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3953\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff00")
port map (
combout => N_30674,
dataf => \GRLFPC20.R.FSR.RD\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0f0f000c0c0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5019_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_78\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_0_A2_0_2\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I_0_0__G0_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13));
\GRLFPC20_R_FSR_AEXC_RNO_0_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1341\,
datad => \GRLFPC20.N_1378\,
datac => N_368,
datab => N_408);
\GRLFPC20_R_FSR_AEXC_RNO_3_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_3__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\,
datac => \GRLFPC20.R.I.EXC\(3),
datab => \GRLFPC20.R.FSR.AEXC\(3));
\GRLFPC20_R_FSR_AEXC_RNO_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\,
dataf => \GRLFPC20.N_1269\,
datae => \GRLFPC20.N_1341\,
datad => \GRLFPC20.N_1378\,
datac => N_365,
datab => N_405);
\GRLFPC20_R_FSR_AEXC_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_0__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\,
datac => \GRLFPC20.R.I.EXC\(0),
datab => \GRLFPC20.R.FSR.AEXC\(0));
GRLFPC20_V_STATE_0_SQMUXA_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.N_1378\,
dataf => N_392,
datae => N_393,
datad => N_394);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_SCTRL_38_IV_0_A2_0_3_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000003000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_0_A2_0_2\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5312\,
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_242_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000fc0000")
port map (
combout => N_32138,
dataf => \GRLFPC20.FPO.EXP\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_7790_I_0\,
datad => N_30760,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_242_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => N_30760,
dataf => N_30976_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(255));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14S2_I_A2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_94\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_142\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M5S4: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7965\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_258_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c333ccc33ccc333c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7270\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_13695\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1493_I\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7133\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN15_NOTXZYFROMD: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eac0eac0ffffeac0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5419\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(375),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_0_8069_A2_3: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff0f")
port map (
combout => N_30976_3,
dataf => \GRLFPC20.R.MK.RST\,
datae => \GRLFPC20.R.MK.RST2\,
datad => \GRLFPC20.R.MK.LDOP\,
datac => N_5);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_82_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G3_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datae => N_58);
\GRLFPC20_R_I_EXC_RNO_1_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000300000")
port map (
combout => \GRLFPC20.R.I.EXC_MB\(1),
dataf => \GRLFPC20.N_1452\,
datae => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
\GRLFPC20_R_I_EXC_RNO_4_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ccc00000")
port map (
combout => \GRLFPC20.R.I.EXC_MB\(4),
dataf => \GRLFPC20.N_1452\,
datae => \GRLFPC20.R.I.CC_0_0_1__I1_I_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
GRLFPC20_R_A_LD_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000cf")
port map (
combout => \GRLFPC20.R.A.LD_0_0_G1\,
dataf => \GRLFPC20.N_3747\,
datae => \GRLFPC20.N_3768\,
datad => N_68,
datac => N_67,
datab => N_66);
GRLFPC20_R_A_AFSR_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => \GRLFPC20.R.A.AFSR_0_0_G1\,
dataf => \GRLFPC20.N_3747\,
datae => \GRLFPC20.N_3768\,
datad => N_67,
datac => N_66);
GRLFPC20_R_MK_BUSY_RNO_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => \GRLFPC20.R.MK.BUSY_0_0_G0_2\,
dataf => \GRLFPC20.COMB.UN1_ANNULFPU\,
datae => CPO_HOLDNZ,
datad => \GRLFPC20.R.MK.RST\,
datac => \GRLFPC20.R.MK.RST2\,
datab => N_5);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP_2: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4274\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68));
GRLFPC20_R_MK_RST_RNO_1: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.COMB.V.MK.RST_1_0_G0_1\,
dataf => \GRLFPC20.R.MK.HOLDN1\,
datae => \GRLFPC20.R.MK.HOLDN2\,
datad => N_7);
GRLFPC20_COMB_UN1_FPCI_2_RNIIP8T: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000f0f0ff00ffff")
port map (
combout => \GRLFPC20.R.MK.BUSY2_0_0_G3_0\,
dataf => \GRLFPC20.R.E.FPOP\,
datae => \GRLFPC20.R.A.FPOP\,
datad => \GRLFPC20.N_1173\,
datac => \GRLFPC20.N_1804\);
GRLFPC20_COMB_UN1_FPCI_1_RNIHEF72: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000cf000000")
port map (
combout => \GRLFPC20.COMB.UN1_ANNULFPU\,
dataf => \GRLFPC20.N_2125\,
datae => \GRLFPC20.COMB.UN1_ANNULFPU_TZ_TZ\,
datad => \GRLFPC20.R.MK.BUSY2_0_0_G3_0\,
datac => \GRLFPC20.R.M.FPOP\,
datab => \GRLFPC20.N_1802\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_1_SQMUXA_31: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"e2e20000e2e00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_84_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_1_0\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datae => N_56);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"1d1dffff1d1fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_N_5_MUX\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_73\,
datac => N_30976_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOINSTANDNOEXC_41_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000fff300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7440\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3968\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_85_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_S_0\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_1_0\,
datae => N_57);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_85_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3f00ff003f3fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_0__G0_1_TZ\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_S_0\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN14_EXMIPTRLSBS\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4724\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_114_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4545404045404540")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(114),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SS0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(114),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(114),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\,
dataa => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_113_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"22ff30ff22003000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(113),
dataf => N_48624,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datad => N_48611,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datab => N_30976_3,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_113_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3030330030302222")
port map (
combout => N_48624,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(113),
datab => N_30976_3,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSAMPLEDWAIT_44_C_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffff0f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_C_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4273\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3945\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_0_75_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0000ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12_32_0\(75),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5206\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4345\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_53_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000f000f00f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_53__G2_10_TZ\,
dataf => N_26969_1,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_62_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"030003003fc33f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_62__G2_6_TZ\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_60_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00fc00cc00f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_60__G2_7_TZ\,
dataf => N_22673_1,
datae => N_26972_1,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_10_61_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00c00000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_61__G2_14\,
dataf => N_22745_1,
datae => N_22681_1,
datad => N_26822_1,
datac => N_26726_I,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_R_A_SEQERR_RNO_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => \GRLFPC20.R.A.SEQERR_0_0_0__G1\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2248_I_I_0\,
datad => \GRLFPC20.R.A.SEQERR_0_0_0__G3\);
GRLFPC20_R_A_ST_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000f")
port map (
combout => \GRLFPC20.R.A.ST_0_0_G1\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2248_I_I_0\,
datad => \GRLFPC20.N_3733\,
datac => \GRLFPC20.N_3736\);
GRLFPC20_R_A_AFQ_RNO: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => \GRLFPC20.R.A.AFQ_0_0_G1\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2248_I_I_0\,
datad => \GRLFPC20.R.A.AFQ_0_0_G1_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_233_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0ff0000c000")
port map (
combout => N_30959,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_232_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0ff0000c000")
port map (
combout => N_30976,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => N_30976_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_59_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0f0f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(59),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(59),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__N_6_I\,
datac => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_58_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0f0f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(58),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M2\(58),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3723\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_317__G3\,
datac => N_30976_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_43257,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_31_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_43163,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_30_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_43159,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_20_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43129,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11027\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(211));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_19_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43128,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11026\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(212));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_18_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43123,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11025\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(213));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_15_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43116,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11022\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(216));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_14_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43111,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11021\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(217));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_13_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43110,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11020\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(218));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_12_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43105,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11019\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(219));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_11_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43104,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11018\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(220));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_10_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43099,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11017\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(221));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43098,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11016\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(222));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43093,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11015\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(223));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43092,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11014\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(224));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_43087,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_11013\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(225));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN31_XZROUNDOUT_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => N_43067,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN8_TEMP_2_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccaaccaaf0fff000")
port map (
combout => N_43066,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_43008,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_43007,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_43001,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_5_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_43000,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(310));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42993,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42985,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42984,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42978,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_54_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42977,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(261));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_55_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42954,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(260));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42947,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42939,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_42938,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42932,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_56_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42931,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(259));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42927,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_SI_118_1_SUM_0_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f00ff0ff0ff00")
port map (
combout => N_42926,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7209\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7217\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7302\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_42923,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42922,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_SI_61_1_SUM_0_A2_0_0_0_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0000ff00ffff00")
port map (
combout => N_42921,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7217\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7765\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42912,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_42902,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42894,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42893,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_6_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42886,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(309));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42879,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42871,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42864,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_7_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42863,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(308));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42856,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_1_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42848,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42847,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_3_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42841,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_8_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42840,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(307));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42833,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42824,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_0: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_42818,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_9_\: stratixii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_42817,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(306));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_0: 