------------------------------------------------------------------------------
--  This file is a part of the GRLIB VHDL IP LIBRARY
--  Copyright (C) 2015, Cobham Gaisler AB - all rights reserved.
--
-- ANY USE OR REDISTRIBUTION IN PART OR IN WHOLE MUST BE HANDLED IN 
-- ACCORDANCE WITH THE GAISLER LICENSE AGREEMENT AND MUST BE APPROVED 
-- IN ADVANCE IN WRITING.
------------------------------------------------------------------------------

library ieee, stratixiii;
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use stratixiii.stratixiii_components.all;
library altera;
use altera.altera_primitives_components.all;

entity grlfpw_0_stratixiii is
port(
  rst :  in std_logic;
  clk :  in std_logic;
  holdn :  in std_logic;
  cpi_flush :  in std_logic;
  cpi_exack :  in std_logic;
  cpi_a_rs1 : in std_logic_vector(4 downto 0);
  cpi_d_pc : in std_logic_vector(31 downto 0);
  cpi_d_inst : in std_logic_vector(31 downto 0);
  cpi_d_cnt : in std_logic_vector(1 downto 0);
  cpi_d_trap :  in std_logic;
  cpi_d_annul :  in std_logic;
  cpi_d_pv :  in std_logic;
  cpi_a_pc : in std_logic_vector(31 downto 0);
  cpi_a_inst : in std_logic_vector(31 downto 0);
  cpi_a_cnt : in std_logic_vector(1 downto 0);
  cpi_a_trap :  in std_logic;
  cpi_a_annul :  in std_logic;
  cpi_a_pv :  in std_logic;
  cpi_e_pc : in std_logic_vector(31 downto 0);
  cpi_e_inst : in std_logic_vector(31 downto 0);
  cpi_e_cnt : in std_logic_vector(1 downto 0);
  cpi_e_trap :  in std_logic;
  cpi_e_annul :  in std_logic;
  cpi_e_pv :  in std_logic;
  cpi_m_pc : in std_logic_vector(31 downto 0);
  cpi_m_inst : in std_logic_vector(31 downto 0);
  cpi_m_cnt : in std_logic_vector(1 downto 0);
  cpi_m_trap :  in std_logic;
  cpi_m_annul :  in std_logic;
  cpi_m_pv :  in std_logic;
  cpi_x_pc : in std_logic_vector(31 downto 0);
  cpi_x_inst : in std_logic_vector(31 downto 0);
  cpi_x_cnt : in std_logic_vector(1 downto 0);
  cpi_x_trap :  in std_logic;
  cpi_x_annul :  in std_logic;
  cpi_x_pv :  in std_logic;
  cpi_lddata : in std_logic_vector(31 downto 0);
  cpi_dbg_enable :  in std_logic;
  cpi_dbg_write :  in std_logic;
  cpi_dbg_fsr :  in std_logic;
  cpi_dbg_addr : in std_logic_vector(4 downto 0);
  cpi_dbg_data : in std_logic_vector(31 downto 0);
  cpo_data : out std_logic_vector(31 downto 0);
  cpo_exc :  out std_logic;
  cpo_cc : out std_logic_vector(1 downto 0);
  cpo_ccv :  out std_logic;
  cpo_ldlock :  out std_logic;
  cpo_holdn :  out std_logic;
  cpo_dbg_data : out std_logic_vector(31 downto 0);
  rfi1_rd1addr : out std_logic_vector(3 downto 0);
  rfi1_rd2addr : out std_logic_vector(3 downto 0);
  rfi1_wraddr : out std_logic_vector(3 downto 0);
  rfi1_wrdata : out std_logic_vector(31 downto 0);
  rfi1_ren1 :  out std_logic;
  rfi1_ren2 :  out std_logic;
  rfi1_wren :  out std_logic;
  rfi2_rd1addr : out std_logic_vector(3 downto 0);
  rfi2_rd2addr : out std_logic_vector(3 downto 0);
  rfi2_wraddr : out std_logic_vector(3 downto 0);
  rfi2_wrdata : out std_logic_vector(31 downto 0);
  rfi2_ren1 :  out std_logic;
  rfi2_ren2 :  out std_logic;
  rfi2_wren :  out std_logic;
  rfo1_data1 : in std_logic_vector(31 downto 0);
  rfo1_data2 : in std_logic_vector(31 downto 0);
  rfo2_data1 : in std_logic_vector(31 downto 0);
  rfo2_data2 : in std_logic_vector(31 downto 0));
end grlfpw_0_stratixiii;

architecture beh of grlfpw_0_stratixiii is
  signal devclrn : std_logic := '1';
  signal devpor : std_logic := '1';
  signal devoe : std_logic := '0';
  signal \GRLFPC20.FPI.OP2\ : std_logic_vector(63 downto 32);
  signal \GRLFPC20.R.FSR.RD\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.FPO.FRAC\ : std_logic_vector(54 downto 3);
  signal \GRLFPC20.FPO.EXP\ : std_logic_vector(10 downto 0);
  signal \GRLFPC20.R.STATE\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.I.INST\ : std_logic_vector(31 downto 0);
  signal \GRLFPC20.R.FSR.TEM\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.I.EXC\ : std_logic_vector(5 downto 0);
  signal \GRLFPC20.R.FSR.AEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.A.RS2\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.I.PC\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.R.FSR.CEXC\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.R.FSR.FTT\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.R.I.CC\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.R.I.RES\ : std_logic_vector(63 downto 0);
  signal \GRLFPC20.COMB.V.I.RES_1\ : std_logic_vector(63 to 63);
  signal \GRLFPC20.R.A.RF1REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.A.RF2REN\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.R.I.EXC_MB\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.COMB.RS2_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.E.STDATA_1\ : std_logic_vector(31 downto 2);
  signal \GRLFPC20.COMB.RS1_1\ : std_logic_vector(4 downto 0);
  signal \GRLFPC20.COMB.V.FSR.FCC_1\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\ : std_logic_vector(16 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SCTRL_NEW\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\ : std_logic_vector(57 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\ : std_logic_vector(12 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_DIVMULTV\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\ : std_logic_vector(85 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\ : std_logic_vector(377 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\ : std_logic_vector(83 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_4\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_5\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_6\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\ : std_logic_vector(40 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\ : std_logic_vector(12 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPXBUS\ : std_logic_vector(2 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\ : std_logic_vector(52 to 52);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\ : std_logic_vector(51 to 51);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\ : std_logic_vector(4 to 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\ : std_logic_vector(5 to 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\ : std_logic_vector(6 to 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\ : std_logic_vector(9 to 9);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\ : std_logic_vector(11 to 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\ : std_logic_vector(13 to 13);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\ : std_logic_vector(14 to 14);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\ : std_logic_vector(15 to 15);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\ : std_logic_vector(16 to 16);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\ : std_logic_vector(17 to 17);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\ : std_logic_vector(18 to 18);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\ : std_logic_vector(19 to 19);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\ : std_logic_vector(20 to 20);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\ : std_logic_vector(21 to 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\ : std_logic_vector(22 to 22);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\ : std_logic_vector(23 to 23);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\ : std_logic_vector(24 to 24);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\ : std_logic_vector(25 to 25);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\ : std_logic_vector(26 to 26);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\ : std_logic_vector(27 to 27);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\ : std_logic_vector(28 to 28);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\ : std_logic_vector(29 to 29);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\ : std_logic_vector(30 to 30);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\ : std_logic_vector(31 to 31);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\ : std_logic_vector(32 to 32);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\ : std_logic_vector(33 to 33);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\ : std_logic_vector(34 to 34);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\ : std_logic_vector(35 to 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\ : std_logic_vector(36 to 36);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\ : std_logic_vector(37 to 37);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\ : std_logic_vector(38 to 38);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\ : std_logic_vector(39 to 39);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\ : std_logic_vector(40 to 40);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\ : std_logic_vector(41 to 41);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\ : std_logic_vector(42 to 42);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\ : std_logic_vector(43 to 43);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\ : std_logic_vector(44 to 44);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\ : std_logic_vector(45 to 45);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\ : std_logic_vector(46 to 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\ : std_logic_vector(47 to 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\ : std_logic_vector(48 to 48);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\ : std_logic_vector(49 to 49);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\ : std_logic_vector(50 to 50);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\ : std_logic_vector(65 to 65);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_18\ : std_logic_vector(74 to 74);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\ : std_logic_vector(55 downto 4);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\ : std_logic_vector(113 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\ : std_logic_vector(9 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\ : std_logic_vector(375 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW\ : std_logic_vector(9 downto 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\ : std_logic_vector(62 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\ : std_logic_vector(54 downto 6);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M3\ : std_logic_vector(83 downto 61);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\ : std_logic_vector(7 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M2\ : std_logic_vector(3 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17\ : std_logic_vector(2 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M8\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M11\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M5\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\ : std_logic_vector(57 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TOPBITSIN\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\ : std_logic_vector(115 downto 58);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\ : std_logic_vector(115 downto 58);
  signal \GRLFPC20.COMB.V.A.RF2REN_1_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.FPI.OP1\ : std_logic_vector(63 downto 35);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\ : std_logic_vector(50 downto 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\ : std_logic_vector(56 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\ : std_logic_vector(49 downto 11);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\ : std_logic_vector(56 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.SUMIN_5\ : std_logic_vector(3 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.CTRLXERSHFT.MIXOIN_3\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.COMB.V.STATE_9\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.FPCI_I_M\ : std_logic_vector(340 to 340);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\ : std_logic_vector(31 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.55.SI_60\ : std_logic_vector(53 to 53);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\ : std_logic_vector(257 downto 247);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\ : std_logic_vector(53 downto 46);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\ : std_logic_vector(9 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\ : std_logic_vector(6 downto 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\ : std_logic_vector(142 to 142);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.U_RDN_1\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\ : std_logic_vector(6 downto 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_I_M_C\ : std_logic_vector(12 to 12);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_IV_1_TZ\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_39_I_I_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\ : std_logic_vector(57 downto 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\ : std_logic_vector(45 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\ : std_logic_vector(53 downto 21);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\ : std_logic_vector(55 downto 47);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_4\ : std_logic_vector(6 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_6\ : std_logic_vector(6 downto 5);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_0\ : std_logic_vector(1 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_1\ : std_logic_vector(77 to 77);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_13_0_A2_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0_1\ : std_logic_vector(7 to 7);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_0\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\ : std_logic_vector(57 to 57);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\ : std_logic_vector(8 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\ : std_logic_vector(2 to 2);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\ : std_logic_vector(1 to 1);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\ : std_logic_vector(3 downto 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\ : std_logic_vector(3 to 3);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\ : std_logic_vector(75 to 75);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_I\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\ : std_logic_vector(10 to 10);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\ : std_logic_vector(8 to 8);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\ : std_logic_vector(0 to 0);
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\ : std_logic_vector(0 to 0);
  signal CPO_DATAZ : std_logic_vector(31 downto 0);
  signal CPO_CCZ : std_logic_vector(1 downto 0);
  signal CPO_DBG_DATAZ : std_logic_vector(31 downto 0);
  signal RFI1_WRDATAZ : std_logic_vector(31 downto 0);
  signal RFI2_RD1ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_RD2ADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRADDRZ : std_logic_vector(3 downto 0);
  signal RFI2_WRDATAZ : std_logic_vector(31 downto 0);
  signal CLK_INTERNAL : std_logic ;
  signal HOLDN_INTERNAL : std_logic ;
  signal CPI_FLUSH_INTERNAL : std_logic ;
  signal CPI_EXACK_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL : std_logic ;
  signal CPI_A_RS1_INTERNAL_0 : std_logic ;
  signal CPI_A_RS1_INTERNAL_1 : std_logic ;
  signal CPI_A_RS1_INTERNAL_2 : std_logic ;
  signal CPI_A_RS1_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL : std_logic ;
  signal CPI_D_PC_INTERNAL_0 : std_logic ;
  signal CPI_D_PC_INTERNAL_1 : std_logic ;
  signal CPI_D_PC_INTERNAL_2 : std_logic ;
  signal CPI_D_PC_INTERNAL_3 : std_logic ;
  signal CPI_D_PC_INTERNAL_4 : std_logic ;
  signal CPI_D_PC_INTERNAL_5 : std_logic ;
  signal CPI_D_PC_INTERNAL_6 : std_logic ;
  signal CPI_D_PC_INTERNAL_7 : std_logic ;
  signal CPI_D_PC_INTERNAL_8 : std_logic ;
  signal CPI_D_PC_INTERNAL_9 : std_logic ;
  signal CPI_D_PC_INTERNAL_10 : std_logic ;
  signal CPI_D_PC_INTERNAL_11 : std_logic ;
  signal CPI_D_PC_INTERNAL_12 : std_logic ;
  signal CPI_D_PC_INTERNAL_13 : std_logic ;
  signal CPI_D_PC_INTERNAL_14 : std_logic ;
  signal CPI_D_PC_INTERNAL_15 : std_logic ;
  signal CPI_D_PC_INTERNAL_16 : std_logic ;
  signal CPI_D_PC_INTERNAL_17 : std_logic ;
  signal CPI_D_PC_INTERNAL_18 : std_logic ;
  signal CPI_D_PC_INTERNAL_19 : std_logic ;
  signal CPI_D_PC_INTERNAL_20 : std_logic ;
  signal CPI_D_PC_INTERNAL_21 : std_logic ;
  signal CPI_D_PC_INTERNAL_22 : std_logic ;
  signal CPI_D_PC_INTERNAL_23 : std_logic ;
  signal CPI_D_PC_INTERNAL_24 : std_logic ;
  signal CPI_D_PC_INTERNAL_25 : std_logic ;
  signal CPI_D_PC_INTERNAL_26 : std_logic ;
  signal CPI_D_PC_INTERNAL_27 : std_logic ;
  signal CPI_D_PC_INTERNAL_28 : std_logic ;
  signal CPI_D_PC_INTERNAL_29 : std_logic ;
  signal CPI_D_PC_INTERNAL_30 : std_logic ;
  signal CPI_D_INST_INTERNAL : std_logic ;
  signal CPI_D_INST_INTERNAL_0 : std_logic ;
  signal CPI_D_INST_INTERNAL_1 : std_logic ;
  signal CPI_D_INST_INTERNAL_2 : std_logic ;
  signal CPI_D_INST_INTERNAL_3 : std_logic ;
  signal CPI_D_INST_INTERNAL_4 : std_logic ;
  signal CPI_D_INST_INTERNAL_5 : std_logic ;
  signal CPI_D_INST_INTERNAL_6 : std_logic ;
  signal CPI_D_INST_INTERNAL_7 : std_logic ;
  signal CPI_D_INST_INTERNAL_8 : std_logic ;
  signal CPI_D_INST_INTERNAL_9 : std_logic ;
  signal CPI_D_INST_INTERNAL_10 : std_logic ;
  signal CPI_D_INST_INTERNAL_11 : std_logic ;
  signal CPI_D_INST_INTERNAL_12 : std_logic ;
  signal CPI_D_INST_INTERNAL_13 : std_logic ;
  signal CPI_D_INST_INTERNAL_14 : std_logic ;
  signal CPI_D_INST_INTERNAL_15 : std_logic ;
  signal CPI_D_INST_INTERNAL_16 : std_logic ;
  signal CPI_D_INST_INTERNAL_17 : std_logic ;
  signal CPI_D_INST_INTERNAL_18 : std_logic ;
  signal CPI_D_INST_INTERNAL_19 : std_logic ;
  signal CPI_D_INST_INTERNAL_20 : std_logic ;
  signal CPI_D_INST_INTERNAL_21 : std_logic ;
  signal CPI_D_INST_INTERNAL_22 : std_logic ;
  signal CPI_D_INST_INTERNAL_23 : std_logic ;
  signal CPI_D_INST_INTERNAL_24 : std_logic ;
  signal CPI_D_INST_INTERNAL_25 : std_logic ;
  signal CPI_D_INST_INTERNAL_26 : std_logic ;
  signal CPI_D_INST_INTERNAL_27 : std_logic ;
  signal CPI_D_INST_INTERNAL_28 : std_logic ;
  signal CPI_D_INST_INTERNAL_29 : std_logic ;
  signal CPI_D_INST_INTERNAL_30 : std_logic ;
  signal CPI_D_CNT_INTERNAL : std_logic ;
  signal CPI_D_CNT_INTERNAL_0 : std_logic ;
  signal CPI_D_TRAP_INTERNAL : std_logic ;
  signal CPI_D_ANNUL_INTERNAL : std_logic ;
  signal CPI_D_PV_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL : std_logic ;
  signal CPI_A_PC_INTERNAL_0 : std_logic ;
  signal CPI_A_PC_INTERNAL_1 : std_logic ;
  signal CPI_A_PC_INTERNAL_2 : std_logic ;
  signal CPI_A_PC_INTERNAL_3 : std_logic ;
  signal CPI_A_PC_INTERNAL_4 : std_logic ;
  signal CPI_A_PC_INTERNAL_5 : std_logic ;
  signal CPI_A_PC_INTERNAL_6 : std_logic ;
  signal CPI_A_PC_INTERNAL_7 : std_logic ;
  signal CPI_A_PC_INTERNAL_8 : std_logic ;
  signal CPI_A_PC_INTERNAL_9 : std_logic ;
  signal CPI_A_PC_INTERNAL_10 : std_logic ;
  signal CPI_A_PC_INTERNAL_11 : std_logic ;
  signal CPI_A_PC_INTERNAL_12 : std_logic ;
  signal CPI_A_PC_INTERNAL_13 : std_logic ;
  signal CPI_A_PC_INTERNAL_14 : std_logic ;
  signal CPI_A_PC_INTERNAL_15 : std_logic ;
  signal CPI_A_PC_INTERNAL_16 : std_logic ;
  signal CPI_A_PC_INTERNAL_17 : std_logic ;
  signal CPI_A_PC_INTERNAL_18 : std_logic ;
  signal CPI_A_PC_INTERNAL_19 : std_logic ;
  signal CPI_A_PC_INTERNAL_20 : std_logic ;
  signal CPI_A_PC_INTERNAL_21 : std_logic ;
  signal CPI_A_PC_INTERNAL_22 : std_logic ;
  signal CPI_A_PC_INTERNAL_23 : std_logic ;
  signal CPI_A_PC_INTERNAL_24 : std_logic ;
  signal CPI_A_PC_INTERNAL_25 : std_logic ;
  signal CPI_A_PC_INTERNAL_26 : std_logic ;
  signal CPI_A_PC_INTERNAL_27 : std_logic ;
  signal CPI_A_PC_INTERNAL_28 : std_logic ;
  signal CPI_A_PC_INTERNAL_29 : std_logic ;
  signal CPI_A_PC_INTERNAL_30 : std_logic ;
  signal CPI_A_INST_INTERNAL : std_logic ;
  signal CPI_A_INST_INTERNAL_0 : std_logic ;
  signal CPI_A_INST_INTERNAL_1 : std_logic ;
  signal CPI_A_INST_INTERNAL_2 : std_logic ;
  signal CPI_A_INST_INTERNAL_3 : std_logic ;
  signal CPI_A_INST_INTERNAL_4 : std_logic ;
  signal CPI_A_INST_INTERNAL_5 : std_logic ;
  signal CPI_A_INST_INTERNAL_6 : std_logic ;
  signal CPI_A_INST_INTERNAL_7 : std_logic ;
  signal CPI_A_INST_INTERNAL_8 : std_logic ;
  signal CPI_A_INST_INTERNAL_9 : std_logic ;
  signal CPI_A_INST_INTERNAL_10 : std_logic ;
  signal CPI_A_INST_INTERNAL_11 : std_logic ;
  signal CPI_A_INST_INTERNAL_12 : std_logic ;
  signal CPI_A_INST_INTERNAL_13 : std_logic ;
  signal CPI_A_INST_INTERNAL_14 : std_logic ;
  signal CPI_A_INST_INTERNAL_15 : std_logic ;
  signal CPI_A_INST_INTERNAL_16 : std_logic ;
  signal CPI_A_INST_INTERNAL_17 : std_logic ;
  signal CPI_A_INST_INTERNAL_18 : std_logic ;
  signal CPI_A_INST_INTERNAL_19 : std_logic ;
  signal CPI_A_INST_INTERNAL_20 : std_logic ;
  signal CPI_A_INST_INTERNAL_21 : std_logic ;
  signal CPI_A_INST_INTERNAL_22 : std_logic ;
  signal CPI_A_INST_INTERNAL_23 : std_logic ;
  signal CPI_A_INST_INTERNAL_24 : std_logic ;
  signal CPI_A_INST_INTERNAL_25 : std_logic ;
  signal CPI_A_INST_INTERNAL_26 : std_logic ;
  signal CPI_A_INST_INTERNAL_27 : std_logic ;
  signal CPI_A_INST_INTERNAL_28 : std_logic ;
  signal CPI_A_INST_INTERNAL_29 : std_logic ;
  signal CPI_A_INST_INTERNAL_30 : std_logic ;
  signal CPI_A_CNT_INTERNAL : std_logic ;
  signal CPI_A_CNT_INTERNAL_0 : std_logic ;
  signal CPI_A_TRAP_INTERNAL : std_logic ;
  signal CPI_A_ANNUL_INTERNAL : std_logic ;
  signal CPI_A_PV_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL : std_logic ;
  signal CPI_E_PC_INTERNAL_0 : std_logic ;
  signal CPI_E_PC_INTERNAL_1 : std_logic ;
  signal CPI_E_PC_INTERNAL_2 : std_logic ;
  signal CPI_E_PC_INTERNAL_3 : std_logic ;
  signal CPI_E_PC_INTERNAL_4 : std_logic ;
  signal CPI_E_PC_INTERNAL_5 : std_logic ;
  signal CPI_E_PC_INTERNAL_6 : std_logic ;
  signal CPI_E_PC_INTERNAL_7 : std_logic ;
  signal CPI_E_PC_INTERNAL_8 : std_logic ;
  signal CPI_E_PC_INTERNAL_9 : std_logic ;
  signal CPI_E_PC_INTERNAL_10 : std_logic ;
  signal CPI_E_PC_INTERNAL_11 : std_logic ;
  signal CPI_E_PC_INTERNAL_12 : std_logic ;
  signal CPI_E_PC_INTERNAL_13 : std_logic ;
  signal CPI_E_PC_INTERNAL_14 : std_logic ;
  signal CPI_E_PC_INTERNAL_15 : std_logic ;
  signal CPI_E_PC_INTERNAL_16 : std_logic ;
  signal CPI_E_PC_INTERNAL_17 : std_logic ;
  signal CPI_E_PC_INTERNAL_18 : std_logic ;
  signal CPI_E_PC_INTERNAL_19 : std_logic ;
  signal CPI_E_PC_INTERNAL_20 : std_logic ;
  signal CPI_E_PC_INTERNAL_21 : std_logic ;
  signal CPI_E_PC_INTERNAL_22 : std_logic ;
  signal CPI_E_PC_INTERNAL_23 : std_logic ;
  signal CPI_E_PC_INTERNAL_24 : std_logic ;
  signal CPI_E_PC_INTERNAL_25 : std_logic ;
  signal CPI_E_PC_INTERNAL_26 : std_logic ;
  signal CPI_E_PC_INTERNAL_27 : std_logic ;
  signal CPI_E_PC_INTERNAL_28 : std_logic ;
  signal CPI_E_PC_INTERNAL_29 : std_logic ;
  signal CPI_E_PC_INTERNAL_30 : std_logic ;
  signal CPI_E_INST_INTERNAL : std_logic ;
  signal CPI_E_INST_INTERNAL_0 : std_logic ;
  signal CPI_E_INST_INTERNAL_1 : std_logic ;
  signal CPI_E_INST_INTERNAL_2 : std_logic ;
  signal CPI_E_INST_INTERNAL_3 : std_logic ;
  signal CPI_E_INST_INTERNAL_4 : std_logic ;
  signal CPI_E_INST_INTERNAL_5 : std_logic ;
  signal CPI_E_INST_INTERNAL_6 : std_logic ;
  signal CPI_E_INST_INTERNAL_7 : std_logic ;
  signal CPI_E_INST_INTERNAL_8 : std_logic ;
  signal CPI_E_INST_INTERNAL_9 : std_logic ;
  signal CPI_E_INST_INTERNAL_10 : std_logic ;
  signal CPI_E_INST_INTERNAL_11 : std_logic ;
  signal CPI_E_INST_INTERNAL_12 : std_logic ;
  signal CPI_E_INST_INTERNAL_13 : std_logic ;
  signal CPI_E_INST_INTERNAL_14 : std_logic ;
  signal CPI_E_INST_INTERNAL_15 : std_logic ;
  signal CPI_E_INST_INTERNAL_16 : std_logic ;
  signal CPI_E_INST_INTERNAL_17 : std_logic ;
  signal CPI_E_INST_INTERNAL_18 : std_logic ;
  signal CPI_E_INST_INTERNAL_19 : std_logic ;
  signal CPI_E_INST_INTERNAL_20 : std_logic ;
  signal CPI_E_INST_INTERNAL_21 : std_logic ;
  signal CPI_E_INST_INTERNAL_22 : std_logic ;
  signal CPI_E_INST_INTERNAL_23 : std_logic ;
  signal CPI_E_INST_INTERNAL_24 : std_logic ;
  signal CPI_E_INST_INTERNAL_25 : std_logic ;
  signal CPI_E_INST_INTERNAL_26 : std_logic ;
  signal CPI_E_INST_INTERNAL_27 : std_logic ;
  signal CPI_E_INST_INTERNAL_28 : std_logic ;
  signal CPI_E_INST_INTERNAL_29 : std_logic ;
  signal CPI_E_INST_INTERNAL_30 : std_logic ;
  signal CPI_E_CNT_INTERNAL : std_logic ;
  signal CPI_E_CNT_INTERNAL_0 : std_logic ;
  signal CPI_E_TRAP_INTERNAL : std_logic ;
  signal CPI_E_ANNUL_INTERNAL : std_logic ;
  signal CPI_E_PV_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL : std_logic ;
  signal CPI_M_PC_INTERNAL_0 : std_logic ;
  signal CPI_M_PC_INTERNAL_1 : std_logic ;
  signal CPI_M_PC_INTERNAL_2 : std_logic ;
  signal CPI_M_PC_INTERNAL_3 : std_logic ;
  signal CPI_M_PC_INTERNAL_4 : std_logic ;
  signal CPI_M_PC_INTERNAL_5 : std_logic ;
  signal CPI_M_PC_INTERNAL_6 : std_logic ;
  signal CPI_M_PC_INTERNAL_7 : std_logic ;
  signal CPI_M_PC_INTERNAL_8 : std_logic ;
  signal CPI_M_PC_INTERNAL_9 : std_logic ;
  signal CPI_M_PC_INTERNAL_10 : std_logic ;
  signal CPI_M_PC_INTERNAL_11 : std_logic ;
  signal CPI_M_PC_INTERNAL_12 : std_logic ;
  signal CPI_M_PC_INTERNAL_13 : std_logic ;
  signal CPI_M_PC_INTERNAL_14 : std_logic ;
  signal CPI_M_PC_INTERNAL_15 : std_logic ;
  signal CPI_M_PC_INTERNAL_16 : std_logic ;
  signal CPI_M_PC_INTERNAL_17 : std_logic ;
  signal CPI_M_PC_INTERNAL_18 : std_logic ;
  signal CPI_M_PC_INTERNAL_19 : std_logic ;
  signal CPI_M_PC_INTERNAL_20 : std_logic ;
  signal CPI_M_PC_INTERNAL_21 : std_logic ;
  signal CPI_M_PC_INTERNAL_22 : std_logic ;
  signal CPI_M_PC_INTERNAL_23 : std_logic ;
  signal CPI_M_PC_INTERNAL_24 : std_logic ;
  signal CPI_M_PC_INTERNAL_25 : std_logic ;
  signal CPI_M_PC_INTERNAL_26 : std_logic ;
  signal CPI_M_PC_INTERNAL_27 : std_logic ;
  signal CPI_M_PC_INTERNAL_28 : std_logic ;
  signal CPI_M_PC_INTERNAL_29 : std_logic ;
  signal CPI_M_PC_INTERNAL_30 : std_logic ;
  signal CPI_M_INST_INTERNAL : std_logic ;
  signal CPI_M_INST_INTERNAL_0 : std_logic ;
  signal CPI_M_INST_INTERNAL_1 : std_logic ;
  signal CPI_M_INST_INTERNAL_2 : std_logic ;
  signal CPI_M_INST_INTERNAL_3 : std_logic ;
  signal CPI_M_INST_INTERNAL_4 : std_logic ;
  signal CPI_M_INST_INTERNAL_5 : std_logic ;
  signal CPI_M_INST_INTERNAL_6 : std_logic ;
  signal CPI_M_INST_INTERNAL_7 : std_logic ;
  signal CPI_M_INST_INTERNAL_8 : std_logic ;
  signal CPI_M_INST_INTERNAL_9 : std_logic ;
  signal CPI_M_INST_INTERNAL_10 : std_logic ;
  signal CPI_M_INST_INTERNAL_11 : std_logic ;
  signal CPI_M_INST_INTERNAL_12 : std_logic ;
  signal CPI_M_INST_INTERNAL_13 : std_logic ;
  signal CPI_M_INST_INTERNAL_14 : std_logic ;
  signal CPI_M_INST_INTERNAL_15 : std_logic ;
  signal CPI_M_INST_INTERNAL_16 : std_logic ;
  signal CPI_M_INST_INTERNAL_17 : std_logic ;
  signal CPI_M_INST_INTERNAL_18 : std_logic ;
  signal CPI_M_INST_INTERNAL_19 : std_logic ;
  signal CPI_M_INST_INTERNAL_20 : std_logic ;
  signal CPI_M_INST_INTERNAL_21 : std_logic ;
  signal CPI_M_INST_INTERNAL_22 : std_logic ;
  signal CPI_M_INST_INTERNAL_23 : std_logic ;
  signal CPI_M_INST_INTERNAL_24 : std_logic ;
  signal CPI_M_INST_INTERNAL_25 : std_logic ;
  signal CPI_M_INST_INTERNAL_26 : std_logic ;
  signal CPI_M_INST_INTERNAL_27 : std_logic ;
  signal CPI_M_INST_INTERNAL_28 : std_logic ;
  signal CPI_M_INST_INTERNAL_29 : std_logic ;
  signal CPI_M_INST_INTERNAL_30 : std_logic ;
  signal CPI_M_CNT_INTERNAL : std_logic ;
  signal CPI_M_CNT_INTERNAL_0 : std_logic ;
  signal CPI_M_TRAP_INTERNAL : std_logic ;
  signal CPI_M_ANNUL_INTERNAL : std_logic ;
  signal CPI_M_PV_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL : std_logic ;
  signal CPI_X_PC_INTERNAL_0 : std_logic ;
  signal CPI_X_PC_INTERNAL_1 : std_logic ;
  signal CPI_X_PC_INTERNAL_2 : std_logic ;
  signal CPI_X_PC_INTERNAL_3 : std_logic ;
  signal CPI_X_PC_INTERNAL_4 : std_logic ;
  signal CPI_X_PC_INTERNAL_5 : std_logic ;
  signal CPI_X_PC_INTERNAL_6 : std_logic ;
  signal CPI_X_PC_INTERNAL_7 : std_logic ;
  signal CPI_X_PC_INTERNAL_8 : std_logic ;
  signal CPI_X_PC_INTERNAL_9 : std_logic ;
  signal CPI_X_PC_INTERNAL_10 : std_logic ;
  signal CPI_X_PC_INTERNAL_11 : std_logic ;
  signal CPI_X_PC_INTERNAL_12 : std_logic ;
  signal CPI_X_PC_INTERNAL_13 : std_logic ;
  signal CPI_X_PC_INTERNAL_14 : std_logic ;
  signal CPI_X_PC_INTERNAL_15 : std_logic ;
  signal CPI_X_PC_INTERNAL_16 : std_logic ;
  signal CPI_X_PC_INTERNAL_17 : std_logic ;
  signal CPI_X_PC_INTERNAL_18 : std_logic ;
  signal CPI_X_PC_INTERNAL_19 : std_logic ;
  signal CPI_X_PC_INTERNAL_20 : std_logic ;
  signal CPI_X_PC_INTERNAL_21 : std_logic ;
  signal CPI_X_PC_INTERNAL_22 : std_logic ;
  signal CPI_X_PC_INTERNAL_23 : std_logic ;
  signal CPI_X_PC_INTERNAL_24 : std_logic ;
  signal CPI_X_PC_INTERNAL_25 : std_logic ;
  signal CPI_X_PC_INTERNAL_26 : std_logic ;
  signal CPI_X_PC_INTERNAL_27 : std_logic ;
  signal CPI_X_PC_INTERNAL_28 : std_logic ;
  signal CPI_X_PC_INTERNAL_29 : std_logic ;
  signal CPI_X_PC_INTERNAL_30 : std_logic ;
  signal CPI_X_INST_INTERNAL : std_logic ;
  signal CPI_X_INST_INTERNAL_0 : std_logic ;
  signal CPI_X_INST_INTERNAL_1 : std_logic ;
  signal CPI_X_INST_INTERNAL_2 : std_logic ;
  signal CPI_X_INST_INTERNAL_3 : std_logic ;
  signal CPI_X_INST_INTERNAL_4 : std_logic ;
  signal CPI_X_INST_INTERNAL_5 : std_logic ;
  signal CPI_X_INST_INTERNAL_6 : std_logic ;
  signal CPI_X_INST_INTERNAL_7 : std_logic ;
  signal CPI_X_INST_INTERNAL_8 : std_logic ;
  signal CPI_X_INST_INTERNAL_9 : std_logic ;
  signal CPI_X_INST_INTERNAL_10 : std_logic ;
  signal CPI_X_INST_INTERNAL_11 : std_logic ;
  signal CPI_X_INST_INTERNAL_12 : std_logic ;
  signal CPI_X_INST_INTERNAL_13 : std_logic ;
  signal CPI_X_INST_INTERNAL_14 : std_logic ;
  signal CPI_X_INST_INTERNAL_15 : std_logic ;
  signal CPI_X_INST_INTERNAL_16 : std_logic ;
  signal CPI_X_INST_INTERNAL_17 : std_logic ;
  signal CPI_X_INST_INTERNAL_18 : std_logic ;
  signal CPI_X_INST_INTERNAL_19 : std_logic ;
  signal CPI_X_INST_INTERNAL_20 : std_logic ;
  signal CPI_X_INST_INTERNAL_21 : std_logic ;
  signal CPI_X_INST_INTERNAL_22 : std_logic ;
  signal CPI_X_INST_INTERNAL_23 : std_logic ;
  signal CPI_X_INST_INTERNAL_24 : std_logic ;
  signal CPI_X_INST_INTERNAL_25 : std_logic ;
  signal CPI_X_INST_INTERNAL_26 : std_logic ;
  signal CPI_X_INST_INTERNAL_27 : std_logic ;
  signal CPI_X_INST_INTERNAL_28 : std_logic ;
  signal CPI_X_INST_INTERNAL_29 : std_logic ;
  signal CPI_X_INST_INTERNAL_30 : std_logic ;
  signal CPI_X_CNT_INTERNAL : std_logic ;
  signal CPI_X_CNT_INTERNAL_0 : std_logic ;
  signal CPI_X_TRAP_INTERNAL : std_logic ;
  signal CPI_X_ANNUL_INTERNAL : std_logic ;
  signal CPI_X_PV_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL : std_logic ;
  signal CPI_LDDATA_INTERNAL_0 : std_logic ;
  signal CPI_LDDATA_INTERNAL_1 : std_logic ;
  signal CPI_LDDATA_INTERNAL_2 : std_logic ;
  signal CPI_LDDATA_INTERNAL_3 : std_logic ;
  signal CPI_LDDATA_INTERNAL_4 : std_logic ;
  signal CPI_LDDATA_INTERNAL_5 : std_logic ;
  signal CPI_LDDATA_INTERNAL_6 : std_logic ;
  signal CPI_LDDATA_INTERNAL_7 : std_logic ;
  signal CPI_LDDATA_INTERNAL_8 : std_logic ;
  signal CPI_LDDATA_INTERNAL_9 : std_logic ;
  signal CPI_LDDATA_INTERNAL_10 : std_logic ;
  signal CPI_LDDATA_INTERNAL_11 : std_logic ;
  signal CPI_LDDATA_INTERNAL_12 : std_logic ;
  signal CPI_LDDATA_INTERNAL_13 : std_logic ;
  signal CPI_LDDATA_INTERNAL_14 : std_logic ;
  signal CPI_LDDATA_INTERNAL_15 : std_logic ;
  signal CPI_LDDATA_INTERNAL_16 : std_logic ;
  signal CPI_LDDATA_INTERNAL_17 : std_logic ;
  signal CPI_LDDATA_INTERNAL_18 : std_logic ;
  signal CPI_LDDATA_INTERNAL_19 : std_logic ;
  signal CPI_LDDATA_INTERNAL_20 : std_logic ;
  signal CPI_LDDATA_INTERNAL_21 : std_logic ;
  signal CPI_LDDATA_INTERNAL_22 : std_logic ;
  signal CPI_LDDATA_INTERNAL_23 : std_logic ;
  signal CPI_LDDATA_INTERNAL_24 : std_logic ;
  signal CPI_LDDATA_INTERNAL_25 : std_logic ;
  signal CPI_LDDATA_INTERNAL_26 : std_logic ;
  signal CPI_LDDATA_INTERNAL_27 : std_logic ;
  signal CPI_LDDATA_INTERNAL_28 : std_logic ;
  signal CPI_LDDATA_INTERNAL_29 : std_logic ;
  signal CPI_LDDATA_INTERNAL_30 : std_logic ;
  signal CPI_DBG_ENABLE_INTERNAL : std_logic ;
  signal CPI_DBG_WRITE_INTERNAL : std_logic ;
  signal CPI_DBG_FSR_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_0 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_1 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_2 : std_logic ;
  signal CPI_DBG_ADDR_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_0 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_1 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_2 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_3 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_4 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_5 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_6 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_7 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_8 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_9 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_10 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_11 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_12 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_13 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_14 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_15 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_16 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_17 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_18 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_19 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_20 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_21 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_22 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_23 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_24 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_25 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_26 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_27 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_28 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_29 : std_logic ;
  signal CPI_DBG_DATA_INTERNAL_30 : std_logic ;
  signal RFO1_DATA1_INTERNAL : std_logic ;
  signal RFO1_DATA1_INTERNAL_0 : std_logic ;
  signal RFO1_DATA1_INTERNAL_1 : std_logic ;
  signal RFO1_DATA1_INTERNAL_2 : std_logic ;
  signal RFO1_DATA1_INTERNAL_3 : std_logic ;
  signal RFO1_DATA1_INTERNAL_4 : std_logic ;
  signal RFO1_DATA1_INTERNAL_5 : std_logic ;
  signal RFO1_DATA1_INTERNAL_6 : std_logic ;
  signal RFO1_DATA1_INTERNAL_7 : std_logic ;
  signal RFO1_DATA1_INTERNAL_8 : std_logic ;
  signal RFO1_DATA1_INTERNAL_9 : std_logic ;
  signal RFO1_DATA1_INTERNAL_10 : std_logic ;
  signal RFO1_DATA1_INTERNAL_11 : std_logic ;
  signal RFO1_DATA1_INTERNAL_12 : std_logic ;
  signal RFO1_DATA1_INTERNAL_13 : std_logic ;
  signal RFO1_DATA1_INTERNAL_14 : std_logic ;
  signal RFO1_DATA1_INTERNAL_15 : std_logic ;
  signal RFO1_DATA1_INTERNAL_16 : std_logic ;
  signal RFO1_DATA1_INTERNAL_17 : std_logic ;
  signal RFO1_DATA1_INTERNAL_18 : std_logic ;
  signal RFO1_DATA1_INTERNAL_19 : std_logic ;
  signal RFO1_DATA1_INTERNAL_20 : std_logic ;
  signal RFO1_DATA1_INTERNAL_21 : std_logic ;
  signal RFO1_DATA1_INTERNAL_22 : std_logic ;
  signal RFO1_DATA1_INTERNAL_23 : std_logic ;
  signal RFO1_DATA1_INTERNAL_24 : std_logic ;
  signal RFO1_DATA1_INTERNAL_25 : std_logic ;
  signal RFO1_DATA1_INTERNAL_26 : std_logic ;
  signal RFO1_DATA1_INTERNAL_27 : std_logic ;
  signal RFO1_DATA1_INTERNAL_28 : std_logic ;
  signal RFO1_DATA1_INTERNAL_29 : std_logic ;
  signal RFO1_DATA1_INTERNAL_30 : std_logic ;
  signal RFO1_DATA2_INTERNAL : std_logic ;
  signal RFO1_DATA2_INTERNAL_0 : std_logic ;
  signal RFO1_DATA2_INTERNAL_1 : std_logic ;
  signal RFO1_DATA2_INTERNAL_2 : std_logic ;
  signal RFO1_DATA2_INTERNAL_3 : std_logic ;
  signal RFO1_DATA2_INTERNAL_4 : std_logic ;
  signal RFO1_DATA2_INTERNAL_5 : std_logic ;
  signal RFO1_DATA2_INTERNAL_6 : std_logic ;
  signal RFO1_DATA2_INTERNAL_7 : std_logic ;
  signal RFO1_DATA2_INTERNAL_8 : std_logic ;
  signal RFO1_DATA2_INTERNAL_9 : std_logic ;
  signal RFO1_DATA2_INTERNAL_10 : std_logic ;
  signal RFO1_DATA2_INTERNAL_11 : std_logic ;
  signal RFO1_DATA2_INTERNAL_12 : std_logic ;
  signal RFO1_DATA2_INTERNAL_13 : std_logic ;
  signal RFO1_DATA2_INTERNAL_14 : std_logic ;
  signal RFO1_DATA2_INTERNAL_15 : std_logic ;
  signal RFO1_DATA2_INTERNAL_16 : std_logic ;
  signal RFO1_DATA2_INTERNAL_17 : std_logic ;
  signal RFO1_DATA2_INTERNAL_18 : std_logic ;
  signal RFO1_DATA2_INTERNAL_19 : std_logic ;
  signal RFO1_DATA2_INTERNAL_20 : std_logic ;
  signal RFO1_DATA2_INTERNAL_21 : std_logic ;
  signal RFO1_DATA2_INTERNAL_22 : std_logic ;
  signal RFO1_DATA2_INTERNAL_23 : std_logic ;
  signal RFO1_DATA2_INTERNAL_24 : std_logic ;
  signal RFO1_DATA2_INTERNAL_25 : std_logic ;
  signal RFO1_DATA2_INTERNAL_26 : std_logic ;
  signal RFO1_DATA2_INTERNAL_27 : std_logic ;
  signal RFO1_DATA2_INTERNAL_28 : std_logic ;
  signal RFO1_DATA2_INTERNAL_29 : std_logic ;
  signal RFO1_DATA2_INTERNAL_30 : std_logic ;
  signal RFO2_DATA1_INTERNAL : std_logic ;
  signal RFO2_DATA1_INTERNAL_0 : std_logic ;
  signal RFO2_DATA1_INTERNAL_1 : std_logic ;
  signal RFO2_DATA1_INTERNAL_2 : std_logic ;
  signal RFO2_DATA1_INTERNAL_3 : std_logic ;
  signal RFO2_DATA1_INTERNAL_4 : std_logic ;
  signal RFO2_DATA1_INTERNAL_5 : std_logic ;
  signal RFO2_DATA1_INTERNAL_6 : std_logic ;
  signal RFO2_DATA1_INTERNAL_7 : std_logic ;
  signal RFO2_DATA1_INTERNAL_8 : std_logic ;
  signal RFO2_DATA1_INTERNAL_9 : std_logic ;
  signal RFO2_DATA1_INTERNAL_10 : std_logic ;
  signal RFO2_DATA1_INTERNAL_11 : std_logic ;
  signal RFO2_DATA1_INTERNAL_12 : std_logic ;
  signal RFO2_DATA1_INTERNAL_13 : std_logic ;
  signal RFO2_DATA1_INTERNAL_14 : std_logic ;
  signal RFO2_DATA1_INTERNAL_15 : std_logic ;
  signal RFO2_DATA1_INTERNAL_16 : std_logic ;
  signal RFO2_DATA1_INTERNAL_17 : std_logic ;
  signal RFO2_DATA1_INTERNAL_18 : std_logic ;
  signal RFO2_DATA1_INTERNAL_19 : std_logic ;
  signal RFO2_DATA1_INTERNAL_20 : std_logic ;
  signal RFO2_DATA1_INTERNAL_21 : std_logic ;
  signal RFO2_DATA1_INTERNAL_22 : std_logic ;
  signal RFO2_DATA1_INTERNAL_23 : std_logic ;
  signal RFO2_DATA1_INTERNAL_24 : std_logic ;
  signal RFO2_DATA1_INTERNAL_25 : std_logic ;
  signal RFO2_DATA1_INTERNAL_26 : std_logic ;
  signal RFO2_DATA1_INTERNAL_27 : std_logic ;
  signal RFO2_DATA1_INTERNAL_28 : std_logic ;
  signal RFO2_DATA1_INTERNAL_29 : std_logic ;
  signal RFO2_DATA1_INTERNAL_30 : std_logic ;
  signal RFO2_DATA2_INTERNAL : std_logic ;
  signal RFO2_DATA2_INTERNAL_0 : std_logic ;
  signal RFO2_DATA2_INTERNAL_1 : std_logic ;
  signal RFO2_DATA2_INTERNAL_2 : std_logic ;
  signal RFO2_DATA2_INTERNAL_3 : std_logic ;
  signal RFO2_DATA2_INTERNAL_4 : std_logic ;
  signal RFO2_DATA2_INTERNAL_5 : std_logic ;
  signal RFO2_DATA2_INTERNAL_6 : std_logic ;
  signal RFO2_DATA2_INTERNAL_7 : std_logic ;
  signal RFO2_DATA2_INTERNAL_8 : std_logic ;
  signal RFO2_DATA2_INTERNAL_9 : std_logic ;
  signal RFO2_DATA2_INTERNAL_10 : std_logic ;
  signal RFO2_DATA2_INTERNAL_11 : std_logic ;
  signal RFO2_DATA2_INTERNAL_12 : std_logic ;
  signal RFO2_DATA2_INTERNAL_13 : std_logic ;
  signal RFO2_DATA2_INTERNAL_14 : std_logic ;
  signal RFO2_DATA2_INTERNAL_15 : std_logic ;
  signal RFO2_DATA2_INTERNAL_16 : std_logic ;
  signal RFO2_DATA2_INTERNAL_17 : std_logic ;
  signal RFO2_DATA2_INTERNAL_18 : std_logic ;
  signal RFO2_DATA2_INTERNAL_19 : std_logic ;
  signal RFO2_DATA2_INTERNAL_20 : std_logic ;
  signal RFO2_DATA2_INTERNAL_21 : std_logic ;
  signal RFO2_DATA2_INTERNAL_22 : std_logic ;
  signal RFO2_DATA2_INTERNAL_23 : std_logic ;
  signal RFO2_DATA2_INTERNAL_24 : std_logic ;
  signal RFO2_DATA2_INTERNAL_25 : std_logic ;
  signal RFO2_DATA2_INTERNAL_26 : std_logic ;
  signal RFO2_DATA2_INTERNAL_27 : std_logic ;
  signal RFO2_DATA2_INTERNAL_28 : std_logic ;
  signal RFO2_DATA2_INTERNAL_29 : std_logic ;
  signal RFO2_DATA2_INTERNAL_30 : std_logic ;
  signal GND : std_logic ;
  signal VCC : std_logic ;
  signal \GRLFPC20.FPI.START\ : std_logic ;
  signal \GRLFPC20.FPI.RST\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY\ : std_logic ;
  signal \GRLFPC20.R.X.LD\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.SEQERR\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D\ : std_logic ;
  signal \GRLFPC20.R.A.RS2D\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ\ : std_logic ;
  signal \GRLFPC20.R.MK.RST\ : std_logic ;
  signal \GRLFPC20.R.MK.RST2\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN1\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP\ : std_logic ;
  signal \GRLFPC20.R.A.ST\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR\ : std_logic ;
  signal \GRLFPC20.R.MK.HOLDN2\ : std_logic ;
  signal \GRLFPC20.R.I.V\ : std_logic ;
  signal \GRLFPC20.R.M.LD\ : std_logic ;
  signal \GRLFPC20.R.E.LD\ : std_logic ;
  signal \GRLFPC20.R.A.LD\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP\ : std_logic ;
  signal \GRLFPC20.R.MK.LDOP\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ\ : std_logic ;
  signal \GRLFPC20.R.A.MOV\ : std_logic ;
  signal \GRLFPC20.R.I.RDD\ : std_logic ;
  signal \GRLFPC20.R.X.RDD\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD\ : std_logic ;
  signal \GRLFPC20.COMB.RS2D_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.MK.RST_1\ : std_logic ;
  signal \GRLFPC20.N_2002\ : std_logic ;
  signal \GRLFPC20.N_316\ : std_logic ;
  signal \GRLFPC20.N_317\ : std_logic ;
  signal \GRLFPC20.N_318\ : std_logic ;
  signal \GRLFPC20.N_320\ : std_logic ;
  signal \GRLFPC20.N_321\ : std_logic ;
  signal \GRLFPC20.N_322\ : std_logic ;
  signal \GRLFPC20.N_2563\ : std_logic ;
  signal \GRLFPC20.N_2565\ : std_logic ;
  signal \GRLFPC20.N_2567\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.RNDMODESELECT.TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_259__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_317__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4756\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4718\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4376\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4758\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9271\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9272\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9273\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9274\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9275\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9276\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9277\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9278\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9279\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9280\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9281\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9282\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9283\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9284\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9285\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9286\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9287\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9288\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9289\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9290\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9291\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9292\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9293\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9294\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9295\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9296\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9297\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9298\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9299\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9300\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9303\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9304\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9305\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9306\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9307\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9308\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9309\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9310\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9311\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9312\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9313\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9314\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9315\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9316\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9317\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9318\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9319\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9320\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9321\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9322\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9323\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9324\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9325\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9326\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9327\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9328\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9331\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9332\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9333\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9334\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9335\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9336\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9337\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9338\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9339\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9340\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9341\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9342\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9343\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9344\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9345\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9346\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9347\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9348\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9349\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9350\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9351\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9352\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9353\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9354\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9355\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9356\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9357\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9358\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9359\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9360\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9361\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9362\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9363\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9364\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9365\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9366\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9367\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9368\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9369\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9370\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9371\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9372\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9373\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9374\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9375\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9376\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9377\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9378\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9379\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9380\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9381\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9382\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9383\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9384\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9385\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9386\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9387\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9388\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10122\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10862\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3967\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN38_PCTRL_NEW_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4296\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_46__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_8__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_2__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_319__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_316__N_6_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_262__N_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_260__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_86__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_86__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G2\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.A.ST_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.A.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.COMB.RS1D_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.NONSTD_0_0_G2\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.X.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.M.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.LD_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.FPOP_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.AFSR_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.E.AFQ_0_0_G1\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_0__G4\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__G4\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_17__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_19__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_20__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_21__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_0__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.RD_0_0_1__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_0__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_1__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_2__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_3__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.TEM_1_0_4__G2\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.STATE_0_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__N_5\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_2__G2\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_0__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_2__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_3__G1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G1\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_4__G3\ : std_logic ;
  signal N_12534 : std_logic ;
  signal N_12535 : std_logic ;
  signal N_12733 : std_logic ;
  signal N_12758 : std_logic ;
  signal N_12783 : std_logic ;
  signal N_12822 : std_logic ;
  signal N_12839 : std_logic ;
  signal N_12854 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4724_I\ : std_logic ;
  signal N_13993 : std_logic ;
  signal N_13994 : std_logic ;
  signal N_13995 : std_logic ;
  signal N_13996 : std_logic ;
  signal N_13997 : std_logic ;
  signal N_13998 : std_logic ;
  signal N_13999 : std_logic ;
  signal N_14000 : std_logic ;
  signal N_14001 : std_logic ;
  signal N_14002 : std_logic ;
  signal N_14003 : std_logic ;
  signal N_14004 : std_logic ;
  signal N_14005 : std_logic ;
  signal N_14006 : std_logic ;
  signal N_14007 : std_logic ;
  signal RST_INTERNAL : std_logic ;
  signal \GRLFPC20.N_1803\ : std_logic ;
  signal \GRLFPC20.N_1805\ : std_logic ;
  signal \GRLFPC20.N_1174\ : std_logic ;
  signal N_15103 : std_logic ;
  signal N_15106 : std_logic ;
  signal N_15107 : std_logic ;
  signal N_15108 : std_logic ;
  signal N_15109 : std_logic ;
  signal N_15110 : std_logic ;
  signal N_15111 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8452\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8453\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4455\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8444\ : std_logic ;
  signal \GRLFPC20.N_925_2\ : std_logic ;
  signal \GRLFPC20.N_3745\ : std_logic ;
  signal \GRLFPC20.N_953\ : std_logic ;
  signal \GRLFPC20.UN1_FPOP7_1\ : std_logic ;
  signal \GRLFPC20.N_3739\ : std_logic ;
  signal \GRLFPC20.N_3751\ : std_logic ;
  signal \GRLFPC20.N_2306\ : std_logic ;
  signal \GRLFPC20.N_3763\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D_0_0_G4\ : std_logic ;
  signal \GRLFPC20.N_953_1\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.I7_MUX\ : std_logic ;
  signal \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\ : std_logic ;
  signal \GRLFPC20.RS1D_CNST\ : std_logic ;
  signal \GRLFPC20.N_921\ : std_logic ;
  signal \GRLFPC20.N_2316\ : std_logic ;
  signal \GRLFPC20.N_3655\ : std_logic ;
  signal \GRLFPC20.N_3662\ : std_logic ;
  signal N_12971 : std_logic ;
  signal \GRLFPC20.N_3185\ : std_logic ;
  signal \GRLFPC20.N_1978\ : std_logic ;
  signal \GRLFPC20.N_3742\ : std_logic ;
  signal \GRLFPC20.N_3769\ : std_logic ;
  signal \GRLFPC20.N_1171\ : std_logic ;
  signal \GRLFPC20.N_1981\ : std_logic ;
  signal \GRLFPC20.N_3748\ : std_logic ;
  signal \GRLFPC20.N_3737\ : std_logic ;
  signal \GRLFPC20.N_3731\ : std_logic ;
  signal \GRLFPC20.N_3728\ : std_logic ;
  signal \GRLFPC20.N_3749_1\ : std_logic ;
  signal \GRLFPC20.N_3749\ : std_logic ;
  signal \GRLFPC20.COMB.SEQERR.UN3_QNE_1\ : std_logic ;
  signal \GRLFPC20.R.A.SEQERR_0_0_0__G3\ : std_logic ;
  signal \GRLFPC20.N_2392\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7266\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7139\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7244\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7213\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7211\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.REMWTAGE57.55.TRFWWBASICCELL.CIN_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_32\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO3\ : std_logic ;
  signal N_12946_1 : std_logic ;
  signal \GRLFPC20.N_3459\ : std_logic ;
  signal \GRLFPC20.N_3663\ : std_logic ;
  signal \GRLFPC20.N_3767\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_M\ : std_logic ;
  signal \GRLFPC20.N_1212\ : std_logic ;
  signal \GRLFPC20.N_2126\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_ANNULFPU\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\ : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_3__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9920\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9251\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9046\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9831\ : std_logic ;
  signal \GRLFPC20.N_3401\ : std_logic ;
  signal N_10421 : std_logic ;
  signal \GRLFPC20.FPO.SIGN\ : std_logic ;
  signal \GRLFPC20.N_2686\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4931\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9947\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9950\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4066\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7462\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4367\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4132\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7422\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7413\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_35__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_47__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_42__G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9940\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9943\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9261\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9931\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9262\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.TEMP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5207\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4312\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3990\ : std_logic ;
  signal N_12556 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7124\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7182\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7155\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10505\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7094\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5478\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5477\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN13_NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_GEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN13_GEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN3_GEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7095\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5544\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9889\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9829\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9220\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7528\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4769\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9267\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5437\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9660\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9036\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9936\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9449\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_5_MUX\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9917\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9248\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.I.V_1\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_28__G2\ : std_logic ;
  signal N_12853 : std_logic ;
  signal \GRLFPC20.N_3407\ : std_logic ;
  signal \GRLFPC20.N_3406\ : std_logic ;
  signal \GRLFPC20.COMB.ISFPOP2_1\ : std_logic ;
  signal \GRLFPC20.N_1147\ : std_logic ;
  signal N_12854_2 : std_logic ;
  signal \GRLFPC20.N_1694\ : std_logic ;
  signal \GRLFPC20.N_1270\ : std_logic ;
  signal \GRLFPC20.N_1508\ : std_logic ;
  signal \GRLFPC20.N_1257\ : std_logic ;
  signal \GRLFPC20.R.I.V_1_0_G0\ : std_logic ;
  signal N_12891_1 : std_logic ;
  signal \GRLFPC20.COMB.V.I.V_1_F1\ : std_logic ;
  signal \GRLFPC20.N_1635\ : std_logic ;
  signal \GRLFPC20.WREN2_2_SQMUXA_1_1\ : std_logic ;
  signal \GRLFPC20.N_1661\ : std_logic ;
  signal \GRLFPC20.N_1883\ : std_logic ;
  signal \GRLFPC20.N_2132\ : std_logic ;
  signal \GRLFPC20.N_1241\ : std_logic ;
  signal \GRLFPC20.N_1536\ : std_logic ;
  signal \GRLFPC20.N_1714\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_1__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10002\ : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_2_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7114\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7271\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7720\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_4\ : std_logic ;
  signal N_11016 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1505_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1502_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7333\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7329\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7789\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7231\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9615\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_29__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9994\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9986\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9996\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9991\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9992\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10003\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_20__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9055\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9901\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9822\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9232\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9037\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9934\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9265\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4682\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10305\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9885\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9216\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9641\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.UN10_AREGSIGN_SEL_I_M\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8445\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9595\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9592\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9634\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9609\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9605\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9063\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9919\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9250\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7502\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN20_LOCOV_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9896\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9227\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5421\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5420\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_6_0_67__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10011\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_0__G2\ : std_logic ;
  signal \GRLFPC20.N_3395\ : std_logic ;
  signal \GRLFPC20.N_3399\ : std_logic ;
  signal \GRLFPC20.N_3400\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_12__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_18__G2\ : std_logic ;
  signal \GRLFPC20.R.E.STDATA_1_0_19__G2\ : std_logic ;
  signal \GRLFPC20.N_3417\ : std_logic ;
  signal \GRLFPC20.N_3423\ : std_logic ;
  signal N_12705 : std_logic ;
  signal N_12683 : std_logic ;
  signal N_12661 : std_logic ;
  signal N_12639 : std_logic ;
  signal N_12617 : std_logic ;
  signal N_12595 : std_logic ;
  signal N_12573 : std_logic ;
  signal \GRLFPC20.R.I.EXC_2_0_2__G3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10583\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN4_TFCC_M\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9902\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9505\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9452\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9233\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9633\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9916\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9898\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9893\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9892\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9832\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9890\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9830\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9888\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9828\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9638\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9597\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9612\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9611\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9610\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9593\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9606\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9590\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9603\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9613\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9247\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9229\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9224\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9223\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9221\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9219\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9933\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9932\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9930\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9929\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9928\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9925\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9924\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9922\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9921\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9918\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9915\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9914\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9913\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9912\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9911\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9910\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9909\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9907\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9906\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9905\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9904\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9903\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9899\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9897\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9894\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9827\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9886\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9884\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9883\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9663\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9268\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9090\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9264\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9263\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9260\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9259\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9082\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9256\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9255\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9253\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9252\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9249\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9246\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9245\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9244\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9243\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9242\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9241\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9240\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9238\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9237\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9236\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9235\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9234\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9230\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9228\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9226\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9225\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9042\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9217\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9215\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9214\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9995\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9608\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9594\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9607\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9591\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9604\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9614\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9987\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9993\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9035\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9820\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9664\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9662\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9661\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9659\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9656\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9926\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9923\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9667\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9665\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9257\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9254\ : std_logic ;
  signal N_12726 : std_logic ;
  signal N_10346 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10521\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10518\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10512\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5413\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5496\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5493\ : std_logic ;
  signal \GRLFPC20.N_3738\ : std_logic ;
  signal \GRLFPC20.N_1144_I_M\ : std_logic ;
  signal \GRLFPC20.N_1142\ : std_logic ;
  signal \GRLFPC20.N_1145_I_M\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4030\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4035\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4137\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4286\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7455\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4034\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5485\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5487\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5450\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4933\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5446\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN14_EXMIPTRLSBS\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN4_NOTSTICKYINFORSR\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_10\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_16\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_21\ : std_logic ;
  signal N_10350 : std_logic ;
  signal N_10349 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7324\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_536_I_0_TZ\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_ANNULFPU_TZ_TZ\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_221_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\ : std_logic ;
  signal N_16975 : std_logic ;
  signal N_16976 : std_logic ;
  signal N_16978 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN\ : std_logic ;
  signal N_17003 : std_logic ;
  signal N_17005 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_C\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_D\ : std_logic ;
  signal N_17013 : std_logic ;
  signal N_17014 : std_logic ;
  signal D_N_2 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0_TZ\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\ : std_logic ;
  signal N_12576_2 : std_logic ;
  signal N_18707 : std_logic ;
  signal N_18709 : std_logic ;
  signal N_18711 : std_logic ;
  signal N_18713 : std_logic ;
  signal N_18715 : std_logic ;
  signal N_18717 : std_logic ;
  signal N_18719 : std_logic ;
  signal N_18721 : std_logic ;
  signal N_18723 : std_logic ;
  signal N_18725 : std_logic ;
  signal N_18727 : std_logic ;
  signal N_18729 : std_logic ;
  signal N_18731 : std_logic ;
  signal N_18733 : std_logic ;
  signal N_18735 : std_logic ;
  signal N_18737 : std_logic ;
  signal N_18739 : std_logic ;
  signal N_18741 : std_logic ;
  signal N_18743 : std_logic ;
  signal N_18745 : std_logic ;
  signal N_18747 : std_logic ;
  signal N_18749 : std_logic ;
  signal N_18751 : std_logic ;
  signal N_18753 : std_logic ;
  signal N_18755 : std_logic ;
  signal N_18757 : std_logic ;
  signal N_18759 : std_logic ;
  signal N_18761 : std_logic ;
  signal N_18763 : std_logic ;
  signal N_18765 : std_logic ;
  signal N_18767 : std_logic ;
  signal N_18769 : std_logic ;
  signal N_18771 : std_logic ;
  signal N_18773 : std_logic ;
  signal N_18775 : std_logic ;
  signal N_18777 : std_logic ;
  signal N_18779 : std_logic ;
  signal N_18781 : std_logic ;
  signal N_18783 : std_logic ;
  signal N_18785 : std_logic ;
  signal N_18787 : std_logic ;
  signal N_18789 : std_logic ;
  signal N_18791 : std_logic ;
  signal N_18793 : std_logic ;
  signal N_18795 : std_logic ;
  signal N_18797 : std_logic ;
  signal N_18799 : std_logic ;
  signal N_18801 : std_logic ;
  signal N_18803 : std_logic ;
  signal N_18805 : std_logic ;
  signal N_18807 : std_logic ;
  signal N_18809 : std_logic ;
  signal N_18811 : std_logic ;
  signal N_18813 : std_logic ;
  signal N_18815 : std_logic ;
  signal N_18817 : std_logic ;
  signal N_18819 : std_logic ;
  signal N_18821 : std_logic ;
  signal N_18823 : std_logic ;
  signal N_18825 : std_logic ;
  signal N_18827 : std_logic ;
  signal N_18829 : std_logic ;
  signal N_18831 : std_logic ;
  signal N_18833 : std_logic ;
  signal N_18835 : std_logic ;
  signal N_18837 : std_logic ;
  signal N_18839 : std_logic ;
  signal N_18841 : std_logic ;
  signal N_18843 : std_logic ;
  signal N_18845 : std_logic ;
  signal N_18847 : std_logic ;
  signal N_18849 : std_logic ;
  signal N_18851 : std_logic ;
  signal N_18853 : std_logic ;
  signal N_18855 : std_logic ;
  signal N_18857 : std_logic ;
  signal N_18859 : std_logic ;
  signal N_18861 : std_logic ;
  signal N_18863 : std_logic ;
  signal N_18865 : std_logic ;
  signal N_18867 : std_logic ;
  signal N_18869 : std_logic ;
  signal N_18871 : std_logic ;
  signal N_18873 : std_logic ;
  signal N_18875 : std_logic ;
  signal N_18877 : std_logic ;
  signal N_18879 : std_logic ;
  signal N_18881 : std_logic ;
  signal N_18883 : std_logic ;
  signal N_18885 : std_logic ;
  signal N_18887 : std_logic ;
  signal N_18889 : std_logic ;
  signal N_18891 : std_logic ;
  signal N_18893 : std_logic ;
  signal N_18895 : std_logic ;
  signal N_18897 : std_logic ;
  signal N_18899 : std_logic ;
  signal N_18901 : std_logic ;
  signal N_18903 : std_logic ;
  signal N_18905 : std_logic ;
  signal N_18907 : std_logic ;
  signal N_18909 : std_logic ;
  signal N_18911 : std_logic ;
  signal N_18913 : std_logic ;
  signal N_18915 : std_logic ;
  signal N_18917 : std_logic ;
  signal N_18919 : std_logic ;
  signal N_18921 : std_logic ;
  signal N_18926 : std_logic ;
  signal N_18927 : std_logic ;
  signal N_18933 : std_logic ;
  signal N_18934 : std_logic ;
  signal N_18942 : std_logic ;
  signal N_18949 : std_logic ;
  signal N_18950 : std_logic ;
  signal N_18956 : std_logic ;
  signal N_18957 : std_logic ;
  signal N_18965 : std_logic ;
  signal N_18972 : std_logic ;
  signal N_18973 : std_logic ;
  signal N_18979 : std_logic ;
  signal N_18980 : std_logic ;
  signal N_18988 : std_logic ;
  signal N_18995 : std_logic ;
  signal N_18996 : std_logic ;
  signal N_19002 : std_logic ;
  signal N_19003 : std_logic ;
  signal N_19011 : std_logic ;
  signal N_19018 : std_logic ;
  signal N_19019 : std_logic ;
  signal N_19025 : std_logic ;
  signal N_19026 : std_logic ;
  signal N_19034 : std_logic ;
  signal N_19041 : std_logic ;
  signal N_19042 : std_logic ;
  signal N_19048 : std_logic ;
  signal N_19049 : std_logic ;
  signal N_19057 : std_logic ;
  signal N_19064 : std_logic ;
  signal N_19065 : std_logic ;
  signal N_19071 : std_logic ;
  signal N_19072 : std_logic ;
  signal N_19080 : std_logic ;
  signal N_19087 : std_logic ;
  signal N_19088 : std_logic ;
  signal N_19094 : std_logic ;
  signal N_19095 : std_logic ;
  signal N_19103 : std_logic ;
  signal N_19110 : std_logic ;
  signal N_19111 : std_logic ;
  signal N_19117 : std_logic ;
  signal N_19118 : std_logic ;
  signal N_19126 : std_logic ;
  signal N_19133 : std_logic ;
  signal N_19134 : std_logic ;
  signal N_19140 : std_logic ;
  signal N_19141 : std_logic ;
  signal N_19149 : std_logic ;
  signal N_19156 : std_logic ;
  signal N_19157 : std_logic ;
  signal N_19163 : std_logic ;
  signal N_19164 : std_logic ;
  signal N_19172 : std_logic ;
  signal N_19179 : std_logic ;
  signal N_19180 : std_logic ;
  signal N_19186 : std_logic ;
  signal N_19187 : std_logic ;
  signal N_19195 : std_logic ;
  signal N_19202 : std_logic ;
  signal N_19203 : std_logic ;
  signal N_19209 : std_logic ;
  signal N_19210 : std_logic ;
  signal N_19218 : std_logic ;
  signal N_19225 : std_logic ;
  signal N_19226 : std_logic ;
  signal N_19232 : std_logic ;
  signal N_19233 : std_logic ;
  signal N_19241 : std_logic ;
  signal N_19248 : std_logic ;
  signal N_19249 : std_logic ;
  signal N_19255 : std_logic ;
  signal N_19256 : std_logic ;
  signal N_19264 : std_logic ;
  signal N_19271 : std_logic ;
  signal N_19272 : std_logic ;
  signal N_19278 : std_logic ;
  signal N_19279 : std_logic ;
  signal N_19287 : std_logic ;
  signal N_19294 : std_logic ;
  signal N_19295 : std_logic ;
  signal N_19301 : std_logic ;
  signal N_19302 : std_logic ;
  signal N_19310 : std_logic ;
  signal N_19317 : std_logic ;
  signal N_19318 : std_logic ;
  signal N_19324 : std_logic ;
  signal N_19325 : std_logic ;
  signal N_19333 : std_logic ;
  signal N_19340 : std_logic ;
  signal N_19341 : std_logic ;
  signal N_19347 : std_logic ;
  signal N_19348 : std_logic ;
  signal N_19356 : std_logic ;
  signal N_19363 : std_logic ;
  signal N_19364 : std_logic ;
  signal N_19370 : std_logic ;
  signal N_19371 : std_logic ;
  signal N_19379 : std_logic ;
  signal N_19386 : std_logic ;
  signal N_19387 : std_logic ;
  signal N_19393 : std_logic ;
  signal N_19394 : std_logic ;
  signal N_19402 : std_logic ;
  signal N_19409 : std_logic ;
  signal N_19410 : std_logic ;
  signal N_19416 : std_logic ;
  signal N_19417 : std_logic ;
  signal N_19425 : std_logic ;
  signal N_19432 : std_logic ;
  signal N_19433 : std_logic ;
  signal N_19439 : std_logic ;
  signal N_19440 : std_logic ;
  signal N_19448 : std_logic ;
  signal N_19455 : std_logic ;
  signal N_19456 : std_logic ;
  signal N_19462 : std_logic ;
  signal N_19463 : std_logic ;
  signal N_19471 : std_logic ;
  signal N_19478 : std_logic ;
  signal N_19479 : std_logic ;
  signal N_19485 : std_logic ;
  signal N_19486 : std_logic ;
  signal N_19494 : std_logic ;
  signal N_19501 : std_logic ;
  signal N_19502 : std_logic ;
  signal N_19508 : std_logic ;
  signal N_19509 : std_logic ;
  signal N_19517 : std_logic ;
  signal N_19524 : std_logic ;
  signal N_19525 : std_logic ;
  signal N_19531 : std_logic ;
  signal N_19532 : std_logic ;
  signal N_19540 : std_logic ;
  signal N_19547 : std_logic ;
  signal N_19548 : std_logic ;
  signal N_19554 : std_logic ;
  signal N_19555 : std_logic ;
  signal N_19563 : std_logic ;
  signal N_19570 : std_logic ;
  signal N_19571 : std_logic ;
  signal N_19577 : std_logic ;
  signal N_19578 : std_logic ;
  signal N_19586 : std_logic ;
  signal N_19593 : std_logic ;
  signal N_19594 : std_logic ;
  signal N_19600 : std_logic ;
  signal N_19601 : std_logic ;
  signal N_19609 : std_logic ;
  signal N_19616 : std_logic ;
  signal N_19617 : std_logic ;
  signal N_19623 : std_logic ;
  signal N_19624 : std_logic ;
  signal N_19632 : std_logic ;
  signal N_19639 : std_logic ;
  signal N_19640 : std_logic ;
  signal N_19646 : std_logic ;
  signal N_19647 : std_logic ;
  signal N_19655 : std_logic ;
  signal N_19662 : std_logic ;
  signal N_19663 : std_logic ;
  signal N_19669 : std_logic ;
  signal N_19670 : std_logic ;
  signal N_19678 : std_logic ;
  signal N_19685 : std_logic ;
  signal N_19686 : std_logic ;
  signal N_19692 : std_logic ;
  signal N_19693 : std_logic ;
  signal N_19701 : std_logic ;
  signal N_19708 : std_logic ;
  signal N_19709 : std_logic ;
  signal N_19715 : std_logic ;
  signal N_19716 : std_logic ;
  signal N_19724 : std_logic ;
  signal N_19731 : std_logic ;
  signal N_19732 : std_logic ;
  signal N_19738 : std_logic ;
  signal N_19739 : std_logic ;
  signal N_19747 : std_logic ;
  signal N_19754 : std_logic ;
  signal N_19755 : std_logic ;
  signal N_19761 : std_logic ;
  signal N_19762 : std_logic ;
  signal N_19770 : std_logic ;
  signal N_19777 : std_logic ;
  signal N_19778 : std_logic ;
  signal N_19784 : std_logic ;
  signal N_19785 : std_logic ;
  signal N_19793 : std_logic ;
  signal N_19800 : std_logic ;
  signal N_19801 : std_logic ;
  signal N_19807 : std_logic ;
  signal N_19808 : std_logic ;
  signal N_19816 : std_logic ;
  signal N_19823 : std_logic ;
  signal N_19824 : std_logic ;
  signal N_19830 : std_logic ;
  signal N_19831 : std_logic ;
  signal N_19839 : std_logic ;
  signal N_19846 : std_logic ;
  signal N_19847 : std_logic ;
  signal N_19853 : std_logic ;
  signal N_19854 : std_logic ;
  signal N_19862 : std_logic ;
  signal N_19869 : std_logic ;
  signal N_19870 : std_logic ;
  signal N_19876 : std_logic ;
  signal N_19877 : std_logic ;
  signal N_19885 : std_logic ;
  signal N_19892 : std_logic ;
  signal N_19893 : std_logic ;
  signal N_19899 : std_logic ;
  signal N_19900 : std_logic ;
  signal N_19908 : std_logic ;
  signal N_19915 : std_logic ;
  signal N_19916 : std_logic ;
  signal N_19922 : std_logic ;
  signal N_19923 : std_logic ;
  signal N_19931 : std_logic ;
  signal N_19938 : std_logic ;
  signal N_19939 : std_logic ;
  signal N_19945 : std_logic ;
  signal N_19946 : std_logic ;
  signal N_19954 : std_logic ;
  signal N_19964 : std_logic ;
  signal N_19973 : std_logic ;
  signal N_19974 : std_logic ;
  signal N_19975 : std_logic ;
  signal N_19978 : std_logic ;
  signal N_19979 : std_logic ;
  signal N_19983 : std_logic ;
  signal N_19984 : std_logic ;
  signal N_19990 : std_logic ;
  signal N_19991 : std_logic ;
  signal N_19999 : std_logic ;
  signal N_20006 : std_logic ;
  signal N_20007 : std_logic ;
  signal N_20013 : std_logic ;
  signal N_20014 : std_logic ;
  signal N_20022 : std_logic ;
  signal N_20029 : std_logic ;
  signal N_20030 : std_logic ;
  signal N_20036 : std_logic ;
  signal N_20037 : std_logic ;
  signal N_20045 : std_logic ;
  signal N_20052 : std_logic ;
  signal N_20053 : std_logic ;
  signal N_20059 : std_logic ;
  signal N_20060 : std_logic ;
  signal N_20068 : std_logic ;
  signal N_20075 : std_logic ;
  signal N_20076 : std_logic ;
  signal N_20082 : std_logic ;
  signal N_20083 : std_logic ;
  signal N_20091 : std_logic ;
  signal N_20098 : std_logic ;
  signal N_20099 : std_logic ;
  signal N_20105 : std_logic ;
  signal N_20106 : std_logic ;
  signal N_20114 : std_logic ;
  signal N_20121 : std_logic ;
  signal N_20122 : std_logic ;
  signal N_20128 : std_logic ;
  signal N_20129 : std_logic ;
  signal N_20187 : std_logic ;
  signal N_20188 : std_logic ;
  signal N_20189 : std_logic ;
  signal N_20195 : std_logic ;
  signal N_20196 : std_logic ;
  signal N_20201 : std_logic ;
  signal N_20202 : std_logic ;
  signal N_20207 : std_logic ;
  signal N_20208 : std_logic ;
  signal N_20213 : std_logic ;
  signal N_20214 : std_logic ;
  signal N_20219 : std_logic ;
  signal N_20220 : std_logic ;
  signal N_20225 : std_logic ;
  signal N_20226 : std_logic ;
  signal N_20231 : std_logic ;
  signal N_20232 : std_logic ;
  signal N_20237 : std_logic ;
  signal N_20238 : std_logic ;
  signal N_20243 : std_logic ;
  signal N_20244 : std_logic ;
  signal N_20249 : std_logic ;
  signal N_20250 : std_logic ;
  signal N_20255 : std_logic ;
  signal N_20256 : std_logic ;
  signal N_20261 : std_logic ;
  signal N_20262 : std_logic ;
  signal N_20267 : std_logic ;
  signal N_20268 : std_logic ;
  signal N_20273 : std_logic ;
  signal N_20274 : std_logic ;
  signal N_20279 : std_logic ;
  signal N_20280 : std_logic ;
  signal N_20284 : std_logic ;
  signal N_20378 : std_logic ;
  signal \GRLFPC20.COMB.RS1_1_SN_N_3\ : std_logic ;
  signal \GRLFPC20.N_1180\ : std_logic ;
  signal N_20660 : std_logic ;
  signal N_20662 : std_logic ;
  signal N_20663 : std_logic ;
  signal N_20664 : std_logic ;
  signal N_20665 : std_logic ;
  signal N_20666 : std_logic ;
  signal N_20668 : std_logic ;
  signal N_20669 : std_logic ;
  signal N_20672 : std_logic ;
  signal N_20673 : std_logic ;
  signal N_20674 : std_logic ;
  signal N_20675 : std_logic ;
  signal N_20676 : std_logic ;
  signal N_20677 : std_logic ;
  signal N_20678 : std_logic ;
  signal N_20679 : std_logic ;
  signal N_20680 : std_logic ;
  signal N_20682 : std_logic ;
  signal N_20683 : std_logic ;
  signal N_20684 : std_logic ;
  signal N_20685 : std_logic ;
  signal N_20686 : std_logic ;
  signal N_20687 : std_logic ;
  signal N_20688 : std_logic ;
  signal N_20689 : std_logic ;
  signal N_20692 : std_logic ;
  signal N_20694 : std_logic ;
  signal N_20695 : std_logic ;
  signal N_20696 : std_logic ;
  signal N_20699 : std_logic ;
  signal N_20700 : std_logic ;
  signal N_20701 : std_logic ;
  signal N_20703 : std_logic ;
  signal N_20704 : std_logic ;
  signal N_20705 : std_logic ;
  signal N_20706 : std_logic ;
  signal N_20707 : std_logic ;
  signal N_20708 : std_logic ;
  signal N_20711 : std_logic ;
  signal N_20712 : std_logic ;
  signal N_20714 : std_logic ;
  signal N_20715 : std_logic ;
  signal N_20716 : std_logic ;
  signal N_20718 : std_logic ;
  signal N_20721 : std_logic ;
  signal N_20722 : std_logic ;
  signal N_20723 : std_logic ;
  signal N_20727 : std_logic ;
  signal N_20729 : std_logic ;
  signal N_20732 : std_logic ;
  signal N_20735 : std_logic ;
  signal N_20736 : std_logic ;
  signal N_20738 : std_logic ;
  signal N_20740 : std_logic ;
  signal N_20745 : std_logic ;
  signal N_20746 : std_logic ;
  signal N_20748 : std_logic ;
  signal N_20749 : std_logic ;
  signal N_20750 : std_logic ;
  signal N_20751 : std_logic ;
  signal N_20752 : std_logic ;
  signal N_20753 : std_logic ;
  signal N_20754 : std_logic ;
  signal N_20755 : std_logic ;
  signal N_20757 : std_logic ;
  signal N_20758 : std_logic ;
  signal N_20759 : std_logic ;
  signal N_20760 : std_logic ;
  signal N_20761 : std_logic ;
  signal N_20762 : std_logic ;
  signal N_20763 : std_logic ;
  signal N_20765 : std_logic ;
  signal N_20766 : std_logic ;
  signal N_20768 : std_logic ;
  signal N_20769 : std_logic ;
  signal N_20771 : std_logic ;
  signal N_20773 : std_logic ;
  signal N_20774 : std_logic ;
  signal N_20776 : std_logic ;
  signal N_20777 : std_logic ;
  signal N_20779 : std_logic ;
  signal N_20780 : std_logic ;
  signal N_20781 : std_logic ;
  signal N_20782 : std_logic ;
  signal N_20783 : std_logic ;
  signal N_20784 : std_logic ;
  signal N_20786 : std_logic ;
  signal N_20787 : std_logic ;
  signal N_20789 : std_logic ;
  signal N_20791 : std_logic ;
  signal N_20792 : std_logic ;
  signal N_20794 : std_logic ;
  signal N_20797 : std_logic ;
  signal N_20799 : std_logic ;
  signal N_20800 : std_logic ;
  signal N_20806 : std_logic ;
  signal N_20807 : std_logic ;
  signal N_20808 : std_logic ;
  signal N_20809 : std_logic ;
  signal N_20810 : std_logic ;
  signal N_20811 : std_logic ;
  signal N_20815 : std_logic ;
  signal N_20816 : std_logic ;
  signal N_20817 : std_logic ;
  signal N_20818 : std_logic ;
  signal N_20819 : std_logic ;
  signal N_20820 : std_logic ;
  signal N_20824 : std_logic ;
  signal N_20825 : std_logic ;
  signal N_20826 : std_logic ;
  signal N_20827 : std_logic ;
  signal N_20828 : std_logic ;
  signal N_20829 : std_logic ;
  signal N_20831 : std_logic ;
  signal \GRLFPC20.COMB.UN9_CCV_2\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.ST5_3\ : std_logic ;
  signal \GRLFPC20.RS2_0_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN1_11_IV_1\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV_0\ : std_logic ;
  signal \GRLFPC20.COMB.WREN2_11_IV_1\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_1.M10_0\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD2_4\ : std_logic ;
  signal \GRLFPC20.COMB.FPDECODE.RDD2_5\ : std_logic ;
  signal \GRLFPC20.RS1V_0_SQMUXA_1_0_A2_0\ : std_logic ;
  signal \GRLFPC20.UN1_MOV_1_SQMUXA_0\ : std_logic ;
  signal \GRLFPC20.MOV_2_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.MOV_1_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.MOV_1_SQMUXA_4\ : std_logic ;
  signal \GRLFPC20.R.A.RS1D_0_0_G4_4\ : std_logic ;
  signal \GRLFPC20.R.A.MOV_0_0_G1_4\ : std_logic ;
  signal \GRLFPC20.WREN1_1_SQMUXA_1\ : std_logic ;
  signal \GRLFPC20.ANNULRES_0_SQMUXA_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1_0\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_MEXC_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTBINFNAN_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.AEBEEXC.UN26_NOTAINFNAN_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_745_I_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_769_I_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_15\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_19\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_20\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_23\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_27\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_0_A2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_0_A2_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0_0\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_1\ : std_logic ;
  signal \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_3\ : std_logic ;
  signal \GRLFPC20.N_2249_I_I_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN12_SRTOSTICKY_1\ : std_logic ;
  signal \GRLFPC20.COMB.ANNULRES_1_IV_221_0\ : std_logic ;
  signal \GRLFPC20.R.MK.BUSY2_0_0_G3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.STKGEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_7\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_9\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_17\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_21\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_22\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_24\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_26\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_28\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_30\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_33\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_37\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_39\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_41\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_42\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_43\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_52\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_53\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_54\ : std_logic ;
  signal \GRLFPC20.R.I.EXEC_0_0_G1_0_698_A2_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_0__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_2__G1_1\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\ : std_logic ;
  signal N_12822_3 : std_logic ;
  signal \GRLFPC20.N_1453\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_3_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_2_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7787\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10506\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\ : std_logic ;
  signal \GRLFPC20.N_1342\ : std_logic ;
  signal \GRLFPC20.N_1379\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\ : std_logic ;
  signal \GRLFPC20.COMB.V.E.STDATA2\ : std_logic ;
  signal \GRLFPC20.N_1930\ : std_logic ;
  signal \GRLFPC20.COMB.RDD_2\ : std_logic ;
  signal \GRLFPC20.WRADDR_1_SQMUXA\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_FPCI_4\ : std_logic ;
  signal \GRLFPC20.COMB.UN1_R.A.RS1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7292\ : std_logic ;
  signal \GRLFPC20.WRADDR_0_SQMUXA\ : std_logic ;
  signal \GRLFPC20.N_2174\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7989\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7987\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\ : std_logic ;
  signal N_12871 : std_logic ;
  signal N_23926 : std_logic ;
  signal \GRLFPC20.N_2406_3\ : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__N_7\ : std_logic ;
  signal \GRLFPC20.R.I.PC_1_0_9__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2\ : std_logic ;
  signal N_23932 : std_logic ;
  signal N_23933_I : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\ : std_logic ;
  signal N_24210 : std_logic ;
  signal N_24211 : std_logic ;
  signal N_24212 : std_logic ;
  signal N_24213 : std_logic ;
  signal N_24214 : std_logic ;
  signal N_24215 : std_logic ;
  signal N_24216 : std_logic ;
  signal N_24217 : std_logic ;
  signal N_24218 : std_logic ;
  signal N_24219 : std_logic ;
  signal N_24220 : std_logic ;
  signal N_24221 : std_logic ;
  signal N_24222 : std_logic ;
  signal N_24223 : std_logic ;
  signal N_24224 : std_logic ;
  signal N_24225 : std_logic ;
  signal N_24226 : std_logic ;
  signal N_24227 : std_logic ;
  signal N_24228 : std_logic ;
  signal N_24229 : std_logic ;
  signal N_24230 : std_logic ;
  signal N_24231 : std_logic ;
  signal N_24232 : std_logic ;
  signal N_24233 : std_logic ;
  signal N_24234 : std_logic ;
  signal N_24235 : std_logic ;
  signal N_24236 : std_logic ;
  signal N_24237 : std_logic ;
  signal N_24238 : std_logic ;
  signal N_24239 : std_logic ;
  signal N_24240 : std_logic ;
  signal N_24241 : std_logic ;
  signal N_24242 : std_logic ;
  signal N_24243 : std_logic ;
  signal N_24244 : std_logic ;
  signal N_24245 : std_logic ;
  signal N_24246 : std_logic ;
  signal N_24247 : std_logic ;
  signal N_24248 : std_logic ;
  signal N_24249 : std_logic ;
  signal N_24250 : std_logic ;
  signal N_24251 : std_logic ;
  signal N_24252 : std_logic ;
  signal N_24253 : std_logic ;
  signal N_24254 : std_logic ;
  signal N_24255 : std_logic ;
  signal N_24256 : std_logic ;
  signal N_24257 : std_logic ;
  signal N_24258 : std_logic ;
  signal N_24289 : std_logic ;
  signal N_24291 : std_logic ;
  signal N_24293 : std_logic ;
  signal N_24295 : std_logic ;
  signal N_24297 : std_logic ;
  signal N_24299 : std_logic ;
  signal N_24301 : std_logic ;
  signal N_24303 : std_logic ;
  signal N_24309 : std_logic ;
  signal N_24311 : std_logic ;
  signal N_24313 : std_logic ;
  signal N_24319 : std_logic ;
  signal N_24320 : std_logic ;
  signal N_24321 : std_logic ;
  signal N_24322 : std_logic ;
  signal N_24323 : std_logic ;
  signal N_24324 : std_logic ;
  signal N_24325 : std_logic ;
  signal N_24326 : std_logic ;
  signal N_24327 : std_logic ;
  signal N_24328 : std_logic ;
  signal N_24401 : std_logic ;
  signal N_24403 : std_logic ;
  signal N_24407 : std_logic ;
  signal N_24409 : std_logic ;
  signal N_24411 : std_logic ;
  signal N_24417 : std_logic ;
  signal N_24427 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_5\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_6\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_8\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G4\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G3_1_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_3\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G0_9_2\ : std_logic ;
  signal N_24805 : std_logic ;
  signal N_24806 : std_logic ;
  signal N_24807 : std_logic ;
  signal N_24808 : std_logic ;
  signal N_24809 : std_logic ;
  signal N_24810 : std_logic ;
  signal N_24811 : std_logic ;
  signal N_24812 : std_logic ;
  signal N_24813 : std_logic ;
  signal N_24814 : std_logic ;
  signal N_24815 : std_logic ;
  signal N_24816 : std_logic ;
  signal N_24817 : std_logic ;
  signal N_24818 : std_logic ;
  signal N_24819 : std_logic ;
  signal N_24820 : std_logic ;
  signal N_24821 : std_logic ;
  signal N_24822 : std_logic ;
  signal N_24823 : std_logic ;
  signal N_24824 : std_logic ;
  signal N_24825 : std_logic ;
  signal N_24826 : std_logic ;
  signal N_24827 : std_logic ;
  signal N_24828 : std_logic ;
  signal N_24829 : std_logic ;
  signal N_24830 : std_logic ;
  signal N_24831 : std_logic ;
  signal N_24832 : std_logic ;
  signal N_24833 : std_logic ;
  signal N_24834 : std_logic ;
  signal N_24835 : std_logic ;
  signal N_24836 : std_logic ;
  signal N_24837 : std_logic ;
  signal N_24838 : std_logic ;
  signal N_24839 : std_logic ;
  signal N_24840 : std_logic ;
  signal N_24841 : std_logic ;
  signal N_24842 : std_logic ;
  signal N_24843 : std_logic ;
  signal N_24844 : std_logic ;
  signal N_24845 : std_logic ;
  signal N_24846 : std_logic ;
  signal N_24847 : std_logic ;
  signal N_24848 : std_logic ;
  signal N_24849 : std_logic ;
  signal N_24850 : std_logic ;
  signal N_24851 : std_logic ;
  signal N_24852 : std_logic ;
  signal N_24853 : std_logic ;
  signal N_24854 : std_logic ;
  signal N_24855 : std_logic ;
  signal N_24856 : std_logic ;
  signal N_24857 : std_logic ;
  signal N_24858 : std_logic ;
  signal N_24859 : std_logic ;
  signal N_24860 : std_logic ;
  signal N_24861 : std_logic ;
  signal N_24862 : std_logic ;
  signal N_24863 : std_logic ;
  signal N_24864 : std_logic ;
  signal N_24865 : std_logic ;
  signal N_24866 : std_logic ;
  signal N_24867 : std_logic ;
  signal N_25118 : std_logic ;
  signal N_25152 : std_logic ;
  signal N_25153 : std_logic ;
  signal \GRLFPC20.N_2406_3_I\ : std_logic ;
  signal N_23932_I : std_logic ;
  signal N_12822_3_I : std_logic ;
  signal RST_I : std_logic ;
  signal \GRLFPC20.R.I.CC_0_0_1__N_7_0\ : std_logic ;
  signal N_12871_0 : std_logic ;
  signal \GRLFPC20.N_1453_0\ : std_logic ;
  signal \GRLFPC20.N_2406_3_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\ : std_logic ;
  signal N_23933_I_0 : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2_0_NC_00\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2_0_NC_00_0\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_2_0_NC_00_1\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_84__G13\ : std_logic ;
  signal \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_87__G13\ : std_logic ;
  signal \GRLFPC20.V.FSR.CEXC_2_SQMUXA0\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_2__G10\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_1__G10\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_0__G11\ : std_logic ;
  signal \GRLFPC20.R.FSR.CEXC_1_0_4__G10\ : std_logic ;
  signal \GRLFPC20.V.FSR.AEXC_2_SQMUXA0\ : std_logic ;
  signal \GRLFPC20.R.FSR.AEXC_1_0_0__G11\ : std_logic ;
  signal N_1 : std_logic ;
  signal N_2 : std_logic ;
  signal N_3 : std_logic ;
  signal N_4 : std_logic ;
  signal N_5 : std_logic ;
  signal N_6 : std_logic ;
  signal N_7 : std_logic ;
  signal N_8 : std_logic ;
  signal N_9 : std_logic ;
  signal N_10 : std_logic ;
  signal N_11 : std_logic ;
  signal N_12 : std_logic ;
  signal N_13 : std_logic ;
  signal N_14 : std_logic ;
  signal N_15 : std_logic ;
  signal N_16 : std_logic ;
  signal N_17 : std_logic ;
  signal N_18 : std_logic ;
  signal N_19 : std_logic ;
  signal N_20 : std_logic ;
  signal N_21 : std_logic ;
  signal N_22 : std_logic ;
  signal N_23 : std_logic ;
  signal N_24 : std_logic ;
  signal N_25 : std_logic ;
  signal N_26 : std_logic ;
  signal N_27 : std_logic ;
  signal N_28 : std_logic ;
  signal N_29 : std_logic ;
  signal N_30 : std_logic ;
  signal N_31 : std_logic ;
  signal N_32 : std_logic ;
  signal N_33 : std_logic ;
  signal N_34 : std_logic ;
  signal N_35 : std_logic ;
  signal N_36 : std_logic ;
  signal N_37 : std_logic ;
  signal N_38 : std_logic ;
  signal N_39 : std_logic ;
  signal N_40 : std_logic ;
  signal N_41 : std_logic ;
  signal N_42 : std_logic ;
  signal N_43 : std_logic ;
  signal N_44 : std_logic ;
  signal N_45 : std_logic ;
  signal N_46 : std_logic ;
  signal N_47 : std_logic ;
  signal N_48 : std_logic ;
  signal N_49 : std_logic ;
  signal N_50 : std_logic ;
  signal N_51 : std_logic ;
  signal N_52 : std_logic ;
  signal N_53 : std_logic ;
  signal N_54 : std_logic ;
  signal N_55 : std_logic ;
  signal N_56 : std_logic ;
  signal N_57 : std_logic ;
  signal N_58 : std_logic ;
  signal N_59 : std_logic ;
  signal N_60 : std_logic ;
  signal N_61 : std_logic ;
  signal N_62 : std_logic ;
  signal N_63 : std_logic ;
  signal N_64 : std_logic ;
  signal N_65 : std_logic ;
  signal N_66 : std_logic ;
  signal N_67 : std_logic ;
  signal N_68 : std_logic ;
  signal N_69 : std_logic ;
  signal N_70 : std_logic ;
  signal N_71 : std_logic ;
  signal N_72 : std_logic ;
  signal N_73 : std_logic ;
  signal N_74 : std_logic ;
  signal N_75 : std_logic ;
  signal N_76 : std_logic ;
  signal N_77 : std_logic ;
  signal N_78 : std_logic ;
  signal N_79 : std_logic ;
  signal N_80 : std_logic ;
  signal N_81 : std_logic ;
  signal N_82 : std_logic ;
  signal N_83 : std_logic ;
  signal N_84 : std_logic ;
  signal N_85 : std_logic ;
  signal N_86 : std_logic ;
  signal N_87 : std_logic ;
  signal N_88 : std_logic ;
  signal N_89 : std_logic ;
  signal N_90 : std_logic ;
  signal N_91 : std_logic ;
  signal N_92 : std_logic ;
  signal N_93 : std_logic ;
  signal N_94 : std_logic ;
  signal N_95 : std_logic ;
  signal N_96 : std_logic ;
  signal N_97 : std_logic ;
  signal N_98 : std_logic ;
  signal N_99 : std_logic ;
  signal N_100 : std_logic ;
  signal N_101 : std_logic ;
  signal N_102 : std_logic ;
  signal N_103 : std_logic ;
  signal N_104 : std_logic ;
  signal N_105 : std_logic ;
  signal N_106 : std_logic ;
  signal N_107 : std_logic ;
  signal N_108 : std_logic ;
  signal N_109 : std_logic ;
  signal N_110 : std_logic ;
  signal N_111 : std_logic ;
  signal N_112 : std_logic ;
  signal N_113 : std_logic ;
  signal N_114 : std_logic ;
  signal N_115 : std_logic ;
  signal N_116 : std_logic ;
  signal N_117 : std_logic ;
  signal N_118 : std_logic ;
  signal N_119 : std_logic ;
  signal N_120 : std_logic ;
  signal N_121 : std_logic ;
  signal N_122 : std_logic ;
  signal N_123 : std_logic ;
  signal N_124 : std_logic ;
  signal N_125 : std_logic ;
  signal N_126 : std_logic ;
  signal N_127 : std_logic ;
  signal N_128 : std_logic ;
  signal N_129 : std_logic ;
  signal N_130 : std_logic ;
  signal N_131 : std_logic ;
  signal N_132 : std_logic ;
  signal N_133 : std_logic ;
  signal N_134 : std_logic ;
  signal N_135 : std_logic ;
  signal N_136 : std_logic ;
  signal N_137 : std_logic ;
  signal N_138 : std_logic ;
  signal N_139 : std_logic ;
  signal N_140 : std_logic ;
  signal N_141 : std_logic ;
  signal N_142 : std_logic ;
  signal N_143 : std_logic ;
  signal N_144 : std_logic ;
  signal N_145 : std_logic ;
  signal N_146 : std_logic ;
  signal N_147 : std_logic ;
  signal N_148 : std_logic ;
  signal N_149 : std_logic ;
  signal N_150 : std_logic ;
  signal N_151 : std_logic ;
  signal N_152 : std_logic ;
  signal N_153 : std_logic ;
  signal N_154 : std_logic ;
  signal N_155 : std_logic ;
  signal N_156 : std_logic ;
  signal N_157 : std_logic ;
  signal N_158 : std_logic ;
  signal N_159 : std_logic ;
  signal N_160 : std_logic ;
  signal N_161 : std_logic ;
  signal N_162 : std_logic ;
  signal N_163 : std_logic ;
  signal N_164 : std_logic ;
  signal N_165 : std_logic ;
  signal N_166 : std_logic ;
  signal N_167 : std_logic ;
  signal N_168 : std_logic ;
  signal N_169 : std_logic ;
  signal N_170 : std_logic ;
  signal N_171 : std_logic ;
  signal N_172 : std_logic ;
  signal N_173 : std_logic ;
  signal N_174 : std_logic ;
  signal N_175 : std_logic ;
  signal N_176 : std_logic ;
  signal N_177 : std_logic ;
  signal N_178 : std_logic ;
  signal N_179 : std_logic ;
  signal N_180 : std_logic ;
  signal N_181 : std_logic ;
  signal N_182 : std_logic ;
  signal N_183 : std_logic ;
  signal N_184 : std_logic ;
  signal N_185 : std_logic ;
  signal N_186 : std_logic ;
  signal N_187 : std_logic ;
  signal N_188 : std_logic ;
  signal N_189 : std_logic ;
  signal N_190 : std_logic ;
  signal N_191 : std_logic ;
  signal N_192 : std_logic ;
  signal N_193 : std_logic ;
  signal N_194 : std_logic ;
  signal N_195 : std_logic ;
  signal N_196 : std_logic ;
  signal N_197 : std_logic ;
  signal N_198 : std_logic ;
  signal N_199 : std_logic ;
  signal N_200 : std_logic ;
  signal N_201 : std_logic ;
  signal N_202 : std_logic ;
  signal N_203 : std_logic ;
  signal N_204 : std_logic ;
  signal N_205 : std_logic ;
  signal N_206 : std_logic ;
  signal N_207 : std_logic ;
  signal N_208 : std_logic ;
  signal N_209 : std_logic ;
  signal N_210 : std_logic ;
  signal N_211 : std_logic ;
  signal N_212 : std_logic ;
  signal N_213 : std_logic ;
  signal N_214 : std_logic ;
  signal N_215 : std_logic ;
  signal N_216 : std_logic ;
  signal N_217 : std_logic ;
  signal N_218 : std_logic ;
  signal N_219 : std_logic ;
  signal N_220 : std_logic ;
  signal N_221 : std_logic ;
  signal N_222 : std_logic ;
  signal N_223 : std_logic ;
  signal N_224 : std_logic ;
  signal N_225 : std_logic ;
  signal N_226 : std_logic ;
  signal N_227 : std_logic ;
  signal N_228 : std_logic ;
  signal N_229 : std_logic ;
  signal N_230 : std_logic ;
  signal N_231 : std_logic ;
  signal N_232 : std_logic ;
  signal N_233 : std_logic ;
  signal N_234 : std_logic ;
  signal N_235 : std_logic ;
  signal N_236 : std_logic ;
  signal N_237 : std_logic ;
  signal N_238 : std_logic ;
  signal N_239 : std_logic ;
  signal N_240 : std_logic ;
  signal N_241 : std_logic ;
  signal N_242 : std_logic ;
  signal N_243 : std_logic ;
  signal N_244 : std_logic ;
  signal N_245 : std_logic ;
  signal N_246 : std_logic ;
  signal N_247 : std_logic ;
  signal N_248 : std_logic ;
  signal N_249 : std_logic ;
  signal N_250 : std_logic ;
  signal N_251 : std_logic ;
  signal N_252 : std_logic ;
  signal N_253 : std_logic ;
  signal N_254 : std_logic ;
  signal N_255 : std_logic ;
  signal N_256 : std_logic ;
  signal N_257 : std_logic ;
  signal N_258 : std_logic ;
  signal N_259 : std_logic ;
  signal N_260 : std_logic ;
  signal N_261 : std_logic ;
  signal N_262 : std_logic ;
  signal N_263 : std_logic ;
  signal N_264 : std_logic ;
  signal N_265 : std_logic ;
  signal N_266 : std_logic ;
  signal N_267 : std_logic ;
  signal N_268 : std_logic ;
  signal N_269 : std_logic ;
  signal N_270 : std_logic ;
  signal N_271 : std_logic ;
  signal N_272 : std_logic ;
  signal N_273 : std_logic ;
  signal N_274 : std_logic ;
  signal N_275 : std_logic ;
  signal N_276 : std_logic ;
  signal N_277 : std_logic ;
  signal N_278 : std_logic ;
  signal N_279 : std_logic ;
  signal N_280 : std_logic ;
  signal N_281 : std_logic ;
  signal N_282 : std_logic ;
  signal N_283 : std_logic ;
  signal N_284 : std_logic ;
  signal N_285 : std_logic ;
  signal N_286 : std_logic ;
  signal N_287 : std_logic ;
  signal N_288 : std_logic ;
  signal N_289 : std_logic ;
  signal N_290 : std_logic ;
  signal N_291 : std_logic ;
  signal N_292 : std_logic ;
  signal N_293 : std_logic ;
  signal N_294 : std_logic ;
  signal N_295 : std_logic ;
  signal N_296 : std_logic ;
  signal N_297 : std_logic ;
  signal N_298 : std_logic ;
  signal N_299 : std_logic ;
  signal N_300 : std_logic ;
  signal N_301 : std_logic ;
  signal N_302 : std_logic ;
  signal N_303 : std_logic ;
  signal N_304 : std_logic ;
  signal N_305 : std_logic ;
  signal N_306 : std_logic ;
  signal N_307 : std_logic ;
  signal N_308 : std_logic ;
  signal N_309 : std_logic ;
  signal N_310 : std_logic ;
  signal N_311 : std_logic ;
  signal N_312 : std_logic ;
  signal N_313 : std_logic ;
  signal N_314 : std_logic ;
  signal N_315 : std_logic ;
  signal N_316 : std_logic ;
  signal N_317 : std_logic ;
  signal N_318 : std_logic ;
  signal N_319 : std_logic ;
  signal N_320 : std_logic ;
  signal N_321 : std_logic ;
  signal N_322 : std_logic ;
  signal N_323 : std_logic ;
  signal N_324 : std_logic ;
  signal N_325 : std_logic ;
  signal N_326 : std_logic ;
  signal N_327 : std_logic ;
  signal N_328 : std_logic ;
  signal N_329 : std_logic ;
  signal N_330 : std_logic ;
  signal N_331 : std_logic ;
  signal N_332 : std_logic ;
  signal N_333 : std_logic ;
  signal N_334 : std_logic ;
  signal N_335 : std_logic ;
  signal N_336 : std_logic ;
  signal N_337 : std_logic ;
  signal N_338 : std_logic ;
  signal N_339 : std_logic ;
  signal N_340 : std_logic ;
  signal N_341 : std_logic ;
  signal N_342 : std_logic ;
  signal N_343 : std_logic ;
  signal N_344 : std_logic ;
  signal N_345 : std_logic ;
  signal N_346 : std_logic ;
  signal N_347 : std_logic ;
  signal N_348 : std_logic ;
  signal N_349 : std_logic ;
  signal N_350 : std_logic ;
  signal N_351 : std_logic ;
  signal N_352 : std_logic ;
  signal N_353 : std_logic ;
  signal N_354 : std_logic ;
  signal N_355 : std_logic ;
  signal N_356 : std_logic ;
  signal N_357 : std_logic ;
  signal N_358 : std_logic ;
  signal N_359 : std_logic ;
  signal N_360 : std_logic ;
  signal N_361 : std_logic ;
  signal N_362 : std_logic ;
  signal N_363 : std_logic ;
  signal N_364 : std_logic ;
  signal N_365 : std_logic ;
  signal N_366 : std_logic ;
  signal N_367 : std_logic ;
  signal N_368 : std_logic ;
  signal N_369 : std_logic ;
  signal N_370 : std_logic ;
  signal N_371 : std_logic ;
  signal N_372 : std_logic ;
  signal N_373 : std_logic ;
  signal N_374 : std_logic ;
  signal N_375 : std_logic ;
  signal N_376 : std_logic ;
  signal N_377 : std_logic ;
  signal N_378 : std_logic ;
  signal N_379 : std_logic ;
  signal N_380 : std_logic ;
  signal N_381 : std_logic ;
  signal N_382 : std_logic ;
  signal N_383 : std_logic ;
  signal N_384 : std_logic ;
  signal N_385 : std_logic ;
  signal N_386 : std_logic ;
  signal N_387 : std_logic ;
  signal N_388 : std_logic ;
  signal N_389 : std_logic ;
  signal N_390 : std_logic ;
  signal N_391 : std_logic ;
  signal N_392 : std_logic ;
  signal N_393 : std_logic ;
  signal N_394 : std_logic ;
  signal N_395 : std_logic ;
  signal N_396 : std_logic ;
  signal N_397 : std_logic ;
  signal N_398 : std_logic ;
  signal N_399 : std_logic ;
  signal N_400 : std_logic ;
  signal N_401 : std_logic ;
  signal N_402 : std_logic ;
  signal N_403 : std_logic ;
  signal N_404 : std_logic ;
  signal N_405 : std_logic ;
  signal N_406 : std_logic ;
  signal N_407 : std_logic ;
  signal N_408 : std_logic ;
  signal N_409 : std_logic ;
  signal N_410 : std_logic ;
  signal N_411 : std_logic ;
  signal N_412 : std_logic ;
  signal N_413 : std_logic ;
  signal N_414 : std_logic ;
  signal N_415 : std_logic ;
  signal N_416 : std_logic ;
  signal N_417 : std_logic ;
  signal N_418 : std_logic ;
  signal N_419 : std_logic ;
  signal N_420 : std_logic ;
  signal N_421 : std_logic ;
  signal N_422 : std_logic ;
  signal N_423 : std_logic ;
  signal N_424 : std_logic ;
  signal N_425 : std_logic ;
  signal N_426 : std_logic ;
  signal N_427 : std_logic ;
  signal N_428 : std_logic ;
  signal N_429 : std_logic ;
  signal N_430 : std_logic ;
  signal N_431 : std_logic ;
  signal N_0 : std_logic ;
  signal N_1_0 : std_logic ;
  signal N_2_0 : std_logic ;
  signal N_3_0 : std_logic ;
  signal N_4_0 : std_logic ;
  signal N_5_0 : std_logic ;
  signal N_6_0 : std_logic ;
  signal N_7_0 : std_logic ;
  signal N_8_0 : std_logic ;
  signal N_9_0 : std_logic ;
  signal N_10_0 : std_logic ;
  signal N_11_0 : std_logic ;
  signal N_12_0 : std_logic ;
  signal N_13_0 : std_logic ;
  signal N_14_0 : std_logic ;
  signal N_15_0 : std_logic ;
  signal N_16_0 : std_logic ;
  signal N_17_0 : std_logic ;
  signal N_18_0 : std_logic ;
  signal N_19_0 : std_logic ;
  signal N_20_0 : std_logic ;
  signal N_21_0 : std_logic ;
  signal N_22_0 : std_logic ;
  signal N_23_0 : std_logic ;
  signal N_24_0 : std_logic ;
  signal N_25_0 : std_logic ;
  signal N_26_0 : std_logic ;
  signal N_27_0 : std_logic ;
  signal N_28_0 : std_logic ;
  signal N_29_0 : std_logic ;
  signal N_30_0 : std_logic ;
  signal N_31_0 : std_logic ;
  signal N_32_0 : std_logic ;
  signal N_33_0 : std_logic ;
  signal N_34_0 : std_logic ;
  signal N_35_0 : std_logic ;
  signal N_36_0 : std_logic ;
  signal N_37_0 : std_logic ;
  signal N_38_0 : std_logic ;
  signal N_39_0 : std_logic ;
  signal N_40_0 : std_logic ;
  signal N_41_0 : std_logic ;
  signal N_42_0 : std_logic ;
  signal N_43_0 : std_logic ;
  signal N_44_0 : std_logic ;
  signal N_45_0 : std_logic ;
  signal N_46_0 : std_logic ;
  signal N_47_0 : std_logic ;
  signal N_48_0 : std_logic ;
  signal N_49_0 : std_logic ;
  signal N_50_0 : std_logic ;
  signal N_51_0 : std_logic ;
  signal N_52_0 : std_logic ;
  signal N_53_0 : std_logic ;
  signal N_54_0 : std_logic ;
  signal N_55_0 : std_logic ;
  signal N_56_0 : std_logic ;
  signal N_57_0 : std_logic ;
  signal N_58_0 : std_logic ;
  signal N_59_0 : std_logic ;
  signal N_60_0 : std_logic ;
  signal N_61_0 : std_logic ;
  signal N_62_0 : std_logic ;
  signal N_63_0 : std_logic ;
  signal N_64_0 : std_logic ;
  signal N_65_0 : std_logic ;
  signal N_66_0 : std_logic ;
  signal N_67_0 : std_logic ;
  signal N_68_0 : std_logic ;
  signal N_69_0 : std_logic ;
  signal N_70_0 : std_logic ;
  signal N_71_0 : std_logic ;
  signal N_72_0 : std_logic ;
  signal N_73_0 : std_logic ;
  signal N_74_0 : std_logic ;
  signal N_75_0 : std_logic ;
  signal N_76_0 : std_logic ;
  signal N_77_0 : std_logic ;
  signal N_78_0 : std_logic ;
  signal N_79_0 : std_logic ;
  signal N_80_0 : std_logic ;
  signal N_81_0 : std_logic ;
  signal N_82_0 : std_logic ;
  signal N_83_0 : std_logic ;
  signal N_84_0 : std_logic ;
  signal N_85_0 : std_logic ;
  signal N_86_0 : std_logic ;
  signal N_87_0 : std_logic ;
  signal N_88_0 : std_logic ;
  signal N_89_0 : std_logic ;
  signal N_90_0 : std_logic ;
  signal N_91_0 : std_logic ;
  signal N_92_0 : std_logic ;
  signal N_93_0 : std_logic ;
  signal N_94_0 : std_logic ;
  signal N_95_0 : std_logic ;
  signal N_96_0 : std_logic ;
  signal N_97_0 : std_logic ;
  signal N_98_0 : std_logic ;
  signal N_99_0 : std_logic ;
  signal N_100_0 : std_logic ;
  signal N_101_0 : std_logic ;
  signal N_102_0 : std_logic ;
  signal N_103_0 : std_logic ;
  signal N_104_0 : std_logic ;
  signal N_105_0 : std_logic ;
  signal N_106_0 : std_logic ;
  signal N_107_0 : std_logic ;
  signal N_108_0 : std_logic ;
  signal N_109_0 : std_logic ;
  signal N_110_0 : std_logic ;
  signal N_111_0 : std_logic ;
  signal N_112_0 : std_logic ;
  signal N_113_0 : std_logic ;
  signal N_114_0 : std_logic ;
  signal N_115_0 : std_logic ;
  signal N_116_0 : std_logic ;
  signal N_117_0 : std_logic ;
  signal N_118_0 : std_logic ;
  signal N_119_0 : std_logic ;
  signal N_120_0 : std_logic ;
  signal N_121_0 : std_logic ;
  signal N_122_0 : std_logic ;
  signal N_123_0 : std_logic ;
  signal N_124_0 : std_logic ;
  signal N_125_0 : std_logic ;
  signal N_126_0 : std_logic ;
  signal N_127_0 : std_logic ;
  signal N_128_0 : std_logic ;
  signal N_129_0 : std_logic ;
  signal N_130_0 : std_logic ;
  signal N_131_0 : std_logic ;
  signal N_132_0 : std_logic ;
  signal N_133_0 : std_logic ;
  signal N_134_0 : std_logic ;
  signal N_135_0 : std_logic ;
  signal N_136_0 : std_logic ;
  signal N_137_0 : std_logic ;
  signal N_138_0 : std_logic ;
  signal N_139_0 : std_logic ;
  signal N_140_0 : std_logic ;
  signal N_141_0 : std_logic ;
  signal N_142_0 : std_logic ;
  signal N_143_0 : std_logic ;
  signal N_144_0 : std_logic ;
  signal N_145_0 : std_logic ;
  signal N_146_0 : std_logic ;
  signal N_147_0 : std_logic ;
  signal N_148_0 : std_logic ;
  signal N_149_0 : std_logic ;
  signal N_150_0 : std_logic ;
  signal N_151_0 : std_logic ;
  signal N_152_0 : std_logic ;
  signal N_153_0 : std_logic ;
  signal N_154_0 : std_logic ;
  signal N_155_0 : std_logic ;
  signal N_156_0 : std_logic ;
  signal N_157_0 : std_logic ;
  signal N_158_0 : std_logic ;
  signal N_159_0 : std_logic ;
  signal N_160_0 : std_logic ;
  signal N_161_0 : std_logic ;
  signal N_162_0 : std_logic ;
  signal N_163_0 : std_logic ;
  signal N_596 : std_logic ;
  signal N_597 : std_logic ;
  signal N_598 : std_logic ;
  signal N_599 : std_logic ;
  signal N_600 : std_logic ;
  signal N_601 : std_logic ;
  signal N_602 : std_logic ;
  signal N_603 : std_logic ;
  signal N_604 : std_logic ;
  signal N_605 : std_logic ;
  signal N_606 : std_logic ;
  signal N_607 : std_logic ;
  signal N_608 : std_logic ;
  signal N_609 : std_logic ;
  signal N_610 : std_logic ;
  signal N_611 : std_logic ;
  signal N_612 : std_logic ;
  signal N_613 : std_logic ;
  signal N_614 : std_logic ;
  signal N_615 : std_logic ;
  signal N_616 : std_logic ;
  signal N_617 : std_logic ;
  signal N_618 : std_logic ;
  signal N_619 : std_logic ;
  signal N_620 : std_logic ;
  signal N_621 : std_logic ;
  signal N_622 : std_logic ;
  signal N_623 : std_logic ;
  signal N_624 : std_logic ;
  signal N_625 : std_logic ;
  signal N_626 : std_logic ;
  signal N_627 : std_logic ;
  signal N_628 : std_logic ;
  signal N_629 : std_logic ;
  signal N_630 : std_logic ;
  signal N_631 : std_logic ;
  signal N_632 : std_logic ;
  signal N_633 : std_logic ;
  signal N_634 : std_logic ;
  signal N_635 : std_logic ;
  signal N_636 : std_logic ;
  signal N_637 : std_logic ;
  signal N_638 : std_logic ;
  signal N_639 : std_logic ;
  signal N_640 : std_logic ;
  signal N_641 : std_logic ;
  signal N_642 : std_logic ;
  signal N_643 : std_logic ;
  signal N_644 : std_logic ;
  signal N_645 : std_logic ;
  signal N_646 : std_logic ;
  signal N_647 : std_logic ;
  signal N_648 : std_logic ;
  signal N_649 : std_logic ;
  signal N_650 : std_logic ;
  signal N_651 : std_logic ;
  signal N_652 : std_logic ;
  signal N_653 : std_logic ;
  signal N_654 : std_logic ;
  signal N_655 : std_logic ;
  signal N_656 : std_logic ;
  signal N_657 : std_logic ;
  signal N_658 : std_logic ;
  signal N_659 : std_logic ;
  signal N_660 : std_logic ;
  signal N_661 : std_logic ;
  signal N_662 : std_logic ;
  signal N_663 : std_logic ;
  signal N_664 : std_logic ;
  signal N_665 : std_logic ;
  signal N_666 : std_logic ;
  signal N_667 : std_logic ;
  signal N_668 : std_logic ;
  signal N_669 : std_logic ;
  signal N_670 : std_logic ;
  signal N_671 : std_logic ;
  signal N_672 : std_logic ;
  signal N_673 : std_logic ;
  signal N_674 : std_logic ;
  signal N_675 : std_logic ;
  signal N_676 : std_logic ;
  signal N_677 : std_logic ;
  signal N_678 : std_logic ;
  signal N_679 : std_logic ;
  signal N_680 : std_logic ;
  signal N_681 : std_logic ;
  signal N_682 : std_logic ;
  signal N_683 : std_logic ;
  signal N_684 : std_logic ;
  signal N_685 : std_logic ;
  signal N_686 : std_logic ;
  signal N_687 : std_logic ;
  signal N_688 : std_logic ;
  signal N_689 : std_logic ;
  signal N_690 : std_logic ;
  signal N_691 : std_logic ;
  signal N_692 : std_logic ;
  signal N_693 : std_logic ;
  signal N_694 : std_logic ;
  signal N_695 : std_logic ;
  signal N_696 : std_logic ;
  signal N_697 : std_logic ;
  signal N_698 : std_logic ;
  signal N_699 : std_logic ;
  signal N_700 : std_logic ;
  signal N_701 : std_logic ;
  signal N_702 : std_logic ;
  signal N_703 : std_logic ;
  signal N_704 : std_logic ;
  signal N_705 : std_logic ;
  signal N_706 : std_logic ;
  signal N_707 : std_logic ;
  signal N_708 : std_logic ;
  signal N_709 : std_logic ;
  signal N_710 : std_logic ;
  signal N_711 : std_logic ;
  signal N_712 : std_logic ;
  signal N_713 : std_logic ;
  signal N_714 : std_logic ;
  signal N_715 : std_logic ;
  signal N_716 : std_logic ;
  signal N_717 : std_logic ;
  signal N_718 : std_logic ;
  signal N_719 : std_logic ;
  signal N_720 : std_logic ;
  signal N_721 : std_logic ;
  signal N_722 : std_logic ;
  signal N_723 : std_logic ;
  signal CPO_EXCZ : std_logic ;
  signal CPO_CCVZ : std_logic ;
  signal CPO_LDLOCKZ : std_logic ;
  signal CPO_HOLDNZ : std_logic ;
  signal RFI1_REN1Z : std_logic ;
  signal RFI1_REN2Z : std_logic ;
  signal RFI1_WRENZ : std_logic ;
  signal RFI2_REN1Z : std_logic ;
  signal RFI2_REN2Z : std_logic ;
  signal RFI2_WRENZ : std_logic ;
begin
GND <= '0';
VCC <= '1';
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\,
dataf => N_18927,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(320),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18921);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\,
dataf => N_18933,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\,
dataf => N_18934,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(8),
cout => N_18919,
dataf => N_18942,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.CI_8.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\,
dataf => N_18950,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(321),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18917);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\,
dataf => N_18956,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_9\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\,
dataf => N_18957,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_66\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(9),
cout => N_18915,
dataf => N_18965,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_123\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.CI_9.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\,
dataf => N_18973,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(322),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18913);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\,
dataf => N_18979,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_10\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\,
dataf => N_18980,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_67\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(10),
cout => N_18911,
dataf => N_18988,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_124\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.CI_10.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\,
dataf => N_18996,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(323),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18909);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\,
dataf => N_19002,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.48.SI_11\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\,
dataf => N_19003,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_68\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(11),
cout => N_18907,
dataf => N_19011,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_125\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.CI_11.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\,
dataf => N_19019,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(324),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18905);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\,
dataf => N_19025,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.47.SI_12\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\,
dataf => N_19026,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_69\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(12),
cout => N_18903,
dataf => N_19034,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_126\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.CI_12.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\,
dataf => N_19042,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(325),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18901);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\,
dataf => N_19048,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.46.SI_13\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\,
dataf => N_19049,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_70\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(13),
cout => N_18899,
dataf => N_19057,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_127\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.CI_13.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\,
dataf => N_19065,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(326),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18897);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\,
dataf => N_19071,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.45.SI_14\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\,
dataf => N_19072,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_71\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(14),
cout => N_18895,
dataf => N_19080,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_128\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.CI_14.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\,
dataf => N_19088,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(327),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18893);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\,
dataf => N_19094,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.44.SI_15\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\,
dataf => N_19095,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_72\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(15),
cout => N_18891,
dataf => N_19103,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_129\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.CI_15.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\,
dataf => N_19111,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(328),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18889);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\,
dataf => N_19117,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.43.SI_16\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\,
dataf => N_19118,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_73\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(16),
cout => N_18887,
dataf => N_19126,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_130\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.CI_16.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\,
dataf => N_19134,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(329),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18885);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\,
dataf => N_19140,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.42.SI_17\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\,
dataf => N_19141,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_74\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(17),
cout => N_18883,
dataf => N_19149,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_131\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.CI_17.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\,
dataf => N_19157,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(330),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18881);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\,
dataf => N_19163,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.41.SI_18\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\,
dataf => N_19164,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_75\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(18),
cout => N_18879,
dataf => N_19172,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_132\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.CI_18.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\,
dataf => N_19180,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(331),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18877);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\,
dataf => N_19186,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.40.SI_19\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\,
dataf => N_19187,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_76\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(19),
cout => N_18875,
dataf => N_19195,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_133\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.CI_19.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\,
dataf => N_19203,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(332),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18873);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\,
dataf => N_19209,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.39.SI_20\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\,
dataf => N_19210,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_77\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(20),
cout => N_18871,
dataf => N_19218,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_134\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.CI_20.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\,
dataf => N_19226,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(333),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18869);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\,
dataf => N_19232,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.38.SI_21\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\,
dataf => N_19233,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_78\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(21),
cout => N_18867,
dataf => N_19241,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_135\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.CI_21.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\,
dataf => N_19249,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(334),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18865);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\,
dataf => N_19255,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.37.SI_22\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\,
dataf => N_19256,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_79\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(22),
cout => N_18863,
dataf => N_19264,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_136\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.CI_22.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\,
dataf => N_19272,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(335),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18861);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\,
dataf => N_19278,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.36.SI_23\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\,
dataf => N_19279,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_80\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(23),
cout => N_18859,
dataf => N_19287,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_137\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.CI_23.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\,
dataf => N_19295,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(336),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18857);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\,
dataf => N_19301,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.35.SI_24\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\,
dataf => N_19302,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_81\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(24),
cout => N_18855,
dataf => N_19310,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_138\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.CI_24.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\,
dataf => N_19318,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(337),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18853);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\,
dataf => N_19324,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.34.SI_25\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\,
dataf => N_19325,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_82\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(25),
cout => N_18851,
dataf => N_19333,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_139\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.CI_25.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\,
dataf => N_19341,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(338),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18849);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\,
dataf => N_19347,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.33.SI_26\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\,
dataf => N_19348,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_83\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(26),
cout => N_18847,
dataf => N_19356,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_140\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.CI_26.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\,
dataf => N_19364,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(339),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18845);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\,
dataf => N_19370,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.32.SI_27\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\,
dataf => N_19371,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_84\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(27),
cout => N_18843,
dataf => N_19379,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_141\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.CI_27.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\,
dataf => N_19387,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(340),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18841);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\,
dataf => N_19393,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.31.SI_28\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\,
dataf => N_19394,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_85\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(28),
cout => N_18839,
dataf => N_19402,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_142\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.CI_28.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\,
dataf => N_19410,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(341),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18837);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\,
dataf => N_19416,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.30.SI_29\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\,
dataf => N_19417,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_86\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(29),
cout => N_18835,
dataf => N_19425,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_143\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.CI_29.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\,
dataf => N_19433,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(342),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18833);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\,
dataf => N_19439,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.29.SI_30\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\,
dataf => N_19440,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_87\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(30),
cout => N_18831,
dataf => N_19448,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_144\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.CI_30.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\,
dataf => N_19456,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(343),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18829);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\,
dataf => N_19462,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.28.SI_31\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\,
dataf => N_19463,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_88\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(31),
cout => N_18827,
dataf => N_19471,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_145\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.CI_31.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\,
dataf => N_19479,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(344),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18825);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\,
dataf => N_19485,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.27.SI_32\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\,
dataf => N_19486,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_89\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(32),
cout => N_18823,
dataf => N_19494,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_146\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.CI_32.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\,
dataf => N_19502,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(345),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18821);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\,
dataf => N_19508,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.26.SI_33\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\,
dataf => N_19509,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_90\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(33),
cout => N_18819,
dataf => N_19517,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_147\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.CI_33.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\,
dataf => N_19525,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(346),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18817);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\,
dataf => N_19531,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.25.SI_34\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\,
dataf => N_19532,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_91\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(34),
cout => N_18815,
dataf => N_19540,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_148\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.CI_34.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\,
dataf => N_19548,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(347),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18813);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\,
dataf => N_19554,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.24.SI_35\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\,
dataf => N_19555,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_92\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(35),
cout => N_18811,
dataf => N_19563,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_149\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.CI_35.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\,
dataf => N_19571,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(348),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18809);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\,
dataf => N_19577,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.23.SI_36\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\,
dataf => N_19578,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_93\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(36),
cout => N_18807,
dataf => N_19586,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_150\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.CI_36.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\,
dataf => N_19594,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(349),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18805);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\,
dataf => N_19600,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.22.SI_37\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\,
dataf => N_19601,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_94\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(37),
cout => N_18803,
dataf => N_19609,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_151\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.CI_37.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\,
dataf => N_19617,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(350),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18801);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\,
dataf => N_19623,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.21.SI_38\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\,
dataf => N_19624,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_95\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(38),
cout => N_18799,
dataf => N_19632,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_152\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.CI_38.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\,
dataf => N_19640,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(351),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18797);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\,
dataf => N_19646,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.20.SI_39\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\,
dataf => N_19647,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_96\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(39),
cout => N_18795,
dataf => N_19655,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_153\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.CI_39.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\,
dataf => N_19663,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(352),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18793);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\,
dataf => N_19669,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.19.SI_40\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\,
dataf => N_19670,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_97\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(40),
cout => N_18791,
dataf => N_19678,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_154\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.CI_40.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\,
dataf => N_19686,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(353),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18789);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\,
dataf => N_19692,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.18.SI_41\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\,
dataf => N_19693,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_98\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(41),
cout => N_18787,
dataf => N_19701,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_155\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.CI_41.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\,
dataf => N_19709,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(354),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18785);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\,
dataf => N_19715,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.17.SI_42\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\,
dataf => N_19716,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_99\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(42),
cout => N_18783,
dataf => N_19724,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_156\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.CI_42.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\,
dataf => N_19732,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(355),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18781);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\,
dataf => N_19738,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.16.SI_43\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\,
dataf => N_19739,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_100\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(43),
cout => N_18779,
dataf => N_19747,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_157\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.CI_43.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\,
dataf => N_19755,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(356),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18777);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\,
dataf => N_19761,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.15.SI_44\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\,
dataf => N_19762,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_101\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(44),
cout => N_18775,
dataf => N_19770,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_158\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.CI_44.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\,
dataf => N_19778,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(357),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18773);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\,
dataf => N_19784,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.14.SI_45\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\,
dataf => N_19785,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_102\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(45),
cout => N_18771,
dataf => N_19793,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_159\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.CI_45.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\,
dataf => N_19801,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(358),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18769);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\,
dataf => N_19807,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.13.SI_46\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\,
dataf => N_19808,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_103\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(46),
cout => N_18767,
dataf => N_19816,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_160\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.CI_46.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\,
dataf => N_19824,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(359),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18765);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\,
dataf => N_19830,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.12.SI_47\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\,
dataf => N_19831,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_104\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(47),
cout => N_18763,
dataf => N_19839,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_161\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.CI_47.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\,
dataf => N_19847,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(360),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18761);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\,
dataf => N_19853,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.11.SI_48\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\,
dataf => N_19854,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_105\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(48),
cout => N_18759,
dataf => N_19862,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_162\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.CI_48.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\,
dataf => N_19870,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(361),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18757);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\,
dataf => N_19876,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.10.SI_49\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\,
dataf => N_19877,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_106\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(49),
cout => N_18755,
dataf => N_19885,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_163\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.CI_49.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\,
dataf => N_19893,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(362),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18753);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\,
dataf => N_19899,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.9.SI_50\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\,
dataf => N_19900,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_107\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(50),
cout => N_18751,
dataf => N_19908,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_164\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.CI_50.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\,
dataf => N_19916,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(363),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18749);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\,
dataf => N_19922,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.8.SI_51\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\,
dataf => N_19923,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_108\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(51),
cout => N_18747,
dataf => N_19931,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_165\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.CI_51.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\,
dataf => N_19939,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(364),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18745);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\,
dataf => N_19945,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.7.SI_52\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\,
dataf => N_19946,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_109\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(52),
cout => N_18743,
dataf => N_19954,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_166\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.CI_52.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\(52),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\,
dataf => N_19964,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(316),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18741);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\,
dataf => N_19974,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7789\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7124\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\,
dataf => N_19975,
datad => N_19973,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7333\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7182\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000ff0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(4),
cout => N_18739,
dataf => N_19979,
datad => N_19978,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.55.SI_60\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7266\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.CI_4.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\,
dataf => N_19984,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(317),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18737);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\,
dataf => N_19990,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.54.SI_5\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\,
dataf => N_19991,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_62\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(5),
cout => N_18735,
dataf => N_19999,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_119\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.CI_5.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\,
dataf => N_20007,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(318),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18733);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\,
dataf => N_20013,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.53.SI_6\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\,
dataf => N_20014,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_63\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(6),
cout => N_18731,
dataf => N_20022,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_120\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.CI_6.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_8\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\,
dataf => N_20030,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(319),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18729);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_65\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\,
dataf => N_20036,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.52.SI_7\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.49.SI_122\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\,
dataf => N_20037,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.SI_64\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(7),
cout => N_18727,
dataf => N_20045,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.50.SI_121\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.51.CI_7.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\,
dataf => N_20053,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(365),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18725);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\,
dataf => N_20059,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.6.SI_53\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\,
dataf => N_20060,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_110\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(53),
cout => N_18723,
dataf => N_20068,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_167\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.CI_53.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\,
dataf => N_20076,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(366),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18721);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\,
dataf => N_20082,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.5.SI_54\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\,
dataf => N_20083,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_111\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cfff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(54),
cout => N_18719,
dataf => N_20091,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_168\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.CI_54.Z_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033ff00000f00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\,
dataf => N_20099,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(367),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
cin => N_18717);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\,
dataf => N_20105,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.4.SI_55\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\,
dataf => N_20106,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_112\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00003000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(55),
cout => N_18715,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI\(0),
datad => N_20114,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.CI_55.Z_CARRY_2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIMI3P1_368_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ccff0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(368),
datad => N_20122,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
cin => N_18713);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_0_RNIC71E4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000c00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.3.SI_56\(1),
datad => N_20128,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNIG4IF9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f3ff0000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\,
dataf => N_20129,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_113\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNIG4IF9_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\,
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\,
dataf => VCC,
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNI9JEKI: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\,
cout => N_18711,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f0cc")
port map (
sumout => \GRLFPC20.FPO.EXP\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9603\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9590\,
cin => N_18709);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9591\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9604\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9592\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9605\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9593\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9606\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9594\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9607\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_5: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9608\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9595\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9609\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9595\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_7: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9610\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9597\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_8: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000fc30")
port map (
sumout => \GRLFPC20.FPO.EXP\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9611\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9597\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ff0000f3c0")
port map (
sumout => \GRLFPC20.FPO.EXP\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9597\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9612\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_10: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.FPO.EXP\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5413\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9613\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_11: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5496\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9614\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cc330000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
cout => N_1,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5493\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9615\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f0cc")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\,
dataf => N_20189,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
cin => N_18707);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\,
dataf => N_20195,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\,
dataf => N_20196,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\,
dataf => N_20201,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\,
dataf => N_20202,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_5: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\,
dataf => N_20207,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\,
dataf => N_20208,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_7: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\,
dataf => N_20213,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_8: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\,
dataf => N_20214,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\,
dataf => N_20219,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_10: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\,
dataf => N_20220,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_11: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\,
dataf => N_20225,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(12),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\,
dataf => N_20226,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_13: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(13),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\,
dataf => N_20231,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_12\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_14: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(14),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\,
dataf => N_20232,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_13\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_15: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(15),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\,
dataf => N_20237,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_14\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_16: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(16),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\,
dataf => N_20238,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_15\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_17: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(17),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\,
dataf => N_20243,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_16\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_18: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(18),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\,
dataf => N_20244,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_17\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_19: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(19),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\,
dataf => N_20249,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_18\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_20: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(20),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\,
dataf => N_20250,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_19\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(21),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\,
dataf => N_20255,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_20\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(22),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\,
dataf => N_20256,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_21\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(23),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\,
dataf => N_20261,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_22\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(24),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\,
dataf => N_20262,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_23\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(25),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\,
dataf => N_20267,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_24\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(26),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\,
dataf => N_20268,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_25\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(27),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\,
dataf => N_20273,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_26\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_28: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(28),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\,
dataf => N_20274,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_27\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_29: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(29),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\,
dataf => N_20279,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_28\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_30: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000fc30")
port map (
sumout => \GRLFPC20.FPO.FRAC\(30),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\,
dataf => N_20280,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_29\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_31: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.FPO.FRAC\(31),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\,
dataf => N_20284,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_30\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_32: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(32),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_31\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_33: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(33),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_32\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_34: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(34),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_33\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_35: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(35),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_34\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_36: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(36),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_35\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_37: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(37),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_36\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_38: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(38),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_37\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_39: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(39),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_38\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_40: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(40),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_39\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_41: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(41),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_40\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_42: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(42),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_41\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_43: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(43),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_42\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_44: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(44),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_43\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_45: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(45),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_44\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_46: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(46),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_45\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_47: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(47),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_46\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_48: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(48),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_47\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_49: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(49),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_48\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_50: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(50),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_49\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_51: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(51),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_50\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_52: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(52),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_51\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_53: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(53),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_52\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_54: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.FPO.FRAC\(54),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_53\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_55: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f3c0")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\,
dataf => N_20378,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_54\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_56: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_55\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_57: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000033cc0000f000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
cout => N_2,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF_CARRY_56\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(0),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(257),
cin => N_25118);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(1),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(256),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_0\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(2),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(242),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(255),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(3),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(241),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(254),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(4),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(240),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(253),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_3\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_5: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(5),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(239),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(252),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(6),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(238),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(251),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_7: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(7),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(237),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(250),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_6\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_8: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(8),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(236),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(249),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_7\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(9),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(248),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_8\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_10: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(10),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(234),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(247),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_9\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_11: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(11),
cout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_10\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000ff00")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(12),
cout => N_3,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(232),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245),
cin => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE_CARRY_11\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f033")
port map (
cout => N_18707,
datad => N_20188,
datac => N_20187,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUE_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000f0cc")
port map (
cout => N_18709,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNI9JEKI_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_4\,
cout => N_4,
cin => N_18711);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_RNIV6KS_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18713,
datad => N_20121,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(112),
cin => N_18715);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_3_CI_55_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18717,
datad => N_20098,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(111),
cin => N_18719);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_4_CI_54_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18721,
datad => N_20075,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(110),
cin => N_18723);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_5_CI_53_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18725,
datad => N_20052,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(64),
cin => N_18727);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_51_CI_7_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18729,
datad => N_20029,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(63),
cin => N_18731);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_52_CI_6_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18733,
datad => N_20006,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(62),
cin => N_18735);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_CI_5_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18737,
datad => N_19983,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(61),
cin => N_18739);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_CI_4_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18741,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9505\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(109),
cin => N_18743);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_6_CI_52_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18745,
datad => N_19938,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(108),
cin => N_18747);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_7_CI_51_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18749,
datad => N_19915,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(107),
cin => N_18751);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_8_CI_50_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18753,
datad => N_19892,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(106),
cin => N_18755);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_9_CI_49_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18757,
datad => N_19869,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(105),
cin => N_18759);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_10_CI_48_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18761,
datad => N_19846,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(104),
cin => N_18763);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_11_CI_47_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18765,
datad => N_19823,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(103),
cin => N_18767);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_12_CI_46_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18769,
datad => N_19800,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(102),
cin => N_18771);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_13_CI_45_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18773,
datad => N_19777,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(101),
cin => N_18775);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_14_CI_44_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18777,
datad => N_19754,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(100),
cin => N_18779);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_15_CI_43_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18781,
datad => N_19731,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(99),
cin => N_18783);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_16_CI_42_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18785,
datad => N_19708,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(98),
cin => N_18787);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_17_CI_41_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18789,
datad => N_19685,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(97),
cin => N_18791);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_18_CI_40_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18793,
datad => N_19662,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(96),
cin => N_18795);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_19_CI_39_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18797,
datad => N_19639,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(95),
cin => N_18799);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_20_CI_38_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18801,
datad => N_19616,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(94),
cin => N_18803);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_21_CI_37_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18805,
datad => N_19593,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(93),
cin => N_18807);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_22_CI_36_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18809,
datad => N_19570,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(92),
cin => N_18811);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_23_CI_35_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18813,
datad => N_19547,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(91),
cin => N_18815);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_24_CI_34_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18817,
datad => N_19524,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(90),
cin => N_18819);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_25_CI_33_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18821,
datad => N_19501,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(89),
cin => N_18823);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_26_CI_32_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18825,
datad => N_19478,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(88),
cin => N_18827);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_27_CI_31_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18829,
datad => N_19455,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(87),
cin => N_18831);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_28_CI_30_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18833,
datad => N_19432,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(86),
cin => N_18835);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_29_CI_29_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18837,
datad => N_19409,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(85),
cin => N_18839);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_30_CI_28_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18841,
datad => N_19386,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(84),
cin => N_18843);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_31_CI_27_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18845,
datad => N_19363,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(83),
cin => N_18847);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_32_CI_26_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18849,
datad => N_19340,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(82),
cin => N_18851);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_33_CI_25_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18853,
datad => N_19317,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(81),
cin => N_18855);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_34_CI_24_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18857,
datad => N_19294,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_1\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(80),
cin => N_18859);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_35_CI_23_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18861,
datad => N_19271,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(79),
cin => N_18863);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_36_CI_22_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18865,
datad => N_19248,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(78),
cin => N_18867);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_37_CI_21_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18869,
datad => N_19225,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(77),
cin => N_18871);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_38_CI_20_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18873,
datad => N_19202,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(76),
cin => N_18875);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_39_CI_19_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18877,
datad => N_19179,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(75),
cin => N_18879);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_40_CI_18_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18881,
datad => N_19156,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(74),
cin => N_18883);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_41_CI_17_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18885,
datad => N_19133,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(73),
cin => N_18887);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_42_CI_16_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18889,
datad => N_19110,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(72),
cin => N_18891);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_43_CI_15_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18893,
datad => N_19087,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(71),
cin => N_18895);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_44_CI_14_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18897,
datad => N_19064,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(70),
cin => N_18899);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_45_CI_13_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18901,
datad => N_19041,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(69),
cin => N_18903);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_46_CI_12_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18905,
datad => N_19018,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(68),
cin => N_18907);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_47_CI_11_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18909,
datad => N_18995,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(67),
cin => N_18911);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_48_CI_10_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18913,
datad => N_18972,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(66),
cin => N_18915);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_49_CI_9_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18917,
datad => N_18949,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_3_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
sumout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(65),
cin => N_18919);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_50_CI_8_Z_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000cf00")
port map (
cout => N_18921,
datad => N_18926,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
cin => GND);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_78_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"ffcffcfcddcddcdc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => N_59,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\);
\GRLFPC20_COMB_V_FSR_FCC_1_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0ccf5f0f0cca0")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(0),
dataf => CPO_CCZ(0),
datae => \GRLFPC20.N_1379\,
datad => \GRLFPC20.N_1270\,
datac => N_370,
datab => \GRLFPC20.R.I.CC\(0),
dataa => \GRLFPC20.N_1342\,
datag => N_410);
\GRLFPC20_COMB_V_FSR_FCC_1_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0ccf5f0f0cca0")
port map (
combout => \GRLFPC20.COMB.V.FSR.FCC_1\(1),
dataf => CPO_CCZ(1),
datae => \GRLFPC20.N_1379\,
datad => \GRLFPC20.N_1270\,
datac => N_371,
datab => \GRLFPC20.R.I.CC\(1),
dataa => \GRLFPC20.N_1342\,
datag => N_411);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_171_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0ff0404f0000404")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(171),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(171),
datae => N_23932,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_5_MUX\,
datac => N_20779,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_172_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0ff0404f0000404")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(172),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(172),
datae => N_23932,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_5_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10583\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_245_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f3ff5050c0005050")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(245),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(232));
\GRLFPC20_R_A_RF1REN_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"8c008c008c8c8c8c")
port map (
combout => N_14005,
dataf => \GRLFPC20.N_3742\,
datae => \GRLFPC20.N_2174\,
datad => \GRLFPC20.UN1_FPOP7_1\,
datac => N_12946_1,
datab => \GRLFPC20.COMB.V.A.RF2REN_1_1\(1),
dataa => \GRLFPC20.COMB.RS1D_1\,
datag => \GRLFPC20.N_3459\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"fe54f5f5fe54a0a0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44));
\GRLFPC20_R_A_RF2REN_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"3332302032322020")
port map (
combout => N_14006,
dataf => \GRLFPC20.R.A.RS1D_0_0_G4\,
datae => \GRLFPC20.N_2174\,
datad => \GRLFPC20.N_953\,
datac => \GRLFPC20.N_3749\,
datab => N_12971,
dataa => \GRLFPC20.N_2316\,
datag => N_47);
\GRLFPC20_WRDATA_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(4),
dataf => \GRLFPC20.R.I.RES\(33),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_364,
datac => \GRLFPC20.R.I.RES\(36),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_404);
\GRLFPC20_WRDATA_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(0),
dataf => \GRLFPC20.R.I.RES\(29),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_360,
datac => \GRLFPC20.R.I.RES\(0),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_400);
\GRLFPC20_WRDATA_62_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(30),
dataf => \GRLFPC20.R.I.RES\(59),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_390,
datac => \GRLFPC20.R.I.RES\(62),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_430);
\GRLFPC20_WRDATA_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(25),
dataf => \GRLFPC20.R.I.RES\(54),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_385,
datac => \GRLFPC20.R.I.RES\(57),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_425);
\GRLFPC20_WRDATA_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(28),
dataf => \GRLFPC20.R.I.RES\(57),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_388,
datac => \GRLFPC20.R.I.RES\(28),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_428);
\GRLFPC20_WRDATA_60_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(28),
dataf => \GRLFPC20.R.I.RES\(57),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_388,
datac => \GRLFPC20.R.I.RES\(60),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_428);
\GRLFPC20_WRDATA_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(13),
dataf => \GRLFPC20.R.I.RES\(42),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_373,
datac => \GRLFPC20.R.I.RES\(13),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_413);
\GRLFPC20_WRDATA_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(1),
dataf => \GRLFPC20.R.I.RES\(30),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_361,
datac => \GRLFPC20.R.I.RES\(1),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_401);
\GRLFPC20_WRDATA_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(1),
dataf => \GRLFPC20.R.I.RES\(30),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_361,
datac => \GRLFPC20.R.I.RES\(33),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_401);
\GRLFPC20_WRDATA_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(8),
dataf => \GRLFPC20.R.I.RES\(37),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_368,
datac => \GRLFPC20.R.I.RES\(8),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_408);
\GRLFPC20_WRDATA_59_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(27),
dataf => \GRLFPC20.R.I.RES\(56),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_387,
datac => \GRLFPC20.R.I.RES\(59),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_427);
\GRLFPC20_WRDATA_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(15),
dataf => \GRLFPC20.R.I.RES\(44),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_375,
datac => \GRLFPC20.R.I.RES\(15),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_415);
\GRLFPC20_WRDATA_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(18),
dataf => \GRLFPC20.R.I.RES\(47),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_378,
datac => \GRLFPC20.R.I.RES\(50),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_418);
\GRLFPC20_WRDATA_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(9),
dataf => \GRLFPC20.R.I.RES\(38),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_369,
datac => \GRLFPC20.R.I.RES\(9),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_409);
\GRLFPC20_WRDATA_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(4),
dataf => \GRLFPC20.R.I.RES\(33),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_364,
datac => \GRLFPC20.R.I.RES\(4),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_404);
\GRLFPC20_WRDATA_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(21),
dataf => \GRLFPC20.R.I.RES\(50),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_381,
datac => \GRLFPC20.R.I.RES\(53),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_421);
\GRLFPC20_WRDATA_61_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(29),
dataf => \GRLFPC20.R.I.RES\(58),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_389,
datac => \GRLFPC20.R.I.RES\(61),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_429);
\GRLFPC20_WRDATA_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(17),
dataf => \GRLFPC20.R.I.RES\(46),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_377,
datac => \GRLFPC20.R.I.RES\(17),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_417);
\GRLFPC20_WRDATA_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(7),
dataf => \GRLFPC20.R.I.RES\(36),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_367,
datac => \GRLFPC20.R.I.RES\(7),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_407);
\GRLFPC20_WRDATA_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(5),
dataf => \GRLFPC20.R.I.RES\(34),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_365,
datac => \GRLFPC20.R.I.RES\(5),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_405);
\GRLFPC20_WRDATA_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(2),
dataf => \GRLFPC20.R.I.RES\(31),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_362,
datac => \GRLFPC20.R.I.RES\(2),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_402);
\GRLFPC20_WRDATA_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(24),
dataf => \GRLFPC20.R.I.RES\(53),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_384,
datac => \GRLFPC20.R.I.RES\(56),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_424);
\GRLFPC20_WRDATA_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(16),
dataf => \GRLFPC20.R.I.RES\(45),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_376,
datac => \GRLFPC20.R.I.RES\(16),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_416);
\GRLFPC20_WRDATA_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(6),
dataf => \GRLFPC20.R.I.RES\(35),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_366,
datac => \GRLFPC20.R.I.RES\(6),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_406);
\GRLFPC20_WRDATA_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(9),
dataf => \GRLFPC20.R.I.RES\(38),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_369,
datac => \GRLFPC20.R.I.RES\(41),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_409);
\GRLFPC20_WRDATA_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(30),
dataf => \GRLFPC20.R.I.RES\(59),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_390,
datac => \GRLFPC20.R.I.RES\(30),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_430);
\GRLFPC20_WRDATA_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(20),
dataf => \GRLFPC20.R.I.RES\(49),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_380,
datac => \GRLFPC20.R.I.RES\(20),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_420);
\GRLFPC20_WRDATA_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(12),
dataf => \GRLFPC20.R.I.RES\(41),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_372,
datac => \GRLFPC20.R.I.RES\(12),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_412);
\GRLFPC20_WRDATA_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(10),
dataf => \GRLFPC20.R.I.RES\(39),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_370,
datac => \GRLFPC20.R.I.RES\(10),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_410);
\GRLFPC20_WRDATA_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(14),
dataf => \GRLFPC20.R.I.RES\(43),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_374,
datac => \GRLFPC20.R.I.RES\(46),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_414);
\GRLFPC20_WRDATA_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(19),
dataf => \GRLFPC20.R.I.RES\(48),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_379,
datac => \GRLFPC20.R.I.RES\(19),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_419);
\GRLFPC20_WRDATA_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(3),
dataf => \GRLFPC20.R.I.RES\(32),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_363,
datac => \GRLFPC20.R.I.RES\(3),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_403);
\GRLFPC20_WRDATA_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(22),
dataf => \GRLFPC20.R.I.RES\(51),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_382,
datac => \GRLFPC20.R.I.RES\(54),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_422);
\GRLFPC20_WRDATA_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(13),
dataf => \GRLFPC20.R.I.RES\(42),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_373,
datac => \GRLFPC20.R.I.RES\(45),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_413);
\GRLFPC20_WRDATA_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(24),
dataf => \GRLFPC20.R.I.RES\(53),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_384,
datac => \GRLFPC20.R.I.RES\(24),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_424);
\GRLFPC20_WRDATA_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(15),
dataf => \GRLFPC20.R.I.RES\(44),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_375,
datac => \GRLFPC20.R.I.RES\(47),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_415);
\GRLFPC20_WRDATA_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(12),
dataf => \GRLFPC20.R.I.RES\(41),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_372,
datac => \GRLFPC20.R.I.RES\(44),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_412);
\GRLFPC20_WRDATA_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(11),
dataf => \GRLFPC20.R.I.RES\(40),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_371,
datac => \GRLFPC20.R.I.RES\(43),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_411);
\GRLFPC20_WRDATA_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(6),
dataf => \GRLFPC20.R.I.RES\(35),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_366,
datac => \GRLFPC20.R.I.RES\(38),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_406);
\GRLFPC20_WRDATA_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(27),
dataf => \GRLFPC20.R.I.RES\(56),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_387,
datac => \GRLFPC20.R.I.RES\(27),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_427);
\GRLFPC20_WRDATA_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(26),
dataf => \GRLFPC20.R.I.RES\(55),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_386,
datac => \GRLFPC20.R.I.RES\(26),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_426);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_18: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"a05090900a050909")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(20),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95));
\GRLFPC20_WRDATA_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(18),
dataf => \GRLFPC20.R.I.RES\(47),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_378,
datac => \GRLFPC20.R.I.RES\(18),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_418);
\GRLFPC20_WRDATA_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(29),
dataf => \GRLFPC20.R.I.RES\(58),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_389,
datac => \GRLFPC20.R.I.RES\(29),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_429);
\GRLFPC20_WRDATA_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(11),
dataf => \GRLFPC20.R.I.RES\(40),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_371,
datac => \GRLFPC20.R.I.RES\(11),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_411);
\GRLFPC20_WRDATA_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(7),
dataf => \GRLFPC20.R.I.RES\(36),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_367,
datac => \GRLFPC20.R.I.RES\(39),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_407);
\GRLFPC20_WRDATA_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(23),
dataf => \GRLFPC20.R.I.RES\(52),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_383,
datac => \GRLFPC20.R.I.RES\(55),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_423);
\GRLFPC20_WRDATA_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(17),
dataf => \GRLFPC20.R.I.RES\(46),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_377,
datac => \GRLFPC20.R.I.RES\(49),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_417);
\GRLFPC20_WRDATA_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(31),
dataf => \GRLFPC20.R.I.RES\(63),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_391,
datac => \GRLFPC20.R.I.RES\(31),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_431);
\GRLFPC20_WRDATA_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(23),
dataf => \GRLFPC20.R.I.RES\(52),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_383,
datac => \GRLFPC20.R.I.RES\(23),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_423);
\GRLFPC20_WRDATA_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(21),
dataf => \GRLFPC20.R.I.RES\(50),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_381,
datac => \GRLFPC20.R.I.RES\(21),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_421);
\GRLFPC20_WRDATA_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(10),
dataf => \GRLFPC20.R.I.RES\(39),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_370,
datac => \GRLFPC20.R.I.RES\(42),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_410);
\GRLFPC20_WRDATA_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(3),
dataf => \GRLFPC20.R.I.RES\(32),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_363,
datac => \GRLFPC20.R.I.RES\(35),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_403);
\GRLFPC20_WRDATA_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(0),
dataf => \GRLFPC20.R.I.RES\(29),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_360,
datac => \GRLFPC20.R.I.RES\(32),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_400);
\GRLFPC20_WRDATA_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(2),
dataf => \GRLFPC20.R.I.RES\(31),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_362,
datac => \GRLFPC20.R.I.RES\(34),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_402);
\GRLFPC20_WRDATA_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(16),
dataf => \GRLFPC20.R.I.RES\(45),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_376,
datac => \GRLFPC20.R.I.RES\(48),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_416);
\GRLFPC20_WRDATA_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(14),
dataf => \GRLFPC20.R.I.RES\(43),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_374,
datac => \GRLFPC20.R.I.RES\(14),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_414);
\GRLFPC20_WRDATA_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(19),
dataf => \GRLFPC20.R.I.RES\(48),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_379,
datac => \GRLFPC20.R.I.RES\(51),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_419);
\GRLFPC20_WRDATA_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(26),
dataf => \GRLFPC20.R.I.RES\(55),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_386,
datac => \GRLFPC20.R.I.RES\(58),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_426);
\GRLFPC20_WRDATA_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(8),
dataf => \GRLFPC20.R.I.RES\(37),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_368,
datac => \GRLFPC20.R.I.RES\(40),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_408);
\GRLFPC20_WRDATA_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(20),
dataf => \GRLFPC20.R.I.RES\(49),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_380,
datac => \GRLFPC20.R.I.RES\(52),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_420);
\GRLFPC20_WRDATA_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI1_WRDATAZ(5),
dataf => \GRLFPC20.R.I.RES\(34),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_365,
datac => \GRLFPC20.R.I.RES\(37),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_405);
\GRLFPC20_WRDATA_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(22),
dataf => \GRLFPC20.R.I.RES\(51),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_382,
datac => \GRLFPC20.R.I.RES\(22),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_422);
\GRLFPC20_WRDATA_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f0fd31f0f0ec20")
port map (
combout => RFI2_WRDATAZ(25),
dataf => \GRLFPC20.R.I.RES\(54),
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => N_385,
datac => \GRLFPC20.R.I.RES\(25),
datab => \GRLFPC20.N_1930\,
dataa => \GRLFPC20.COMB.RDD_2\,
datag => N_425);
\GRLFPC20_R_E_STDATA_RNO_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(26),
dataf => \GRLFPC20.FPI.OP1\(58),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(26),
datac => \GRLFPC20.R.FSR.TEM\(3),
datab => \GRLFPC20.R.I.PC\(26),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(25),
dataf => \GRLFPC20.FPI.OP1\(57),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(25),
datac => \GRLFPC20.R.FSR.TEM\(2),
datab => \GRLFPC20.R.I.PC\(25),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(16),
dataf => \GRLFPC20.FPI.OP1\(48),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(16),
datac => \GRLFPC20.R.FSR.FTT\(2),
datab => \GRLFPC20.R.I.PC\(16),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(23),
dataf => \GRLFPC20.FPI.OP1\(55),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(23),
datac => \GRLFPC20.R.FSR.TEM\(0),
datab => \GRLFPC20.R.I.PC\(23),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(22),
dataf => \GRLFPC20.FPI.OP1\(54),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(22),
datac => \GRLFPC20.R.FSR.NONSTD\,
datab => \GRLFPC20.R.I.PC\(22),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_235_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"b3a0b3a0a0a0a0a0")
port map (
combout => N_12758,
dataf => \GRLFPC20.FPI.OP2\(61),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => N_12822_3,
datac => \GRLFPC20.FPO.EXP\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
dataa => N_12576_2,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(248));
\GRLFPC20_R_E_STDATA_RNO_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(27),
dataf => \GRLFPC20.FPI.OP1\(59),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(27),
datac => \GRLFPC20.R.FSR.TEM\(4),
datab => \GRLFPC20.R.I.PC\(27),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0000000084218181")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5420\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5446\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115));
\GRLFPC20_R_E_STDATA_RNO_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(4),
dataf => \GRLFPC20.FPI.OP1\(36),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(4),
datac => \GRLFPC20.R.FSR.CEXC\(4),
datab => \GRLFPC20.R.I.PC\(4),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(15),
dataf => \GRLFPC20.FPI.OP1\(47),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(15),
datac => \GRLFPC20.R.FSR.FTT\(1),
datab => \GRLFPC20.R.I.PC\(15),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(31),
dataf => \GRLFPC20.FPI.OP1\(63),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(31),
datac => \GRLFPC20.R.FSR.RD\(1),
datab => \GRLFPC20.R.I.PC\(31),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_234_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"b3a0b3a0a0a0a0a0")
port map (
combout => N_12783,
dataf => \GRLFPC20.FPI.OP2\(62),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => N_12822_3,
datac => \GRLFPC20.FPO.EXP\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
dataa => N_12576_2,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(247));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_236_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"b3a0b3a0a0a0a0a0")
port map (
combout => N_12733,
dataf => \GRLFPC20.FPI.OP2\(60),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => N_12822_3,
datac => \GRLFPC20.FPO.EXP\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
dataa => N_12576_2,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(249));
\GRLFPC20_R_E_STDATA_RNO_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(9),
dataf => \GRLFPC20.FPI.OP1\(41),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(9),
datac => \GRLFPC20.R.FSR.AEXC\(4),
datab => \GRLFPC20.R.I.PC\(9),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(10),
dataf => \GRLFPC20.FPI.OP1\(42),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(10),
datac => CPO_CCZ(0),
datab => \GRLFPC20.R.I.PC\(10),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(11),
dataf => \GRLFPC20.FPI.OP1\(43),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(11),
datac => CPO_CCZ(1),
datab => \GRLFPC20.R.I.PC\(11),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(3),
dataf => \GRLFPC20.FPI.OP1\(35),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(3),
datac => \GRLFPC20.R.FSR.CEXC\(3),
datab => \GRLFPC20.R.I.PC\(3),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cfc0f5f5cfc0a0a0")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(5),
dataf => \GRLFPC20.FPI.OP1\(37),
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(5),
datac => \GRLFPC20.R.FSR.AEXC\(0),
datab => \GRLFPC20.R.I.PC\(5),
dataa => \GRLFPC20.R.A.AFSR\,
datag => \GRLFPC20.COMB.V.E.STDATA2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_17: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_17\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(214),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9665\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_16: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_16\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(215),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9664\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULLSBLOGIC_STCKYPAIR_UN3_GEN: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"00c0888800c08080")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN3_GEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(371),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(313),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9449\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(372),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8));
GRLFPC20_COMB_UN1_FPCI_1_RNI2MVR1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0003000100030000")
port map (
combout => \GRLFPC20.COMB.ANNULRES_1_IV_221_1\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.R.M.FPOP\,
datad => \GRLFPC20.R.I.EXEC\,
datac => \GRLFPC20.N_1174\,
datab => \GRLFPC20.R.X.FPOP\,
dataa => \GRLFPC20.R.E.FPOP\,
datag => \GRLFPC20.N_1803\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_19: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_19\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(212),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9667\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_11: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_11\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(220),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9659\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_10: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_10\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(221),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_14: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(217),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9662\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_15: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_15\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(216),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9663\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_18: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(213),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f66ff99ff99ff99f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9613\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9594\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5413\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9607\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_9\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(222),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_8: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(223),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9656\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(219),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9660\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN18_XZXBUS_13: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4b4b4bbb78787888")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_13\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(218),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9661\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_1_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0f04400f0f04000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10122\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M12_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0fcf5f5f0fcf0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7987\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M13_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"f0fcf5f5f0fcf0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7989\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_2_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"4400440044404440")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9638\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M12\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M13\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_YY_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"0000323200033232")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_8445\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7989\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM6\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_WAITMULXFF_NOTSAMPLEDWAIT: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "on",
    lut_mask => X"cc0c400000004000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN11_WQSTSETS_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4367\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datag => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_0_BUF: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
cout => N_25118,
datad => VCC,
cin => GND);
GRLFPC20_R_X_LD_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.LD_0_0_G1\,
dataf => \GRLFPC20.R.M.LD\,
datae => \GRLFPC20.N_1803\);
GRLFPC20_R_X_FPOP_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.M.FPOP\,
datae => \GRLFPC20.N_1803\);
GRLFPC20_R_X_AFSR_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.M.AFSR\,
datae => \GRLFPC20.N_1803\);
GRLFPC20_R_X_AFQ_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.X.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.M.AFQ\,
datae => \GRLFPC20.N_1803\);
GRLFPC20_R_M_LD_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.LD_0_0_G1\,
dataf => \GRLFPC20.R.E.LD\,
datae => \GRLFPC20.N_1805\);
GRLFPC20_R_M_FPOP_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.E.FPOP\,
datae => \GRLFPC20.N_1805\);
GRLFPC20_R_M_AFSR_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.E.AFSR\,
datae => \GRLFPC20.N_1805\);
GRLFPC20_R_M_AFQ_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.M.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.E.AFQ\,
datae => \GRLFPC20.N_1805\);
GRLFPC20_R_E_LD_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.LD_0_0_G1\,
dataf => \GRLFPC20.R.A.LD\,
datae => \GRLFPC20.N_1174\);
GRLFPC20_R_E_FPOP_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.FPOP_0_0_G1\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.N_1174\);
GRLFPC20_R_E_AFSR_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.AFSR_0_0_G1\,
dataf => \GRLFPC20.R.A.AFSR\,
datae => \GRLFPC20.N_1174\);
GRLFPC20_R_E_AFQ_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.R.E.AFQ_0_0_G1\,
dataf => \GRLFPC20.R.A.AFQ\,
datae => \GRLFPC20.N_1174\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_3_0__ROM_31_RNIQVMH1\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc3ccc0cf030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_3_0__ROM_32_RNITVMH1\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc3ccc0cf030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_3_0__ROM_27_RNILFRN1\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(34),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_63_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(62),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(62),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(62),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(62),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(62),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_62_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(61),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(61),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(61),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(61),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_61_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(60),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(60),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(60),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(60),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(60),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_60_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(59),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(59),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(59),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(59),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(59),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_59_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(58),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(58),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(58),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(57),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(56),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(55),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(55),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(54),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(54),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(52),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(52),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(51),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(51),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(50),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(49),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(48),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(48),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(47),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(47),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(44),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(46),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(44),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fcccf0c03c0c3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(42),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fcccf0c03c0c3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(42),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc3ccc0cf030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(40),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(37),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(39),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3e6a2d591c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(38),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(37),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(37),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(37),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(36),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(36),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(32),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(31),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(28),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(27),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(26),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(25),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3e6a2d591c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3e6a2d591c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(19),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(19),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(19),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(18),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(18),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(18),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(17),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fc3ccc0cf030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(15),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3f0f33033c0c3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(13),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(11),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(7),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f7b3d591e6a2c480")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10122\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10862\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_230_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24867,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(230));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_231_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24866,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_231__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(231));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24865,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24864,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_1__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24863,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_2__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24862,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24861,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24860,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24859,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24858,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24857,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_8__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24855,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24854,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24853,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24852,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24851,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_15__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24850,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24849,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24848,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24847,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24846,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24845,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24844,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24843,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24842,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24841,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24840,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24839,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24838,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24837,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24836,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24835,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24834,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24833,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24832,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24831,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24830,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_41__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24829,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_43__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24828,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_44__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24827,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24826,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_46__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24825,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24824,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24823,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24822,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24821,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24820,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24819,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24818,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(55));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24817,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24816,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24815,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(58));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_59_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24814,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(59));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_60_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24813,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(59),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_61_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24812,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(60),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_62_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24811,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(61),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_63_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24810,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(62),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24809,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_30__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24808,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_29__G2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24806,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UPDATE_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_EXPXBUS_1_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9595\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(34),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.EXPYBUS_2\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI5IC2H3_315_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"b77bbf7ff7fbffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_I\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G0_9_2\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c3f0c033033000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9272\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0_RNI9JEKI_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G3_1_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_9_RNIGFOUT2_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eded48e8ffff00a0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN25_NOTPROP\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.2.CI_56_CARRY_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G3_1_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_2\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_I\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9271\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_315__G3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI6A5741_315_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f300000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G0_9_2\,
dataf => N_20831,
datae => N_20783,
datad => N_20781,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(315));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_CIN_0_RNIO2C29: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f0ff0f0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7528\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_0\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_9_RNID5T0R_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fceee2aafcccc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_MIXOIN_19_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SBLSBS_1\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
datac => N_20782,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO1_0\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7114\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI1VB5K_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0000ff00ffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SCLSBS_1\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_943\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.G1_3\);
\GRLFPC20_R_A_RF1REN_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ccccc444")
port map (
combout => N_14004,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2316\,
datad => \GRLFPC20.N_953_1\,
datac => \GRLFPC20.R.A.RS1D_0_0_G4\,
datab => \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_3\,
dataa => N_47);
\GRLFPC20_R_I_EXC_RNI7POI3_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"23000000af000000")
port map (
combout => \GRLFPC20.COMB.UN1_ANNULFPU\,
dataf => \GRLFPC20.N_2132\,
datae => \GRLFPC20.COMB.UN1_ANNULFPU_TZ_TZ\,
datad => \GRLFPC20.R.MK.BUSY2_0_0_G3_0\,
datac => \GRLFPC20.R.M.FPOP\,
datab => \GRLFPC20.R.I.EXC\(5),
dataa => \GRLFPC20.N_1803\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_237_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff000f0ffc000c0")
port map (
combout => N_14000,
dataf => \GRLFPC20.FPO.EXP\(7),
datae => N_12726,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_536_I_0_TZ\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN40_SHDVAR: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffe00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5450\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_141_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0a000affca00ca")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(141),
dataf => N_20779,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10305\,
datad => N_23932,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(143));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN1_ENTRYPOINT: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"2020202020202000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7413\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4286\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7422\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4137\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_GRFPUE_CARRY_10_RNIK9NM1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8888888888888880")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN12_SRTOSTICKY_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.GRFPUE\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(15));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"808040402f20101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff6a95ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10512\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5496\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9614\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
GRLFPC20_COMB_RDD_1_M10_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"1111111111111000")
port map (
combout => \GRLFPC20.COMB.RDD_1.M10_0\,
dataf => \GRLFPC20.N_3751\,
datae => \GRLFPC20.N_2306\,
datad => \GRLFPC20.COMB.FPDECODE.RDD2_5\,
datac => \GRLFPC20.COMB.FPDECODE.RDD2_4\,
datab => N_66,
dataa => N_67);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_84_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffeaffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4066\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4035\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4030\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_84_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
datae => N_56);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_84_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00fff0ff00ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_8\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\,
datad => N_24326,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_84_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f2f2000af0fa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_2_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_8\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_1__G0_N_5\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_7_SQMUXA: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => N_24427,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_DPATH_NEW_7_SQMUXA_SUB: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff7fffffffffffff")
port map (
combout => N_24427,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_C\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(5));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_52: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0040000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_52\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_33\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_31\,
datad => N_24417,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_11\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_4\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_52_SUB: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff7fff8ffff7fff8")
port map (
combout => N_24417,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_19\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20267,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24411,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(206));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_25_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24411,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20261,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24409,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(208));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_23_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24409,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20273,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24407,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(204));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_27_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24407,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20268,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24403,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(205));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_26_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24403,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20262,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24401,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(207));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_24_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24401,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNI6D4T5_68_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c43b04fbf70837c8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9638\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33ccff0023dcef10")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9633\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33ccff0023dcef10")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9634\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"01fe05fa01fe0ff0")
port map (
combout => N_20189,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5437\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f1e0f3c0f5a0ff0")
port map (
combout => N_20195,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5437\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.EXTEND.TEMP_0\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14S2_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM6\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_COUNTSUCCESSIVEZERO18_S: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffe")
port map (
combout => N_24328,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_COUNTSUCCESSIVEZERO18_S_RNIR8R21: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000f00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_COUNTSUCCESSIVEZERO18_12\,
datae => N_24328,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2));
GRLFPC20_COMB_V_A_LD_1_I_O2_S: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0004000500050005")
port map (
combout => N_24327,
dataf => \GRLFPC20.N_1981\,
datae => \GRLFPC20.N_3728\,
datad => \GRLFPC20.N_3737\,
datac => \GRLFPC20.N_3731\,
datab => \GRLFPC20.N_1978\,
dataa => N_82);
GRLFPC20_COMB_V_A_LD_1_I_O2_S_RNIC7BO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff0ffffffff")
port map (
combout => \GRLFPC20.N_3748\,
dataf => N_24327,
datae => CPO_EXCZ,
datad => N_8,
datac => N_81);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_RESULT_IV_S_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"faaaaaaacaaaaaaa")
port map (
combout => N_24326,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SFTLFT.AREGXORBREG\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(59));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_244_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24325,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(257));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_244_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13993,
dataf => \GRLFPC20.FPO.EXP\(0),
datae => N_24325,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12573);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_243_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24324,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(256));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_243_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13994,
dataf => \GRLFPC20.FPO.EXP\(1),
datae => N_24324,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12595);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_242_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24323,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(255));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_242_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13995,
dataf => \GRLFPC20.FPO.EXP\(2),
datae => N_24323,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12617);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_241_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24322,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(254));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_241_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13996,
dataf => \GRLFPC20.FPO.EXP\(3),
datae => N_24322,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12639);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_240_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24321,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(253));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_240_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13997,
dataf => \GRLFPC20.FPO.EXP\(4),
datae => N_24321,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12661);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_239_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24320,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(252));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_239_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13998,
dataf => \GRLFPC20.FPO.EXP\(5),
datae => N_24320,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12683);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_238_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaffa8fcfffffcfc")
port map (
combout => N_24319,
dataf => N_12576_2,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(251));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_238_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0000000f0000")
port map (
combout => N_13999,
dataf => \GRLFPC20.FPO.EXP\(6),
datae => N_24319,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
datac => N_12705);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff7ff77ff80ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
dataf => N_16975,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\,
datad => N_24313,
datac => N_17013,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_SUB_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0f8f0f0f")
port map (
combout => N_24313,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
datae => N_17014,
datad => N_17013,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4367\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNITIV86_1_68_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => N_24311,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIKH3F5_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"03cfffffffffffff")
port map (
combout => N_24311,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_C\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_RNO_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"aaa8aaa80a08aaa8")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN30_CONDITIONAL\,
dataf => N_24309,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(56),
datac => \GRLFPC20.FPO.FRAC\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0_1\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_RNO_0_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fffffffffffffff")
port map (
combout => N_24309,
dataf => \GRLFPC20.FPO.FRAC\(53),
datae => \GRLFPC20.FPO.FRAC\(52),
datad => \GRLFPC20.FPO.FRAC\(51),
datac => \GRLFPC20.FPO.FRAC\(50));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_47: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000087000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_47\,
dataf => N_24303,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_47_SUB: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff3fffffffc0")
port map (
combout => N_24303,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_9\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.UN18_XZXBUS_13\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20256,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24301,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(209));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_22_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_24301,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_4_RNO_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_24299,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_6_RNO_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_24297,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_7_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20213,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24295,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(224));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_7_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24295,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_20_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20250,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24293,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(211));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_20_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_24293,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(37));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_5_RNO_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00ff00ff")
port map (
combout => N_24291,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00ff00f3c3cf0f0")
port map (
combout => N_20255,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
datad => N_24289,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(210));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_21_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff0000ffff")
port map (
combout => N_24289,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_M3_S_113_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000002fff")
port map (
combout => N_16976,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_NEW_1_SQMUXA_31\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_D\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZBREGLOADEN\,
datab => N_12822_3,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNIVIA05_68_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0000000f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_C\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_WQSCTRL_RNIMO5C5_68_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3300000003000000")
port map (
combout => N_10421,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.DPATH_M3_E_C\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\,
datab => N_12822_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9322\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9382\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9321\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9381\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(8),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9320\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9380\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(9),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9319\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9379\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9318\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9378\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9317\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9377\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9316\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9376\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9315\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9375\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9314\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9374\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(15),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9313\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9373\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(16),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9312\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9372\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(17),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9311\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9371\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(18),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9310\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9370\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(19),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9309\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9369\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(20),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9308\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9368\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(21),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9307\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9367\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9306\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9366\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9305\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9365\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9304\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9364\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9303\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9363\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9362\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9361\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9300\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9360\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(29),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9299\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9359\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9298\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9358\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9297\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9357\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9296\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9356\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9355\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9294\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9354\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9293\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9353\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9292\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9352\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(37),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9291\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9351\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9290\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9350\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9289\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9349\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(40),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9288\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9348\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(41),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9287\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9347\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9286\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9346\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9285\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9345\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(44),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9284\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9344\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(45),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9283\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9343\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(46),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9282\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9342\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9281\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9341\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9280\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9340\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9279\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9339\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9278\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9338\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(51),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9277\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9337\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(52),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9276\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9336\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9275\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9335\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(54),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9274\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9334\,
datad => N_23933_I_0);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24258,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24257,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24256,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24255,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24254,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24253,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24252,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24251,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24250,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24249,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24248,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24247,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24246,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(18),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24245,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24244,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24243,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24242,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24241,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24240,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24239,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24238,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24237,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24236,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24235,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24234,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24233,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24232,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24231,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24230,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24229,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(35),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24228,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24227,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24226,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24225,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24224,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24223,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(41),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24222,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24221,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24220,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24219,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24218,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24217,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24216,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24215,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24214,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24213,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24212,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24211,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_24210,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.XZAREGLOADEN_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH1\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_MIXOIN_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00c000aa00aa")
port map (
combout => N_20780,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.NOTPROP\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN3_GEN\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(371),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(313),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(373));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M2_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_M2\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16));
GRLFPC20_R_A_MOV_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000070000000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1_4\,
dataf => N_52,
datae => N_53,
datad => \GRLFPC20.N_3763\,
datac => N_58,
datab => N_55,
dataa => N_54);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_UN10_S_MOV: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000001000300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7462\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4132\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_ENTRYSHFT_ENTRYPOINT_0_TZ: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fefeffffffffffbf")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.ENTRYSHFT.ENTRYPOINT_0_TZ\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_COMB_LOCKGEN_DEPCHECK: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffffc")
port map (
combout => \GRLFPC20.N_1171\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.R.I.EXEC\,
datad => \GRLFPC20.R.A.FPOP\,
datac => \GRLFPC20.R.E.FPOP\,
datab => \GRLFPC20.R.M.FPOP\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
GRLFPC20_COMB_UN9_CCV_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff888f888f888")
port map (
combout => \GRLFPC20.COMB.UN9_CCV_2\,
dataf => \GRLFPC20.R.I.EXEC\,
datae => \GRLFPC20.R.I.INST\(19),
datad => \GRLFPC20.R.X.FPOP\,
datac => N_342,
datab => \GRLFPC20.R.M.FPOP\,
dataa => N_273);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI16G42_78_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000002")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_9__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(200));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(205));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(201));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(176));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(206));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_19990,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20030,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20059,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20076,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(207));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18934,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(203));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18942,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI0KQO1_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7095\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(21),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(210));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(198));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(40),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(191));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(51),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(180));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(183));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(193));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNI3EGO2_369_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0cf3fcf3f30c030c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7094\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7502\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9452\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(369));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(45),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(186));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(46),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(185));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(209));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(30),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(204));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(37),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(194));
\GRLFPC20_R_A_RS1_RNI6QK02_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00aaf3f300aac0c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(4),
dataf => \GRLFPC20.R.A.RS1\(4),
datae => \GRLFPC20.COMB.RS1_1_SN_N_3\,
datad => \GRLFPC20.N_3742\,
datac => N_65,
datab => N_7,
dataa => N_76);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(188));
\GRLFPC20_R_E_STDATA_RNO_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"d8ffd8ffd8ffd800")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_17__G1\,
dataf => \GRLFPC20.FPI.OP1\(49),
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.A.AFQ\,
datac => \GRLFPC20.R.I.INST\(17),
datab => \GRLFPC20.R.I.PC\(17),
dataa => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(181));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(52),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(179));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(41),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(190));
\GRLFPC20_R_E_STDATA_RNO_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"d800d8ffd800d800")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_21__G1\,
dataf => \GRLFPC20.FPI.OP1\(53),
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.A.AFQ\,
datac => \GRLFPC20.R.I.INST\(21),
datab => \GRLFPC20.R.I.PC\(21),
dataa => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(192));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(199));
\GRLFPC20_R_A_RS1_RNI3NK02_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00aaf3f300aac0c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(3),
dataf => \GRLFPC20.R.A.RS1\(3),
datae => \GRLFPC20.COMB.RS1_1_SN_N_3\,
datad => \GRLFPC20.N_3742\,
datac => N_64,
datab => N_7,
dataa => N_75);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(54),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(177));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(178));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(202));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(208));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(184));
\GRLFPC20_COMB_RS1_1_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00aaf3f300aac0c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(1),
dataf => \GRLFPC20.R.A.RS1\(1),
datae => \GRLFPC20.COMB.RS1_1_SN_N_3\,
datad => \GRLFPC20.N_3742\,
datac => N_62,
datab => N_7,
dataa => N_73);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(44),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(187));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(196));
\GRLFPC20_COMB_RS1_1_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00aaf3f300aac0c0")
port map (
combout => \GRLFPC20.COMB.RS1_1\(2),
dataf => \GRLFPC20.R.A.RS1\(2),
datae => \GRLFPC20.COMB.RS1_1_SN_N_3\,
datad => \GRLFPC20.N_3742\,
datac => N_63,
datab => N_7,
dataa => N_74);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(7),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(182));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(197));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0aaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(195));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\(57),
datad => N_20678,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(56),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(175));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_1_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccaaaa0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441_1\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(189));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_UN23_EXPXBUS_NE_6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fdf7df2aa8f7df7f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_NE_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9597\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9612\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9611\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(33));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8f8020204040101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(25),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_29_D_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"66633363eec9bbc9")
port map (
combout => N_17014,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4066\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8f8020204040101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_6\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_14: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"808020204f40101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_14\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(47),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZZERO_1_21: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8f8020204040101f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1_21\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f4f6f9fbfdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f1f4f5fafbfeff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(50),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f4f6f9fbfdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f9fbf4f6fdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f8f2faf5fdf7ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f9fbf4f6fdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f4f1f5fafefbff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(36),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_RS1_1_0_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfcfcfc0cfc0cfc0")
port map (
combout => RFI2_RD1ADDRZ(3),
dataf => N_76,
datae => \GRLFPC20.N_3767\,
datad => \GRLFPC20.COMB.RS1_1\(4),
datac => N_392,
datab => N_399);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_CIN_0_RNIVDQG6: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0f00ff00f0ff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULLSBLOGIC.STCKYPAIR.UN16_NOTPROP\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.TRFWWRRAY.SI_57\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7528\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7114\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f4f9fdf2f6fbff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(18),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f9f2fbf4fdf6ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f4f9fdf2f6fbff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f2f4f6f9fbfdff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f9f4fdf2fbf6ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
GRLFPC20_COMB_WREN1_11_IV_1_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => \GRLFPC20.FPCI_I_M\(340),
dataf => N_343,
datae => \GRLFPC20.N_1635\,
datad => N_348,
datac => \GRLFPC20.WREN2_2_SQMUXA_1_1\);
\GRLFPC20_COMB_RF2REN_1_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"30303030fcfcfc30")
port map (
combout => \GRLFPC20.N_3655\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.COMB.RS2D_1\,
datad => \GRLFPC20.COMB.RS2_1\(0),
datac => \GRLFPC20.R.A.RF2REN\(2),
datab => N_7);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f8f2faf5fdf7ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(20),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(36),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f1f4f5fafbfeff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(35),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00000caa0caa")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20721,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(0));
\GRLFPC20_COMB_RF1REN_1_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4f400f004f404f40")
port map (
combout => \GRLFPC20.N_3662\,
dataf => \GRLFPC20.COMB.RS2_1\(0),
datae => \GRLFPC20.COMB.RS2D_1\,
datad => \GRLFPC20.R.A.RF1REN\(2),
datac => N_7,
datab => \GRLFPC20.N_2174\,
dataa => N_12971);
\GRLFPC20_COMB_RF2REN_1_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"bfbfb0bfbfb0b0b0")
port map (
combout => RFI2_REN1Z,
dataf => \GRLFPC20.R.A.RF2REN\(1),
datae => N_14007,
datad => N_7,
datac => N_392,
datab => N_393,
dataa => N_394);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN50_ZERO_RNI4OPC71: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c33c3cc33cc3c33c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_32\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7155\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7244\);
\GRLFPC20_R_FSR_CEXC_RNO_1_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"8c008c8caf00afaf")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_0__G1_1\,
dataf => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datae => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
datad => \GRLFPC20.N_1142\,
datac => \GRLFPC20.N_1379\,
datab => N_360,
dataa => N_400);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_247_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(247),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9996\,
datad => \GRLFPC20.FPO.EXP\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(247),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_248_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffccf0f03300f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(248),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9995\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datad => \GRLFPC20.FPO.EXP\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(248),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_249_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(249),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9994\,
datad => \GRLFPC20.FPO.EXP\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(249),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_250_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(250),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9993\,
datad => \GRLFPC20.FPO.EXP\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(250),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_251_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(251),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9992\,
datad => \GRLFPC20.FPO.EXP\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(251),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_252_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(252),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9991\,
datad => \GRLFPC20.FPO.EXP\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(252),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_253_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(253),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\,
datad => \GRLFPC20.FPO.EXP\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(253),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_254_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000fc30fc30")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(254),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10003\,
datad => \GRLFPC20.FPI.OP1\(58),
datac => \GRLFPC20.FPI.OP1\(55),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_255_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000fc30fc30")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(255),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10002\,
datad => \GRLFPC20.FPI.OP1\(57),
datac => \GRLFPC20.FPI.OP1\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_256_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(256),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9987\,
datad => \GRLFPC20.FPO.EXP\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(256),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_257_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc3300f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(257),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9986\,
datad => \GRLFPC20.FPO.EXP\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(257),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_246_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00f0000000f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(246),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10011\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246));
\GRLFPC20_R_E_STDATA_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00ffff0f000000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_0__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_0__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(0),
datac => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00ffff0f000000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_1__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_1__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(1),
datac => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(2),
dataf => \GRLFPC20.N_3395\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(2),
datac => \GRLFPC20.R.I.PC\(2),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(6),
dataf => \GRLFPC20.N_3399\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(6),
datac => \GRLFPC20.R.I.PC\(6),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(7),
dataf => \GRLFPC20.N_3400\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(7),
datac => \GRLFPC20.R.I.PC\(7),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(8),
dataf => \GRLFPC20.N_3401\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(8),
datac => \GRLFPC20.R.I.PC\(8),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_12__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_12__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(12),
datac => \GRLFPC20.R.I.PC\(12),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(13),
dataf => \GRLFPC20.N_3406\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(13),
datac => \GRLFPC20.R.I.PC\(13),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(14),
dataf => \GRLFPC20.N_3407\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(14),
datac => \GRLFPC20.R.I.PC\(14),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_18__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_18__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(18),
datac => \GRLFPC20.R.I.PC\(18),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_19__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_19__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(19),
datac => \GRLFPC20.R.I.PC\(19),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_20__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_20__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(20),
datac => \GRLFPC20.R.I.PC\(20),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(24),
dataf => \GRLFPC20.N_3417\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(24),
datac => \GRLFPC20.R.I.PC\(24),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_28__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_28__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(28),
datac => \GRLFPC20.R.I.PC\(28),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_29__G1\,
dataf => \GRLFPC20.R.E.STDATA_1_0_29__G2\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(29),
datac => \GRLFPC20.R.I.PC\(29),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
\GRLFPC20_R_E_STDATA_RNO_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f3c0fffff3c00000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA_1\(30),
dataf => \GRLFPC20.N_3423\,
datae => \GRLFPC20.R.A.AFQ\,
datad => \GRLFPC20.R.I.INST\(30),
datac => \GRLFPC20.R.I.PC\(30),
datab => \GRLFPC20.COMB.V.E.STDATA2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M5S4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7987\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M14S2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.COUNTSUCCESSIVEZERO_SM12_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(10));
\GRLFPC20_R_A_SEQERR_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => \GRLFPC20.R.A.SEQERR_0_0_1__G1\,
dataf => \GRLFPC20.COMB.RDD_1.I7_MUX\,
datae => N_71,
datad => N_69,
datac => N_78);
\GRLFPC20_R_A_RF1REN_RNO_1_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_1\,
dataf => N_71,
datae => N_67,
datad => N_70);
\GRLFPC20_R_A_RF1REN_RNO_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000c000000")
port map (
combout => \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_3\,
dataf => N_77,
datae => N_78,
datad => \GRLFPC20.COMB.V.A.RF1REN_1_0_796_I_1\,
datac => N_69,
datab => N_68);
GRLFPC20_R_A_LD_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000cf")
port map (
combout => \GRLFPC20.R.A.LD_0_0_G1\,
dataf => \GRLFPC20.N_3769\,
datae => \GRLFPC20.N_3748\,
datad => N_68,
datac => N_67,
datab => N_66);
GRLFPC20_RS2_0_SQMUXA_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.RS2_0_SQMUXA_1\,
dataf => N_70,
datae => N_77,
datad => N_78);
GRLFPC20_RS2_0_SQMUXA: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000c000000000000")
port map (
combout => \GRLFPC20.N_2174\,
dataf => \GRLFPC20.RS2_0_SQMUXA_1\,
datae => N_71,
datad => N_67,
datac => N_69,
datab => N_68);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_374_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff30000003ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(374),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_258_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c333ccc33ccc333c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G3\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7292\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10506\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_1505_I\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7155\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_258__G5\);
GRLFPC20_R_MK_BUSY2_RNI08GJ: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f000000000")
port map (
combout => \GRLFPC20.R.I.CC_0_0_1__N_7\,
dataf => \GRLFPC20.N_1171\,
datae => \GRLFPC20.N_1180\,
datad => \GRLFPC20.R.MK.BUSY\,
datac => \GRLFPC20.R.MK.BUSY2\);
GRLFPC20_R_MK_BUSY2_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.N_2567\,
dataf => \GRLFPC20.COMB.UN1_ANNULFPU\,
datae => \GRLFPC20.R.MK.BUSY\,
datad => N_5);
GRLFPC20_R_MK_BUSY_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000c00000")
port map (
combout => \GRLFPC20.N_2565\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\,
datae => \GRLFPC20.COMB.UN1_ANNULFPU\,
datad => \GRLFPC20.N_1180\,
datac => CPO_HOLDNZ,
datab => N_5);
GRLFPC20_COMB_UN1_FPCI_2_RNIIP8T: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000ff00f0f0ffff")
port map (
combout => \GRLFPC20.R.MK.BUSY2_0_0_G3_0\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.R.E.FPOP\,
datad => \GRLFPC20.N_1174\,
datac => \GRLFPC20.N_1805\);
GRLFPC20_R_MK_RST_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000080")
port map (
combout => \GRLFPC20.COMB.V.MK.RST_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\,
datae => \GRLFPC20.COMB.UN1_ANNULFPU\,
datad => \GRLFPC20.N_1180\,
datac => \GRLFPC20.R.MK.HOLDN1\,
datab => \GRLFPC20.R.MK.HOLDN2\,
dataa => N_7);
\GRLFPC20_R_I_EXC_RNO_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_3__G3\,
dataf => \GRLFPC20.N_1453_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_FEEDBACKMULXFF_UN6_FEEDBACK: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_76_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffff0f0f0fff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.UN33_PCTRL_NEW_I\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(61));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_115_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0300030003030000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(115),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(115),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(115),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
datab => N_12822_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIFDCR1_4_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000eac0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5437\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(374),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(12));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_EXPBREGLOADEN: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fffcff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPBREGLOADEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26));
GRLFPC20_R_I_EXEC_RNO_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000c000c0c0")
port map (
combout => \GRLFPC20.R.I.EXEC_0_0_G1_0_698_A2_1\,
dataf => \GRLFPC20.N_1147\,
datae => N_12871_0,
datad => \GRLFPC20.R.I.EXEC_M\,
datac => N_12853,
datab => N_5);
GRLFPC20_R_I_EXEC_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000030000000000")
port map (
combout => N_12854,
dataf => N_12854_2,
datae => \GRLFPC20.N_2126\,
datad => \GRLFPC20.R.I.EXEC_0_0_G1_0_698_A2_1\,
datac => \GRLFPC20.COMB.ANNULRES_1_IV_221_0\,
datab => \GRLFPC20.COMB.ANNULRES_1_IV_221_1\);
GRLFPC20_COMB_LOCK_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000030")
port map (
combout => CPO_LDLOCKZ,
dataf => \GRLFPC20.R.STATE\(1),
datae => \GRLFPC20.R.STATE\(0),
datad => N_81,
datac => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datab => N_82);
\GRLFPC20_R_FSR_FTT_RNO_0_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00cc00c000cc00")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_769_I_1\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.R.X.SEQERR\,
datad => \GRLFPC20.R.I.EXC\(5),
datac => \GRLFPC20.N_1212\,
datab => N_5);
\GRLFPC20_R_FSR_FTT_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0c0000000000000")
port map (
combout => N_14003,
dataf => N_12891_1,
datae => \GRLFPC20.R.FSR.FTT_1_0_1__G2_0_769_I_1\,
datad => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.I.V\,
datab => \GRLFPC20.R.I.EXEC\);
\GRLFPC20_R_FSR_FTT_RNO_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00cc00c000cc00")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_745_I_1\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.R.X.SEQERR\,
datad => \GRLFPC20.R.I.V\,
datac => \GRLFPC20.N_1212\,
datab => N_5);
\GRLFPC20_R_FSR_FTT_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccc00000fff00000")
port map (
combout => N_14002,
dataf => N_12891_1,
datae => \GRLFPC20.R.FSR.FTT_1_0_0__G2_0_745_I_1\,
datad => \GRLFPC20.R.X.FPOP\,
datac => \GRLFPC20.R.I.EXEC\,
datab => \GRLFPC20.R.I.EXC\(5));
\GRLFPC20_R_FSR_FTT_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000c00")
port map (
combout => \GRLFPC20.R.FSR.FTT_1_0_2__G2\,
dataf => \GRLFPC20.N_2126\,
datae => \GRLFPC20.N_1147\,
datad => \GRLFPC20.R.X.SEQERR\,
datac => \GRLFPC20.N_1212\,
datab => N_5);
\GRLFPC20_R_STATE_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00ff0000000000")
port map (
combout => \GRLFPC20.R.STATE_0_0_0__G1\,
dataf => \GRLFPC20.COMB.V.STATE_9\(0),
datae => CPO_EXCZ,
datad => \GRLFPC20.N_1536\,
datac => N_9);
GRLFPC20_R_X_FPOP_RNIVP8E: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff0000000000")
port map (
combout => \GRLFPC20.R.I.PC_1_0_9__G2\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.N_1212\,
datad => N_7);
GRLFPC20_R_X_FPOP_RNIA0UC: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffffffff")
port map (
combout => N_12871,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.N_1212\);
GRLFPC20_COMB_UN2_HOLDN: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.N_1453\,
dataf => \GRLFPC20.R.A.FPOP\,
datae => \GRLFPC20.R.A.MOV\,
datad => \GRLFPC20.N_1174\,
datac => N_7);
\GRLFPC20_R_FSR_AEXC_RNO_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
dataf => \GRLFPC20.N_1270\,
datae => \GRLFPC20.N_1342\,
datad => \GRLFPC20.N_1379\,
datac => N_367,
datab => N_407);
\GRLFPC20_R_FSR_AEXC_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_2__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_2__G1_0\,
datac => \GRLFPC20.R.I.EXC\(2),
datab => \GRLFPC20.R.FSR.AEXC\(2));
GRLFPC20_V_STATE_0_SQMUXA_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => \GRLFPC20.N_1379\,
dataf => N_393,
datae => N_394,
datad => N_392);
\GRLFPC20_R_FSR_AEXC_RNO_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_0__G1_0\,
dataf => \GRLFPC20.N_1270\,
datae => \GRLFPC20.N_1342\,
datad => \GRLFPC20.N_1379\,
datac => N_365,
datab => N_405);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_65_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0fff0fffffff0ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_2\(65),
dataf => N_12556,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(66),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(64));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN48_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7273\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN54_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7189\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(18));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_81_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff00ff00fe00f2")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.CHECKOVANDDENORM.UN13_NOTPOSSIBLEOV\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(56));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_81_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00fb0fff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_4__G0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
dataa => N_53);
GRLFPC20_R_A_MOV_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000c0000000000")
port map (
combout => \GRLFPC20.R.A.MOV_0_0_G1\,
dataf => \GRLFPC20.R.A.MOV_0_0_G1_4\,
datae => N_57,
datad => \GRLFPC20.N_921\,
datac => N_77,
datab => N_78);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_64_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00ff")
port map (
combout => \GRLFPC20.FPI.RST\,
dataf => \GRLFPC20.R.MK.RST2\,
datae => \GRLFPC20.R.MK.RST\,
datad => N_5);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_0_679_A2_3: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff00ff")
port map (
combout => N_12822_3,
dataf => \GRLFPC20.N_1180\,
datae => \GRLFPC20.R.MK.LDOP\,
datad => N_5);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SXC.SCTRL_NEW_4\(2),
dataf => N_54,
datae => N_58,
datad => N_56,
datac => N_59);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0fffffff00")
port map (
combout => N_12535,
dataf => \GRLFPC20.R.FSR.RD\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffffff00")
port map (
combout => N_12534,
dataf => \GRLFPC20.R.FSR.RD\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(21));
\GRLFPC20_R_I_EXC_RNO_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f0000000000000")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_2__G3\,
dataf => \GRLFPC20.R.I.EXC_MB\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_78_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f2f3f3f300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_7__G0_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datac => N_10350,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_79_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffaf0000ffcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(54),
dataa => N_55);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_79_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f2f3f3f300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I_0_6__G0_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datac => N_10349,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_82_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00b300b300ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3967\,
dataa => N_58);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_82_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffd0c0c0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_0_3__G0_0_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datac => N_10346,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000003033f0ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.SCTRL_38_IV_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN4_TFCC_M\,
datae => N_10421,
datad => N_12822_3,
datac => \GRLFPC20.FPI.OP1\(63),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_0\);
\GRLFPC20_R_FSR_CEXC_RNO_2_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cf000000cfcfcfcf")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_4__G1_0\,
dataf => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
datae => \GRLFPC20.R.FSR.TEM\(4),
datad => \GRLFPC20.R.I.EXC\(4),
datac => \GRLFPC20.N_1379\,
datab => N_404);
\GRLFPC20_R_FSR_CEXC_RNO_0_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0f00000ccff")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\,
dataf => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datae => \GRLFPC20.N_1145_I_M\,
datad => \GRLFPC20.N_1379\,
datac => N_363,
datab => N_403);
\GRLFPC20_R_FSR_CEXC_RNO_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000f000cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_3__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.CEXC_3_SQMUXA\,
datad => \GRLFPC20.R.FSR.CEXC_1_0_3__G1_1\,
datac => \GRLFPC20.R.I.EXC\(3),
datab => \GRLFPC20.R.FSR.CEXC\(3));
\GRLFPC20_R_FSR_CEXC_RNO_1_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0f00000ccff")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_2__G1_1\,
dataf => \GRLFPC20.V.FSR.CEXC_2_SQMUXA\,
datae => \GRLFPC20.N_1144_I_M\,
datad => \GRLFPC20.N_1379\,
datac => N_362,
datab => N_402);
\GRLFPC20_R_FSR_CEXC_RNO_2_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cf000000cfcfcfcf")
port map (
combout => \GRLFPC20.R.FSR.CEXC_1_0_1__G1_0\,
dataf => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
datae => \GRLFPC20.R.FSR.TEM\(1),
datad => \GRLFPC20.R.I.EXC\(1),
datac => \GRLFPC20.N_1379\,
datab => N_401);
\GRLFPC20_R_FSR_AEXC_RNO_0_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_4__G1_0\,
dataf => \GRLFPC20.N_1270\,
datae => \GRLFPC20.N_1342\,
datad => \GRLFPC20.N_1379\,
datac => N_369,
datab => N_409);
\GRLFPC20_R_FSR_AEXC_RNO_0_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_3__G1_0\,
dataf => \GRLFPC20.N_1270\,
datae => \GRLFPC20.N_1342\,
datad => \GRLFPC20.N_1379\,
datac => N_368,
datab => N_408);
\GRLFPC20_R_FSR_AEXC_RNO_0_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccffccffccf0ccff")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
dataf => \GRLFPC20.N_1270\,
datae => \GRLFPC20.N_1342\,
datad => \GRLFPC20.N_1379\,
datac => N_366,
datab => N_406);
\GRLFPC20_R_FSR_AEXC_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc00fc00cc00ff00")
port map (
combout => \GRLFPC20.R.FSR.AEXC_1_0_1__G1\,
dataf => \GRLFPC20.V.FSR.CEXC_0_SQMUXA\,
datae => \GRLFPC20.V.FSR.AEXC_2_SQMUXA\,
datad => \GRLFPC20.R.FSR.AEXC_1_0_1__G1_0\,
datac => \GRLFPC20.R.I.EXC\(1),
datab => \GRLFPC20.R.FSR.AEXC\(1));
GRLFPC20_COMB_UN9_CCV: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000003f3f3f")
port map (
combout => CPO_CCVZ,
dataf => \GRLFPC20.COMB.UN9_CCV_2\,
datae => \GRLFPC20.R.E.FPOP\,
datad => N_204,
datac => \GRLFPC20.R.X.LD\,
datab => \GRLFPC20.R.X.AFSR\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN39_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7626\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN33_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7621\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_1_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN29_GRFPUSX_M_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000f0000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4296\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(70));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_BUSYMULXFF_UN2_TEMP: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00f000d000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4312\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.BUSYMULXFF.UN2_TEMP_2\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7462\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_UN15_NOTXZYFROMD: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"eeaacc00fefafcf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(375),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(13));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_COUNTSUCCESSIVEZERO_M11S4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffffffffffff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7989\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN24_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000330f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7783\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_EXPAREGLOADEN: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fffcff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.EXPAREGLOADEN\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_266__G2_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4902\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_80_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0fffffff0ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_80_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffaf0000ffcc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(55),
dataa => N_52);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_80_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_4_0_2\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_83_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"030f030f030f000c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_83_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_0\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
datae => N_54);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_83_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"a2f3ffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.FPINST_I_M_0\(2),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000033300000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN14_EXMIPTRLSBS\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7455\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4034\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0f0f000ffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN13_EXMIPTRLSBS_M_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fb00fb00ff00f000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
dataa => N_57);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"edefffff00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_1_IV_I\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_1_0_2\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.PCTRL_NEW_12\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_81_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc0c3303cc003300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_0_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_84_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f00c30f0f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_44_2_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_R_I_EXC_RNO_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000cc00c000")
port map (
combout => \GRLFPC20.R.I.EXC_2_0_4__G3\,
dataf => \GRLFPC20.N_1453_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
\GRLFPC20_R_I_EXC_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000003000")
port map (
combout => \GRLFPC20.R.I.EXC_MB\(1),
dataf => \GRLFPC20.N_1453_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(38),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(41));
GRLFPC20_R_A_AFSR_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => \GRLFPC20.R.A.AFSR_0_0_G1\,
dataf => \GRLFPC20.N_3769\,
datae => \GRLFPC20.N_3748\,
datad => N_67,
datac => N_66);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_233_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0ff0000c000")
port map (
combout => N_12822,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_232_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000c0ff0000c000")
port map (
combout => N_12839,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(245));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_114_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4540454045454040")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(114),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(114),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(114),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_373__G3\,
dataa => N_12822_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4540454045454040")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(58),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(58),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_317__G3\,
dataa => N_12822_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_59_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4540454045454040")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(59),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(59),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(59),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_318__N_6_I\,
dataa => N_12822_3);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_113_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"4540454045454040")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(113),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(113),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(113),
dataa => N_12822_3);
GRLFPC20_R_A_AFQ_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000000c00")
port map (
combout => \GRLFPC20.R.A.AFQ_0_0_G1\,
dataf => \GRLFPC20.N_3769\,
datae => \GRLFPC20.N_3748\,
datad => \GRLFPC20.COMB.FPDECODE.ST5_3\,
datac => N_66,
datab => N_71);
GRLFPC20_R_A_ST_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000000c")
port map (
combout => \GRLFPC20.R.A.ST_0_0_G1\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2249_I_I_0\,
datad => \GRLFPC20.N_3737\,
datac => \GRLFPC20.N_3731\,
datab => N_68);
\GRLFPC20_R_A_SEQERR_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ff00")
port map (
combout => \GRLFPC20.R.A.SEQERR_0_0_0__G1\,
dataf => \GRLFPC20.COMB.LOCKGEN.LOCKI_I_I_0\,
datae => \GRLFPC20.N_2249_I_I_0\,
datad => \GRLFPC20.R.A.SEQERR_0_0_0__G3\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0f00000f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_21__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0f00000f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL_2_0_20__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(20),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_2\(20),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_20378,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_20284,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(31),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_20280,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_20279,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => N_20274,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1\(28),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20249,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9667\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(212));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20244,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9666\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(213));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20243,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9665\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(214));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20238,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9664\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(215));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20237,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9663\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(216));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20232,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9662\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(217));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20231,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9661\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(218));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20226,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9660\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(219));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20225,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9659\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(220));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20220,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9658\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(221));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20219,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9657\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(222));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_TEMP_2_0_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff00ff03c3cf0f0")
port map (
combout => N_20214,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_6_MUX_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9656\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB_0\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(223));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_3_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3c5a3c5af00ff0f0")
port map (
combout => N_20201,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_0_A2_1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN6_GRFPUF_CARRY_2_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"5a3c5a3cf00ff0f0")
port map (
combout => N_20196,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_M2_0_A2_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_UN31_XZROUNDOUT_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => N_20188,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN8_TEMP_2_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccaaccaaf0fff000")
port map (
combout => N_20187,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(1),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_20129,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20128,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20122,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20121,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(310));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_0_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_20114,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(114));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20106,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20105,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20099,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20098,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(309));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_1_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20091,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(113),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20083,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20082,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20075,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(308));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_2_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20068,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20060,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20053,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20052,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(307));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20045,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20037,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20036,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20029,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(261));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20022,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20014,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_20013,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_20007,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_20006,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(260));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19999,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19991,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19984,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19983,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(259));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_51_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19979,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_53_SI_118_1_SUM_0_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f00f00ff0ff0ff00")
port map (
combout => N_19978,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7231\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7329\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7324\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_52_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffff000f0ff0f0")
port map (
combout => N_19975,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_53_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19974,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(61),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_54_SI_61_1_SUM_0_A2_0_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0000ff00ffff00")
port map (
combout => N_19973,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7329\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO0_2\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7787\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_54_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19964,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(59));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_3_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19954,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19946,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19945,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19939,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19938,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(306));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_4_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19931,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(110),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19923,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19922,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19916,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19915,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(305));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_5_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19908,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19900,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19899,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19893,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19892,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(304));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_6_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19885,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19877,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19876,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19870,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19869,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(303));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_7_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19862,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19854,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19853,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19847,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19846,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(302));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_8_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19839,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19831,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19830,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19824,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19823,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(301));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_9_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19816,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19808,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19807,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19801,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19800,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(300));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_10_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19793,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19785,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19784,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19778,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19777,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(299));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_11_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19770,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19762,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19761,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19755,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_17_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19754,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(298));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_12_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19747,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19739,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19738,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19732,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19731,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(297));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_13_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19724,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19716,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19715,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19709,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19708,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(296));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_14_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19701,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19693,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19692,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19686,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19685,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(295));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_15_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19678,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19670,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19669,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19663,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19662,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(294));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_16_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19655,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19647,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19646,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19640,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19639,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(293));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_17_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19632,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19624,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19623,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19617,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19616,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(292));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_18_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19609,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19601,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19600,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19594,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19593,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(291));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_19_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19586,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19578,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19577,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19571,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19570,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(290));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_20_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19563,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19555,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19554,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19548,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19547,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(289));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_21_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19540,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19532,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19531,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19525,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19524,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(288));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_22_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19517,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19509,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19508,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19502,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19501,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(287));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_23_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19494,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19486,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19485,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19479,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19478,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(286));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_24_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19471,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19463,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19462,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19456,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19455,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(285));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_25_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19448,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19440,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19439,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19433,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19432,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(284));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_26_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19425,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19417,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19416,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19410,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19409,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(283));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_27_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19402,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(87),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19394,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19393,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19387,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19386,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(282));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_28_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19379,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19371,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19370,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19364,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19363,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(281));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_29_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19356,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19348,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19347,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19341,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19340,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(280));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_30_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19333,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19325,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19324,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19318,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19317,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(279));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_31_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19310,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19302,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19301,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19295,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19294,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(278));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_32_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19287,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19279,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19278,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19272,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19271,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(277));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_33_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19264,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19256,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19255,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19249,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19248,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(276));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_34_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19241,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19233,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19232,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19226,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19225,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(275));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_35_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19218,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19210,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19209,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19203,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19202,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(274));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_36_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19195,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(78),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19187,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19186,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19180,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19179,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(273));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_37_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19172,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19164,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19163,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19157,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19156,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(272));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_38_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19149,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(76),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19141,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19140,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19134,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19133,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(271));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_39_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19126,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(75),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19118,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19117,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19111,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19110,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(270));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_40_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19103,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19095,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19094,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19088,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19087,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(269));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_41_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19080,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19072,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19071,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19065,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19064,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(268));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_42_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19057,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19049,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19048,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19042,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19041,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(267));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_43_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19034,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19026,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19025,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_3_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19019,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_19018,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(266));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_44_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19011,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19003,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_19002,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18996,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_18995,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(265));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_45_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18988,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18980,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18979,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18973,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_18972,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(264));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_46_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18965,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_4\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_47_TRFWWBASICCELL_TEMP2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18957,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_3\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_48_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18956,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_1_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18950,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_18949,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(263));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_49_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18933,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_TRFWWRRAY_REMWTAGE57_50_TRFWWBASICCELL_TEMP2_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0ff0f000ffff00")
port map (
combout => N_18927,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(64),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_CTRLXERSHFT_SUMIN_5_0_0_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffff00ff00")
port map (
combout => N_18926,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(262));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN18_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7810\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_79_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI1G2N_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000000000ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_9_408_I_A5_0_0\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_2_81_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIDL0R_316_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff0f00f0000f00f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9505\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(316));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNIB8J33_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0c33cff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7787\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1_0\(0),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_11_5_0_A2_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58));
GRLFPC20_R_I_RDD_RNO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cc000000c0c00000")
port map (
combout => N_14001,
dataf => N_12871_0,
datae => N_12853,
datad => \GRLFPC20.R.I.RDD\,
datac => \GRLFPC20.R.X.RDD\,
datab => N_5);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_29_S_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00000000000000")
port map (
combout => N_17013,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_32_RNO_1_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000000000f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.WQSTSETS_0_1\(7),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5485\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN20_LOCOV_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.UN23_EXPXBUS_I\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_31_D_RNO_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00000000ffff")
port map (
combout => D_N_2,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_15_D_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ff333cc0cc000")
port map (
combout => N_17003,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9940\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9947\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9950\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_31_D_D_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff55ba10ef45aa00")
port map (
combout => N_17005,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9943\,
datae => N_17003,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9955\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(50),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_PXS_PCTRL_NEW_12_31_D_75_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff77f7788800800")
port map (
combout => N_16975,
dataf => N_17005,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datad => D_N_2,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(49),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(51),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(52));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_PCTRL_1_CO3_RNIE0R12: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c3c30f0fc3000f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_PCTRL_NEW_43_0_RNIISKV1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffc03f00ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_I_M_0\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOINSTANDNOEXC_41_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffcf00000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOINSTANDNOEXC_41_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3967\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7462\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3990\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_PCTRL_NEW_43_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000000000f00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_PCTRL_NEW_43_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4312\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3967\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7462\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.TEMP_20_1\);
\GRLFPC20_R_X_SEQERR_RNIOB8L_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000ffff00ffff")
port map (
combout => \GRLFPC20.COMB.UN1_ANNULFPU_TZ_TZ\,
dataf => \GRLFPC20.R.X.FPOP\,
datae => \GRLFPC20.R.X.SEQERR\,
datad => \GRLFPC20.N_1212\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_237_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0fffffff000ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_2_5_536_I_0_TZ\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(250));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_FAX_XZXBUS_V_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZXBUS_2\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(7));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_41_248_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(248),
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => N_689,
datac => N_625);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNIFDCR1_3_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000153f153f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.TEMP_1_SN_N_5\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5441\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5437\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(374),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_SHIFT_2_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f00fff0f0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_2\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_EXPADDERSHFT_GRFPUELOC_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.GRFPUELOC\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(36));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_OPREXCSHFT_UN14_EXMIPTRLSBS: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000333ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.OPREXCSHFT.UN14_EXMIPTRLSBS\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4066\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4035\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4030\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(246));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_SCTRL_RNO_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000033333333333")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.UN4_TFCC_M\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5041_1\,
datae => N_12822_3,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_3_83_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000fff00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.MULTIPLEXORMULXFF.RESULT_I_M\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4066\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5207\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSAMPLEDWAIT_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_NOTSAMPLEDWAIT_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3967\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5012\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNID58Q_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN5_ZERO: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"330fffffffffccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7105\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_SHIFT_1_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f00fff0f0ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.MULTIPLELOGIC.SHIFT_1\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_0\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_INEXACTSIG_UN13_INEXACT_27_RNITR0T1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0004080c080c080c")
port map (
combout => \GRLFPC20.R.I.EXC_MB\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_28\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.INEXACTSIG.UN13_INEXACT_27\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4933\,
datac => \GRLFPC20.N_1453_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4931\,
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10));
GRLFPC20_COMB_V_E_STDATA2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.COMB.V.E.STDATA2\,
dataf => N_148,
datae => N_149);
\GRLFPC20_COMB_DBGDATA_4_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffff00f0f0")
port map (
combout => CPO_DBG_DATAZ(18),
dataf => N_394,
datae => N_395,
datad => N_678,
datac => N_614);
\GRLFPC20_COMB_DBGDATA_4_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff00f0f0")
port map (
combout => CPO_DBG_DATAZ(21),
dataf => N_394,
datae => N_395,
datad => N_681,
datac => N_617);
\GRLFPC20_COMB_DBGDATA_4_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ff00f0f0")
port map (
combout => CPO_DBG_DATAZ(12),
dataf => N_394,
datae => N_395,
datad => N_672,
datac => N_608);
GRLFPC20_R_X_AFSR_RNI5HA9: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ff000000000000")
port map (
combout => \GRLFPC20.N_1342\,
dataf => \GRLFPC20.R.X.LD\,
datae => \GRLFPC20.R.X.AFSR\,
datad => \GRLFPC20.N_1212\);
\GRLFPC20_R_FSR_CEXC_RNO_1_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffffff00000000")
port map (
combout => \GRLFPC20.N_1145_I_M\,
dataf => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
datae => \GRLFPC20.R.I.EXC\(3),
datad => \GRLFPC20.R.FSR.TEM\(3));
GRLFPC20_V_FSR_CEXC_1_SQMUXA: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ffff00000000")
port map (
combout => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
dataf => \GRLFPC20.N_1147\,
datae => \GRLFPC20.N_1379\);
\GRLFPC20_R_FSR_CEXC_RNO_2_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ffffff00000000")
port map (
combout => \GRLFPC20.N_1144_I_M\,
dataf => \GRLFPC20.V.FSR.CEXC_1_SQMUXA\,
datae => \GRLFPC20.R.I.EXC\(2),
datad => \GRLFPC20.R.FSR.TEM\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_PCTRL_1_SUM_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00003fffc000")
port map (
combout => N_10346,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_4295\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(82),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(83),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(84),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_PCTRL_1_SUM_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0ff0f0f0f0f0f0f0")
port map (
combout => N_10349,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_PCTRL_1_SUM_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3ccccccccccccccc")
port map (
combout => N_10350,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.PCTRL_1_CO3\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(80),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(81),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_0_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0f00000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_21_0_46__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(45),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_0\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(79),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_112_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_660);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_111_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_661);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_110_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_110__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_662);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_109_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_663);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_108_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_664);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_107_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_665);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_106_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_666);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_103_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_669);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_100_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_100__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_672);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_99_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_673);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_97_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_675);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_96_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_676);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_94_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_678);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_91_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_681);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_88_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_88__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_684);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datae => N_687);
\GRLFPC20_R_E_STDATA_RNO_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f0f0")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_12__G2\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => N_672,
datac => N_608);
\GRLFPC20_R_E_STDATA_RNO_0_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff00fffff0f0")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_18__G2\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => N_678,
datac => N_614);
\GRLFPC20_R_E_STDATA_RNO_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000ff000000f0f0")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_19__G2\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => N_679,
datac => N_615);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_244_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12573,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(55),
datad => \GRLFPC20.FPI.OP2\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_243_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12595,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(56),
datad => \GRLFPC20.FPI.OP2\(53),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_242_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12617,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(57),
datad => \GRLFPC20.FPI.OP2\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_241_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12639,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(58),
datad => \GRLFPC20.FPI.OP2\(55),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_240_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12661,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(59),
datad => \GRLFPC20.FPI.OP2\(56),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_239_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12683,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(60),
datad => \GRLFPC20.FPI.OP2\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_1_238_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000ff0ff00000000")
port map (
combout => N_12705,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(61),
datad => \GRLFPC20.FPI.OP2\(58),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNI0F2N_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => N_12576_2,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(27));
\GRLFPC20_R_FSR_RD_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.RD_0_0_0__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.RD\(0),
datad => \GRLFPC20.N_1379\,
datac => N_430,
datab => N_390);
\GRLFPC20_R_FSR_RD_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.RD_0_0_1__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.RD\(1),
datad => \GRLFPC20.N_1379\,
datac => N_431,
datab => N_391);
\GRLFPC20_R_FSR_TEM_RNO_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_0__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.TEM\(0),
datad => \GRLFPC20.N_1379\,
datac => N_423,
datab => N_383);
\GRLFPC20_R_FSR_TEM_RNO_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_1__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.TEM\(1),
datad => \GRLFPC20.N_1379\,
datac => N_424,
datab => N_384);
\GRLFPC20_R_FSR_TEM_RNO_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_3__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.TEM\(3),
datad => \GRLFPC20.N_1379\,
datac => N_426,
datab => N_386);
\GRLFPC20_R_FSR_TEM_RNO_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccf0fff000")
port map (
combout => \GRLFPC20.R.FSR.TEM_1_0_4__G2\,
dataf => \GRLFPC20.N_1342\,
datae => \GRLFPC20.R.FSR.TEM\(4),
datad => \GRLFPC20.N_1379\,
datac => N_427,
datab => N_387);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_237_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => N_12726,
dataf => \GRLFPC20.FPI.OP2\(59),
datae => \GRLFPC20.FPI.OP2\(62),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_R_E_STDATA_RNO_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00f0f0ff00cccc")
port map (
combout => \GRLFPC20.R.E.STDATA_1_0_0__G2\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.FSR.CEXC\(0),
datac => N_660,
datab => N_596);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_85__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(85),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(85),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_89_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_89__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(89),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(89),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(89));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_90_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_90__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(90),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(90),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(90));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_91_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_91__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(91),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(91),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(91));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_92_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_92__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(92),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(92),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(92));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_93_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_93__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(93),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(93),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(93));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_94_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_94__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(94),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(94),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(94));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_95_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_95__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(95),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(95),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(95));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_96_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_96__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(96),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(96),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(96));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_97_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_97__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(97),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(97),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(97));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_98_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_98__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(98),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(98),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(98));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_99_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_99__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(99),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(99),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(99));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_101_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_101__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(101),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(101),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(101));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_102_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_102__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(102),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(102),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(102));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_103_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_103__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(103),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(103),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(103));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_104_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_104__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(104),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(104),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(104));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_105_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_105__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(105),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(105),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(105));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_106_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_106__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(106),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(106),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(106));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_107_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_107__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(107),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(107),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(107));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_108_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_108__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(108),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(108),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(108));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_109_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_109__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(109),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(109),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(109));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_111_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_111__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(111),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(111),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(111));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_0_112_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfc0cfc0cfcfc0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19_0_112__G1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SM0_0\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M0\(112),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_M1\(112),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3745_0\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_23\(112));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_DPATH_RNO_375_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000cf0000fc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(375),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(3),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH_2\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_PCTRL_NEW_19_MUX_2_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10862\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_1\(22),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.PCTRL_NEW_19_3\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(78));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_SELECTQUOBITS_QUOBITS_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff00000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10583\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(374),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(376));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_14_142_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(142),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10583\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL_0\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(144));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_142_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fcff0cfffc000c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH\(142),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_14\(142),
datae => \GRLFPC20.FPO.FRAC\(31),
datad => N_23932,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_SN_N_5_MUX\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(142));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_2_246_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"cfffcf00c0ffc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10011\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(233));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_62_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(62),
dataf => \GRLFPC20.FPI.OP1\(53),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_678,
datab => N_614);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_65_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(65),
dataf => \GRLFPC20.FPI.OP1\(47),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_678,
datab => N_614);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_68_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(68),
dataf => \GRLFPC20.FPI.OP1\(47),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_672,
datab => N_608);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_71_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(71),
dataf => \GRLFPC20.FPI.OP1\(41),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_672,
datab => N_608);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_74_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(74),
dataf => \GRLFPC20.FPI.OP1\(41),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_666,
datab => N_602);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_77_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(77),
dataf => \GRLFPC20.FPI.OP1\(35),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_666,
datab => N_602);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_80_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(80),
dataf => \GRLFPC20.FPI.OP1\(35),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_660,
datab => N_596);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_83_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0ff00ccccff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(83),
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => N_689,
datac => N_660,
datab => N_596);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fb3bf838cb0bc808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9326\,
dataf => \GRLFPC20.FPO.FRAC\(54),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUF\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_261__G3\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9275\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(53),
datae => \GRLFPC20.FPO.FRAC\(4),
datad => \GRLFPC20.FPO.FRAC\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(54));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9276\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(52),
datae => \GRLFPC20.FPO.FRAC\(5),
datad => \GRLFPC20.FPO.FRAC\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(53));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9277\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(51),
datae => \GRLFPC20.FPO.FRAC\(6),
datad => \GRLFPC20.FPO.FRAC\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9279\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(49),
datae => \GRLFPC20.FPO.FRAC\(8),
datad => \GRLFPC20.FPO.FRAC\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9296\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(32),
datae => \GRLFPC20.FPO.FRAC\(25),
datad => \GRLFPC20.FPO.FRAC\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9297\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(31),
datae => \GRLFPC20.FPO.FRAC\(26),
datad => \GRLFPC20.FPO.FRAC\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(32));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9303\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(25),
datae => \GRLFPC20.FPO.FRAC\(32),
datad => \GRLFPC20.FPO.FRAC\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9304\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(24),
datae => \GRLFPC20.FPO.FRAC\(33),
datad => \GRLFPC20.FPO.FRAC\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9309\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(19),
datae => \GRLFPC20.FPO.FRAC\(38),
datad => \GRLFPC20.FPO.FRAC\(37),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(20));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9314\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(14),
datae => \GRLFPC20.FPO.FRAC\(43),
datad => \GRLFPC20.FPO.FRAC\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9317\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(11),
datae => \GRLFPC20.FPO.FRAC\(46),
datad => \GRLFPC20.FPO.FRAC\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9318\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(10),
datae => \GRLFPC20.FPO.FRAC\(47),
datad => \GRLFPC20.FPO.FRAC\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9321\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(7),
datae => \GRLFPC20.FPO.FRAC\(50),
datad => \GRLFPC20.FPO.FRAC\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(8));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_MULTIPLELOGIC_UN50_ZERO_RNI04HL91: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"3cc3c33cc33c3cc3")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_262__N_4\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7211\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_10506\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.SUM_13_0_A2_0\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.CO3\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_7213\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_3_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fb3bcb0bf838c808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9325\,
dataf => \GRLFPC20.FPO.FRAC\(54),
datae => \GRLFPC20.FPO.FRAC\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_0_262__N_4\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(4));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9254\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(43),
datad => \GRLFPC20.FPI.OP2\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(130));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9374\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9923\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9254\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(72));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9257\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(46),
datad => \GRLFPC20.FPI.OP2\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(127));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9377\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9926\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9257\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(69));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20829,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9923\,
dataf => N_20829,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20828,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9926\,
dataf => N_20828,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9278\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(50),
datae => \GRLFPC20.FPO.FRAC\(7),
datad => \GRLFPC20.FPO.FRAC\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9281\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(47),
datae => \GRLFPC20.FPO.FRAC\(10),
datad => \GRLFPC20.FPO.FRAC\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9282\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(46),
datae => \GRLFPC20.FPO.FRAC\(11),
datad => \GRLFPC20.FPO.FRAC\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(47));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9283\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(45),
datae => \GRLFPC20.FPO.FRAC\(12),
datad => \GRLFPC20.FPO.FRAC\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(46));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9284\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(44),
datae => \GRLFPC20.FPO.FRAC\(13),
datad => \GRLFPC20.FPO.FRAC\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9285\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(43),
datae => \GRLFPC20.FPO.FRAC\(14),
datad => \GRLFPC20.FPO.FRAC\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(44));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9286\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(42),
datae => \GRLFPC20.FPO.FRAC\(15),
datad => \GRLFPC20.FPO.FRAC\(14),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9287\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(41),
datae => \GRLFPC20.FPO.FRAC\(16),
datad => \GRLFPC20.FPO.FRAC\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9289\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(39),
datae => \GRLFPC20.FPO.FRAC\(18),
datad => \GRLFPC20.FPO.FRAC\(17),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(40));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9290\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(38),
datae => \GRLFPC20.FPO.FRAC\(19),
datad => \GRLFPC20.FPO.FRAC\(18),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(39));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_37_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9291\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(37),
datae => \GRLFPC20.FPO.FRAC\(20),
datad => \GRLFPC20.FPO.FRAC\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(38));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_36_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9292\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(36),
datae => \GRLFPC20.FPO.FRAC\(21),
datad => \GRLFPC20.FPO.FRAC\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(37));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9295\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(33),
datae => \GRLFPC20.FPO.FRAC\(24),
datad => \GRLFPC20.FPO.FRAC\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9305\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(23),
datae => \GRLFPC20.FPO.FRAC\(34),
datad => \GRLFPC20.FPO.FRAC\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9307\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(21),
datae => \GRLFPC20.FPO.FRAC\(36),
datad => \GRLFPC20.FPO.FRAC\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_20_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9308\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(20),
datae => \GRLFPC20.FPO.FRAC\(37),
datad => \GRLFPC20.FPO.FRAC\(36),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(21));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9312\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(16),
datae => \GRLFPC20.FPO.FRAC\(41),
datad => \GRLFPC20.FPO.FRAC\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9313\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(15),
datae => \GRLFPC20.FPO.FRAC\(42),
datad => \GRLFPC20.FPO.FRAC\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9315\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(13),
datae => \GRLFPC20.FPO.FRAC\(44),
datad => \GRLFPC20.FPO.FRAC\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9316\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(12),
datae => \GRLFPC20.FPO.FRAC\(45),
datad => \GRLFPC20.FPO.FRAC\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(13));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fb3bcb0bf838c808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9324\,
dataf => \GRLFPC20.FPO.FRAC\(53),
datae => \GRLFPC20.FPO.FRAC\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(5));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_67_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(67),
dataf => \GRLFPC20.FPI.OP1\(48),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_673,
datab => N_609);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_64_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(64),
dataf => \GRLFPC20.FPI.OP1\(48),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_679,
datab => N_615);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN2_DIVMULTV_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"000000f00f000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN2_DIVMULTV\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(0),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_GRFPUF\(3));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00f0000000f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9331\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9035\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(173));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ffffffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9820\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(57),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_U: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000030300000f03")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN4_NOTSTICKYINFORSR\,
datae => N_20740,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_2\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00ccf0cc0fccffcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9035\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9820\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(115));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN4_NOTSTICKYINFORSR: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f0f0f00000f0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN4_NOTSTICKYINFORSR\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN38_SHDVAR_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(50),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(52));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN38_SHDVAR_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffffffffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN38_SHDVAR_0\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_UN17_SHDVAR_1: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"03030303000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_1\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(56),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(48),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_2_0: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00330033003300f3")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\,
dataf => N_20707,
datae => N_20708,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN40_SHDVAR\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.UN17_SHDVAR_1\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSTICKYINFORSR_2_2: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000330000003f00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_2\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(55),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSTICKYINFORSR_2_0\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(56),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_250_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9993\,
dataf => \GRLFPC20.FPO.EXP\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(237));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_256_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9987\,
dataf => \GRLFPC20.FPO.EXP\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_41_250_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(250),
dataf => \GRLFPC20.FPI.OP1\(59),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_690,
datab => N_626);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_41_253_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(253),
dataf => \GRLFPC20.FPI.OP1\(59),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_684,
datab => N_620);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_41_256_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_41\(256),
dataf => \GRLFPC20.FPI.OP1\(53),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_684,
datab => N_620);
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_REEXCOVUV_UN13_LOCOV_4: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\,
dataf => \GRLFPC20.FPO.EXP\(6),
datae => \GRLFPC20.FPO.EXP\(5),
datad => \GRLFPC20.FPO.EXP\(4),
datac => \GRLFPC20.FPO.EXP\(3));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_REEXCOVUV_UN14_LOCOV: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0f0f0f0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5487\,
dataf => \GRLFPC20.FPO.EXP\(10),
datae => \GRLFPC20.FPO.EXP\(9),
datad => \GRLFPC20.FPO.EXP\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10));
GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_REEXCOVUV_UN13_LOCOV: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"c000000000000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5485\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5487\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN13_LOCOV_4\,
datad => \GRLFPC20.FPO.EXP\(7),
datac => \GRLFPC20.FPO.EXP\(2),
datab => \GRLFPC20.FPO.EXP\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_85_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0cfc0cfc0cfc0c0c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_5485\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.REEXCOVUV.UN20_LOCOV_0\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN6_GRFPUE\(12),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_248_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9995\,
dataf => \GRLFPC20.FPO.EXP\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(235));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3cf330cf0cc300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcff3c33c0c3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_81_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0ff00ccccff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(81),
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => N_691,
datac => N_662,
datab => N_598);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_78_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(78),
dataf => \GRLFPC20.FPI.OP1\(37),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_662,
datab => N_598);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_76_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(76),
dataf => \GRLFPC20.FPI.OP1\(36),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_667,
datab => N_603);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9214\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(170),
datac => N_692);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9334\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9883\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9214\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(112));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9215\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(169),
datac => N_693);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9335\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9884\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9215\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(111));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9217\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(167),
datac => N_695);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9337\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9886\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9217\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(109));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00cc0fccf0ccffcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9042\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9827\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(108));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0cc0000f0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9338\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9042\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(50),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(166));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9225\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(159),
datac => N_703);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9345\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9894\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9225\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(101));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9226\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(158),
datac => N_704);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9346\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9226\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(100));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9228\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(156),
datac => N_706);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9348\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9897\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9228\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(98));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9230\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(154),
datac => N_708);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9350\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9899\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9230\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(96));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9234\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(150),
datac => N_712);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9354\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9903\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9234\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(92));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9235\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(149),
datac => N_713);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9355\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9904\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9235\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(91));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9236\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(148),
datac => N_714);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9356\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9905\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9236\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(90));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9237\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(147),
datac => N_715);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9357\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9906\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9237\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(89));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9238\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(146),
datac => N_716);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9358\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9907\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9238\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(88));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9240\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(144),
datac => N_718);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9360\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9909\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9240\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(86));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9241\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(143),
datac => N_719);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9361\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9910\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9241\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(85));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9242\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(142),
datac => N_720);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9362\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9911\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9242\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(84));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc00ccf0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9243\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(141),
datab => N_721);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9363\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9912\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9243\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(83));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc00ccf0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9244\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(140),
datab => N_722);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9364\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9913\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9244\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(82));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcc00ccf0f0f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9245\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(139),
datab => N_723);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9365\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9914\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9245\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(81));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9246\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(35),
datad => \GRLFPC20.FPI.OP2\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(138));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9366\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9915\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9246\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(80));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9249\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(38),
datad => \GRLFPC20.FPI.OP2\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(135));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9369\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9918\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9249\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(77));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9252\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(41),
datad => \GRLFPC20.FPI.OP2\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(132));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9372\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9921\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9252\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(74));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9253\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(42),
datad => \GRLFPC20.FPI.OP2\(39),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(131));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9373\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9922\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9253\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(73));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9255\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(44),
datad => \GRLFPC20.FPI.OP2\(41),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(129));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9375\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9924\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9255\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(71));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9256\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(45),
datad => \GRLFPC20.FPI.OP2\(42),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(128));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9376\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9925\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9256\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(70));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccffcc00cc0fcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9082\,
dataf => N_20806,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(68));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_1_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(10),
dataf => \GRLFPC20.FPI.OP2\(44),
datae => \GRLFPC20.FPI.OP2\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffc0c0000fc0c")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9378\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9082\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_1\(10),
datac => N_12822_3,
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(126));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9259\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(48),
datad => \GRLFPC20.FPI.OP2\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(125));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9379\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9928\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9259\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(67));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9260\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(49),
datad => \GRLFPC20.FPI.OP2\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(124));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9380\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9929\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9260\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(66));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9381\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9930\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9261\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(65));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9263\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(52),
datad => \GRLFPC20.FPI.OP2\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(121));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9383\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9932\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9263\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(63));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9264\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(53),
datad => \GRLFPC20.FPI.OP2\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(120));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9384\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9933\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9264\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(62));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccffcc00cc0fcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9090\,
dataf => N_20800,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(60));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffffff00000fff0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9386\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9090\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => N_12822_3,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(118));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"00000000ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9268\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(116));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9388\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9268\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f00000f3f00300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.NORMDETECT.NOTSLFROMNORM_17\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9633\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(43));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_54_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9883\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(4),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(52),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ff333cc0cc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9884\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(4),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(53),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(54),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fff0ff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(50),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_51_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ff333cc0cc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9886\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3fcf00f030c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9827\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(51),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => N_20827,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(44),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33c30cfc30c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9894\,
dataf => N_20827,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3fcf00f030c00")
port map (
combout => N_20826,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(43),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(44),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcff3c33c0c3000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9895\,
dataf => N_20826,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20825,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3c0cf3c33000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(40),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(40),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9897\,
dataf => N_20825,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20824,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(39),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3cfc33c300c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9899\,
dataf => N_20824,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(38),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9903\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(23),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(34),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccfffff0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(34),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20761,
datab => N_20758);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9904\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(24),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccfffff0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20760,
datab => N_20757);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9905\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(25),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ccf0ccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20759,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(42));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(34),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20820,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(32),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3cf330cf0cc300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9906\,
dataf => N_20820,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ccf0ccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20776,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(33),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20819,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(30),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(33),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(31),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(29),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00fff00f0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9907\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(30),
datae => N_20819,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3fcf00f030c00")
port map (
combout => N_20818,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(28),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9909\,
dataf => N_20818,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3fcf0ff030c000")
port map (
combout => N_20817,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(27),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3cfc33c300c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(27),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(27),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9910\,
dataf => N_20817,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(27),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20816,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(27),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3c0cf3c33000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9911\,
dataf => N_20816,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(26),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(28),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20752,
datad => N_20755);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20815,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(25),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(28),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(26),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ff333cc0cc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(24),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f00fff00f0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9912\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(25),
datae => N_20815,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(24),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9913\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(25),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000f0ccf0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20754,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(34),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(26));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0cc0000f0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20752,
datab => N_20751);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fff0ff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(34),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(22),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(23),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"333ff3ff000cc0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9914\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(34),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fff0ff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9915\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(35),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20811,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(19),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(20),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_19_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9918\,
dataf => N_20811,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3fcf0ff030c000")
port map (
combout => N_20810,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(16),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(19),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3cf330cf0cc300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(16),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_16_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9921\,
dataf => N_20810,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20809,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(16),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(17),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3cfc33c300c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(15),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(15),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9922\,
dataf => N_20809,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(16),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20808,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3cfc33c300c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9924\,
dataf => N_20808,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_15_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ccf0ccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(15),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20773,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_14_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000f0ccf0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(14),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20729,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffccf00000ccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(14),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20745,
datab => N_20748);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20807,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(15),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(13),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ccf0cf330c300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9925\,
dataf => N_20807,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(12),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_13_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(13),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20746,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20806,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(13),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(11),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ffffccf00000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20745,
datab => N_20748);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(48),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f300c03fff0ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9928\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(10),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ccf0ccf0ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20771,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_9_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(9),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(11),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(9),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00fff0ff0fffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"333f000cf3ffc0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9929\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(9),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_20_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccf0ccffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datae => N_20723,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(22),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(14));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0cc0000f0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(8),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20745,
datab => N_20722);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(6),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33003f0cf3c0ffcc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9930\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(8),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(7),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9932\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(52),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(6),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_5_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccfffff0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(5),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20771,
datab => N_20769);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(4),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_4_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"333ff3ff000cc0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9933\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(5),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(4),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3fcf0ff030c000")
port map (
combout => N_20800,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(2),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(5),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_NOTSRRES_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(55),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffcf3f00f0c0300")
port map (
combout => N_20799,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(1),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(2),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9937\,
dataf => N_20799,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_82_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0ff00ccccff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(82),
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => N_690,
datac => N_661,
datab => N_597);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_DPATH_NEW_19_79_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_19\(79),
dataf => \GRLFPC20.FPI.OP1\(36),
datae => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datac => N_661,
datab => N_597);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_SUB_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ff000000ff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_SUB\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(58),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(8),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9219\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(165),
datac => N_697);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9339\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9888\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9219\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(107));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9221\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(163),
datac => N_699);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9341\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9890\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9221\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(105));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9223\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(161),
datac => N_701);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9343\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9892\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9223\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(103));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9224\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(160),
datac => N_702);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9344\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9893\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9224\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(102));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9229\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(155),
datac => N_707);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9349\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9898\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9229\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(97));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff00f00cccccccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9247\,
dataf => N_12822_3,
datae => \GRLFPC20.FPI.OP2\(36),
datad => \GRLFPC20.FPI.OP2\(33),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(137));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9367\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9916\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9247\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(79));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_0_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0fcfffcf00c0f0c0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9638\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(31),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(244));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3fcf0ff030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9828\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(49),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff3cfc33c300c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(48),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffff0f000f0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9888\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9828\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(49),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3fcf0ff030c000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9830\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26_I\(47),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(50),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33c30cfc30c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(47),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(46),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(47),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_47_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffff0f000f0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9890\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9830\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(47),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0c03000ffcf3f0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9832\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(45),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(48),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20\(46),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33c30cfc30c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(45),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffff0f000f0f")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9892\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9832\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(45),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"33f33fff00c00ccc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9893\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(13),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(45),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffccf00000ccf0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20760,
datab => N_20777);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_0_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcf3f0ff0c03000")
port map (
combout => N_20797,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(39),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(42),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(40),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_16_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ccf0cf330c300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(39),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(39),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(37),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRONEMORE\);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_39_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0f000f0ffff0ffff")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9898\,
dataf => N_20797,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_16\(39),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_3954\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_S_8_29_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff0000ff00ff00")
port map (
combout => N_20752,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ccfffff0cc0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(22),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20752,
datab => N_20751);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"333ff3ff000cc0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9916\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(36),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_253_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ffffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9990\,
dataf => \GRLFPC20.FPO.EXP\(5),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(25),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(240));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_R_PCTRL_RNO_1_82_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff000000ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.RESULT\(3),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.FAX.XZZERO_1\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.PXS.FEEDBACKMULXFF.UN6_FEEDBACK\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(57));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_LEFTSHIFTERBL_SLCONTROL_1_1_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0f0ff00f0f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9633\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.EXPADDERSHFT.COMPUTECONST.UN25_RESVEC\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(32),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(243));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_C_DPXX_RIGHTSHIFTERBL_S_8_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0f0ff00ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.S_8_I\(57),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(44),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(0),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(12));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_DPATH_140_2_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(2),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(51),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_DPATH_117_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(6),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => N_20740,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(56),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(55),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(57),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(23),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(23),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(21),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(20),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(38),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(36),
datae => N_20672,
datad => N_20685,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff3ff333cc0cc000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(32),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(32),
datae => N_20673,
datad => N_20674,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(31),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(29),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcffccc33033000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(30),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(28),
datae => N_20673,
datad => N_20674,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_25_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(25),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(23),
datae => N_20692,
datad => N_20684,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(24),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(24),
datae => N_20665,
datad => N_20664,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(22),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(20),
datae => N_20665,
datad => N_20664,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(21),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(21),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(19),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_12_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(12),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(12),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(10),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_11_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(11),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(11),
datae => N_20676,
datad => N_20663,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_0_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffccfff000cc00f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(57),
dataf => N_20706,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_23_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(23),
dataf => N_20699,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(15),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_21_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"f0ffccfff000cc00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(21),
dataf => N_20692,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(9),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(17));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_48_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9280\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(48),
datae => \GRLFPC20.FPO.FRAC\(9),
datad => \GRLFPC20.FPO.FRAC\(8),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(49));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9293\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(35),
datae => \GRLFPC20.FPO.FRAC\(22),
datad => \GRLFPC20.FPO.FRAC\(21),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(36));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_34_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9294\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(34),
datae => \GRLFPC20.FPO.FRAC\(23),
datad => \GRLFPC20.FPO.FRAC\(22),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(35));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_27_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9301\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(27),
datae => \GRLFPC20.FPO.FRAC\(30),
datad => \GRLFPC20.FPO.FRAC\(29),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(28));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9302\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(26),
datae => \GRLFPC20.FPO.FRAC\(31),
datad => \GRLFPC20.FPO.FRAC\(30),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(27));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_22_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9306\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(22),
datae => \GRLFPC20.FPO.FRAC\(35),
datad => \GRLFPC20.FPO.FRAC\(34),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_18_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9310\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(18),
datae => \GRLFPC20.FPO.FRAC\(39),
datad => \GRLFPC20.FPO.FRAC\(38),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(19));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_3_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0000f0f0ff00ff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9233\,
dataf => N_12822_3,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(11),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(151),
datac => N_711);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_5_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"0c0cff00fcfcff00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9353\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9902\,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.RIN.DPATH_1_SN_N_4\,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9233\,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(93));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_26_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0cc0000f0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(35),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_20_I\(37),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(1),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(2),
datac => N_20760,
datab => N_20757);
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_31_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff0ffcc00f000cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(31),
dataf => N_20701,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(23),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(31));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(33),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(33),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(31),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_NOTSRRES_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"333ff3ff000cc0cc")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9902\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.RIGHTSHIFTERBL.NOTSRRES\(22),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(36),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_26\(35),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.LEFTSHIFTERBL.SLCONTROL\(0),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(45));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(53),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(53),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(52),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_50_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffcffccc33033000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_10_I\(50),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(50),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(48),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(0));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(42),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(42),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(40),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffccfff000cc00f0")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(24),
dataf => N_20700,
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(3),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(24),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(16));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_26_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(26),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(26),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(24),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffff00ffff000000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(10),
dataf => N_20669,
datae => N_20662,
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_10_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fff33f33ccc00c00")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(10),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(10),
datae => N_20678,
datad => N_20679,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(8),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(6),
datae => N_20678,
datad => N_20679,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffccfcc33300300")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(49),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(47),
datae => N_20689,
datad => N_20682,
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(2),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_S_8_6_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ffffff0000ff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_6\(43),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(41),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_S_8_I\(43),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.SRCONTROL_1\(1));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_UN1_R_DPATH_0_8_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.UN1_R.DPATH\(8),
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.SCTRL\(10),
datae => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(57),
datad => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(25));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_40_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9288\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(40),
datae => \GRLFPC20.FPO.FRAC\(17),
datad => \GRLFPC20.FPO.FRAC\(16),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(41));
\GRLFPC20_GRFPUL_GEN0_GRLFPU0_RIN_DPATH_1_4_28_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fbcbf8c83b0b3808")
port map (
combout => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.N_9300\,
dataf => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.C.DPXX.DPATH_NEW_8\(28),
datae => \GRLFPC20.FPO.FRAC\(29),
datad => \GRLFPC20.FPO.FRAC\(28),
datac => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(7),
datab => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.PCTRL\(6),
dataa => \GRLFPC20.GRFPUL_GEN0.GRLFPU0.R.DPATH\(29));
\GRLFPC20_FPI_OP2_32_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(32),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_628,
datad => N_692);
\GRLFPC20_FPI_OP2_33_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(33),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_629,
datad => N_693);
\GRLFPC20_FPI_OP2_35_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(35),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_631,
datad => N_695);
\GRLFPC20_FPI_OP2_38_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(38),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_634,
datad => N_698);
\GRLFPC20_FPI_OP2_41_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(41),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_637,
datad => N_701);
\GRLFPC20_FPI_OP2_42_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(42),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_638,
datad => N_702);
\GRLFPC20_FPI_OP2_43_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(43),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_639,
datad => N_703);
\GRLFPC20_FPI_OP2_44_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(44),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_640,
datad => N_704);
\GRLFPC20_FPI_OP2_45_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(45),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_641,
datad => N_705);
\GRLFPC20_FPI_OP2_46_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(46),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_642,
datad => N_706);
\GRLFPC20_FPI_OP2_49_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(49),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_645,
datad => N_709);
\GRLFPC20_FPI_OP2_52_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(52),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_648,
datad => N_712);
\GRLFPC20_FPI_OP2_53_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(53),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_649,
datad => N_713);
\GRLFPC20_FPI_OP2_55_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(55),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_651,
datad => N_715);
\GRLFPC20_FPI_OP2_56_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(56),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_652,
datad => N_716);
\GRLFPC20_FPI_OP2_57_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(57),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_653,
datad => N_717);
\GRLFPC20_FPI_OP2_58_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(58),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_654,
datad => N_718);
\GRLFPC20_FPI_OP2_59_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(59),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_655,
datad => N_719);
\GRLFPC20_FPI_OP2_60_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(60),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_656,
datad => N_720);
\GRLFPC20_FPI_OP2_61_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(61),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_657,
datad => N_721);
\GRLFPC20_FPI_OP2_62_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00ff00ffff0000")
port map (
combout => \GRLFPC20.FPI.OP2\(62),
dataf => \GRLFPC20.COMB.UN1_FPCI_4\,
datae => N_658,
datad => N_722);
\GRLFPC20_WRDATA_63_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"fffff0cc0000f0cc")
port map (
combout => RFI1_WRDATAZ(31),
dataf => N_431,
datae => \GRLFPC20.WRADDR_0_SQMUXA\,
datad => \GRLFPC20.N_1930\,
datac => N_391,
datab => \GRLFPC20.R.I.RES\(63));
\GRLFPC20_COMB_V_E_STDATA_1_1_30_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00f0f0ff00cccc")
port map (
combout => \GRLFPC20.N_3423\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.FSR.RD\(0),
datac => N_690,
datab => N_626);
\GRLFPC20_COMB_V_E_STDATA_1_1_24_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00f0f0ff00cccc")
port map (
combout => \GRLFPC20.N_3417\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.FSR.TEM\(1),
datac => N_684,
datab => N_620);
\GRLFPC20_COMB_V_E_STDATA_1_1_7_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
    lut_mask => X"ff00f0f0ff00cccc")
port map (
combout => \GRLFPC20.N_3400\,
dataf => \GRLFPC20.COMB.UN1_R.A.RS1_1\,
datae => \GRLFPC20.R.A.AFSR\,
datad => \GRLFPC20.R.FSR.AEXC\(2),
datac => N_667,
datab => N_603);
\GRLFPC20_COMB_V_E_STDATA_1_1_6_\: stratixiii_lcell_comb generic map (
    shared_arith => "off",
    extended_lut => "off",
 