/*
 * below is to bring up the UART at power-on
 * NOTE: BCC by default configures 19200 BAUD
 */

#ifndef CFG_SYSFREQ
 #define CFG_SYSFREQ (20*1000*1000)
#endif

#if defined(CFG_BOARD_BOARD)
 #define GPIO_UART_TX3 35
 #define GPIO_UART_RX3 36
#elif defined(CFG_BOARD_MINI)
 #define GPIO_UART_TX3 62
 #define GPIO_UART_RX3 61
#else
 #define GPIO_UART_TX3 (-1)
 #define GPIO_UART_RX3 (-1)
#endif

#include <bcc/bcc_param.h>
#include <drv/clkgate.h>
#include <drv/gr716/clkgate.h>
#include <drv/regs/clkgate_bits.h>
#include <pinhelper.h>

const unsigned int __bsp_sysfreq = CFG_SYSFREQ;

/* apbuart3 */
uint32_t __bcc_con_handle = 0x80303000;

/* clock enable an apbuart if not already enabled */
static void enable_the_uart_clock(int index)
{
        const uint32_t GATEMASK = CLKGATE0_GR716_UART0 << index;
        struct clkgate_priv *dev;
        uint32_t enabled;
        uint32_t disabled;

        clkgate_init(GR716_CLKGATE_DRV_ALL);
        dev = clkgate_open(0);
        clkgate_status(dev, &enabled, &disabled);
        if (enabled & ~disabled & GATEMASK) {
                ;
        } else {
                clkgate_gate(dev, GATEMASK);
                clkgate_enable(dev, GATEMASK);
        }
        clkgate_close(dev);
}

static void enable_the_uart_pins(int index)
{
        (void) sizeof index;
        set_pinfunc(GPIO_UART_TX3, IO_MODE_APBUART);
        set_pinfunc(GPIO_UART_RX3, IO_MODE_APBUART);
}

/*
 * This function is called by BCC run-time setup before console initialization.
 */
void __bcc_init60(void)
{
        enable_the_uart_clock(3);
        enable_the_uart_pins(3);
}


