#include <assert.h>
#include <stdio.h>
#include <clockhelper.h>

static void printlocked(void)
{
        int ret;
        ret = gr716_pll_islocked();
        if (ret) {
                puts("PLL is currently locked");
        } else {
                puts("PLL is currently NOT locked");
        }
}

int main(void)
{
        int ret;

        puts("GR716 PLL and clock example begin");

        printlocked();

        puts("Enable PLL and select external SpaceWire clock input...");
        ret = gr716_pll_config(
                PLL_REF_SPW_CLK,
                PLL_FREQ_25MHZ,
                PLL_POWER_ENABLE
        );
        assert(ret == 0);

        /* Give PLL some time to lock */
        for (volatile int i = 0; i < 1000 * 1000; i++) {
                ;
        }
        printlocked();

        puts("Internal system clock directly from SYS_CLK pin");
        ret = gr716_sysclk(
                CLK_SOURCE_CLK,
                0,
                0
        );
        assert(ret == 0);

        puts("Configure SpaceWire clock to 100 MHz...");
        {
                /* 'duty' = '0' means 50% duty cycle */
                const int spwdiv  = 8;
                const int spwduty = 0;
                ret = gr716_spwclk(SPWCLK_SOURCE_PLL, spwdiv, spwduty);
                assert(ret == 0);
        }

        printf("GR716 PLL and clock example end\n");

        return 0;
}

