CC = sparc-gaisler-elf-gcc
OBJDUMP = sparc-gaisler-elf-objdump
SIZE = sparc-gaisler-elf-size

ROOTDIR := $(realpath $(dir $(abspath $(lastword $(MAKEFILE_LIST)))))
IMG     = $(ROOTDIR)/scripts/img-gr716.tcl
BCHFILE = $(ROOTDIR)/scripts/bchfile.tcl

BINDIR ?= bin
OBJDIR ?= obj
BSP?=gr716

ALL_EX  ?=

_CFLAGS  += -qbsp=$(strip $(BSP))
_CFLAGS  += -Os
_CFLAGS  += -mcpu=leon3
_CFLAGS  += -qnano
_CFLAGS  += -qsvt
_CFLAGS  += -flto
_CFLAGS  += -std=c99
_CFLAGS  += -Wall -Wextra -pedantic
_CFLAGS  += -I$(ROOTDIR)/common/include

override CFLAGS := $(_CFLAGS) $(CFLAGS)

_LDFLAGS ?=
# _LDFLAGS += -L$(ROOTDIR)/lib
override LDFLAGS := $(_LDFLAGS) $(LDFLAGS)

_LDLIBS  ?=
_LDLIBS  += -ldrv
override LDLIBS := $(_LDLIBS) $(LDLIBS)

_COMMON_C        =
_COMMON_C       += $(ROOTDIR)/common/pinhelper.c
_COMMON_C       += $(ROOTDIR)/common/adchelper.c
_COMMON_C       += $(ROOTDIR)/common/clockhelper.c

