#ifndef ADCHELPER_H
#define ADCHELPER_H

#define ADC_MODE_SINGLE      0x0
#define ADC_MODE_SEQ         0x1
#define ADC_MODE_SEQ_CONT    0x2

#define ADC_INMODE_DIFF      0x0
#define ADC_INMODE_SINGLE    0x1

#define ADC_GAIN_0db         0x0
#define ADC_GAIN_6db         0x1
#define ADC_GAIN_12db        0x2
#define ADC_GAIN_BYPASS      0x4

struct adc_config {
        /* 0..7 */
        unsigned int channel;
        int mode;
        int inputmode;
        unsigned int oversampling;
        unsigned int oversampling_events;
        int sync;
        unsigned int sync_source;
        int gain;
        unsigned int rate;
        /* sequence rate (1..65535 Msps) if no sync source is selected */
        unsigned int seqrate;
};

/*
 * convenience for setting various ADC configuration options
 *
 * This function always disables the ADC controller
 */
int adc_config(
        int unit,
        const struct adc_config *cfg
);

int adc_enable(
        int unit
);

int adc_disable(
        int unit
);

int adc_start(
        int unit
);

int adc_stop(
        int unit
);

unsigned int adc_get(
        int unit
);

#define ADC_INTMASK_END_OF_SEQUENCE             0x8
#define ADC_INTMASK_HIGH_LEVEL_DETECTION        0x4
#define ADC_INTMASK_LOW_LEVEL_DETECTION         0x2
#define ADC_INTMASK_END_OF_CONVERSION           0x1
#define ADC_INTMASK_ALL                         0xf
#define ADC_INTMASK_NONE                        0x0

int adc_intmask(
        int unit,
        unsigned int mask
);

unsigned int adc_getint(
        int unit,
        unsigned int clearmask
);

#endif

