#include <stdint.h>
#include <pinhelper.h>
#include <bcc/bsp_pnp.h>

int set_pinfunc(unsigned int pin, unsigned int mode)
{
        if (64 <= pin) {
                return 1;
        }
        if (IO_MODE_MAX <= mode) {
                return 2;
        }
        /* There are 8 4-bit fields per control register. */
        const int regi  = pin / 8;
        const int field = pin % 8;
        const int shift = field * 4;
        const uint32_t mask = 0xf  << shift;
        volatile uint32_t *const gpio = (void *) GAISLER_GPREGBANK_0_PNP_APB;
        uint32_t val;

        val = gpio[regi];
        val &= ~mask;
        val |= (mode << shift);
        gpio[regi] = val;

        return 0;
}

