
static void inline udelay200(void) {
  __asm__ __volatile__(
    "set	0x7fffff, %%g1;\n\t"
"1:"
    "nop;\n\t"
    "nop;\n\t"
    "subcc	%%g1,1,%%g1;\n\t"
    "bne	1b;\n\t"
    " nop;\n\t" : : : "g1" );
}

#include "bdinit_gr740_l2cache.ci"
#include "bdinit_gr740_sdctrl0.ci"
#include "bdinit_gr740_mctrl0.ci"
#include "bdinit_gr740_uart0.ci"
#include "bdinit_gr740_grcg.ci"

void bdinit0(void) { 
  /* Setup SDCTRL */
  bdinit_gr740_sdctrl0();
  /* Enable 2T signaling: 
   * This is required for some memory modules to improve
   * SDRAM signal timing. Otherwise, the memory might
   * deliver wrong data eventually. */
  bdinit_gr740_setup2t(1);
  /* After enabling 2T we need to reinit the SDCTRL */
  bdinit_gr740_sdctrl0_init();
  /* Setup correct lead out cycles for PROM writes */
  bdinit_gr740_mctrl0();
}

void bdinit1(void) {
  /* using bdinit0 */
  /* Invalidate L2cache contents */
  bdinit_gr740_l2cache_invalidate();
  /* Wait for cache to be invalidated */
  udelay200();
  /* Now it is safe to enable L2 cache */
  bdinit_gr740_l2cache_on();
}

void bdinit2(void) {
  /* Enable UART pin multiplexing */
  bdinit_gr740_uart0();
  /* Enable Clock gated cores */
  /* bdinit_gr740_grcg_enable(CLKGATE_L4STAT | CLKGATE_SPWRTR); */
}
