#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <drv/clkgate.h>
#include <drv/gr716/clkgate.h>
#include <adchelper.h>
#include <pinhelper.h>

/* configuration specific to this example */
#ifndef CFG_ADC_INDEX
 #define CFG_ADC_INDEX 0
#endif

#ifndef CFG_ADC_CHANNEL
 #define CFG_ADC_CHANNEL 0
#endif

struct global {
        struct clkgate_priv *clkgate[2];
};
static struct global g;

static void openstuff(void)
{
        clkgate_init(GR716_CLKGATE_DRV_ALL);
        g.clkgate[0] = clkgate_open(0);
        assert(g.clkgate[0]);
        g.clkgate[1] = clkgate_open(1);
        assert(g.clkgate[1]);
}

#include <drv/regs/clkgate_bits.h>
static const int ADC_TO_CLKMASK[8] = {
        CLKGATE1_GR716_ADC0,
        CLKGATE1_GR716_ADC1,
        CLKGATE1_GR716_ADC2,
        CLKGATE1_GR716_ADC3,
        CLKGATE1_GR716_ADC4,
        CLKGATE1_GR716_ADC5,
        CLKGATE1_GR716_ADC6,
        CLKGATE1_GR716_ADC7,
};

static int clock_enable_adc(int adcindex)
{
        int ret;
        ret = clkgate_enable(g.clkgate[1], ADC_TO_CLKMASK[adcindex]);
        if (ret != DRV_OK) {
                return 1;
        }
        return 0;
}

static void initstuff(void)
{
        clock_enable_adc(CFG_ADC_INDEX);
        set_pinfunc(37 + CFG_ADC_CHANNEL, IO_MODE_ADC);
}

struct adc_config thecfg = {
        .channel                = CFG_ADC_CHANNEL,
        .mode                   = ADC_MODE_SINGLE,
        .inputmode              = ADC_INMODE_SINGLE,
        .oversampling           = 0,
        .oversampling_events    = 1,
        .sync                   = 0,
        .sync_source            = 0,
        .gain                   = ADC_GAIN_0db,
        .rate                   = 200 * 1000,
        .seqrate                =   1 * 1000,
};

/* number of samples to collect */
enum {
        NSDATA  = 8,
};
unsigned int sdata[NSDATA];

int main(void)
{
        int ret;

        printf("GR716 ADC example begin\n");
        printf("config: adc%d ch%d\n", CFG_ADC_INDEX, CFG_ADC_CHANNEL);

        openstuff();
        initstuff();

        ret = adc_disable(CFG_ADC_INDEX);
        if (ret) {
                printf("ERROR: adc_disable() -> %d\n", ret);
                exit(__LINE__);
        }

        ret = adc_config(CFG_ADC_INDEX, &thecfg);
        if (ret) {
                printf("ERROR: adc_config() -> %d\n", ret);
                exit(__LINE__);
        }

        ret = adc_enable(CFG_ADC_INDEX);
        if (ret) {
                printf("ERROR: adc_enable() -> %d\n", ret);
                exit(__LINE__);
        }

        /* must set interrupt mask to read interrupt pending as status */
        ret = adc_intmask(CFG_ADC_INDEX, ADC_INTMASK_END_OF_CONVERSION);

        /* collect */
        for (int i = 0; i < NSDATA; i++) {
                unsigned int gotit = 0;
                unsigned int val;

                /* clear the status */
                adc_getint(CFG_ADC_INDEX, ADC_INTMASK_ALL);
                adc_start(CFG_ADC_INDEX);

                while (gotit == 0) {
                        /* get the status */
                        gotit = adc_getint(CFG_ADC_INDEX, ADC_INTMASK_NONE);
                }
                val = adc_get(CFG_ADC_INDEX);

                /* do something with the data */
                sdata[i] = val;
                if (0) {
                        printf("val=%05x\n", val);
                }
        }

        ret = adc_disable(CFG_ADC_INDEX);
        if (ret) {
                printf("ERROR: adc_disable() -> %d\n", ret);
                exit(__LINE__);
        }

        /* report */
        for (int i = 0; i < NSDATA; i++) {
                printf("sdata[%2d]:%05x\n", i, sdata[i]);
        }

        printf("GR716 ADC example end\n");

        return 0;
}

