/* Workarounds for early GR716 with bootstrap issue */

#define GPTIMER0_BASE     0x80003000
#define WATCHDOG_CTRL           0x78
#define DIS_LVDS_ADR      0x8000d030
#define DIS_PLL_ADR       0x8010d000
#define CG_UNLOCK         0x80006000
#define CG_EN             0x80006004
#define CG_RESET          0x80006008
#define BO_VMON           0x8010c018
#define PULLDOWN_BNK0     0x8000d028 
#define PULLDOWN_BNK1     0x8000d02C             

#define BOOTSTRAP_ADR     0x80008000
#define BOOTSTRAP_SPIM    0x400BC003

#define TESTCONFIG_ADR    0x8000E000
#define TESTCONFIG_DIS_R  0x3

#define SPIM0_CONF_ADR    0xFFF00100
#define SPIM0_CTRL_ADR    0xFFF00104
#define SPIM0_EDAC_ADR    0xFFF00114

#define TESTCONFIG_DIS_R  0x3

	.section ".text"
	.global _start
_start:

  /* Watchdog disable BOOT sequence */
  set	GPTIMER0_BASE, %g1
  st	%g0, [%g1 + WATCHDOG_CTRL]

  /* Clear Brownout */
  /*Enable */	
  set CG_UNLOCK, %g1 
  set	0x8000000, %g2 
  st	%g2, [%g1]
  set CG_EN, %g1
  set	0x8000000, %g2  
  st	%g2, [%g1]
  set CG_RESET, %g1 
  st	%g0, [%g1]
  set CG_UNLOCK, %g1 
  st	%g0, [%g1]

  /* wmem 0x8010c018 0x7F */
  set BO_VMON, %g1
  set	0x7F, %g2
  st	%g2, [%g1] 
  st    %g0, [%g1]

  /* Disable LVDS */
  set	DIS_LVDS_ADR, %g1
  set	0x00888888, %g2
  st	%g2, [%g1] 

  /* Disable PLL */
  set	DIS_PLL_ADR, %g1
  set	0x80000000, %g2
  st	%g2, [%g1] 

  /* Pull down all inputs */
  set	PULLDOWN_BNK0, %g1
  set	0xffffffff, %g2
  st	%g2, [%g1] 
  set	PULLDOWN_BNK1, %g1
  st	%g2, [%g1]

  /* Disable WtachDog reset */
  set	TESTCONFIG_ADR, %g1
  set	TESTCONFIG_DIS_R, %g2
  st	%g2, [%g1] 

  /* Enable alt scaler and disbale EDAC for SPI memory */
  set	SPIM0_CTRL_ADR, %g1
  set	0x4, %g2
  st	%g2, [%g1]  
  set	SPIM0_EDAC_ADR, %g1
  st	%g0, [%g1]  

  /* Reboot to SPIM */
  set	BOOTSTRAP_ADR, %g1
  set	BOOTSTRAP_SPIM, %g2
  st	%g2, [%g1]   

  /* Jump to Start */
  jmpl %g0,%g1
  nop

.align	32
