# 16-bit CRC according to ECSS-E-70-41A
proc crc16 {data chk} {
        for {set i 0} {$i < 8} {incr i} {
                if [expr {($data & 0x80) ^ (($chk & 0x8000)>>8)}] {
                        set chk [expr {(($chk<<1) ^ 0x1021) & 0xffff}]
                } else {
                        set chk [expr {($chk<<1) & 0xffff}]
                }
                set data [expr {$data << 1}]
        }
        return $chk
}

proc crc16_gen {datas} {
        set chk 0xffff
        foreach data $datas {
                set chk [crc16 $data $chk]
        }
        return $chk
}

proc crc16_check {datas} {
        crc16_gen $datas
}

# Helpers
# Calculate checksum given file channel.
proc chcksum {ch} {
        set rawdata [read $ch]
        binary scan $rawdata c* data
        set fcksum [crc16_gen $data]
        return $fcksum
}

# Calculate checksum given file.
proc filecksum {name} {
        set c [open $name "rb"]
        set fcksum [chcksum $c]
        close $c
        return $fcksum
}

# Write integer as 32-bit big-endian binary bytes to stream.
proc w32 {ch value} { puts -nonewline $ch [binary format I $value] }
# Write integer as 16-bit big-endian binary bytes to stream.
proc w16 {ch value} { puts -nonewline $ch [binary format S $value] }

