#####################################################################################
# Interface Configuration Sections
#

## UART ##############################

### UART MAIN
set uart0_cfg0 { {uart0_cfg0} {
  { 1 1 uart_ctsn(0) in}
  { 0 1 uart_rtsn(0) out}
  { 2 1 uart_tx(0)   out}
  { 3 1 uart_rx(0)   in}
} }

set uart0_cfg1 { {uart0_cfg1} {
  {47 1 uart_ctsn(0) in}
  {48 1 uart_rtsn(0) out}
  {46 1 uart_tx(0)   out}
  {45 1 uart_rx(0)   in}
} }

set uart0_cfg2 { {uart0_cfg2} {
  {49 1 uart_ctsn(0) in}
  {48 1 uart_rtsn(0) out}
  {50 1 uart_tx(0)   out}
  {51 1 uart_rx(0)   in}
} }

set uart1_cfg0 { {uart1_cfg0} {
  { 4 1 uart_ctsn(1) in}
  { 5 1 uart_rtsn(1) out}
  { 6 1 uart_tx(1)   out}
  { 7 1 uart_rx(1)   in}
} }

set uart1_cfg1 { {uart1_cfg1} {
  {52 1 uart_ctsn(1) in}
  {53 1 uart_rtsn(1) out}
  {54 1 uart_tx(1)   out}
  {55 1 uart_rx(1)   in}
} }

set uart2_cfg0 { {uart2_cfg0} {
  { 8 1 uart_ctsn(2) in}
  { 9 1 uart_rtsn(2) out}
  {10 1 uart_tx(2)   out}
  {11 1 uart_rx(2)   in}
} }

set uart2_cfg1 { {uart2_cfg1} {
  {56 1 uart_ctsn(2) in}
  {57 1 uart_rtsn(2) out}
  {58 1 uart_tx(2)   out}
  {59 1 uart_rx(2)   in}
} }

set uart3_cfg0 { {uart3_cfg0} {
  {13 1 uart_ctsn(3) in}
  {14 1 uart_rtsn(3) out}
  {15 1 uart_tx(3)   out}
  {16 1 uart_rx(3)   in}
} }

set uart3_cfg1 { {uart3_cfg1} {
  {33 1 uart_ctsn(3) in}
  {34 1 uart_rtsn(3) out}
  {35 1 uart_tx(3)   out}
  {36 1 uart_rx(3)   in}
} }

set uart3_cfg2 { {uart3_cfg2} {
  {60 1 uart_ctsn(3) in}
  {61 1 uart_rx(3)   in}
  {62 1 uart_tx(3)   out}
  {63 1 uart_rtsn(3) out}
} }

set uart4_cfg0 { {uart4_cfg0} {
  {20 1 uart_ctsn(4) in}
  {17 1 uart_rtsn(4) out}
  {18 1 uart_tx(4)   out}
  {19 1 uart_rx(4)   in}
} }

set uart4_cfg1 { {uart4_cfg1} {
  {40 1 uart_ctsn(4) in}
  {37 1 uart_rtsn(4) out}
  {38 1 uart_tx(4)   out}
  {39 1 uart_rx(4)   in}
} }

set uart5_cfg0 { {uart5_cfg0} {
  {21 1 uart_ctsn(5) in}
  {22 1 uart_rtsn(5) out}
  {23 1 uart_tx(5)   out}
  {24 1 uart_rx(5)   in}
} }

set uart5_cfg1 { {uart5_cfg1} {
  {41 1 uart_ctsn(5) in}
  {42 1 uart_rtsn(5) out}
  {43 1 uart_tx(5)   out}
  {44 1 uart_rx(5)   in}
} }

### UART Short for GR716 Dev
set uart0_s_cfg0 { {uart0_cfg0} {
  { 2 1 uart_tx(0)   out}
  { 3 1 uart_rx(0)   in}
} }

set uart1_s_cfg0 { {uart1_cfg0} {
  { 6 1 uart_tx(1)   out}
  { 7 1 uart_rx(1)   in}
} }

set uart2_s_cfg0 { {uart2_cfg0} {
  {10 1 uart_tx(2)   out}
  {11 1 uart_rx(2)   in}
} }

set uart3_s_cfg0 { {uart3_cfg0} {
  {15 1 uart_tx(3)   out}
  {16 1 uart_rx(3)   in}
} }

set uart4_s_cfg0 { {uart4_cfg0} {
  {18 1 uart_tx(4)   out}
  {19 1 uart_rx(4)   in}
} }

set uart5_s_cfg0 { {uart5_cfg0} {
  {23 1 uart_tx(5)   out}
  {24 1 uart_rx(5)   in}
} }

## AUART #############################

set auart_cfg0 { {auart_cfg0} {
  {49 12 auart_tx   out}
  {50 12 auart_rx   in}
} }

## SPW ###############################

set spw_cfg0 { {spw_cfg0} {
  {21 11 spw_rxd in}
  {22 11 spw_rxs in}
  {23 11 spw_txs out}
  {24 11 spw_txd out}
} }

## 1553 ##############################

set mil1553_cfg0 { {mil1553_cfg0} {
  { 0 3 mil1553_rxena   out}
  { 1 3 mil1553_txa     out}
  { 2 3 mil1553_rxa     in}
  { 3 3 mil1553_rxna    in}
  { 4 3 mil1553_txna    out}
  { 5 3 mil1553_txinha  out}
  { 6 3 mil1553_rxb     in}
  { 7 3 mil1553_rxnb    in}
  { 8 3 mil1553_rxenb   out}
  { 9 3 mil1553_txb     out}
  {10 3 mil1553_clk     in}
  {11 3 mil1553_txnb    out}
  {12 3 mil1553_txinhb  out}
} }

set mil1553_cfg1 { {mil1553_cfg1} {
  {37 3 mil1553_rxena   out}
  {38 3 mil1553_txa     out}
  {39 3 mil1553_rxa     in}
  {40 3 mil1553_rxna    in}
  {41 3 mil1553_txna    out}
  {42 3 mil1553_txinha  out}
  {43 3 mil1553_rxb     in}
  {44 3 mil1553_rxnb    in}
  {45 3 mil1553_rxenb   out}
  {46 3 mil1553_txb     out}
  {47 3 mil1553_clk     in}
  {48 3 mil1553_txnb    out}
  {49 3 mil1553_txinhb  out}
} }

set mil1553_cfg2 { {mil1553_cfg2} {
  {51 3 mil1553_rxena   out}
  {52 3 mil1553_txa     out}
  {53 3 mil1553_rxa     in}
  {54 3 mil1553_rxna    in}
  {55 3 mil1553_txna    out}
  {56 3 mil1553_txinha  out}
  {57 3 mil1553_rxb     in}
  {58 3 mil1553_rxnb    in}
  {59 3 mil1553_rxenb   out}
  {60 3 mil1553_txb     out}
  {61 3 mil1553_clk     in}
  {62 3 mil1553_txnb    out}
  {63 3 mil1553_txinhb  out}
} }

set mil1553_sc_cfg0 { {mil1553_sc_cfg0} {
  {37 3 mil1553_rxena   out}
  {38 3 mil1553_txa     out}
  {39 3 mil1553_rxa     in}
  {54 3 mil1553_rxna    in}
  {55 3 mil1553_txna    out}
  {56 3 mil1553_txinha  out}
  {57 3 mil1553_rxb     in}
  {58 3 mil1553_rxnb    in}
  {45 3 mil1553_rxenb   out}
  {46 3 mil1553_txb     out}
  {47 3 mil1553_clk     in}
  {62 3 mil1553_txnb    out}
  {63 3 mil1553_txinhb  out}
} }

## PW(RX/TX) ##############################

set pw_cfg0 { {pw_cfg0} {
  { 4 4 pwrx_valid  in}
  { 1 4 pwrx_clk    in}
  { 2 4 pwrx_data   in}
  { 3 4 pwrx_abort  in}
  { 0 4 pwrx_busyn  out}
  { 5 4 pwrx_ready  out}
  { 6 4 pwtx_valid  out}
  { 7 4 pwtx_clk    out}
  { 8 4 pwtx_busyn  in}
  { 9 4 pwtx_ready  in}
  {10 4 pwtx_data   out}
  {11 4 pwtx_abort  out}
} }

set pw_cfg1 { {pw_cfg1} {
  {25 4 pwrx_valid  in}
  {26 4 pwrx_clk    in}
  {27 4 pwrx_data   in}
  {28 4 pwrx_abort  in}
  {29 4 pwrx_busyn  out}
  {30 4 pwrx_ready  out}
  {31 4 pwtx_valid  out}
  {32 4 pwtx_clk    out}
  {33 4 pwtx_busyn  in}
  {34 4 pwtx_ready  in}
  {35 4 pwtx_data   out}
  {36 4 pwtx_abort  out}
} }

set pw_cfg2 { {pw_cfg2} {
  {37 4 pwrx_valid  in}
  {38 4 pwrx_clk    in}
  {39 4 pwrx_data   in}
  {40 4 pwrx_abort  in}
  {41 4 pwrx_busyn  out}
  {42 4 pwrx_ready  out}
  {43 4 pwtx_valid  out}
  {44 4 pwtx_clk    out}
  {45 4 pwtx_busyn  in}
  {46 4 pwtx_ready  in}
  {47 4 pwtx_data   out}
  {48 4 pwtx_abort  out}
} }

set pw_cfg3 { {pw_cfg3} {
  {52 4 pwrx_valid  in}
  {53 4 pwrx_clk    in}
  {54 4 pwrx_data   in}
  {55 4 pwrx_abort  in}
  {56 4 pwrx_busyn  out}
  {57 4 pwrx_ready  out}
  {58 4 pwtx_valid  out}
  {59 4 pwtx_clk    out}
  {60 4 pwtx_busyn  in}
  {61 4 pwtx_ready  in}
  {62 4 pwtx_data   out}
  {63 4 pwtx_abort  out}
} }

## SPIM ###############################

set spim1_cfg0 { {spim0_cfg1} {
  { 1 7 spim_sck(1)   out}
  { 3 7 spim_miso(1)  in}
  { 2 7 spim_mosi(1)  out}
  { 0 7 spim_slv(1)   out}
} }

set spim1_cfg1 { {spim0_cfg1} {
  {50 11 spim_sck(1)   out}
  {52 11 spim_miso(1)  in}
  {51 11 spim_mosi(1)  out}
  {49 11 spim_slv(1)   out}
} }

## SPI #################################

set spi0_cfg0 { {spi0_cfg0} {
  { 4 7 spi_sck(0)   inout}
  { 5 7 spi_miso(0)  inout}
  { 6 7 spi_mosi(0)  inout}
  { 8 7 spi_slv(0)   out}
  { 7 7 spi_sel(0)   in}
} }

set spi0_cfg1 { {spi0_cfg1} {
  {25 7 spi_sck(0)   inout}
  {26 7 spi_miso(0)  inout}
  {27 7 spi_mosi(0)  inout}
  {29 7 spi_slv(0)   out}
  {28 7 spi_sel(0)   in}
} }

set spi0_cfg2 { {spi0_cfg2} {
  {41 7 spi_sck(0)   inout}
  {42 7 spi_miso(0)  inout}
  {43 7 spi_mosi(0)  inout}
  {40 7 spi_slv(0)   out}
  {44 7 spi_sel(0)   in}
} }

set spi0_cfg3 { {spi0_cfg3} {
  {57 7 spi_sck(0)   inout}
  {58 7 spi_miso(0)  inout}
  {59 7 spi_mosi(0)  inout}
  {61 7 spi_slv(0)   out}
  {60 7 spi_sel(0)   in}
} }


set spi1_cfg0 { {spi1_cfg0} {
  {13 7 spi_sck(1)   inout}
  {14 7 spi_miso(1)  inout}
  {15 7 spi_mosi(1)  inout}
  {17 7 spi_slv(1)   out}
  {16 7 spi_sel(1)   in}
} }

set spi1_cfg1 { {spi1_cfg1} {
  {47 7 spi_sck(1)   inout}
  {48 7 spi_miso(1)  inout}
  {49 7 spi_mosi(1)  inout}
  {46 7 spi_slv(1)   out}
  {50 7 spi_sel(1)   in}
} }

set spi1_cfg2 { {spi0_cfg2} {
  {47 7 spi_sck(1)   inout}
  {48 7 spi_miso(1)  inout}
  {51 7 spi_mosi(1)  inout}
  {46 7 spi_slv(1)   out}
  {52 7 spi_sel(1)   in}
} }

## SPI-SLVSEL ###################################

set spi0_slvsel_cfg0 { {spi0_slvsel_cfg0} {
  { 8 7 spi_slvsel(0)   out}
  { 9 7 spi_slvsel(1)   out}
  {10 7 spi_slvsel(2)   out}
  {11 7 spi_slvsel(3)   out}
} }

set spi0_slvsel_cfg1 { {spi0_slvsel_cfg1} {
  {29 7 spi_slvsel(0)   out}
  {30 7 spi_slvsel(1)   out}
  {31 7 spi_slvsel(2)   out}
  {32 7 spi_slvsel(3)   out}
} }

set spi0_slvsel_cfg2 { {spi0_slvsel_cfg2} {
  {40 7 spi_slvsel(0)   out}
  {39 7 spi_slvsel(1)   out}
  {38 7 spi_slvsel(2)   out}
  {37 7 spi_slvsel(3)   out}
} }

set spi0_slvsel_cfg3 { {spi0_slvsel_cfg3} {
  {61 7 spi_slvsel(0)   out}
  {62 7 spi_slvsel(1)   out}
  {63 7 spi_slvsel(2)   out}
  {37 7 spi_slvsel(3)   out}
} }


set spi1_slvsel_cfg0 { {spi1_slvsel_cfg0} {
  {17 7 spi_slvsel(4)   out}
  {18 7 spi_slvsel(5)   out}
  {21 7 spi_slvsel(6)   out}
  {22 7 spi_slvsel(7)   out}
} }

set spi1_slvsel_cfg1 { {spi1_slvsel_cfg1} {
  {46 7 spi_slvsel(4)   out}
  {45 7 spi_slvsel(5)   out}
  {21 7 spi_slvsel(6)   out}
  {22 7 spi_slvsel(7)   out}
} }

## SPI-SLV #######################################

set spis_cfg0 { {spis_cfg0} {
  {53 7 spis_sck   in}
  {54 7 spis_miso  out}
  {55 7 spis_mosi  in}
  {56 7 spis_slv   in}
} }

## SPI-SLV #####################################

set spi4s_cfg0 { {spi4s_cfg0} {
  {53 11 spis_sck   in}
  {54 11 spis_miso  out}
  {55 11 spis_mosi  in}
  {56 11 spis_slv   in}
} }

## CAN #########################################

set can0_cfg0 { {can0_cfg0} {
  { 0 5 can_tx(0)  out}
  { 1 5 can_rx(0)  in}
  { 2 5 can_en(0)  out}
} }

set can0_cfg1 { {can0_cfg1} {
  {13 5 can_tx(0)  out}
  {14 5 can_rx(0)  in}
  {15 5 can_en(0)  out}
} }

set can0_cfg2 { {can0_cfg2} {
  {37 5 can_tx(0)  out}
  {38 5 can_rx(0)  in}
  {39 5 can_en(0)  out}
} }

set can0_cfg3 { {can0_cfg3} {
  {41 5 can_tx(0)  out}
  {42 5 can_rx(0)  in}
  {43 5 can_en(0)  out}
} }

set can0_cfg4 { {can0_cfg4} {
  {58 5 can_tx(0)  out}
  {59 5 can_rx(0)  in}
  {60 5 can_en(0)  out}
} }


set can1_cfg0 { {can1_cfg0} {
  { 4 5 can_tx(1)  out}
  { 3 5 can_rx(1)  in}
  { 5 5 can_en(1)  out}
} }

set can1_cfg1 { {can1_cfg1} {
  {17 5 can_tx(1)  out}
  {16 5 can_rx(1)  in}
  {18 5 can_en(1)  out}
} }

set can1_cfg2 { {can1_cfg2} {
  {47 5 can_tx(1)  out}
  {44 5 can_rx(1)  in}
  {48 5 can_en(1)  out}
} }

set can1_cfg3 { {can1_cfg3} {
  {47 5 can_tx(1)  out}
  {45 5 can_rx(1)  in}
  {48 5 can_en(1)  out}
} }

set can1_cfg4 { {can1_cfg4} {
  {62 5 can_tx(1)  out}
  {61 5 can_rx(1)  in}
  {63 5 can_en(1)  out}
} }

set can1_sc_cfg0 { {can1_sc_cfg0} {
  {62 5 can_tx(1)  out}
  {45 5 can_rx(1)  in}
  {63 5 can_en(1)  out}
} }

# GR716 DEV Board
set can0_s_cfg0 { {can0_cfg0} {
  { 0 5 can_tx(0)  out}
  { 1 5 can_rx(0)  in}
} }

set can1_s_cfg1 { {can1_cfg1} {
  {17 5 can_tx(1)  out}
  {16 5 can_rx(1)  in}
} }

## MEM ####################################

set mem_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {51 2 mem_addr(21) out}
  {52 2 mem_addr(22) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {35 11 mem_brdyn    in}
  {36 11 mem_bexcn    in}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {21 2 ram_csn(2)   out}
  {22 2 ram_csn(3)   out}
  {23 2 rom_csn(0)   out}
  {24 2 rom_csn(1)   out}
} }

set mem_cfg1 { {mem_cfg1} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {51 2 mem_addr(21) out}
  {52 2 mem_addr(22) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {35 11 mem_brdyn    in}
  {36 11 mem_bexcn    in}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {41 2 ram_csn(2)   out}
  {42 2 ram_csn(3)   out}
  {43 2 rom_csn(0)   out}
  {44 2 rom_csn(1)   out}
} }

set mem_cfg2 { {mem_cfg2} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {51 2 mem_addr(21) out}
  {52 2 mem_addr(22) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {35 11 mem_brdyn    in}
  {36 11 mem_bexcn    in}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {21 2 ram_csn(2)   out}
  {22 2 ram_csn(3)   out}
  {62 2 rom_csn(0)   out}
  {63 2 rom_csn(1)   out}
} }

set mem_cfg3 { {mem_cfg3} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {51 2 mem_addr(21) out}
  {52 2 mem_addr(22) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {21 2 ram_csn(2)   out}
  {22 2 ram_csn(3)   out}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

set mem_boot_sram_cfg0 { {mem_boot_sram_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
} }

set mem_boot_prom_cfg0 { {mem_boot_prom_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

set mem_boot_cfg0 { {mem_boot_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

set mem_sc_cfg0 { {mem_sc_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {21 2 ram_csn(2)   out}
  {22 2 ram_csn(3)   out}
  {23 2 rom_csn(0)   out}
  {24 2 rom_csn(1)   out}
} }

set mem_sc_cfg1 { {mem_sc_cfg1} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

set mem_sc_cfg2 { {mem_sc_cfg2} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

set mem_sc_cfg3 { {mem_sc_cfg3} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
  {20 2 ram_csn(1)   out}
  {35 2 rom_csn(0)   out}
  {36 2 rom_csn(1)   out}
} }

# Custom configuration for GR716 Mini Board
set mem_gr716_mini_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
} }

# Custom configuration for GR716 Memory Board
set mem_gr716_mem_ram0_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {19 2 ram_csn(0)   out}
} }

set mem_gr716_mem_ram1_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {20 2 ram_csn(1)   out}
} }

set mem_gr716_mem_flash0_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {23 2 rom_csn(0)   out}
} }

set mem_gr716_mem_flash1_cfg0 { {mem_cfg0} {
  { 0 2 mem_addr(0)  out}
  { 1 2 mem_addr(1)  out}
  { 2 2 mem_addr(2)  out}
  { 3 2 mem_addr(3)  out}
  { 4 2 mem_addr(4)  out}
  { 5 2 mem_addr(5)  out}
  { 6 2 mem_addr(6)  out}
  { 7 2 mem_addr(7)  out}
  { 8 2 mem_addr(8)  out}
  { 9 2 mem_addr(9)  out}
  {10 2 mem_addr(10) out}
  {11 2 mem_addr(11) out}
  {12 2 mem_addr(12) out}
  {13 2 mem_addr(13) out}
  {14 2 mem_addr(14) out}
  {15 2 mem_addr(15) out}
  {16 2 mem_addr(16) out}
  {17 2 mem_addr(17) out}
  {18 2 mem_addr(18) out}
  {49 2 mem_addr(19) out}
  {50 2 mem_addr(20) out}
  {33 2 mem_oen      out}
  {34 2 mem_wrn      out}
  {25 2 mem_data(0)  inout}
  {26 2 mem_data(1)  inout}
  {27 2 mem_data(2)  inout}
  {28 2 mem_data(3)  inout}
  {29 2 mem_data(4)  inout}
  {30 2 mem_data(5)  inout}
  {31 2 mem_data(6)  inout}
  {32 2 mem_data(7)  inout}
  {24 2 rom_csn(1)   out}
} }

## PWM #########################################

set pwm_cfg0 { {pwm_cfg0} {
  { 0 10 pwm(0)  out}
  { 1 10 pwm(1)  out}
  { 2 10 pwm(2)  out}
  { 3 10 pwm(3)  out}
  { 4 10 pwm(4)  out}
  { 5 10 pwm(5)  out}
  { 6 10 pwm(6)  out}
  { 7 10 pwm(7)  out}
  { 8 10 pwm(8)  out}
  { 9 10 pwm(9)  out}
  {10 10 pwm(10) out}
  {11 10 pwm(11) out}
  {12 10 pwm(12) out}
  {13 10 pwm(13) out}
  {14 10 pwm(14) out}
  {15 10 pwm(15) out}
} }

set pwm_cfg1 { {pwm_cfg1} {
  {25 10 pwm(0)  out}
  {26 10 pwm(1)  out}
  {27 10 pwm(2)  out}
  {28 10 pwm(3)  out}
  {29 10 pwm(4)  out}
  {30 10 pwm(5)  out}
  {31 10 pwm(6)  out}
  {32 10 pwm(7)  out}
  {33 10 pwm(8)  out}
  {34 10 pwm(9)  out}
  {35 10 pwm(10) out}
  {36 10 pwm(11) out}
  {21 10 pwm(12) out}
  {22 10 pwm(13) out}
  {23 10 pwm(14) out}
  {24 10 pwm(15) out}
} }

set pwm_cfg2 { {pwm_cfg2} {
  {37 10 pwm(0)  out}
  {38 10 pwm(1)  out}
  {39 10 pwm(2)  out}
  {40 10 pwm(3)  out}
  { 4 10 pwm(4)  out}
  { 5 10 pwm(5)  out}
  { 6 10 pwm(6)  out}
  { 7 10 pwm(7)  out}
  { 8 10 pwm(8)  out}
  { 9 10 pwm(9)  out}
  {10 10 pwm(10) out}
  {11 10 pwm(11) out}
  {12 10 pwm(12) out}
  {13 10 pwm(13) out}
  {14 10 pwm(14) out}
  {15 10 pwm(15) out}
} }

set pwm_cfg3 { {pwm_cfg3} {
  {41 10 pwm(0)  out}
  {42 10 pwm(1)  out}
  {43 10 pwm(2)  out}
  {44 10 pwm(3)  out}
  {45 10 pwm(4)  out}
  {46 10 pwm(5)  out}
  {47 10 pwm(6)  out}
  { 7 10 pwm(7)  out}
  { 8 10 pwm(8)  out}
  { 9 10 pwm(9)  out}
  {10 10 pwm(10) out}
  {11 10 pwm(11) out}
  {12 10 pwm(12) out}
  {13 10 pwm(13) out}
  {14 10 pwm(14) out}
  {15 10 pwm(15) out}
} }

set pwm_cfg4 { {pwm_cfg4} {
  {49 10 pwm(0)  out}
  {50 10 pwm(1)  out}
  {51 10 pwm(2)  out}
  {52 10 pwm(3)  out}
  {53 10 pwm(4)  out}
  {54 10 pwm(5)  out}
  {55 10 pwm(6)  out}
  {56 10 pwm(7)  out}
  {57 10 pwm(8)  out}
  {58 10 pwm(9)  out}
  {59 10 pwm(10) out}
  {60 10 pwm(11) out}
  {61 10 pwm(12) out}
  {62 10 pwm(13) out}
  {63 10 pwm(14) out}
  {48 10 pwm(15) out}
} }

## GRADCDAC ####################################

set gradcdac_cfg0 { {gradcdac_cfg0} {
  {13 9 gradcdac_d(0)  inout}
  {14 9 gradcdac_d(1)  inout}
  {15 9 gradcdac_d(2)  inout}
  {16 9 gradcdac_d(3)  inout}
  {19 9 gradcdac_d(4)  inout}
  {20 9 gradcdac_d(5)  inout}
  {21 9 gradcdac_d(6)  inout}
  {22 9 gradcdac_d(7)  inout}
  {23 9 gradcdac_d(8)  inout}
  {24 9 gradcdac_d(9)  inout}
  {25 9 gradcdac_d(10) inout}
  {26 9 gradcdac_d(11) inout}
  {27 9 gradcdac_d(12) inout}
  {28 9 gradcdac_d(13) inout}
  {29 9 gradcdac_d(14) inout}
  {30 9 gradcdac_d(15) inout}
  { 0 9 gradcdac_a(0)  out}
  { 1 9 gradcdac_a(1)  out}
  { 2 9 gradcdac_a(2)  out}
  { 3 9 gradcdac_a(3)  out}
  { 4 9 gradcdac_a(4)  out}
  { 5 9 gradcdac_a(5)  out}
  { 6 9 gradcdac_a(6)  out}
  { 7 9 gradcdac_a(7)  out}
  {31 9 gradcdac_rc    out}
  {32 9 gradcdac_wr    out}
  {33 9 gradcdac_cs    out}
  {34 9 gradcdac_rdy   in}
  {35 9 gradcdac_trig  in}
} }

set gradcdac_cfg1 { {gradcdac_cfg1} {
  {13 9 gradcdac_d(0)  inout}
  {14 9 gradcdac_d(1)  inout}
  {15 9 gradcdac_d(2)  inout}
  {16 9 gradcdac_d(3)  inout}
  {19 9 gradcdac_d(4)  inout}
  {20 9 gradcdac_d(5)  inout}
  {36 9 gradcdac_d(6)  inout}
  {37 9 gradcdac_d(7)  inout}
  {23 9 gradcdac_d(8)  inout}
  {24 9 gradcdac_d(9)  inout}
  {25 9 gradcdac_d(10) inout}
  {26 9 gradcdac_d(11) inout}
  {27 9 gradcdac_d(12) inout}
  {28 9 gradcdac_d(13) inout}
  {29 9 gradcdac_d(14) inout}
  {30 9 gradcdac_d(15) inout}
  {17 9 gradcdac_a(0)  out}
  {18 9 gradcdac_a(1)  out}
  { 2 9 gradcdac_a(2)  out}
  { 3 9 gradcdac_a(3)  out}
  { 4 9 gradcdac_a(4)  out}
  { 5 9 gradcdac_a(5)  out}
  { 6 9 gradcdac_a(6)  out}
  { 7 9 gradcdac_a(7)  out}
  {31 9 gradcdac_rc    out}
  {32 9 gradcdac_wr    out}
  {33 9 gradcdac_cs    out}
  {34 9 gradcdac_rdy   in}
  {35 9 gradcdac_trig  in}
} }

set gradcdac_cfg2 { {gradcdac_cfg2} {
  {49 9 gradcdac_d(0)  inout}
  {50 9 gradcdac_d(1)  inout}
  {51 9 gradcdac_d(2)  inout}
  {52 9 gradcdac_d(3)  inout}
  {53 9 gradcdac_d(4)  inout}
  {54 9 gradcdac_d(5)  inout}
  {55 9 gradcdac_d(6)  inout}
  {56 9 gradcdac_d(7)  inout}
  {57 9 gradcdac_d(8)  inout}
  {58 9 gradcdac_d(9)  inout}
  {59 9 gradcdac_d(10) inout}
  {60 9 gradcdac_d(11) inout}
  {61 9 gradcdac_d(12) inout}
  {48 9 gradcdac_d(13) inout}
  {47 9 gradcdac_d(14) inout}
  {46 9 gradcdac_d(15) inout}
  {62 9 gradcdac_a(0)  out}
  {63 9 gradcdac_a(1)  out}
  { 2 9 gradcdac_a(2)  out}
  { 3 9 gradcdac_a(3)  out}
  { 4 9 gradcdac_a(4)  out}
  { 5 9 gradcdac_a(5)  out}
  { 6 9 gradcdac_a(6)  out}
  { 7 9 gradcdac_a(7)  out}
  {40 9 gradcdac_rc    out}
  {41 9 gradcdac_wr    out}
  {42 9 gradcdac_cs    out}
  {43 9 gradcdac_rdy   in}
  {44 9 gradcdac_trig  in}
} }

set gradcdac_if_cfg1 { {gradcdac_if_cfg1} {
  {49 9 gradcdac_d(0)  inout}
  {50 9 gradcdac_d(1)  inout}
  {51 9 gradcdac_d(2)  inout}
  {52 9 gradcdac_d(3)  inout}
  {53 9 gradcdac_d(4)  inout}
  {54 9 gradcdac_d(5)  inout}
  {55 9 gradcdac_d(6)  inout}
  {56 9 gradcdac_d(7)  inout}
  {57 9 gradcdac_d(8)  inout}
  {58 9 gradcdac_d(9)  inout}
  {59 9 gradcdac_d(10) inout}
  {60 9 gradcdac_d(11) inout}
  {61 9 gradcdac_d(12) inout}
  {48 9 gradcdac_d(13) inout}
  {47 9 gradcdac_d(14) inout}
  {46 9 gradcdac_d(15) inout}
  {62 9 gradcdac_a(0)  out}
  {63 9 gradcdac_a(1)  out}
  {40 9 gradcdac_rc    out}
  {41 9 gradcdac_wr    out}
  {42 9 gradcdac_cs    out}
  {43 9 gradcdac_rdy   in}
  {44 9 gradcdac_trig  in}
} }

set gradcdac_sc_cfg0 { {gradcdac_sc_cfg0} {
  {17 9 gradcdac_a(0)  out}
  {18 9 gradcdac_a(1)  out}
  {40 9 gradcdac_rc    out}
  {41 9 gradcdac_wr    out}
  {42 9 gradcdac_cs    out}
  {43 9 gradcdac_rdy   in}
  {44 9 gradcdac_trig  in}
  {49 9 gradcdac_d(0)  inout}
  {50 9 gradcdac_d(1)  inout}
  {51 9 gradcdac_d(2)  inout}
  {52 9 gradcdac_d(3)  inout}
  {53 9 gradcdac_d(4)  inout}
  {20 9 gradcdac_d(5)  inout}
  {21 9 gradcdac_d(6)  inout}
  {22 9 gradcdac_d(7)  inout}
  {23 9 gradcdac_d(8)  inout}
  {24 9 gradcdac_d(9)  inout}
  {59 9 gradcdac_d(10) inout}
  {60 9 gradcdac_d(11) inout}
  {61 9 gradcdac_d(12) inout}
  {48 9 gradcdac_d(13) inout}
} }

set gradcdac_sc_cfg1 { {gradcdac_sc_cfg1} {
  {17 9 gradcdac_a(0)  out}
  {18 9 gradcdac_a(1)  out}
  {40 9 gradcdac_rc    out}
  {41 9 gradcdac_wr    out}
  {42 9 gradcdac_cs    out}
  {43 9 gradcdac_rdy   in}
  {44 9 gradcdac_trig  in}
  {49 9 gradcdac_d(0)  inout}
  {50 9 gradcdac_d(1)  inout}
  {51 9 gradcdac_d(2)  inout}
  {52 9 gradcdac_d(3)  inout}
  {53 9 gradcdac_d(4)  inout}
  {54 9 gradcdac_d(5)  inout}
  {55 9 gradcdac_d(6)  inout}
  {56 9 gradcdac_d(7)  inout}
  {57 9 gradcdac_d(8)  inout}
  {58 9 gradcdac_d(9)  inout}
  {59 9 gradcdac_d(10) inout}
  {60 9 gradcdac_d(11) inout}
  {61 9 gradcdac_d(12) inout}
  {48 9 gradcdac_d(13) inout}
  {46 9 gradcdac_d(15) inout}
  {47 9 gradcdac_d(14) inout}
} }

## Internal ADCDAC ###########################

set intadcdac_cfg0 { {intadcdac_cfg0} {
  {37 8 adc(0)  inout}
  {38 8 adc(1)  inout}
  {39 8 adc(2)  inout}
  {40 8 adc(3)  inout}
  {41 8 adc(4)  inout}
  {42 8 adc(5)  inout}
  {43 8 adc(6)  inout}
  {44 8 adc(7)  inout}
  {45 8 dac(0)  inout}
  {46 8 dac(1)  inout}
  {47 8 dac(2)  inout}
  {48 8 dac(3)  inout}
} }

## I2CM #######################################

set i2cm0_cfg0 { {i2cm0_cfg0} {
  { 2 6 i2cm_sda(0)  inout}
  { 3 6 i2cm_scl(0)  inout}
} }

set i2cm0_cfg1 { {i2cm0_cfg1} {
  {25 6 i2cm_sda(0)  inout}
  {26 6 i2cm_scl(0)  inout}
} }

set i2cm0_cfg2 { {i2cm0_cfg2} {
  {33 6 i2cm_sda(0)  inout}
  {34 6 i2cm_scl(0)  inout}
} }

set i2cm0_cfg3 { {i2cm0_cfg3} {
  {41 6 i2cm_sda(0)  inout}
  {42 6 i2cm_scl(0)  inout}
} }

set i2cm0_cfg4 { {i2cm0_cfg4} {
  {52 6 i2cm_sda(0)  inout}
  {53 6 i2cm_scl(0)  inout}
} }


set i2cm1_cfg0 { {i2cm1_cfg0} {
  { 4 6 i2cm_sda(1)  inout}
  { 5 6 i2cm_scl(1)  inout}
} }

set i2cm1_cfg1 { {i2cm1_cfg1} {
  {27 6 i2cm_sda(1)  inout}
  {28 6 i2cm_scl(1)  inout}
} }

set i2cm1_cfg2 { {i2cm1_cfg2} {
  {47 6 i2cm_sda(1)  inout}
  {48 6 i2cm_scl(1)  inout}
} }

set i2cm1_cfg3 { {i2cm1_cfg3} {
  {54 6 i2cm_sda(1)  inout}
  {55 6 i2cm_scl(1)  inout}
} }

## I2CS #######################################

set i2cs0_cfg0 { {i2cs0_cfg0} {
  { 6 6 i2cs_sda(0)  inout}
  { 7 6 i2cs_scl(0)  inout}
} }

set i2cs0_cfg1 { {i2cs0_cfg1} {
  {29 6 i2cs_sda(0)  inout}
  {30 6 i2cs_scl(0)  inout}
} }

set i2cs0_cfg2 { {i2cs0_cfg2} {
  {35 6 i2cs_sda(0)  inout}
  {36 6 i2cs_scl(0)  inout}
} }

set i2cs0_cfg3 { {i2cs0_cfg3} {
  {43 6 i2cs_sda(0)  inout}
  {44 6 i2cs_scl(0)  inout}
} }

set i2cs0_cfg4 { {i2cs0_cfg4} {
  {56 6 i2cs_sda(0)  inout}
  {57 6 i2cs_scl(0)  inout}
} }


set i2cs1_cfg0 { {i2cs1_cfg0} {
  { 8 6 i2cs_sda(1)  inout}
  { 9 6 i2cs_scl(1)  inout}
} }

set i2cs1_cfg1 { {i2cs1_cfg1} {
  {31 6 i2cs_sda(1)  inout}
  {32 6 i2cs_scl(1)  inout}
} }

set i2cs1_cfg2 { {i2cs1_cfg2} {
  {39 6 i2cs_sda(1)  inout}
  {40 6 i2cs_scl(1)  inout}
} }

set i2cs1_cfg3 { {i2cs1_cfg3} {
  {58 6 i2cs_sda(1)  inout}
  {59 6 i2cs_scl(1)  inout}
} }


set i2cs2_cfg0 { {i2cs2_cfg0} {
  {10 6 i2cs_sda(2)  inout}
  {11 6 i2cs_scl(2)  inout}
} }

set i2cs2_cfg1 { {i2cs2_cfg1} {
  {49 6 i2cs_sda(2)  inout}
  {50 6 i2cs_scl(2)  inout}
} }

set i2cs2_cfg2 { {i2cs2_cfg2} {
  {60 6 i2cs_sda(2)  inout}
  {61 6 i2cs_scl(2)  inout}
} }

## GPIO #################################

set gpio_cfg0 { {gpio_cfg} {
} }                                                                                          

#####################################################################################
# Help functions
#

# empty arrays
for {set i 0} {$i < 64} {incr i} {set pin_list($i) gpio($i)}                                          
for {set i 0} {$i < 8} {incr i} {set a($i) 00000000}
set err_list {}
set wrn_list {}

proc gen_config {replace cfg_lists pin_list c_const err_list wrn_list} {                                                                          
  upvar $cfg_lists cfg_list
  upvar $pin_list pinlist
  upvar $c_const cconst
  upvar $err_list errlist
  upvar $wrn_list wrnlist
  set err_cnt 0
  set wrn_cnt 0
  foreach cfg $cfg_list {

    lassign $cfg cfg_name cfg_pins                                                               

    foreach i $cfg_pins {
      set err 0
      set wrn 0
      lassign $i x y z d                                                                            
      #puts "pin $x, cfg $y, name $z"                                                             

      # Update C constant 
      set aidx [expr $x / 8]                                                                      
      set sidx [expr 7 - ($x % 8)]                                                                      
      if { [ string range $cconst($aidx) $sidx $sidx ] != "0" } {
        if { [ string range $cconst($aidx) $sidx $sidx ] != $y } {
          set err 1; incr err_cnt
        } else {
          if { [ string range $cconst($aidx) $sidx $sidx ] != "2" } {
            set err 1; incr err_cnt 
          } else {
            set wrn 1; incr wrn_cnt
          }
        }
      }
      if {$err == 1 && $replace == 0} {
        set cconst($aidx) [string replace $cconst($aidx) $sidx $sidx "X"]
      } else {
        set cconst($aidx) [string replace $cconst($aidx) $sidx $sidx [format "%X" $y]]
      }
      
      # Update pin-list
      if {$err == 1} {
        if {$replace == 1} {
          set errlist [lappend errlist $pinlist($x)]
          set pinlist($x) $z
        } else {
          set errlist [lappend errlist $z]
          set pinlist($x) [lappend pinlist($x) $z]
        }
      } else {
        set pinlist($x) $z
        if {$wrn == 1} {set wrnlist [lappend wrnlist $z]}
      }

    }                                                                                             

  }
  return $err_cnt
}                                                                                               

proc print_pin_list {pin_list} {
  upvar $pin_list pins
  puts "\n#####################################################################################"
  puts "# Pin list"
  puts "#####################################################################################\n"
  for {set i 0} {$i < 64} {incr i} {puts "pin\[$i\]: $pins($i)"}                                          
}

proc print_c_const {name c_const} {
  upvar $c_const cconst
  puts "\n//###################################################################################"
  puts "// C constant ($name)"
  puts "//###################################################################################\n"

  for {set i 0} {$i < 8} {incr i} {                                                             
    if {$i == 0} {                                                                              
      puts "const int $name\[8\] = \{"                                                       
      puts "0x$cconst($i),"                                                                      
    } elseif {$i == 7} {                                                                        
      puts "0x$cconst($i)\};"                                                                    
    } else {                                                                                    
      puts "0x$cconst($i),"                                                                      
    }                                                                                           
  }                                                                                             
}

proc print_err {replace err_list} {
  puts "#####################################################################################"
  puts "Error: conflicting pin config"
  puts "#####################################################################################\n"
  if {$replace == 1} {
    puts "Un-mapped signal:"
    puts $err_list
  } else {
    puts "Double-mapped signal:"
    puts $err_list
  }
}

proc print_wrn {replace wrn_list} {
  puts "#####################################################################################"
  puts "Warning: potential conflicting pin configuration"
  puts "#####################################################################################\n"
  puts ""
  puts "Info: This warning is due to multiple configuration of the same memory interfaces is found in design."
  puts ""
  if {$replace == 1} {
    puts "Un-mapped signal:"
    puts $wrn_list
  } else {
    puts "Double-mapped signal:"
    puts $wrn_list
  }
}

proc print_config_start {config_name} {
  puts "\n#####################################################################################"
  puts "# "
  puts "# Print-out for configuration $config_name"
  puts "# "
  puts "#####################################################################################\n"
}

proc print_config_end {config_name} {
  puts "\n#####################################################################################"
  puts "# "
  puts "# End of printout for configuration $config_name"
  puts "# "
  puts "#####################################################################################\n"
}

#####################################################################################
# Board Configurations
#

### GR716 MINI #####################
#
# Note1: GR716 Board configuration should always include mem_gr716_mini_cfg0

set gr716_mini_1_cfg [list \
$mem_gr716_mini_cfg0 \
]

### GR716 BOARD ####################
#
#

# GPIO Config
set gr716_board_1_cfg [list \
]

# Memory exp Config
set gr716_board_2_cfg [list \
$mem_gr716_mem_ram0_cfg0 \
$mem_gr716_mem_flash0_cfg0 \
]

### GR716 DEV #####################
#
#

### Config Board X
# GPIO config
set gr716_dev_configx_cfg [list \
]

### Config Board 0
# GPIO config
set gr716_dev_config0_cfg [list \
]

set gr716_dev_config0_uart_1553_pw_can_spis_spim_cfg [list \
$uart0_s_cfg0 \
$uart1_s_cfg0 \
$uart2_s_cfg0 \
$uart4_s_cfg0 \
$mil1553_cfg2 \
$pw_cfg2 \
$can0_s_cfg0 \
$can1_s_cfg1 \
$spi0_cfg1 \
]

### Config Board 1
# GPIO config
set gr716_dev_config1_cfg [list \
]

# GPIO config
set gr716_dev_config1_sram_prom_cfg [list \
$mem_gr716_mem_ram0_cfg0 \
$mem_gr716_mem_flash0_cfg0 \
]

#####################################################################################
# List of configurations to generate
#

set gr716_board_config_list [list \
gr716_mini_1 \
gr716_board_1 \
gr716_board_2 \
gr716_dev_configx \
gr716_dev_config0 \
gr716_dev_config0_uart_1553_pw_can_spis_spim \
gr716_dev_config1 \
gr716_dev_config1_sram_prom \
]

#####################################################################################
# Process for generating pin list and register configuration
#

set replace 0
  
  # C constant and info
  foreach config $gr716_board_config_list {
    # empty arrays
    for {set i 0} {$i < 64} {incr i} {set pin_list($i) gpio($i)}                                          
    for {set i 0} {$i < 8} {incr i} {set a($i) 00000000}
    set err_list {}
    set wrn_list {}
  
    print_config_start [subst $config]
    if { [gen_config $replace [subst $config]_cfg pin_list a err_list wrn_list] } {
      print_err $replace $err_list
    } else {
      if {$wrn_list != ""} {print_wrn $replace $wrn_list}
      print_c_const [subst $config] a
      print_pin_list pin_list
    }
    print_config_end [subst $config]
  }
