/*
 * Copyright (c) 2017, Cobham Gaisler AB
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 */

#include <macros.i>

	.section	".text"
	.global		__bcc_crt0

/*
 * At entry to __crt0_entry, the following is assumed:
 * - %sp points to top of stack
 * - %wim and %psr.cwp are valid
 * - %psr.et=1
 */
FUNC_BEGIN __bcc_crt0
	call    __bcc_init50

	/* NOTE: Assuming %sp is already set by boot loader. */
	mv	s0, sp

	/*
	 * If the symbol __bcc_cfg_skip_clear_bss has non-zero value, then
	 * clear .bss. Otherwise do not clear .bss.
	 */
	la	t0, __bcc_cfg_skip_clear_bss
	bnez	t0, .Lskip_clear_bss
	/* Clear bss */
	la	a0, __bss_start
	la	a2, __bss_end
	/* Number of double words. */
	sub	a3, a2, a0
	srl	a1, a3, 3
	call	bcc_dwzero
.Lskip_clear_bss:

	la	t0, __bcc_sp_at_entry
	SREG	s0, 0(t0)

	/*
	 * Copy .data from Load Memory Address (LMA) to Virtual Memory Address
	 * (VMA) if needed.
	 */
	call	__bcc_copy_data

	/* .data can be referenced only after return from __bcc_copy_data(). */

	call	__bcc_init60

#if 0
	call	__bcc_get_leon_info
#endif

	call	__bcc_con_init

	call	__bcc_timer_init

	call	__bcc_int_init

	la	a0, __libc_fini_array
	call	atexit

	call	__libc_init_array

	call    __bcc_init70

	la	t0, __bcc_argc
	lw	a0, 0(t0)
	la	t0, __bcc_argvp
	LREG	a1, 0(t0)
	/* In case someone tries to reach environment. */
	mv	a2, zero

	call    main

	call	exit

	ebreak
FUNC_END __bcc_crt0

	.section	.bss
	.global		__bcc_sp_at_entry
	.align		8
__bcc_sp_at_entry:
	.dword	0

