# Software examples for NOEL3

## Dhrystone
File: dhrystone.elf, Compiled for RV32IMA (GCC 13.2.0)
### Description
Standard benchmark run on a single hart in a 3-hart NOEL3 processor.

### GRMON
JTAG chain (1): xcku040 
  Device ID:           0x296
  GRLIB build version: 4299
  Detected system:     NOEL3 SOC
  Detected frequency:  50.0 MHz

  Component                            Vendor
  NOEL3 RISC-V Processor               Frontgrade Gaisler
  AHB Debug UART                       Frontgrade Gaisler
  JTAG Debug Link                      Frontgrade Gaisler
  AHB/APB Bridge                       Frontgrade Gaisler
  NOEL3 debug module                   Frontgrade Gaisler
  Generic UART                         Frontgrade Gaisler
  Modular Timer Unit                   Frontgrade Gaisler
  General Purpose I/O port             Frontgrade Gaisler

  Use command 'info sys' to print a detailed report of attached cores

grmon4> forward enable uart0 
  I/O forwarding to uart0 enabled

grmon4> load noel3/dhrystone.elf 
          80000000 .text             28.9kB /  28.9kB   [===============>] 100%
          40000000 .rodata            2.2kB /   2.2kB   [===============>] 100%
          400008e8 .srodata.cst8      184B              [===============>] 100%
          400009a0 .srodata.cst4       12B              [===============>] 100%
          400009ac .eh_frame           60B              [===============>] 100%
          400009e8 .data              1.5kB /   1.5kB   [===============>] 100%
          40001040 .tohost             72B              [===============>] 100%
  Total size: 32.95kB (560.07kbit/s)
  Entry point 0x80000000
  Image ./noel3/dhrystone.elf loaded

grmon4> run
Execution starts, 1000000 runs through Dhrystone
Total execution time:                       25.10 s
Microseconds for one run through Dhrystone: 25.0 
Dhrystones per Second:                      38941.0 

Dhrystones MIPS      :                      22.8

  CPU 0:  Forced into debug mode
          0x800003ac: 00100073  ebreak  <tohost_exit+32>
  CPU 1:  Forced into debug mode
          0x800000c4: 00b57063  bgeu    a0, a1, 0x800000c4
  CPU 2:  Forced into debug mode
          0x800000c4: 00b57063  bgeu    a0, a1, 0x800000c4

## Multi-hart demo
File: demo.elf, Compiled for RV32IMA (GCC 13.2.0)

#### Description
Demo application showcasing deterministic operations 
for a multi-hart NOEL3. A number of different test are run either on a single
hart or in parallel on 3 harts. The test are utilizing shared resources (FPU, 
DIV, deterministic bus) and show execution time (for each hart) being 
independent on work performed in other harts.

- FPU test: Simple FPU calculations 
- MUL/DIV test: Simple multiplication and division
- Deterministic bus access test: Performs read/write access to peripherals
  connected to the deterministic bus
- Counter test: Simple counter increments (separate counters for each hart)
- Sum array test: Summarize all items in an array, showing workload can be shared
  by multiple harts.
- Mixed test: Show different workload on different harts. Execution time for the
  workload on each is independent on the workload performed on other harts.

### GRMON
JTAG chain (1): xcku040 
  Device ID:           0x296
  GRLIB build version: 4299
  Detected system:     NOEL3 SOC
  Detected frequency:  50.0 MHz

  Component                            Vendor
  NOEL3 RISC-V Processor               Frontgrade Gaisler
  AHB Debug UART                       Frontgrade Gaisler
  JTAG Debug Link                      Frontgrade Gaisler
  AHB/APB Bridge                       Frontgrade Gaisler
  NOEL3 debug module                   Frontgrade Gaisler
  Generic UART                         Frontgrade Gaisler
  Modular Timer Unit                   Frontgrade Gaisler
  General Purpose I/O port             Frontgrade Gaisler

  Use command 'info sys' to print a detailed report of attached cores

grmon4> forward enable uart0 
  I/O forwarding to uart0 enabled

grmon4> load noel3/demo.elf 
          80000000 .text             14.8kB /  14.8kB   [===============>] 100%
          40000000 .rodata            1.7kB /   1.7kB   [===============>] 100%
          400006cc .eh_frame           60B              [===============>] 100%
          40000710 .data              2.3kB /   2.3kB   [===============>] 100%
          40001024 .got                16B              [===============>] 100%
          40001034 .got.plt             8B              [===============>] 100%
          40001040 .tohost             72B              [===============>] 100%
  Total size: 18.96kB (566.77kbit/s)
  Entry point 0x80000000
  Image ./noel3/demo.elf loaded

grmon4> run
=========================================
FPU test
=========================================
Hart[0]: run FPU test
Hart[1, 2]: idle
Execution time (cycles) Hart[0]: 332

Hart[0, 1, 2]: run FPU test
Execution time (cycles) Hart[0]: 332 Hart[1]: 332 Hart[2]: 332 

=========================================
MUL/DIV test
=========================================
Hart[0]: run MUL/DIV test
Hart[1, 2]: idle
Execution time (cycles) Hart[0]: 388

Hart[0, 1, 2]: run MUL/DIV test
Execution time (cycles) Hart[0]: 388 Hart[1]: 388 Hart[2]: 388 

=========================================
Deterministic bus access test
=========================================
Hart[0]: run Detbus test
Hart[1, 2]: idle
Execution time (cycles) Hart[0]: 640056

Hart[0, 1, 2]: run Detbus test
Execution time (cycles) Hart[0]: 640056 Hart[1]: 640056 Hart[2]: 640056 

=========================================
Counter test
=========================================
Hart[0]: run Counter test
Hart[1, 2]: idle
Execution time (cycles) Hart[0]: 720056

Hart[0, 1, 2]: run Counter test
Execution time (cycles) Hart[0]: 720056 Hart[1]: 720056 Hart[2]: 720056 

=========================================
Sum array test
=========================================
Sum array using one thread
Sum: 130305
Execution time (cycles): 39132

Sum array using three threads
Sum: 130305
Execution time (cycles): 13776

=========================================
Mixed test (FPU, MUL/DIV, Detbus)
=========================================
Hart[0]: run FPU test
Hart[1]: run MUL/DIV test
Hart[2]: run Detbus test
Execution time (cycles) Hart[0]: 332 Hart[1]: 388 Hart[2]: 640056 

=========================================
All test done
=========================================
  CPU 0:  Forced into debug mode
          0x80002050: 00100073  ebreak  <tohost_exit+60>
  CPU 1:  Forced into debug mode
          0x80000b88: 0000006f  j       0x80000b88  <main+728>
  CPU 2:  Forced into debug mode
          0x80000b88: 0000006f  j       0x80000b88  <main+728>




