/*
 * Copyright (c) 2016 embedded brains GmbH.  All rights reserved.
 *
 *  embedded brains GmbH
 *  Dornierstr. 4
 *  82178 Puchheim
 *  Germany
 *  <rtems@embedded-brains.de>
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution or at
 * http://www.rtems.org/license/LICENSE.
 */

#include <bsp.h>
#include <bsp/bootcard.h>
#include <bsp/irq.h>
#include <bsp/irq-generic.h>
#include <bsp/linker-symbols.h>

#include <chip.h>

RTEMS_STATIC_ASSERT(
  PERIPH_COUNT_IRQn <= BSP_INTERRUPT_VECTOR_MAX,
  PERIPH_COUNT_IRQn
);

void bsp_start(void)
{
  bsp_interrupt_initialize();
  SCB_CleanDCache();
  SCB_InvalidateICache();
  rtems_cache_coherent_add_area(
    bsp_section_nocacheheap_begin,
    (uintptr_t) bsp_section_nocacheheap_size
  );
}
