/* The header file is generated by make_header.py from PCR.json */
/* Current script's version can be found at: */
/* https://github.com/AoLaD/rtems-tms570-utils/tree/headers/headers/python */

/*
 * Copyright (c) 2014-2015, Premysl Houdek <kom541000@gmail.com>
 *
 * Czech Technical University in Prague
 * Zikova 1903/4
 * 166 36 Praha 6
 * Czech Republic
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the FreeBSD Project.
*/
#ifndef LIBBSP_ARM_TMS570_PCR
#define LIBBSP_ARM_TMS570_PCR

#include <bsp/utility.h>

typedef struct{
  uint32_t PMPROTSET0;        /*Peripheral Memory Protection Set Register 0*/
  uint32_t PMPROTSET1;        /*Peripheral Memory Protection Set Register 1*/
  uint8_t reserved1 [8];
  uint32_t PMPROTCLR0;        /*Peripheral Memory Protection Clear Register 0*/
  uint32_t PMPROTCLR1;        /*Peripheral Memory Protection Clear Register 1*/
  uint8_t reserved2 [8];
  uint32_t PPROTSET0;         /*Peripheral Protection Set Register 0*/
  uint32_t PPROTSET1;         /*Peripheral Protection Set Register 1*/
  uint32_t PPROTSET2;         /*Peripheral Protection Set Register 2*/
  uint32_t PPROTSET3;         /*Peripheral Protection Set Register 3*/
  uint8_t reserved3 [16];
  uint32_t PPROTCLR0;         /*Peripheral Protection Clear Register 0*/
  uint32_t PPROTCLR1;         /*Peripheral Protection Clear Register 1*/
  uint32_t PPROTCLR2;         /*Peripheral Protection Clear Register 2*/
  uint32_t PPROTCLR3;         /*Peripheral Protection Clear Register 3*/
  uint8_t reserved4 [16];
  uint32_t PCSPWRDWNSET0;     /*Peripheral Memory Power-Down Set Register 0*/
  uint32_t PCSPWRDWNSET1;     /*Peripheral Memory Power-Down Set Register 1*/
  uint8_t reserved5 [8];
  uint32_t PCSPWRDWNCLR0;     /*Peripheral Memory Power-Down Clear Register 0*/
  uint32_t PCSPWRDWNCLR1;     /*Peripheral Memory Power-Down Clear Register 1*/
  uint8_t reserved6 [8];
  uint32_t PSPWRDWNSET0;      /*Peripheral Power-Down Set Register 0*/
  uint32_t PSPWRDWNSET1;      /*Peripheral Power-Down Set Register 1*/
  uint32_t PSPWRDWNSET2;      /*Peripheral Power-Down Set Register 2*/
  uint32_t PSPWRDWNSET3;      /*Peripheral Power-Down Set Register 3*/
  uint8_t reserved7 [16];
  uint32_t PSPWRDWNCLR0;      /*Peripheral Power-Down Clear Register 0*/
  uint32_t PSPWRDWNCLR1;      /*Peripheral Power-Down Clear Register 1*/
  uint32_t PSPWRDWNCLR2;      /*Peripheral Power-Down Clear Register 2*/
  uint32_t PSPWRDWNCLR3;      /*Peripheral Power-Down Clear Register 3*/
} tms570_pcr_t;


/*-------------------TMS570_PCR_PMPROTSET0-------------------*/
/* field: PCSPROTSET - Peripheral memory frame protection set. */
/* Whole 32 bits */

/*-------------------TMS570_PCR_PMPROTSET1-------------------*/
/* field: PCSPROTSET - Peripheral memory frame protection set. */
/* Whole 32 bits */

/*-------------------TMS570_PCR_PMPROTCLR0-------------------*/
/* field: PCSPROTCLR - Peripheral memory frame protection clear. */
/* Whole 32 bits */

/*-------------------TMS570_PCR_PMPROTCLR1-------------------*/
/* field: PCSPROTCLR - Peripheral memory frame protection clear. */
/* Whole 32 bits */

/*--------------------TMS570_PCR_PPROTSETx--------------------*/
/* field: PROTSET - Peripheral select quadrant protection set. */
/* Whole 32 bits */

/*--------------------TMS570_PCR_PPROTCLRx--------------------*/
/* field: PROTCLR - Peripheral select quadrant protection clear. */
/* Whole 32 bits */

/*------------------TMS570_PCR_PCSPWRDWNSETx------------------*/
/* field: PWRDNSET - Peripheral memory clock power-down set. */
/* Whole 32 bits */

/*------------------TMS570_PCR_PCSPWRDWNCLRx------------------*/
/* field: PWRDNCLR - Peripheral memory clock power-down clear. */
/* Whole 32 bits */

/*------------------TMS570_PCR_PSPWRDWNSETx------------------*/
/* field: PWRDWNSET - Peripheral select quadrant clock power-down set. */
/* Whole 32 bits */

/*------------------TMS570_PCR_PSPWRDWNCLRx------------------*/
/* field: PWRDWNCLR - Peripheral select quadrant clock power-down clear. */
/* Whole 32 bits */


#endif /* LIBBSP_ARM_TMS570_PCR */
