/*
 *  This file is an extension of the generic console driver
 *  shell used by all console drivers using libchip, it contains
 *  the console_control routine,  This bsp needs its own version
 *  of this method to handle the keyboard and mouse as a single
 *  device.
 */

/*
 *  COPYRIGHT (c) 1989-2011.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#include <bsp.h>
#include <stdlib.h>
#include <assert.h>
#include <termios.h>
#include <rtems/libio.h>
#include <rtems/console.h>

#include <bsp/irq.h>

#include <rtems/termiostypes.h>
#include <libchip/serial.h>
#include <rtems/mouse_parser.h>
#if BSP_ENABLE_VGA
#include <rtems/keyboard.h>
#endif
#include "../../shared/dev/serial/legacy-console.h"

/*
 *  console_control
 *
 *  this routine uses the termios driver to process io
 */
rtems_device_driver console_control(
  rtems_device_major_number major,
  rtems_device_minor_number minor,
  void                    * arg
)
{
#if BSP_ENABLE_VGA
  if (minor == 0) {
    rtems_libio_ioctl_args_t *args = arg;

    switch (args->command) {
      default:
        if( vt_ioctl( args->command, (unsigned long)args->buffer ) != 0 )
          return rtems_termios_ioctl (arg);
        break;

      case MW_UID_REGISTER_DEVICE:
        printk( "SerialMouse: reg=%s\n", (const char*) args->buffer );
        register_kbd_msg_queue( args->buffer, 0 );
        break;

      case MW_UID_UNREGISTER_DEVICE:
        unregister_kbd_msg_queue( 0 );
        break;
    }

    args->ioctl_return = 0;
    return RTEMS_SUCCESSFUL;
  }
#endif
  return rtems_termios_ioctl (arg);
}
