/*********************************************************************
* Initialisation Code for ColdFire MCF5329 Processor                 *
**********************************************************************
 Generated by ColdFire Initialisation Utility 2.10.8
 Wed Jul 02 14:26:25 2008

 MicroAPL Ltd makes no warranties in respect of the suitability
 of this code for any particular purpose, and accepts
 no liability for any loss arising out of its use. The person or
 persons making use of this file must make the final evaluation
 as to its suitability and correctness for a particular application.

*/

/* External reference frequency is 16.0000 MHz
 Internal bus clock frequency = 80.00 MHz
 Processor core frequency = 240.00 MHz
*/

#include <bsp.h>

/* eDMA Transfer Control Descriptor definitions */
#define  MCF_EDMA_TCD_W0(channel)            (*(vuint32 *)(0xFC045000+((channel)*0x20)))        /* Transfer Control Descriptor Word 0 */
#define  MCF_EDMA_TCD_W1(channel)            (*(vuint32 *)(0xFC045004+((channel)*0x20)))        /* Transfer Control Descriptor Word 1 */
#define  MCF_EDMA_TCD_W2(channel)            (*(vuint32 *)(0xFC045008+((channel)*0x20)))        /* Transfer Control Descriptor Word 2 */
#define  MCF_EDMA_TCD_W3(channel)            (*(vuint32 *)(0xFC04500C+((channel)*0x20)))        /* Transfer Control Descriptor Word 3 */
#define  MCF_EDMA_TCD_W4(channel)            (*(vuint32 *)(0xFC045010+((channel)*0x20)))        /* Transfer Control Descriptor Word 4 */
#define  MCF_EDMA_TCD_W5(channel)            (*(vuint32 *)(0xFC045014+((channel)*0x20)))        /* Transfer Control Descriptor Word 5 */
#define  MCF_EDMA_TCD_W6(channel)            (*(vuint32 *)(0xFC045018+((channel)*0x20)))        /* Transfer Control Descriptor Word 6 */
#define  MCF_EDMA_TCD_W7(channel)            (*(vuint32 *)(0xFC04501C+((channel)*0x20)))        /* Transfer Control Descriptor Word 7 */

/* Function prototypes */
void init_main(void);
static void disable_interrupts(void);
static void disable_watchdog_timer(void);
static void disable_cache(void);
extern void init_clock_config(void) __attribute__ ((section(".ram_code")));
static void init_cache(void);
static void init_crossbar(void);
extern void init_chip_selects(void) __attribute__ ((section(".ram_code")));
static void init_eport(void);
static void init_flexcan(void);
static void init_dma_timers(void);
static void init_interrupt_timers(void);
static void init_real_time_clock(void);
static void init_watchdog_timers(void);
static void init_edma(void);
static void init_pin_assignments(void);
extern void init_sdram_controller(void)
  __attribute__ ((section(".ram_code")));
static void init_interrupt_controller(void);

/*********************************************************************
* init_main - Main entry point for initialisation code               *
**********************************************************************/
void init_main(void)
{
  init_clock_config();

  /* Disable interrupts, watchdog timer, cache */
  disable_interrupts();
  disable_watchdog_timer();
  disable_cache();

  /* Initialise individual modules */
  init_cache();
  init_crossbar();
  init_chip_selects();
  init_eport();
  init_flexcan();
  init_dma_timers();
  init_interrupt_timers();
  init_real_time_clock();
  init_watchdog_timers();
  init_edma();
  init_pin_assignments();

  /* Initialise SDRAM controller (must be done after pin assignments) */
  init_sdram_controller();

  /* Initialise interrupt controller */
  init_interrupt_controller();
}

/*********************************************************************
* disable_interrupts - Disable all interrupt sources                 *
**********************************************************************/
static void disable_interrupts(void)
{
  vuint8 *p;
  int i;

  /* Set ICR001-ICR063 to 0x0 */
  p = (vuint8 *) & MCF_INTC0_ICR1;
  for (i = 1; i <= 63; i++)
    *p++ = 0x0;

  /* Set ICR100-ICR163 to 0x0 */
  p = (vuint8 *) & MCF_INTC1_ICR0;
  for (i = 100; i <= 163; i++)
    *p++ = 0x0;
}

/*********************************************************************
* disable_watchdog_timer - Disable system watchdog timer             *
**********************************************************************/
static void disable_watchdog_timer(void)
{
  /* Disable Core Watchdog Timer */
  MCF_SCM_CWCR = 0;
}

/*********************************************************************
* disable_cache - Disable and invalidate cache                       *
**********************************************************************/
static void disable_cache(void)
{
  __asm__ ("move.l   #0x01000000,%d0");
  __asm__ ("movec    %d0,%CACR");
}

/*********************************************************************
* init_clock_config - Clock Module                                   *
**********************************************************************/
void init_clock_config(void)
{
  /* Clock module uses normal PLL mode with 16.0000 MHz external reference
     Bus clock frequency = 80.00 MHz
     Processor clock frequency = 3 x bus clock = 240.00 MHz
     Dithering disabled
   */

  /* Check to see if the SDRAM has already been initialized
     by a run control tool. If it has, put SDRAM into self-refresh mode before
     initializing the PLL
   */
  if (MCF_SDRAMC_SDCR & MCF_SDRAMC_SDCR_REF)
    MCF_SDRAMC_SDCR &= ~MCF_SDRAMC_SDCR_CKE;

  /* Temporarily switch to LIMP mode
     NOTE: Ensure that this code is not executing from SDRAM, since the
     SDRAM Controller is disabled in LIMP mode
   */
  MCF_CCM_CDR = (MCF_CCM_CDR & 0xf0ff) | MCF_CCM_CDR_LPDIV(0x2);
  MCF_CCM_MISCCR |= MCF_CCM_MISCCR_LIMP;

  /* Configure the PLL settings */
  MCF_PLL_PODR = MCF_PLL_PODR_CPUDIV(0x2) | MCF_PLL_PODR_BUSDIV(0x6);
  MCF_PLL_PFDR = MCF_PLL_PFDR_MFD(0x78);
  MCF_PLL_PLLCR = 0;
  MCF_PLL_PMDR = 0;

  /* Enable PLL and wait for lock */
  MCF_CCM_MISCCR &= ~MCF_CCM_MISCCR_LIMP;
  while ((MCF_CCM_MISCCR & MCF_CCM_MISCCR_PLL_LOCK) == 0) ;

  /* From the Device Errata:

     "After exiting LIMP mode, the value of 0x40000000 should be written
     to address 0xFC0B8080 before attempting to initialize the SDRAMC
     or exit the SDRAM from self-refresh mode."
   */
  *(vuint32 *) 0xfc0b8080 = 0x40000000;

  /* If we put the SDRAM into self-refresh mode earlier, restore mode now */
  if (MCF_SDRAMC_SDCR & MCF_SDRAMC_SDCR_REF)
    MCF_SDRAMC_SDCR |= MCF_SDRAMC_SDCR_CKE;
}

/*********************************************************************
* init_cache - Unified (Instruction and Data) Cache                  *
**********************************************************************/
static void init_cache(void)
{
  /* ACR0: Cache accesses to 32 MB memory region at address $40000000
     CACR: Don't cache accesses to the rest of memory
   */
  /*
   * Cache is enabled in bspstart.c
   */
#if 0
  __asm__ ("move.l   #0xa0000600,%d0");
  __asm__ ("movec    %d0,%CACR");
#endif
  __asm__ ("move.l   #0x4001c020,%d0");
  __asm__ ("movec    %d0,%ACR0");
  __asm__ ("move.l   #0x00000000,%d0");
  __asm__ ("movec    %d0,%ACR1");
}

/*********************************************************************
* init_crossbar - Cross-Bar Switch (XBS) Module                      *
**********************************************************************/
static void init_crossbar(void)
{
  /* XBS settings for FlexBus/SDRAM Controller slave:
     Fixed priority (Core, LCD, eDMA, FEC, USB Host, USB OTG), park on ColdFire Core
   */
  MCF_XBS_PRS1 = MCF_XBS_PRS_M6(0x5) |
    MCF_XBS_PRS_M5(0x4) |
    MCF_XBS_PRS_M4(0x1) | MCF_XBS_PRS_M2(0x3) | MCF_XBS_PRS_M1(0x2);
  MCF_XBS_CRS1 = 0;

  /* XBS settings for SRAM Backdoor slave:
     Fixed priority (Core, eDMA, FEC, LCD, USB Host, USB OTG), park on ColdFire Core
   */
  MCF_XBS_PRS4 = MCF_XBS_PRS_M6(0x5) |
    MCF_XBS_PRS_M5(0x4) |
    MCF_XBS_PRS_M4(0x3) | MCF_XBS_PRS_M2(0x2) | MCF_XBS_PRS_M1(0x1);
  MCF_XBS_CRS4 = 0;

  /* XBS settings for Cryptography Modules slave:
     Fixed priority (Core, eDMA, FEC, LCD, USB Host, USB OTG), park on ColdFire Core
   */
  MCF_XBS_PRS6 = MCF_XBS_PRS_M6(0x5) |
    MCF_XBS_PRS_M5(0x4) |
    MCF_XBS_PRS_M4(0x3) | MCF_XBS_PRS_M2(0x2) | MCF_XBS_PRS_M1(0x1);
  MCF_XBS_CRS6 = 0;

  /* XBS settings for On-chip Peripherals slave:
     Fixed priority (Core, eDMA, FEC, LCD, USB Host, USB OTG), park on ColdFire Core
   */
  MCF_XBS_PRS7 = MCF_XBS_PRS_M6(0x5) |
    MCF_XBS_PRS_M5(0x4) |
    MCF_XBS_PRS_M4(0x3) | MCF_XBS_PRS_M2(0x2) | MCF_XBS_PRS_M1(0x1);
  MCF_XBS_CRS7 = 0;
}

/*********************************************************************
* init_chip_selects - Chip Select Module (FlexBus)                   *
**********************************************************************/
void init_chip_selects(void)
{
  /* Chip Select 1 disabled (CSMR1[V] = 0) */
  MCF_FBCS1_CSMR = 0;

  /* Chip Select 2 disabled (CSMR2[V] = 0) */
  MCF_FBCS2_CSMR = 0;

  /* Chip Select 3 disabled (CSMR3[V] = 0) */
  MCF_FBCS3_CSMR = 0;

  /* Chip Select 4 disabled (CSMR4[V] = 0) */
  MCF_FBCS4_CSMR = 0;

  /* Chip Select 5 disabled (CSMR5[V] = 0) */
  MCF_FBCS5_CSMR = 0;

  /* Chip Select 0: 2 MB of Flash at base address $00000000
     Port size = 16 bits
     Assert chip select on first rising clock edge after address is asserted
     Generate internal transfer acknowledge after 7 wait states
     Address is held for 1 clock at end of read and write cycles
   */
  MCF_FBCS0_CSAR = 0;
  MCF_FBCS0_CSCR = MCF_FBCS_CSCR_WS(0x7) |
    (0x1 << 9) | MCF_FBCS_CSCR_AA | MCF_FBCS_CSCR_PS(0x2) | MCF_FBCS_CSCR_BEM;
  MCF_FBCS0_CSMR = MCF_FBCS_CSMR_BAM(0x1f) | MCF_FBCS_CSMR_V;
}

/*********************************************************************
* init_eport - Edge Port Module (EPORT)                              *
**********************************************************************/
static void init_eport(void)
{
  /* Pins 1-7 configured as GPIO inputs */
  MCF_EPORT_EPPAR = 0;
  MCF_EPORT_EPDDR = 0;
  MCF_EPORT_EPIER = 0;
}

/*********************************************************************
* init_flexcan - FlexCAN Module                                      *
**********************************************************************/
static void init_flexcan(void)
{
  /* FlexCAN controller disabled (CANMCR0[MDIS]=1) */
  MCF_CAN_IMASK = 0;
  MCF_CAN_RXGMASK = MCF_CAN_RXGMASK_MI(0x1fffffff);
  MCF_CAN_RX14MASK = MCF_CAN_RX14MASK_MI(0x1fffffff);
  MCF_CAN_RX15MASK = MCF_CAN_RX15MASK_MI(0x1fffffff);
  MCF_CAN_CANCTRL = 0;
  MCF_CAN_CANMCR = MCF_CAN_CANMCR_MDIS |
    MCF_CAN_CANMCR_FRZ |
    MCF_CAN_CANMCR_HALT | MCF_CAN_CANMCR_SUPV | MCF_CAN_CANMCR_MAXMB(0xf);
}

/*********************************************************************
* init_sdram_controller - SDRAM Controller                           *
**********************************************************************/
void init_sdram_controller(void)
{
  /* Check to see if the SDRAM has already been initialized
     by a run control tool and skip if so
   */
  if (MCF_SDRAMC_SDCR & MCF_SDRAMC_SDCR_REF)
    return;

  /* Ensure that there is a delay from processor reset of the time recommended in
     the SDRAM data sheet (typically 100-200 microseconds) until the following
     code so that the SDRAM is ready for commands...
   */

  /* SDRAM controller configured for Double-data rate (DDR) SDRAM
     Bus width = 16 bits
     SDRAM specification:
     SDRAM clock frequency = 80.00 MHz
     CASL = 2.5
     ACTV-to-read/write delay, tRCD = 20.0 nanoseconds
     Write recovery time, tWR = 15.0 nanoseconds
     Precharge comand to ACTV command, tRP = 20.0 nanoseconds
     Auto refresh command period, tRFC = 75.0 nanoseconds
     Average periodic refresh interval, tREFI = 7.8 microseconds
   */

  /* Memory block 0 enabled - 32 MBytes at address $40000000
     Block consists of 1 device x 256 MBits (13 rows x 9 columns x 4 banks)
   */
  MCF_SDRAMC_SDCS0 = MCF_SDRAMC_SDCS_BASE(0x400) | MCF_SDRAMC_SDCS_CSSZ(0x18);

  /* Memory block 1 disabled */
  MCF_SDRAMC_SDCS1 = 0;

  /* Initialise SDCFG1 register with delay and timing values
     SRD2RWP = 4, SWT2RWP = 3, RD_LAT = 7, ACT2RW = 2
     PRE2ACT = 2, REF2ACT = 6, WT_LAT = 3
   */
  MCF_SDRAMC_SDCFG1 = MCF_SDRAMC_SDCFG1_SRD2RW(0x4) |
    MCF_SDRAMC_SDCFG1_SWT2RD(0x3) |
    MCF_SDRAMC_SDCFG1_RDLAT(0x7) |
    MCF_SDRAMC_SDCFG1_ACT2RW(0x2) |
    MCF_SDRAMC_SDCFG1_PRE2ACT(0x2) |
    MCF_SDRAMC_SDCFG1_REF2ACT(0x6) | MCF_SDRAMC_SDCFG1_WTLAT(0x3);

  /* Initialise SDCFG2 register with delay and timing values
     BRD2RP = 5, BWT2RWP = 6, BRD2W = 6, BL = 7
   */
  MCF_SDRAMC_SDCFG2 = MCF_SDRAMC_SDCFG2_BRD2PRE(0x5) |
    MCF_SDRAMC_SDCFG2_BWT2RW(0x6) |
    MCF_SDRAMC_SDCFG2_BRD2WT(0x6) | MCF_SDRAMC_SDCFG2_BL(0x7);

  /* Issue a Precharge All command */
  MCF_SDRAMC_SDCR = MCF_SDRAMC_SDCR_MODE_EN |
    MCF_SDRAMC_SDCR_CKE |
    MCF_SDRAMC_SDCR_DDR |
    MCF_SDRAMC_SDCR_MUX(0x1) |
    MCF_SDRAMC_SDCR_RCNT(0x8) | MCF_SDRAMC_SDCR_PS_16 | MCF_SDRAMC_SDCR_IPALL;

  /* Write Extended Mode Register */
  MCF_SDRAMC_SDMR = MCF_SDRAMC_SDMR_BNKAD_LEMR | MCF_SDRAMC_SDMR_CMD;

  /* Write Mode Register and Reset DLL */
  MCF_SDRAMC_SDMR = MCF_SDRAMC_SDMR_BNKAD_LMR |
    MCF_SDRAMC_SDMR_AD(0x163) | MCF_SDRAMC_SDMR_CMD;

  /* Insert code here to pause for DLL lock time specified by memory... */

  /* Issue a second Precharge All command */
  MCF_SDRAMC_SDCR |= MCF_SDRAMC_SDCR_IPALL;

  /* Refresh sequence...
     (check the number of refreshes required by the SDRAM manufacturer)
   */
  MCF_SDRAMC_SDCR |= MCF_SDRAMC_SDCR_IREF;
  MCF_SDRAMC_SDCR |= MCF_SDRAMC_SDCR_IREF;

  /* Write Mode Register and clear the Reset DLL bit */
  MCF_SDRAMC_SDMR = MCF_SDRAMC_SDMR_BNKAD_LMR |
    MCF_SDRAMC_SDMR_AD(0x63) | MCF_SDRAMC_SDMR_CMD;

  /* Enable automatic refresh and lock SDMR */
  MCF_SDRAMC_SDCR &= ~MCF_SDRAMC_SDCR_MODE_EN;
  MCF_SDRAMC_SDCR |= MCF_SDRAMC_SDCR_REF |
    MCF_SDRAMC_SDCR_DQS_OE(0x8) | MCF_SDRAMC_SDCR_DQS_OE(0x4);

}

/*********************************************************************
* init_dma_timers - DMA Timers                                       *
**********************************************************************/
static void init_dma_timers(void)
{
  /* DMA Timer 0 disabled (DTMR0[RST] = 0) */
  MCF_DTIM0_DTMR = 0;
  MCF_DTIM0_DTXMR = 0;
  MCF_DTIM0_DTRR = MCF_DTIM_DTRR_REF(0xffffffff);

  /* DMA Timer 1 disabled (DTMR1[RST] = 0) */
  MCF_DTIM1_DTMR = 0;
  MCF_DTIM1_DTXMR = 0;
  MCF_DTIM1_DTRR = MCF_DTIM_DTRR_REF(0xffffffff);

  /* DMA Timer 2 disabled (DTMR2[RST] = 0) */
  MCF_DTIM2_DTMR = 0;
  MCF_DTIM2_DTXMR = 0;
  MCF_DTIM2_DTRR = MCF_DTIM_DTRR_REF(0xffffffff);

  /* DMA Timer 3 disabled (DTMR3[RST] = 0) */
  MCF_DTIM3_DTMR = 0;
  MCF_DTIM3_DTXMR = 0;
  MCF_DTIM3_DTRR = MCF_DTIM_DTRR_REF(0xffffffff);
}

/*********************************************************************
* init_interrupt_timers - Programmable Interrupt Timers (PIT)        *
**********************************************************************/
static void init_interrupt_timers(void)
{
  /* PIT0 disabled (PCSR0[EN]=0) */
  MCF_PIT0_PCSR = 0;

  /* PIT1 disabled (PCSR1[EN]=0) */
  MCF_PIT1_PCSR = 0;

  /* PIT2 disabled (PCSR2[EN]=0) */
  MCF_PIT2_PCSR = 0;

  /* PIT3 disabled (PCSR3[EN]=0) */
  MCF_PIT3_PCSR = 0;
}

/*********************************************************************
* init_real_time_clock - Real-Time Clock (RTC)                       *
**********************************************************************/
static void init_real_time_clock(void)
{
  /* Disable the RTC */
  MCF_RTC_CR = 0;
}

/*********************************************************************
* init_watchdog_timers - Watchdog Timers                             *
**********************************************************************/
static void init_watchdog_timers(void)
{
  /* Watchdog Timer disabled (WCR[EN]=0)
     NOTE: WCR and WMR cannot be written again until after the
     processor is reset.
   */
  MCF_WTM_WCR = MCF_WTM_WCR_WAIT | MCF_WTM_WCR_DOZE | MCF_WTM_WCR_HALTED;
  MCF_WTM_WMR = MCF_WTM_WMR_WM(0xffff);

  /* Core watchdog timer disabled */
  MCF_SCM_CWCR = MCF_SCM_CWCR_CWT(0x8);
}

/*********************************************************************
* init_edma - eDMA Controller                                        *
**********************************************************************/
static void init_edma(void)
{
  /* Associate eDMA channels 9-12 with SSI signals */
  MCF_CCM_MISCCR &= ~MCF_CCM_MISCCR_TIM_DMA;

  /* Configured for round-robin arbitration mode */
  MCF_EDMA_CR = MCF_EDMA_CR_ERCA;

  /* All error interrupts are disabled */
  MCF_EDMA_EEI = 0;

  /* All DMA requests from peripherals are masked */
  MCF_EDMA_ERQ = 0;
}

/*********************************************************************
* init_interrupt_controller - Interrupt Controller                   *
**********************************************************************/
static void init_interrupt_controller(void)
{
  /* No interrupt sources configured */
  MCF_INTC1_ICR0 = 0;
  MCF_INTC1_ICR1 = 0;
  MCF_INTC1_ICR3 = 0;
  MCF_INTC1_ICR4 = 0;
  MCF_INTC1_ICR5 = 0;
  MCF_INTC1_ICR6 = 0;
  MCF_INTC1_ICR7 = 0;
  MCF_INTC1_ICR8 = 0;
  MCF_INTC1_ICR9 = 0;
  MCF_INTC1_ICR10 = 0;
  MCF_INTC1_ICR11 = 0;
  MCF_INTC1_ICR12 = 0;
  MCF_INTC1_ICR13 = 0;
  MCF_INTC1_ICR14 = 0;
  MCF_INTC1_ICR15 = 0;
  MCF_INTC1_ICR16 = 0;
  MCF_INTC1_ICR17 = 0;
  MCF_INTC1_ICR18 = 0;
  MCF_INTC1_ICR19 = 0;
  MCF_INTC1_ICR40 = 0;
  MCF_INTC1_ICR41 = 0;
  MCF_INTC1_ICR42 = 0;
  MCF_INTC1_ICR43 = 0;
  MCF_INTC1_ICR44 = 0;
  MCF_INTC1_ICR45 = 0;
  MCF_INTC1_ICR46 = 0;
  MCF_INTC1_ICR47 = 0;
  MCF_INTC1_ICR48 = 0;
  MCF_INTC1_ICR49 = 0;
  MCF_INTC1_ICR50 = 0;
  MCF_INTC1_ICR51 = 0;
  MCF_INTC1_ICR52 = 0;
  MCF_INTC1_ICR53 = 0;
  MCF_INTC0_ICR1 = 0;
  MCF_INTC0_ICR2 = 0;
  MCF_INTC0_ICR3 = 0;
  MCF_INTC0_ICR4 = 0;
  MCF_INTC0_ICR5 = 0;
  MCF_INTC0_ICR6 = 0;
  MCF_INTC0_ICR7 = 0;
  MCF_INTC0_ICR8 = 0;
  MCF_INTC0_ICR9 = 0;
  MCF_INTC0_ICR10 = 0;
  MCF_INTC0_ICR11 = 0;
  MCF_INTC0_ICR12 = 0;
  MCF_INTC0_ICR13 = 0;
  MCF_INTC0_ICR14 = 0;
  MCF_INTC0_ICR15 = 0;
  MCF_INTC0_ICR16 = 0;
  MCF_INTC0_ICR17 = 0;
  MCF_INTC0_ICR18 = 0;
  MCF_INTC0_ICR19 = 0;
  MCF_INTC0_ICR20 = 0;
  MCF_INTC0_ICR21 = 0;
  MCF_INTC0_ICR22 = 0;
  MCF_INTC0_ICR23 = 0;
  MCF_INTC0_ICR24 = 0;
  MCF_INTC0_ICR25 = 0;
  MCF_INTC0_ICR26 = 0;
  MCF_INTC0_ICR27 = 0;
  MCF_INTC0_ICR28 = 0;
  MCF_INTC0_ICR30 = 0;
  MCF_INTC0_ICR31 = 0;
  MCF_INTC0_ICR32 = 0;
  MCF_INTC0_ICR33 = 0;
  MCF_INTC0_ICR34 = 0;
  MCF_INTC0_ICR35 = 0;
  MCF_INTC0_ICR36 = 0;
  MCF_INTC0_ICR37 = 0;
  MCF_INTC0_ICR38 = 0;
  MCF_INTC0_ICR39 = 0;
  MCF_INTC0_ICR40 = 0;
  MCF_INTC0_ICR41 = 0;
  MCF_INTC0_ICR42 = 0;
  MCF_INTC0_ICR43 = 0;
  MCF_INTC0_ICR44 = 0;
  MCF_INTC0_ICR45 = 0;
  MCF_INTC0_ICR46 = 0;
  MCF_INTC0_ICR47 = 0;
  MCF_INTC0_ICR48 = 0;
  MCF_INTC0_ICR62 = 0;
  MCF_INTC0_IMRH = 0xffffffff;
  MCF_INTC0_IMRL = 0xffffffff;
  MCF_INTC1_IMRH = 0xffffffff;
  MCF_INTC1_IMRL = 0xffffffff;
}

/*********************************************************************
* init_pin_assignments - Pin Assignment and General Purpose I/O      *
**********************************************************************/
static void init_pin_assignments(void)
{
  /* Pin assignments for port BUSCTL
     Pin BUSCTL3 : External bus output enable, /OE
     Pin BUSCTL2 : External bus transfer acknowledge, /TA
     Pin BUSCTL1 : External bus read/write, R/W
     Pin BUSCTL0 : External bus transfer start, /TS
   */
  MCF_GPIO_PDDR_BUSCTL = 0;
  MCF_GPIO_PAR_BUSCTL = MCF_GPIO_PAR_BUSCTL_PAR_OE |
    MCF_GPIO_PAR_BUSCTL_PAR_TA |
    MCF_GPIO_PAR_BUSCTL_PAR_RWB | MCF_GPIO_PAR_BUSCTL_PAR_TS(0x3);

  /* Pin assignments for port BE
     Pin BE3 : External bus byte enable BW/BWE3
     Pin BE2 : External bus byte enable BW/BWE2
     Pin BE1 : External bus byte enable BW/BWE1
     Pin BE0 : External bus byte enable BW/BWE0
   */
  MCF_GPIO_PDDR_BE = 0;
  MCF_GPIO_PAR_BE = MCF_GPIO_PAR_BE_PAR_BE3 |
    MCF_GPIO_PAR_BE_PAR_BE2 |
    MCF_GPIO_PAR_BE_PAR_BE1 | MCF_GPIO_PAR_BE_PAR_BE0;

  /* Pin assignments for port CS
     Pin CS5 : Flex bus chip select /FB_CS5
     Pin CS4 : Flex bus chip select /FB_CS4
     Pin CS3 : Flex bus chip select /FB_CS3
     Pin CS2 : Flex bus chip select /FB_CS2
     Pin CS1 : Flex bus chip select /FB_CS1
   */
  MCF_GPIO_PDDR_CS = 0;
  MCF_GPIO_PAR_CS = MCF_GPIO_PAR_CS_PAR_CS5 |
    MCF_GPIO_PAR_CS_PAR_CS4 |
    MCF_GPIO_PAR_CS_PAR_CS3 |
    MCF_GPIO_PAR_CS_PAR_CS2 | MCF_GPIO_PAR_CS_PAR_CS1;

  /* Pin assignments for port FECI2C
     Pin FECI2C3 : FEC management data clock, FEC_MDC
     Pin FECI2C2 : FEC management data, FEC_MDIO
     Pin FECI2C1 : GPIO input
     Pin FECI2C0 : GPIO input
   */
  MCF_GPIO_PDDR_FECI2C = 0;
  MCF_GPIO_PAR_FECI2C = MCF_GPIO_PAR_FECI2C_PAR_MDC(0x3) |
    MCF_GPIO_PAR_FECI2C_PAR_MDIO(0x3);

  /* Pin assignments for ports FECH and FECL
     Pin FECH7 : FEC transmit clock, FEC_TXCLK
     Pin FECH6 : FEC transmit enable, FEC_TXEN
     Pin FECH5 : FEC transmit data 0, FEC_TXD0
     Pin FECH4 : FEC collision, FEC_COL
     Pin FECH3 : FEC receive clock, FEC_RXCLK
     Pin FECH2 : FEC receive data valid, FEC_RXDV
     Pin FECH1 : FEC receive data 0, FEC_RXD0
     Pin FECH0 : FEC carrier receive sense, FEC_CRS
     Pin FECL7 : FEC transmit data 3, FEC_TXD3
     Pin FECL6 : FEC transmit data 2, FEC_TXD2
     Pin FECL5 : FEC transmit data 1, FEC_TXD1
     Pin FECL4 : FEC transmit error, FEC_TXER
     Pin FECL3 : FEC receive data 3, FEX_RXD3
     Pin FECL2 : FEC receive data 2, FEX_RXD2
     Pin FECL1 : FEC receive data 1, FEX_RXD1
     Pin FECL0 : FEC receive error, FEC_RXER
   */
  MCF_GPIO_PDDR_FECH = 0;
  MCF_GPIO_PDDR_FECL = 0;
  MCF_GPIO_PAR_FEC = MCF_GPIO_PAR_FEC_PAR_FEC_7W(0x3) |
    MCF_GPIO_PAR_FEC_PAR_FEC_MII(0x3);

  /* Pin assignments for port IRQ
     Pins are all used for EdgePort GPIO/IRQ
   */
  MCF_GPIO_PAR_IRQ = 0;

  /* Pin assignments for port LCDDATAH
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_LCDDATAH = 0;
  MCF_GPIO_PAR_LCDDATA = 0;

  /* Pin assignments for port LCDDATAM
     Port LCDDATAM pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_LCDDATAM = 0;

  /* Pin assignments for port LCDDATAL
     Port LCDDATAL pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_LCDDATAL = 0;

  /* Pin assignments for port LCDCTLH
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_LCDCTLH = 0;
  MCF_GPIO_PAR_LCDCTL = 0;

  /* Pin assignments for port LCDCTLL
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_LCDCTLL = 0;

  /* Pin assignments for port PWM
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_PWM = 0;
  MCF_GPIO_PAR_PWM = 0;

  /* Pin assignments for port QSPI
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_QSPI = 0;
  MCF_GPIO_PAR_QSPI = 0;

  /* Pin assignments for port SSI
     Pins are all GPIO inputs
   */
  MCF_GPIO_PDDR_SSI = 0;
  MCF_GPIO_PAR_SSI = 0;

  /* Pin assignments for port TIMER
     Pins are all GPIO outputs
   */
  MCF_GPIO_PDDR_TIMER = MCF_GPIO_PDDR_TIMER_PDDR_TIMER3 |
    MCF_GPIO_PDDR_TIMER_PDDR_TIMER2 |
    MCF_GPIO_PDDR_TIMER_PDDR_TIMER1 | MCF_GPIO_PDDR_TIMER_PDDR_TIMER0;
  MCF_GPIO_PAR_TIMER = 0;

  /* Pin assignments for port UART
     Pin UART7 : UART 1 clear-to-send, /U1CTS
     Pin UART6 : UART 1 request-to-send, /U1RTS
     Pin UART5 : UART 1 transmit data, U1TXD
     Pin UART4 : UART 1 receive data, U1RXD
     Pin UART3 : UART 0 clear-to-send, /U0CTS
     Pin UART2 : UART 0 request-to-send, /U0RTS
     Pin UART1 : UART 0 transmit data, U0TXD
     Pin UART0 : UART 0 receive data, U0RXD
   */
  MCF_GPIO_PDDR_UART = 0;
  MCF_GPIO_PAR_UART = MCF_GPIO_PAR_UART_PAR_UCTS1(0x3) |
    MCF_GPIO_PAR_UART_PAR_URTS1(0x3) |
    MCF_GPIO_PAR_UART_PAR_URXD1(0x3) |
    MCF_GPIO_PAR_UART_PAR_UTXD1(0x3) |
    MCF_GPIO_PAR_UART_PAR_UCTS0 |
    MCF_GPIO_PAR_UART_PAR_URTS0 |
    MCF_GPIO_PAR_UART_PAR_URXD0 | MCF_GPIO_PAR_UART_PAR_UTXD0;
}
