/*
 *  This set of routines are the BSP specific initialization
 *  support routines.
 *
 *  COPYRIGHT (c) 1989-2020.
 *  On-Line Applications Research Corporation (OAR),
 *  Cobham Gaisler AB.
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#include <bsp.h>
#include <bsp/bootcard.h>

#include <rtems/sysinit.h>

/*
 *  These are provided by the linkcmds for ALL of the BSPs which use this file.
 */
extern char WorkAreaBase[];
extern char RamEnd[];

/* Set by BSP early start code. */
extern uintptr_t bsp_sp_at_entry;

static Memory_Area _Memory_Areas[ 1 ];

static void bsp_memory_initialize( void )
{
  char *end;

  /* top of RAM inidicated by initial stack pointer */
  end = (char *) bsp_sp_at_entry;
  if (end == 0) {
    /* fall back to linker symbol if not set */
    end = RamEnd;
  }
  _Memory_Initialize( &_Memory_Areas[ 0 ], WorkAreaBase, end );
}

RTEMS_SYSINIT_ITEM(
  bsp_memory_initialize,
  RTEMS_SYSINIT_MEMORY,
  RTEMS_SYSINIT_ORDER_MIDDLE
);

static const Memory_Information _Memory_Information =
  MEMORY_INFORMATION_INITIALIZER( _Memory_Areas );

const Memory_Information *_Memory_Get( void )
{
  return &_Memory_Information;
}
