/**
 *  @file
 *
 *  @brief Get the Date and Time
 *  @ingroup libcsupport
 */

/*
 *  COPYRIGHT (c) 1989-2007.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if defined(RTEMS_NEWLIB)
/*
 *  Needed to get the prototype for the newlib helper method
 */
#define _COMPILING_NEWLIB

#include <sys/time.h>
#include <reent.h>
#include <errno.h>
#include <rtems/score/todimpl.h>
#include <rtems/seterr.h>

#if defined(RTEMS_NEWLIB) && !defined(HAVE_GETTIMEOFDAY)

/** 
 *  SVR4 and BSD4.3 extension required by Newlib
 * 
 *  @note The solaris gettimeofday does not have a second parameter.
 */
int gettimeofday(
  struct timeval *__restrict tp,
  void *__restrict __tz RTEMS_UNUSED
)
{
  /* struct timezone* tzp = (struct timezone*) __tz; */
  if ( !tp )
    rtems_set_errno_and_return_minus_one( EFAULT );

  /*
   *  POSIX does not seem to allow for not having a TOD so we just
   *  grab the time of day.
   */
  _TOD_Get_timeval( tp );

  /*
   *  Timezone information ignored by the OS proper.   Per email
   *  with Eric Norum, this is how GNU/Linux, Solaris, and MacOS X
   *  do it.  This puts us in good company.
   */

  return 0;
}
#endif

#if defined(RTEMS_NEWLIB) && !defined(HAVE__GETTIMEOFDAY_R)

#include <sys/reent.h>

/**
 *  "Reentrant" version
 */
int _gettimeofday_r(
  struct _reent   *ignored_reentrancy_stuff RTEMS_UNUSED,
  struct timeval  *tp,
  void           *__tz
)
{
  struct timezone *tzp = __tz;
  return gettimeofday( tp, tzp );
}
#endif

#endif /* defined(RTEMS_NEWLIB) */
