/**
 * @file
 *
 * @ingroup libfs
 *
 * @brief RTEMS Default Filesystem - Default Ftruncate Directory
 */

/*
 * Copyright (c) 2012 embedded brains GmbH.  All rights reserved.
 *
 *  embedded brains GmbH
 *  Obere Lagerstr. 30
 *  82178 Puchheim
 *  Germany
 *  <rtems@embedded-brains.de>
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution or at
 * http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rtems/libio_.h>
#include <rtems/seterr.h>

int rtems_filesystem_default_ftruncate_directory(
  rtems_libio_t *iop,
  off_t length
)
{
  rtems_set_errno_and_return_minus_one( EISDIR );
}
