/**
 * @file
 *
 * @ingroup POSIXAPI
 *
 * @brief Function Returns Clock ID of CPU-time Clock of process specified 
 */

/*
 *  COPYRIGHT (c) 1989-2007.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>
#include <errno.h>

#include <rtems/score/isr.h>
#include <rtems/score/thread.h>

#include <rtems/seterr.h>

/*
 *  20.1.3 Accessing a Process CPU-time CLock, P1003.4b/D8, p. 55
 */

int clock_getcpuclockid(
  pid_t      pid,
  clockid_t *clock_id
)
{
  rtems_set_errno_and_return_minus_one( ENOSYS );
}
