/**
 * @file
 *
 * @ingroup POSIXAPI
 *
 * @brief Manipulate Signal Sets
 */

/*
 *  COPYRIGHT (c) 1989-1999.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.org/license/LICENSE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <errno.h>

#include <rtems/posix/sigset.h>
#include <rtems/seterr.h>

int sigismember(
  const sigset_t   *set,
  int               signo
)
{
  if ( !set )
    rtems_set_errno_and_return_minus_one( EINVAL );

  if ( !signo )
    return 0;

  if ( !is_valid_signo(signo) )
    rtems_set_errno_and_return_minus_one( EINVAL );

  if ( *set & signo_to_mask(signo) )
    return 1;

  return 0;
}
