#!/usr/bin/env bash

set -o errexit
set -o nounset

THE_DIRNAME=rtems-noel-1.0.4
THE_KERNPREFIX=/opt/$THE_DIRNAME/kernel

HERE=$PWD
BASE=$HERE
KERNSRC=${1-"$HERE/.."}

echo HERE=$HERE
echo BASE=$BASE
echo KERNSRC=$KERNSRC

THE_NCPU=`getconf _NPROCESSORS_ONLN 2>/dev/null || sysctl -n hw.ncpu`

riscv-rtems5-gcc --version

# Before you can build a Board Support Package (BSP) for your target
# hardware, you have to bootstrap the build system in the RTEMS sources. This
# is only necessary, if you use a Git repository clone of the RTEMS sources.
pushd $KERNSRC
# ./bootstrap -c
# ./bootstrap
popd


# We configure, build and install the BSP in four steps. The first step is to
# create a build directory. It must be separate from the RTEMS source
# directory.
export RISCV_CONSOLE_MAX_NS16550_DEVICES=0
export RISCV_ENABLE_HTIF_SUPPORT=1

mkdir -p $BASE/build-up
pushd $BASE/build-up
 $KERNSRC/configure \
        --prefix=$THE_KERNPREFIX \
        --target=riscv-rtems5 \
        --enable-networking \
        --enable-tests \
        --enable-posix=yes \
        --enable-rtemsbsp="\
                noel32i \
                noel32im \
                noel32imafd \
                noel64im \
                noel64imafd \
        "
 make -j $THE_NCPU
 make install
popd

mkdir -p $BASE/build-smp
pushd $BASE/build-smp
 $KERNSRC/configure \
        --prefix=$THE_KERNPREFIX \
        --target=riscv-rtems5 \
        --enable-smp \
        --enable-networking \
        --enable-tests \
        --enable-posix=yes \
        --enable-rtemsbsp="\
                noel32ima_smp \
                noel32imafd_smp \
                noel64ima_smp \
                noel64imafd_smp \
        "
 make -j $THE_NCPU
 make install
popd

# enable extra kernel checks
# --enable-rtems-debug

THE_DATE=`date +"%Y-%m-%d-%H-%M"`

pushd $KERNSRC
 git archive -o ${BASE}/${THE_DIRNAME}-${THE_DATE}-src.tar.bz2 --prefix=${THE_DIRNAME}/ HEAD
popd

tar \
        -C ${THE_KERNPREFIX}/../.. \
        -caf ${BASE}/${THE_DIRNAME}-${THE_DATE}-kernel.tar.bz2 \
        ${THE_DIRNAME}/kernel

pushd ${BASE}
tar cavf ${BASE}/${THE_DIRNAME}-${THE_DATE}-testsuites.tar.gz `find . -type f -name '*.exe' | grep -v norun | sort`
popd

