--
--  TMTEST / BODY
--
--  DESCRIPTION:
--
--  This package is the implementation of Test 29 of the RTEMS
--  Timing Test Suite.
--
--  DEPENDENCIES: 
--
--  
--
--  COPYRIGHT (c) 1989-2011.
--  On-Line Applications Research Corporation (OAR).
--
--  The license and distribution terms for this file may in
--  the file LICENSE in this distribution or at
--  http://www.rtems.org/license/LICENSE.
--

with INTERFACES; use INTERFACES;
with RTEMS_CALLING_OVERHEAD;
with TEST_SUPPORT;
with TEXT_IO;
with TIME_TEST_SUPPORT;
with TIMER_DRIVER;
with RTEMS.RATE_MONOTONIC;

package body TMTEST is

-- 
--  INIT
--

   procedure INIT (
      ARGUMENT : in     RTEMS.TASKS.ARGUMENT
   ) is
      pragma Unreferenced(ARGUMENT);
      ID     : RTEMS.ID;
      STATUS : RTEMS.STATUS_CODES;
   begin

      TEXT_IO.NEW_LINE( 2 );
      TEST_SUPPORT.ADA_TEST_BEGIN;

      TMTEST.PERIOD_NAME := RTEMS.BUILD_NAME( 'P', 'R', 'D', ' ' );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.CREATE( TMTEST.PERIOD_NAME, ID, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_CREATE",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_CREATE
      );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.PERIOD( ID, 10, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_PERIOD" );

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_PERIOD (initial)",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_PERIOD
      );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.PERIOD( ID, RTEMS.RATE_MONOTONIC_PERIOD_STATUS, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_PERIOD" );

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_PERIOD (STATUS)",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_PERIOD
      );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.CANCEL( ID, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_CANCEL" );

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_CANCEL",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_CANCEL
      );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.DELETE( ID, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_DELETE (cancelled)",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_DELETE
      );

      RTEMS.RATE_MONOTONIC.CREATE( TMTEST.PERIOD_NAME, ID, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_CREATE" );

      RTEMS.RATE_MONOTONIC.PERIOD( ID, 10, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_PERIOD" );

      TIMER_DRIVER.INITIALIZE;
         RTEMS.RATE_MONOTONIC.DELETE( ID, STATUS );
      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_DELETE (active)",
         TMTEST.END_TIME, 
         1,
         0,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_DELETE
      );

      for INDEX in 1 .. TIME_TEST_SUPPORT.OPERATION_COUNT
      loop

         RTEMS.TASKS.CREATE( 
            RTEMS.BUILD_NAME( 'T', 'E', 'S', 'T' ),
            128, 
            1024, 
            RTEMS.DEFAULT_MODES,
            RTEMS.DEFAULT_ATTRIBUTES,
            ID,
            STATUS
         );
         TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_CREATE LOOP" );

         RTEMS.TASKS.START( ID, TMTEST.TASKS'ACCESS, 0, STATUS );
         TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_START LOOP" );

      end loop;

      RTEMS.TASKS.CREATE( 
         RTEMS.BUILD_NAME( 'L', 'O', 'W', ' ' ),
         200, 
         2048, 
         RTEMS.DEFAULT_MODES,
         RTEMS.DEFAULT_ATTRIBUTES,
         ID,
         STATUS
      );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_CREATE LOOP" );

      RTEMS.TASKS.START( ID, TMTEST.LOW_TASK'ACCESS, 0, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_START LOOP" );

      TMTEST.TASK_COUNT := 0;

      RTEMS.TASKS.DELETE( RTEMS.SELF, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_DELETE OF SELF" );

   end INIT;

-- 
--  TASKS
--

   procedure TASKS (
      ARGUMENT : in     RTEMS.TASKS.ARGUMENT
   ) is
      pragma Unreferenced(ARGUMENT);
      ID     : RTEMS.NAME;
      STATUS : RTEMS.STATUS_CODES;
   begin

      RTEMS.RATE_MONOTONIC.CREATE( TMTEST.PERIOD_NAME, ID, STATUS );
      RTEMS.RATE_MONOTONIC.PERIOD( ID, 10, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_PERIOD" );

      -- Give up the processor to allow all tasks to actually
      -- create and start their period timer before the benchmark
      -- timer driver is initialized.

      RTEMS.TASKS.WAKE_AFTER( RTEMS.YIELD_PROCESSOR, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "TASK_WAKE_AFTER" );

      TMTEST.TASK_COUNT := TMTEST.TASK_COUNT + 1;

      if TMTEST.TASK_COUNT = 1 then
         TIMER_DRIVER.INITIALIZE;
      end if;

      RTEMS.RATE_MONOTONIC.PERIOD( ID, 100, STATUS );
      TEST_SUPPORT.DIRECTIVE_FAILED( STATUS, "RATE_MONOTONIC_PERIOD" );

   end TASKS;

-- 
--  LOW_TASK
--

   procedure LOW_TASK (
      ARGUMENT : in     RTEMS.TASKS.ARGUMENT
   ) is
      pragma Unreferenced(ARGUMENT);
      OVERHEAD : RTEMS.UNSIGNED32;
   begin

      TMTEST.END_TIME := TIMER_DRIVER.READ_TIMER;

      TIMER_DRIVER.INITIALIZE;
         for INDEX in 1 .. TIME_TEST_SUPPORT.OPERATION_COUNT
         loop
            TIMER_DRIVER.EMPTY_FUNCTION;
         end loop;
      OVERHEAD := TIMER_DRIVER.READ_TIMER;

      TIME_TEST_SUPPORT.PUT_TIME( 
         "RATE_MONOTONIC_PERIOD (blocking)",
         TMTEST.END_TIME, 
         TIME_TEST_SUPPORT.OPERATION_COUNT, 
         OVERHEAD,
         RTEMS_CALLING_OVERHEAD.RATE_MONOTONIC_PERIOD
      );
   
      TEST_SUPPORT.ADA_TEST_END;
      RTEMS.SHUTDOWN_EXECUTIVE( 0 );

   end LOW_TASK;

end TMTEST;
